"""
This file demonstrates two different styles of tests (one doctest and one
unittest). These will both pass when you run "manage.py test".

Replace these with more appropriate tests for your application.
"""

from ldt.test.testcases import OAuthWebTestCase, TestCase
from django.conf import settings
from django.test import TestCase
from ldt.ldt_utils.models import User, Project, Content, Media
from ldt.ldt_utils.utils import LdtUtils, LdtAnnotation, create_ldt, create_empty_iri, copy_ldt
from ldt.test.client import Client
import lxml.etree
import tempfile
import unittest
import uuid
import logging

class ContentTest(TestCase):
    
    fixtures = ['base_data.json', 'user_data.json']
    
    def setUp(self):
        self.client = Client()
        User.objects.create_superuser('blop', 'blop@blop.com', 'blop')
        
        client = self.client.login(username='blop', password='blop')
        
        self.user = User()
        self.user.username = 'blop'

    #test the creation of a content without media
    def test_create_content_v1(self):
        self.cont12 = Content(iriurl="id12/iriurl12", duration = 100)
        self.cont12.iri_id = "id112"
        self.cont12.save()
        
        self.assertEqual(Content.objects.get(iri_id=self.cont12.iri_id), self.cont12)
        
    #test the creation of a content with a media
    def test_create_content_v2(self):
        self.media13 = Media()
        self.cont13 = Content(iriurl="id13/iriurl13", duration = 100, media_obj = self.media13)
        self.cont13 = Content(iriurl="id13/iriurl13", duration = 100)
        self.cont13.iri_id = "id113"
        self.cont13.save()
        
        self.assertEqual(Content.objects.get(iri_id=self.cont13.iri_id), self.cont13) 
    
    #test the deletion of a content without media
    def test_del_content_v1(self):
        self.cont14 = Content(iriurl="id14/iriurl14", duration = 100)
        self.cont14.iri_id = "id114"
        self.cont14.save()

        self.cont14.delete()
        self.cont14.commit()
        
        with self.assertRaises(Content.DoesNotExist):
            Content.objects.get(iri_id=self.cont14.iri_id)
        
    #test the deletion of a content with media
    def test_del_content_v2(self):
        self.media15 = Media()
        self.cont15 = Content(iriurl="id15/iriurl15", duration = 100, media_obj = self.media15)
        self.cont15.iri_id = "id115"
        self.cont15.save()
        
        self.cont15.delete()
        self.cont15.commit()
    
        with self.assertRaises(Content.DoesNotExist):
            Content.objects.get(iri_id=self.cont15.iri_id)
        