# -*- coding: utf-8 -*-
from __future__ import unicode_literals

from django.db import models, migrations
import sorl.thumbnail.fields
import datetime
import ldt.ldt_utils.utils
from django.conf import settings
import ldt.ldt_utils.models
import taggit.managers


class Migration(migrations.Migration):

    dependencies = [
        ('taggit', '0001_initial'),
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
    ]

    operations = [
        migrations.CreateModel(
            name='Author',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('handle', models.CharField(max_length=255, unique=True, null=True, blank=True)),
                ('email', models.EmailField(max_length=254, null=True, blank=True)),
                ('firstname', models.CharField(max_length=512, null=True, blank=True)),
                ('lastname', models.CharField(max_length=512, null=True, blank=True)),
            ],
            options={
                'permissions': (('view_author', 'Can view author'),),
            },
        ),
        migrations.CreateModel(
            name='Content',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('iri_id', models.CharField(default=ldt.ldt_utils.utils.generate_uuid, unique=True, max_length=255, verbose_name='content.iri_id')),
                ('iriurl', models.CharField(max_length=1024, verbose_name='content.iriurl')),
                ('creation_date', models.DateTimeField(auto_now_add=True, verbose_name='content.creation_date')),
                ('update_date', models.DateTimeField(auto_now=True, verbose_name='content.update_date')),
                ('title', models.CharField(max_length=1024, null=True, verbose_name='content.title', blank=True)),
                ('description', models.TextField(null=True, verbose_name='content.description', blank=True)),
                ('duration', models.IntegerField(null=True, verbose_name='content.duration', blank=True)),
                ('content_creation_date', models.DateTimeField(null=True, verbose_name='content.content_creation_date', blank=True)),
                ('image', sorl.thumbnail.fields.ImageField(default=ldt.ldt_utils.models.get_content_image_default, max_length=200, upload_to=b'thumbnails/contents/')),
                ('authors', models.ManyToManyField(to='ldt_utils.Author', verbose_name='content.authors', blank=True)),
            ],
            options={
                'ordering': ['title'],
                'permissions': (('view_content', 'Can view content'),),
            },
        ),
        migrations.CreateModel(
            name='ContentStat',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('annotation_volume_str', models.CommaSeparatedIntegerField(max_length=1024, null=True, verbose_name='content_stat.annotations_volume', blank=True)),
                ('polemics_volume_str', models.CommaSeparatedIntegerField(max_length=1024, null=True, verbose_name='content_stat.polemics_volume', blank=True)),
                ('nb_annotations', models.IntegerField(default=0, verbose_name='content.nb_annotation', db_index=True)),
                ('last_annotated', models.DateTimeField(default=datetime.datetime.now, null=True, verbose_name='content.last_annotated', blank=True)),
                ('content', models.OneToOneField(related_name='stat_annotation', verbose_name='content_stat.content', to='ldt_utils.Content')),
            ],
        ),
        migrations.CreateModel(
            name='Media',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('external_id', models.CharField(max_length=1024, null=True, verbose_name='media.external_id', blank=True)),
                ('external_permalink', models.URLField(max_length=1024, null=True, verbose_name='media.external_permalink', blank=True)),
                ('external_publication_url', models.URLField(max_length=1024, null=True, verbose_name='media.external_publication_url', blank=True)),
                ('external_src_url', models.CharField(max_length=1024, null=True, verbose_name='media.external_src_url', blank=True)),
                ('creation_date', models.DateTimeField(auto_now_add=True, verbose_name='media.creation_date')),
                ('media_creation_date', models.DateTimeField(null=True, verbose_name='media.media_creation_date', blank=True)),
                ('update_date', models.DateTimeField(auto_now=True, verbose_name='media.update_date')),
                ('videopath', models.CharField(max_length=1024, null=True, verbose_name='media.videopath', blank=True)),
                ('duration', models.IntegerField(null=True, verbose_name='media.duration', blank=True)),
                ('description', models.TextField(null=True, verbose_name='description', blank=True)),
                ('title', models.CharField(max_length=1024, null=True, verbose_name='title', blank=True)),
                ('src', models.CharField(max_length=1024, verbose_name='media.src')),
                ('src_hash', models.CharField(unique=True, max_length=128, verbose_name='media.src_hash', blank=True)),
                ('mimetype_field', models.CharField(max_length=512, null=True, verbose_name='media.mimetype', blank=True)),
                ('creator', models.ForeignKey(verbose_name='media.creator', blank=True, to=settings.AUTH_USER_MODEL, null=True)),
            ],
            options={
                'permissions': (('view_media', 'Can view media'),),
            },
        ),
        migrations.CreateModel(
            name='Project',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('ldt_id', models.CharField(unique=True, max_length=255)),
                ('ldt', models.TextField(null=True)),
                ('title', models.CharField(max_length=1024)),
                ('creation_date', models.DateTimeField(auto_now_add=True)),
                ('modification_date', models.DateTimeField(auto_now=True)),
                ('created_by', models.CharField(max_length=70, verbose_name='created by')),
                ('changed_by', models.CharField(max_length=70, verbose_name='changed by')),
                ('state', models.IntegerField(default=1, choices=[(1, b'edition'), (2, b'published'), (3, b'moderated'), (4, b'rejected'), (5, b'deleted')])),
                ('description', models.TextField(null=True, blank=True)),
                ('image', sorl.thumbnail.fields.ImageField(default=ldt.ldt_utils.models.get_project_image_default, max_length=200, upload_to=b'thumbnails/projects/')),
                ('contents', models.ManyToManyField(to='ldt_utils.Content')),
                ('owner', models.ForeignKey(blank=True, to=settings.AUTH_USER_MODEL, null=True)),
            ],
            options={
                'ordering': ['title'],
                'permissions': (('view_project', 'Can view project'),),
            },
        ),
        migrations.CreateModel(
            name='Segment',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('project_id', models.CharField(db_index=True, max_length=255, null=True, blank=True)),
                ('iri_id', models.CharField(max_length=255, db_index=True)),
                ('ensemble_id', models.CharField(max_length=512, db_index=True)),
                ('cutting_id', models.CharField(max_length=512, db_index=True)),
                ('element_id', models.CharField(max_length=512, db_index=True)),
                ('title', models.CharField(max_length=2048, null=True, blank=True)),
                ('duration', models.IntegerField(null=True)),
                ('start_ts', models.IntegerField(null=True)),
                ('author', models.CharField(max_length=1024, null=True, blank=True)),
                ('date', models.CharField(max_length=128, null=True, blank=True)),
                ('abstract', models.TextField(null=True, blank=True)),
                ('polemics', models.IntegerField(default=0, null=True, blank=True)),
                ('id_hash', models.CharField(unique=True, max_length=128, blank=True)),
                ('audio_src', models.CharField(max_length=255, null=True, blank=True)),
                ('audio_href', models.CharField(max_length=512, null=True, blank=True)),
                ('content', models.ForeignKey(to='ldt_utils.Content')),
                ('project_obj', models.ForeignKey(to='ldt_utils.Project', null=True)),
                ('tags', taggit.managers.TaggableManager(to='taggit.Tag', through='taggit.TaggedItem', blank=True, help_text='A comma-separated list of tags.', verbose_name='Tags')),
            ],
            options={
                'permissions': (('view_segment', 'Can view segment'),),
            },
        ),
        migrations.AddField(
            model_name='content',
            name='front_project',
            field=models.ForeignKey(blank=True, to='ldt_utils.Project', null=True),
        ),
        migrations.AddField(
            model_name='content',
            name='media_obj',
            field=models.ForeignKey(blank=True, to='ldt_utils.Media', null=True),
        ),
        migrations.AddField(
            model_name='content',
            name='tags',
            field=taggit.managers.TaggableManager(to='taggit.Tag', through='taggit.TaggedItem', blank=True, help_text='A comma-separated list of tags.', verbose_name='Tags'),
        ),
    ]
