from django.contrib.auth.models import User, Group
from django.db import models

class OwnerManager(models.Manager):
    def get_by_natural_key(self, user_name):
        return self.get(user__username=user_name)


class Owner(models.Model):
    objects = OwnerManager()
    
    user = models.ForeignKey(User, blank=True, null=True)
    group = models.ForeignKey(Group, blank=True, null=True)

    def __unicode__(self):
        if self.user:
            return self.user.username
        else:
            return self.group.name
    
    def natural_key(self):
        # Right now there is no group so the user.username is enough
        return self.user.username
    natural_key.dependencies = ['auth.user']
    


class Document(models.Model):
    owner = models.ForeignKey(Owner, blank=True, null=True)

    class Meta:
        abstract = True


