import ldt.indexation

class AnnotIndexer(object):
    
    def __init__(self, annotList, writer):
        self.__annotList = annotList
        self.__writer = writer
        
    
    def index_all(self):
        for annot in self.__annotList:
            self.index_annotation(annot)
    
    
    def index_annotation(self, annotation):
        
        
        annottags = annotation.get_tag_list()
        tags = ""
        
        if annottags is None or len(annottags) == 0:
            tags = ""
        else:
            for tag in annottags:
                tags += tag + ";"

        ldt.indexation.add_document([
            ("annotation_id", annotation.external_id, True, "NOT_ANALYZED"),
            ("type_doc", "text-annotation", False, "NOT_ANALYZED"),
            ("tags", tags, False, "ANALYZED"),
            ("title", annotation.title, False, "ANALYZED"),
            ("abstract", annotation.description, False, "ANALYZED"),
            ("text", annotation.text, False, "ANALYZED"),
            ("all", " ".join([tags, annotation.title, annotation.description, annotation.text]), False, "ANALYZED"),
        ], self.__writer)
        
