/* 
 * Widget that ties AnnotationList and CreateAnnotation together
 * using buttons to hide/show AnnotationList and CreateAnnotation widgets.
 * 
 */

IriSP.Widgets.AnnotationsController = function(player, config){
    IriSP.Widgets.Widget.call(this, player, config);
};

IriSP.Widgets.AnnotationsController.prototype = new IriSP.Widgets.Widget();

IriSP.Widgets.AnnotationsController.prototype.defaults = {
    // If true, displaying AnnotationList will hide CreateAnnotation and vice versa.
    display_or_write: false,
};

IriSP.Widgets.AnnotationsController.prototype.template = 
    "<div class='Ldt-AnnotationsController'>"
    + "<div class='Ldt-AnnotationsController-ButtonsContainer'>"
    + "    <div class='Ldt-AnnotationsController-Button Ldt-AnnotationsController-ShowAnnotationsListButton'>{{l10n.display}}</div>"
    + "    <div class='Ldt-AnnotationsController-Button Ldt-AnnotationsController-ShowCreateAnnotationButton'>{{l10n.write}}</div>"
    + "</div>"
    + "</div>"

IriSP.Widgets.AnnotationsController.prototype.messages = {
    en : {
        write : "Write",
        display : "Display",
    },
    fr : {
        write : "Ecrire",
        display : "Voir"
    }
};

IriSP.Widgets.AnnotationsController.prototype.draw = function() { 
    this.renderTemplate();
    var _this = this;
    
    this.$displayButton = this.$.find(".Ldt-AnnotationsController-ShowAnnotationsListButton");
    this.$writeButton = this.$.find(".Ldt-AnnotationsController-ShowCreateAnnotationButton");
    
    this.$writeButton.click(function(){
        _this.player.trigger("CreateAnnotation.toggle");
        if (_this.display_or_write){
            _this.player.trigger("AnnotationsList.hide");
        }
    });
    this.$displayButton.click(function(){
        _this.player.trigger("AnnotationsList.toggle");
        if (_this.display_or_write){
            _this.player.trigger("CreateAnnotation.hide");
        }
    })
};
