/* Widget that displays the last annotation that was posted, optionally for current segment, optionally for a given username */

IriSP.Widgets.LatestAnnotation = function(player, config){
    IriSP.Widgets.Widget.call(this, player, config);
};

IriSP.Widgets.LatestAnnotation.prototype = new IriSP.Widgets.Widget();

IriSP.Widgets.LatestAnnotation.prototype.defaults = {
    from_user: false,
    filter_by_segment: false,
    segment_annotation_type: "chap",
    annotation_type: "contribution"
};

IriSP.Widgets.LatestAnnotation.prototype.template = 
    "<div class='Ldt-LatestAnnotation'>"
    + "</div>";

IriSP.Widgets.LatestAnnotation.prototype.annotationTemplate =
    "<div class='Ldt-LatestAnnotation-Box'>"
    + "    <div class='Ldt-LatestAnnotation-Element Ldt-LatestAnnotation-CreationDate'>{{{annotation_created}}}</div>" 
    + "    <div class='Ldt-LatestAnnotation-Element Ldt-LatestAnnotation-Title'>{{{annotation_creator}}}{{#annotation_title}}: {{{annotation_title}}}{{/annotation_title}}</div>" 
    + "    <div class='Ldt-LatestAnnotation-Element Ldt-LatestAnnotation-Content'>"
    +         "{{{annotation_content}}}"
    + "    </div>"
    + "</div>"

IriSP.Widgets.LatestAnnotation.prototype.draw = function(){
    var _this = this;
    
    this.renderTemplate();
    
    this.annotationContainer_$ = this.$.find('.Ldt-LatestAnnotation');
    this.refresh();
    
    this.onMediaEvent("timeupdate", "refresh");
}

IriSP.Widgets.LatestAnnotation.prototype.refresh = function(){
    var _list = this.getWidgetAnnotations();
    if(this.filter_by_segment){
        _currentTime = this.media.getCurrentTime();
        _segments_annotations = this.source.getAnnotationsByTypeTitle(this.segments_annotation_type);
        _current_segments = _segments_annotations.filter(function(_segment){
            return (_currentTime >= _segment.begin && _currentTime <= _segment.end);
        });
        if (_current_segments.length == 0) {
            _list = _list.filter(function(_annotation){
                return false;
            });
        }
        else {
            _list = _list.filter(function(_annotation){
                _annotation_time = (_annotation.begin+_annotation.end)/2;
                return (_current_segments[0].begin <= _annotation_time && _current_segments[0].end >= _annotation_time);
            });
        }
        _list.sortBy(function(_annotation){
            return _annotation.created;
        });
        
        var _latestAnnotation = false;
        var _html="";
        if (_list.length != 0){
            _latestAnnotation = _list.pop();
            console.log(_latestAnnotation.creator);
            _html = Mustache.to_html(this.annotationTemplate, {
                annotation_created: _latestAnnotation.created.toLocaleDateString()+", "+_latestAnnotation.created.toLocaleTimeString(),
                annotation_creator: _latestAnnotation.creator,
                annotation_title: _latestAnnotation.title,
                annotation_content: _latestAnnotation.description,
            });
        }
        else {
            _html = "<div class='Ldt-LatestAnnotation-Element Ldt-LatestAnnotation-NoAnnotation'>Aucune annotation à afficher</div>";
        }
        this.annotationContainer_$.html(_html);
        
    };
}

IriSP.Widgets.LatestAnnotation.prototype.getLastAnnotation = function(){
    
}