#@PydevCodeAnalysisIgnore
import os.path
import ldtplatform
# Django settings for project.

DEBUG = True
TEMPLATE_DEBUG = DEBUG

ADMINS = (
    # ('Your Name', 'your_email@domain.com'),
)

MANAGERS = ADMINS

DATABASES = {
    'default': {
        'ENGINE': 'django.db.backends.', # Add 'postgresql_psycopg2', 'postgresql', 'mysql', 'sqlite3' or 'oracle'.
        'NAME': '',                      # Or path to database file if using sqlite3.
        'USER': '',                      # Not used with sqlite3.
        'PASSWORD': '',                  # Not used with sqlite3.
        'HOST': '',                      # Set to empty string for localhost. Not used with sqlite3.
        'PORT': '',                      # Set to empty string for default. Not used with sqlite3.
    }
}

# Local time zone for this installation. Choices can be found here:
# http://en.wikipedia.org/wiki/List_of_tz_zones_by_name
# although not all choices may be available on all operating systems.
# If running in a Windows environment this must be set to the same as your
# system time zone.
TIME_ZONE = 'Europe/Paris'

# Language code for this installation. All choices can be found here:
# http://www.i18nguy.com/unicode/language-identifiers.html
LANGUAGE_CODE = 'fr-fr'

ugettext = lambda s: s

LANGUAGES = ( 
    ('fr', ugettext('French')),
    ('en', ugettext('English')),
)


SITE_ID = 1

# If you set this to False, Django will make some optimizations so as not
# to load the internationalization machinery.
USE_I18N = True

# Absolute path to the directory that holds media.
# Example: "/home/media/media.lawrence.com/"
#MEDIA_ROOT = ''

# Root of static files used by each app, generated by code or uploaded by users
#STATIC_URL = '/static/'

# URL that handles the media served from MEDIA_ROOT. Make sure to use a
# trailing slash if there is a path component (optional in other cases).
# Examples: "http://media.lawrence.com", "http://example.com/media/"
#MEDIA_URL = ''

# URL prefix for admin media -- CSS, JavaScript and images. Make sure to use a
# trailing slash.
# Examples: "http://foo.com/media/", "/media/".
#ADMIN_MEDIA_PREFIX = '/media/'

#LDT_MEDIA_PREFIX = '/ldt/'

# Make this unique, and don't share it with anybody.
SECRET_KEY = 't^lii5_z@tho$%6t&b#dm#t9nz$$ylyclxvkdiyqbl+(dnt(ma'

# List of callables that know how to import templates from various sources.
TEMPLATE_LOADERS = (
    'django.template.loaders.filesystem.Loader',
    'django.template.loaders.app_directories.Loader',
#     'django.template.loaders.eggs.Loader',
)

MIDDLEWARE_CLASSES = (
    'django.middleware.gzip.GZipMiddleware',
    'django.middleware.common.CommonMiddleware',
    'ldt.ldt_utils.middleware.swfupload.SWFUploadMiddleware',
    'django.contrib.sessions.middleware.SessionMiddleware',
    'django.middleware.csrf.CsrfViewMiddleware',
    'django.contrib.auth.middleware.AuthenticationMiddleware',
    #'django.middleware.locale.LocaleMiddleware',
    'django.contrib.messages.middleware.MessageMiddleware',
    'django_openid_consumer.middleware.OpenIDMiddleware',
    'ldt.ldt_utils.middleware.userprofile.LanguageMiddleware',
    'ldt.ldt_utils.middleware.security.SecurityMiddleware',
)

TEMPLATE_CONTEXT_PROCESSORS = ( 
    "django.core.context_processors.request",
    "django.contrib.auth.context_processors.auth",
    "django.core.context_processors.debug",
    "django.core.context_processors.i18n",
    "django.core.context_processors.media",
    "django.core.context_processors.static",
    "ldt.utils.context_processors.ldt_context",
)


ROOT_URLCONF = 'ldtplatform.urls'

TEMPLATE_DIRS = (
    # Put strings here, like "/home/html/django_templates" or "C:/www/django/templates".
    # Always use forward slashes, even on Windows.
    # Don't forget to use absolute paths, not relative paths.
    os.path.join(os.path.basename(__file__), 'templates'), 
    os.path.join(os.path.dirname(__file__), 'templates'),  
)
    
FIXTURES_DIRS = (
    os.path.join(os.path.basename(__file__), 'fixtures'),
)

INSTALLED_APPS = (
    'django_extensions',
    'django.contrib.auth',
    'django.contrib.contenttypes',
    'django.contrib.sessions',
    'django.contrib.sites',
    'django.contrib.messages',
    'django.contrib.admin',
    'django.contrib.staticfiles',
    'ldtplatform',
    'registration',
    'tagging',
    'ldt',
    'ldt.core',
    'ldt.ldt_utils',
    'ldt.text',
    'ldt.user',
    'ldt.management',
    'oauth_provider',
    'django_openid_consumer',
    'piston',
    'social_auth',
    'south',
    'guardian',
)

AUTH_PROFILE_MODULE = 'user.UserProfile'

DECOUPAGE_BLACKLIST = (
     "de_PPP",
)
 
ZIP_BLACKLIST = (
     "__MACOSX",
)

AUTHENTICATION_BACKENDS = (
    'social_auth.backends.twitter.TwitterBackend',
    'social_auth.backends.facebook.FacebookBackend',
#    'social_auth.backends.google.GoogleOAuthBackend',
#    'social_auth.backends.google.GoogleOAuth2Backend',
    'social_auth.backends.google.GoogleBackend',
    'social_auth.backends.yahoo.YahooBackend',
#    'social_auth.backends.contrib.linkedin.LinkedinBackend',
#    'social_auth.backends.contrib.LiveJournalBackend',
#    'social_auth.backends.contrib.orkut.OrkutBackend',
    'social_auth.backends.OpenIDBackend',
    'django.contrib.auth.backends.ModelBackend',
    'guardian.backends.ObjectPermissionBackend',
)
SOCIAL_AUTH_IMPORT_BACKENDS = (
    'myproy.social_auth_extra_services',
)

ACCOUNT_ACTIVATION_DAYS = 7 

LDT_MAX_SEARCH_NUMBER = 50
LDT_JSON_DEFAULT_INDENT = 2

OAUTH_PROVIDER_KEY_SIZE = 32
OAUTH_PROVIDER_SECRET_SIZE = 32
OAUTH_PROVIDER_VERIFIER_SIZE = 10
OAUTH_PROVIDER_CONSUMER_KEY_SIZE = 256
OAUTH_AUTHORIZE_VIEW = 'oauth_provider.views.fake_authorize_view'
OAUTH_CALLBACK_VIEW = 'oauth_provider.views.fake_callback_view'
TEST_WEBSERVER_ADDRPORT = "127.0.0.1:8888"

TWITTER_CONSUMER_KEY     = 'UxAdbOLSo4Mx3CXIwDG9Eg'
TWITTER_CONSUMER_SECRET  = '2PcWgdjnJL6Vp8srB40jeAo0fjMEtDnUwmAia6EUww'
FACEBOOK_APP_ID = '163134140411313'
FACEBOOK_API_SECRET = 'f25e0754a44f0d90d3f4d9ea961ff012'

SOCIAL_AUTH_COMPLETE_URL_NAME  = 'complete'
SOCIAL_AUTH_ASSOCIATE_URL_NAME = 'associate_complete'

# twitter testing
TEST_TWITTER_USER = 'jacquesverrier@gmail.com'
TEST_TWITTER_PASSWORD = ''

# facebook testing
#TEST_FACEBOOK_USER = 'testing_account'
#TEST_FACEBOOK_PASSWORD = 'password_for_testing_account'

# google testing
TEST_GOOGLE_USER = 'jacquesverrier@gmail.com'
TEST_GOOGLE_PASSWORD = ''

AUTO_INDEX_AFTER_SAVE = True

ANONYMOUS_USER_ID = -1

WEB_VERSION = ldtplatform.get_version()

PUBLIC_GROUP_NAME = 'published_projects'

from config import *

if not "LOGIN_URL" in locals():
    LOGIN_URL = BASE_URL + 'ldtplatform/accounts/login/'
if not "LOGOUT_URL" in locals():
    LOGOUT_URL = BASE_URL + 'ldtplatform/accounts/disconnect/'
if not "LOGIN_REDIRECT_URL" in locals():
    LOGIN_REDIRECT_URL = BASE_URL + 'ldtplatform/ldt/'
if not "LOGOUT_REDIRECT_URL" in locals():
    LOGOUT_REDIRECT_URL = BASE_URL + 'ldtplatform/accounts/login'
if not "PROFILE_REDIRECT_URL" in locals():
    PROFILE_REDIRECT_URL = BASE_URL + 'ldtplatform/auth_accounts/create/profile'

if not "LOGIN_ERROR_URL" in locals():
    LOGIN_ERROR_URL = BASE_URL + 'ldtplatform/accounts/login'

if not "GLOBAL_LOG_LEVEL" in locals():
    GLOBAL_LOG_LEVEL = LOG_LEVEL
if not "GLOBAL_LOG_HANDLERS" in locals():
    GLOBAL_LOG_HANDLERS = [{'handler':logging.FileHandler(LOG_FILE), 'format':"%(asctime)s - %(levelname)s : %(message)s"}]

# URL prefix for admin media -- CSS, JavaScript and images. Make sure to use a
# trailing slash.
# Examples: "http://foo.com/media/", "/media/".
if not "ADMIN_MEDIA_PREFIX" in locals():
    ADMIN_MEDIA_PREFIX = STATIC_URL + 'admin/'
# Used in a lot of templates
if not "LDT_MEDIA_PREFIX" in locals():
    LDT_MEDIA_PREFIX = STATIC_URL + 'ldt/'
# URL that handles the media served from MEDIA_ROOT.
if not "MEDIA_URL" in locals():
    MEDIA_URL = BASE_URL + 'static/media/'
  
