from django.conf import settings
from django.core.exceptions import MiddlewareNotUsed
from ldt.ldt_utils.security import protect_models, unprotect_models

class SecurityMiddleware(object):
    
    def __init__(self):
        if not hasattr(settings, 'USE_GROUP_PERMISSIONS') or not settings.USE_GROUP_PERMISSIONS:
            raise MiddlewareNotUsed()

    # !! Will not work with concurrent requests
    def process_request(self, request):    
        protect_models(request.user)        
    
    def process_response(self, request, response):
        unprotect_models() 
        
        return response