from django.conf.urls.defaults import patterns, url
from django.views.defaults import page_not_found
from piston.resource import Resource
from ldt.api.ldt.handlers import ProjectHandler, AnnotationHandler, ContentHandler, SegmentHandler

project_handler    = Resource(ProjectHandler, None)
annotation_handler = Resource(AnnotationHandler, None)
content_handler    = Resource(ContentHandler, None)
segment_handler    = Resource(SegmentHandler, None)

urlpatterns = patterns('',
    url(r'projects/(?P<project_id>[^/.]+)\.?(?P<emitter_format>.*)$', project_handler, name='project_api'),
    url(r'annotations/$', page_not_found, name='annotation_api_empty'),
    url(r'annotations/(?P<project_id>[^/.]+)\.?(?P<emitter_format>.*)$', annotation_handler, name='annotation_api'),
    url(r'contents/(?P<iri_id>[^/.]+)\.?(?P<emitter_format>.*)$', content_handler, name='content_api'),
    url(r'segments/$', page_not_found, name='segment_api_empty'),
    url(r'segments/(?P<iri_id>.*)/(?P<begin>.*)/(?P<end>.*)$', segment_handler, name='segment_api'),
)


