from django import forms
from django.conf import settings

from socialauth.models import AuthMeta


ALLOW_MULTIPLE_USERNAME_EDITS = getattr(settings, 'ALLOW_MULTIPLE_USERNAME_EDITS', False)

class EditProfileForm(forms.Form):
    username = forms.CharField(max_length = 100, required=True)
    email = forms.EmailField()
    password = forms.CharField(max_length = 100, widget= forms.PasswordInput, required=False)
    password2 = forms.CharField(max_length = 100, widget= forms.PasswordInput, required=False, label='Repeat password')
    first_name = forms.CharField(max_length = 100, required=False)
    last_name = forms.CharField(max_length = 100, required=False)
    
    #list of accounts and add account
    
    def __init__(self, user=None, *args, **kwargs):
        super(EditProfileForm, self).__init__(*args, **kwargs)
        self.user = user
        self.auth = AuthMeta.objects.get(user=self.user)
        if self.user:
            self.initial = {'email': user.email, 'username':user.username, \
                        'first_name':user.first_name, 'last_name':user.last_name, }
            
    def clean(self):
        cleaned_data = self.cleaned_data
        if 'password' in cleaned_data or 'password2' in cleaned_data:
            if 'password' in cleaned_data and 'password2' in cleaned_data:
                if cleaned_data['password'] != cleaned_data['password2']:
                    raise forms.ValidationError('The passwords do not match.')
            else:
                raise forms.ValidationError('Either ener both or None of the password fields')
                    
        return cleaned_data      
        
    def save(self):
        user = self.user
        user.email = self.cleaned_data['email']
        user.first_name = self.cleaned_data['first_name']
        user.last_name = self.cleaned_data['last_name']
        if 'password' in self.cleaned_data and 'password2' in self.cleaned_data:
            user.set_password(self.cleaned_data['password'])
        user.save()
        try:
            authmeta = AuthMeta.objects.get(user=user)
            authmeta.is_email_filled = True
            authmeta.is_profile_modified = True
            authmeta.save()
        except AuthMeta.DoesNotExist:
            pass
        return user
        

class CreateProfileForm(forms.Form):
    username = forms.CharField(max_length = 100, required=True)
    email = forms.EmailField()
    password = forms.CharField(max_length = 100, widget= forms.PasswordInput, required=True, help_text='Choose a password, and you\'ll be able to log in with any other external account :)')
    password2 = forms.CharField(max_length = 100, widget= forms.PasswordInput, required=True, label='Repeat password') 
    first_name = forms.CharField(max_length = 100, required=False)
    last_name = forms.CharField(max_length = 100, required=False)
   
    def __init__(self, user=None, *args, **kwargs):
        super(CreateProfileForm, self).__init__(*args, **kwargs)
        self.user = user
        self.initial = {'email': user.email,  \
                    'first_name':user.first_name, 'last_name':user.last_name, 'username':user.username,}
            
    def clean(self):
        cleaned_data = self.cleaned_data
        if 'password' in cleaned_data or 'password2' in cleaned_data:
            if 'password' in cleaned_data and 'password2' in cleaned_data:
                if cleaned_data['password'] != cleaned_data['password2']:
                    raise forms.ValidationError('The passwords do not match.')
            else:
                raise forms.ValidationError('Either enter both or None of the password fields')    
        
    def save(self):
        user = self.user
        user.email = self.cleaned_data['email']
        user.first_name = self.cleaned_data['first_name']
        user.last_name = self.cleaned_data['last_name']
        user.set_password(self.cleaned_data['password'])
        user.save()
        try:
            authmeta = AuthMeta.objects.get(user=user)
            authmeta.is_email_filled = True
            authmeta.is_profile_modified = True
            authmeta.save()
        except AuthMeta.DoesNotExist:
            pass
        return user
    
class HereBeforeForm(forms.Form):
    here_before = forms.CharField(max_length = 100, required=False, label='Here before?',help_text='If you\'ve already been here with another account, give your username')
    here_before_password = forms.CharField(max_length = 100, widget= forms.PasswordInput, required=False, label='Password', help_text='and password...')

    def __init__(self, user=None, *args, **kwargs):
        super(HereBeforeForm, self).__init__(*args, **kwargs)
        self.user = user
        self.initial = {}
            
    def clean(self):
        cleaned_data = self.cleaned_data       
        if 'here_before' in cleaned_data:
            if 'here_before_password' not in cleaned_data:
                raise forms.ValidationError('If you\'ve been here with another account, enter your password, please!')
            
        if 'here_before' in cleaned_data and 'here_before_data' in cleaned_data:
            try:
                here_before = User.objects.get(username=cleaned_data['here_before'])
            except User.DoesNotExist:
                raise forms.ValidationError('Wrong username!')
        return cleaned_data      
