from django.contrib.auth import get_user_model
from tastypie.resources import ModelResource, ALL

User = get_user_model()

class UserResource(ModelResource):
    class Meta:
        allowed_methods = ['get']
        queryset =  User.objects.all()
        resource_name = 'users'
        excludes = ['email', 'password', 'is_superuser', 'is_staff']
        filtering = {'username': ALL, }
        detail_uri_name = 'username'
