function init_multi_select_events (first_list, sec_list, first_selection, sec_selection, search_input, search_url) {
	
	var first_list_name = "read_list";
	var second_list_name = "write_list";
	
	$("#selectelems").click(function () {
		var list = get_selected_elems(first_list);
		move_elem(first_list, sec_list, list);
		add_to_form(first_selection, list, first_list_name);
	});

	$("#removeelems").click(function () {
		var list = get_selected_elems(sec_list);
		move_elem(sec_list, first_list, list);
		remove_from_form(first_selection, list);
	});

	$("#selectall").click(function () {
		var list = get_all_options(first_list);
		move_elem(first_list, sec_list, list);
		add_to_form(first_selection, list, first_list_name);
	});

	$("#removeall").click(function () {
		var elem_list = get_all_options(sec_list);
		move_elem(sec_list, first_list, get_all_options(sec_list));
		remove_from_form(first_selection, elem_list);
		remove_from_form(sec_selection, elem_list);
	});

	$("#chooseaux").click(function () {
		var elems = get_selected_elems(sec_list);
		
		for (var i=0; i < elems.length; i++) {
			$("option[value=" + elems[i] + "]", sec_list).css('color', '#2181B1');
			$(sec_selection).append("<input type=\"hidden\" name=\"" + second_list_name + "\" value=\"" + elems[i]+ "\" />");
		}
	});

	$("#removeaux").click(function () {
		var users = get_selected_elems(sec_list);
		
		for (var i=0; i < users.length; i++) {
			$("option[value=" + users[i] + "]", sec_list).css('color', 'black');
			$("input[value=" + users[i] + "]", sec_selection).remove();
		}
	});	
	
	$(document).ready(function () {
		filter_elems(first_list, sec_list);
		input_list_init = [
			{'input_selector':search_input, 'container_selector': first_list, 'url':search_url}
		];	           	
		searchFieldInit(input_list_init);
	});
}

function move_elem (from, to, elems) {
	var selected = $("#sec_selection");		
	for (var i=0; i < elems.length; i++) {
		var option = $("option[value=" + elems[i] + "]", from);
		option.css('color', 'black');
		$("input[value=" + elems[i] + "]", selected).remove();
		to.append(option);
	}		
}

function get_selected_elems(list) {
	var selected = Array();
	$("option:selected", list).each(function (e) {
		selected.push($(this).val());
	});
	return selected;
}

function remove_from_form(form, elem_list) {		
	for (var i=0; i < elem_list.length; i++) {
		$("input[value=" + elem_list[i] + "]", form).remove();
	}
}

function add_to_form(form, elem_list, name) {		
	for (var i=0; i < elem_list.length; i++) {
		form.append("<input type=\"hidden\" name=\"" + name + "\" value=\"" + elem_list[i] + "\"/>");
	}
}

function get_all_options (select) {
	var all = Array();
	$("option", select).each(function()	{
		all.push($(this).val());
	});
	return all;
}	

function filter_elems(first_list, sec_list) {
	var selected = get_all_options(sec_list);
		
	$("option", first_list).each(function () {
		for (var i = 0; i < selected.length; i++) {
			if (selected[i] == $(this).attr('value')) {
				$(this).remove();
			}
		}		
	});		
}