# -*- coding: utf-8 -*-
from __future__ import unicode_literals

from django.db import models, migrations
from django.conf import settings
import taggit.managers


class Migration(migrations.Migration):

    dependencies = [
        ('taggit', '0001_initial'),
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
        ('ldt_utils', '0001_initial'),
    ]

    operations = [
        migrations.AddField(
            model_name='project',
            name='owner',
            field=models.ForeignKey(blank=True, to=settings.AUTH_USER_MODEL, null=True),
        ),
        migrations.AddField(
            model_name='media',
            name='creator',
            field=models.ForeignKey(verbose_name='media.creator', blank=True, to=settings.AUTH_USER_MODEL, null=True),
        ),
        migrations.AddField(
            model_name='contentstat',
            name='content',
            field=models.OneToOneField(related_name='stat_annotation', verbose_name='content_stat.content', to='ldt_utils.Content'),
        ),
        migrations.AddField(
            model_name='content',
            name='authors',
            field=models.ManyToManyField(to='ldt_utils.Author', verbose_name='content.authors', blank=True),
        ),
        migrations.AddField(
            model_name='content',
            name='front_project',
            field=models.ForeignKey(blank=True, to='ldt_utils.Project', null=True),
        ),
        migrations.AddField(
            model_name='content',
            name='media_obj',
            field=models.ForeignKey(blank=True, to='ldt_utils.Media', null=True),
        ),
        migrations.AddField(
            model_name='content',
            name='tags',
            field=taggit.managers.TaggableManager(to='taggit.Tag', through='taggit.TaggedItem', help_text='A comma-separated list of tags.', verbose_name='Tags'),
        ),
    ]
