# -*- coding: utf-8 -*-
from __future__ import unicode_literals

from django.db import models, migrations

class Migration(migrations.Migration):
    
    def add_permission_is_owner_group(apps, schema_editor):
        from django.contrib.contenttypes.management import update_contenttypes
        for app_config in apps.get_app_configs():
            app_config.models_module=True
            update_contenttypes(app_config)
            app_config.models_module=None

        Permission = apps.get_model("auth", "Permission")
        ContentType = apps.get_model("contenttypes", "ContentType")
        content_type = ContentType.objects.get(app_label='auth', model='group')
        Permission.objects.create(
                    codename='is_owner_group', 
                    name='Can add/delete admins to the group',
                    content_type=content_type
                )
        
    
    dependencies = [
        ('contenttypes', '0001_initial'),
        ('auth', '0006_require_contenttypes_0002'),
        ('ldt_utils', '0002_auto_20150430_0951'),
    ]

    operations = [
        migrations.RunPython(add_permission_is_owner_group)
    ]