"""
This file demonstrates two different styles of tests (one doctest and one
unittest). These will both pass when you run "manage.py test".

Replace these with more appropriate tests for your application.
"""

from ldt.test.testcases import OAuthWebTestCase, TestCase
from django.conf import settings
from django.test import TestCase
from ldt.ldt_utils.models import User, Project, Content, Media
from ldt.ldt_utils.utils import LdtUtils, LdtAnnotation, create_ldt, create_empty_iri, copy_ldt
from ldt.test.client import Client
import lxml.etree
import tempfile
import unittest
import uuid
import logging

class ContentTest(TestCase):
    
    fixtures = ['base_data.json', 'user_data.json']
    
    def setUp(self):
        self.client = Client()
        User.objects.create_superuser('blop', 'blop@blop.com', 'blop')
        
        client = self.client.login(username='blop', password='blop')
        
        self.user = User()
        self.user.username = 'blop'

    def test_create_content(self):
        self.cont12 = Content(iriurl="id12/iriurl12", duration = 100)
        self.cont12.iri_id = "id112"
        self.cont12.save()
        
        self.assertEqual(Content.objects.get(iri_id=self.cont12.iri_id), self.cont12)
        
    def test_del_content(self):
        self.cont13 = Content(iriurl="id13/iriurl13", duration = 100)
        self.cont13.iri_id = "id113"
        self.cont13.save()
        self.cont13.delete()
        self.cont13.commit()
        
        #self.assertEqual(Content.objects.get(iri_id=self.cont13.iri_id), None)
        
        
"""     
        self.project.contents.add(self.cont5, self.cont6)
        self.project.ldt = ""
        create_ldt(self.project, self.user)
        ldt = lxml.etree.fromstring(self.project.ldt_encoded)
        self.assertEqual(ldt.xpath("/iri")[0].tag, "iri")
        self.assertEqual(ldt.xpath("/iri/project")[0].get("title"), self.project.title)
        self.assertEqual(ldt.xpath("/iri/medias/media")[0].get("src"), self.cont5.iri_url())
        self.assertEqual(ldt.xpath("/iri/medias/media")[1].get("id"), self.cont6.iri_id)
"""
