from django.conf.urls.defaults import patterns, url
from ldt.management import test_ldt

# Uncomment the next two lines to enable the admin:
# from django.contrib import admin
# admin.autodiscover()

urlpatterns = patterns('ldt.ldt_utils',
    url(r'^searchInit/(?P<field>.*)/(?P<query>.*)$', 'views.searchInit'),
    url(r'^searchForm/$', 'views.searchForm'),
    url(r'^import_rs/$', 'views.import_rs'),
    url(r'^published/$', 'views.published_project'),
    url(r'^groups/$', 'views.groups'),
    url(r'^get_group_projects/$', 'views.get_group_projects'),
    url(r'^search/$', 'views.searchIndex'),
    url(r'^search/(?P<field>.*)/(?P<query>.*)$', 'views.searchIndexGet'),
    url(r'^searchLdt/(?P<field>.*)/(?P<query>.*)$', 'views.searchLdt'),
    url(r'^searchSeg/(?P<field>.*)/(?P<query>.*)$', 'views.searchSegments'),
    url(r'^index/(?P<url>.*)$', 'views.index'),
    url(r'^init/(?P<method>.*)/(?P<url>.*)$', 'views.init', name='ldt_init'),
    url(r'^ldt/(?P<url>.*)$', 'views.ldt'),
    url(r'^search/loading/$', 'views.loading'),
    url(r'^create/(?P<iri_id>.*)$', 'views.create_project'),
    url(r'^copy/(?P<ldt_id>.*)$', 'views.copy_project'),
    url(r'^update/(?P<ldt_id>.*)$', 'views.update_project'),
    url(r'^cljson/id/(?P<id>.*)$', 'views.project_json_id'),
    url(r'^cljson/externalid/(?P<id>.*)$', 'views.project_json_externalid'),
    url(r'^rdf/id/(?P<ldt_id>.*)$', 'views.project_annotations_rdf'),
    url(r'^/?$', "views.workspace", name="root-view"),
    url(r'^filterprojects/_(?P<filter>[\w\%\_\-\+]*?)/(?P<is_owner>true|false)/(?P<status>\d)$', "views.projectsfilter",),
    url(r'^filterprojects/_(?P<filter>[\w\%\_\-\+]*?)/(?P<is_owner>true|false)/(?P<status>\d)/(?P<id_group>.*)$', "views.projectsfilter",),
    url(r'^filtercontents/_(?P<filter>[\w\%\_\-\+]*?)/$', "views.contentsfilter",),
    (r'^embedpopup/?$', "views.popup_embed"),
    url(r'^segment/(?P<project_id>.*)/(?P<content_id>.*)/(?P<ensemble_id>.*)/(?P<cutting_id>.*)/(?P<segment_id>.*)/$', 'views.index_segment'),
    url(r'^segmentInit/(?P<project_id>.*)/(?P<content_id>.*)/(?P<ensemble_id>.*)/(?P<cutting_id>.*)/(?P<segment_id>.*)/$', 'views.init_segment'),
    url(r'^segmentLdt/(?P<project_id>.*)/(?P<content_id>.*)/(?P<ensemble_id>.*)/(?P<cutting_id>.*)/(?P<segment_id>.*)/$', 'views.ldt_segment'),
    url(r'^segmentHighlight/(?P<project_id>.*)/(?P<content_id>.*)/(?P<ensemble_id>.*)/(?P<cutting_id>.*)/(?P<segment_id>.*)/$', 'views.highlight_segment'),
)

urlpatterns += patterns('',
    url('^jsi18n', 'django.views.i18n.javascript_catalog', name='jsi18n'),
)


if test_ldt():
    urlpatterns += patterns('ldt.ldt_utils',
        url(r'^space/content/$', 'views.list_content'),
        url(r'^space/content/create/$', 'views.write_content'),
        url(r'^space/content/update/(?P<iri_id>[\w-]+)$', 'views.write_content'),
        url(r'^space/ldt/$', 'views.list_ldt'),
        url(r'^space/ldt/indexproject/(?P<id>.*)$', 'views.index_project', name='index_project'),
        url(r'^space/ldt/indexprojectfull/(?P<id>.*)$', 'views.index_project', {'full': True}, name='index_project_full'),
        url(r'^space/ldt/init/(?P<method>.*)/(?P<url>.+)$', 'views.init', name='space_ldt_init'),
        url(r'^space/ldt/project/(?P<id>.*)$', 'views.ldtProject'),
        url(r'^space/ldt/create/$', 'views.create_ldt_view'),
        url(r'^space/ldt/created_done/$', 'views.created_ldt'),
        url(r'^space/ldt/save/$', 'views.save_ldtProject'),
        url(r'^space/ldt/publish/(?P<id>[\w-]*)(?:/(?P<redirect>true|false))?$', 'views.publish'),
        url(r'^space/ldt/unpublish/(?P<id>[\w-]*)(?:/(?P<redirect>true|false))?$', 'views.unpublish'),
        url(r'^space/upload/$', 'views.upload'),
        url(r'^space/removetempfile/$', 'views.removetempfile'),
        url(r'^space/getduration/$', 'views.get_duration'),

)
