from django.core.management.base import BaseCommand
from ldt.ldt_utils.models import Content
from ldt.ldt_utils.stat import update_stat_content, get_empty_stat_vector, get_empty_stat_field
from ldt.management.utils import show_progress

class Command(BaseCommand):
    help = 'Computes annotation for all contents'
    
    
    def handle(self, *args, **options):             
       
        empty_stat_vector = get_empty_stat_vector()
        size_stat = len(empty_stat_vector)
        
        writer = None
        total = Content.objects.count()
        i = 1
       
        for c in Content.objects.all():
            show_progress(i, total, "computing annotation stats for contents", 40, writer)
            if not c.stat_annotation or len( c.stat_annotation.split(',')) != size_stat:
                c.stat_annotation = get_empty_stat_field()
                c.save()
            
            update_stat_content(c)
            i += 1
            
        return None
    