# -*- coding: utf-8 -*-
from __future__ import unicode_literals

from django.db import models, migrations
import ldt.text.utils
import taggit.managers


class Migration(migrations.Migration):

    dependencies = [
        ('taggit', '0001_initial'),
    ]

    operations = [
        migrations.CreateModel(
            name='Annotation',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('external_id', models.CharField(default=ldt.text.utils.generate_uuid, unique=True, max_length=255, verbose_name='annotation.external_id')),
                ('uri', models.CharField(max_length=1024, verbose_name='annotation.uri')),
                ('title', models.CharField(max_length=1024, null=True, verbose_name='annotation.title', blank=True)),
                ('description', models.TextField(null=True, verbose_name='annotation.description', blank=True)),
                ('text', models.TextField(null=True, verbose_name='annotation.text', blank=True)),
                ('color', models.CharField(max_length=1024, verbose_name='annotation.color')),
                ('creator', models.CharField(max_length=1024, null=True, verbose_name='creator.title', blank=True)),
                ('contributor', models.CharField(max_length=1024, null=True, verbose_name='contributor.title', blank=True)),
                ('creation_date', models.DateTimeField(auto_now_add=True, verbose_name='annotation.creation_date')),
                ('update_date', models.DateTimeField(auto_now=True, verbose_name='annotation.update_date')),
                ('tags_field', taggit.managers.TaggableManager(to='taggit.Tag', through='taggit.TaggedItem', help_text='A comma-separated list of tags.', verbose_name='Tags')),
            ],
        ),
    ]
