from django.contrib.staticfiles.storage import staticfiles_storage
from django.contrib.sites.models import Site
from django.core.urlresolvers import reverse
from ldt import settings
import httplib2
import re
import urlparse

def get_web_url(request=None):
    if request:
        if request.is_secure():
            domain = "https://%s" % Site.objects.get_current().domain
        else:
            domain = "http://%s" % Site.objects.get_current().domain
    else : 
        domain = "http://%s" % Site.objects.get_current().domain
    return domain

def absstatic(request, path):
    domain=get_web_url(request)
    new_path = staticfiles_storage.url(path)
    return urlparse.urljoin(domain, new_path)

def absurl(request, viewname, urlconf=None, args=None, kwargs=None, prefix=None, current_app=None):
    domain=get_web_url(request)
    path=reverse(viewname, urlconf, args, kwargs, prefix, current_app)
    return urlparse.urljoin(domain, path)

def absurl_norequest(viewname, urlconf=None, args=None, kwargs=None, prefix=None, current_app=None):
    domain=get_web_url()
    path=reverse(viewname, urlconf, args, kwargs, prefix, current_app)
    return urlparse.urljoin(domain, path)

def request_with_auth(url, method='GET'):
    h = httplib2.Http()
    web_auth = settings.WEB_AUTH if settings.WEB_AUTH else []
    for entry in web_auth:
        if not isinstance(entry, dict):
            continue
        regex = entry.get('REGEX', None)
        if regex and re.search(regex, url, re.IGNORECASE):
            h.add_credentials(entry.get('NAME', ''), entry.get('PASSWORD', ''), entry.get('DOMAIN', ''))
            break
            
    return h.request(url, method)


def is_absolute(url):
    return bool(urlparse.urlparse(url).scheme)