import logging

from tastypie.test import ResourceTestCase, TestApiClient
from ldt.api.ldt.serializers.cinelabserializer import CinelabSerializer
from django.core.urlresolvers import reverse
from ldt.ldt_utils.models import Segment
import json


logger = logging.getLogger(__name__)

class AnnotationTest(ResourceTestCase):

    fixtures = ['tests/api/projects_user.json', 'tests/api/projects_project.json']

    def get_credentials(self):
        result = self.api_client.client.login(username='admin',password='admin')
        return result
    
    
    def setUp(self):
        self.api_client = TestApiClient(CinelabSerializer())
        self.get_credentials()
        self.test_annotation_json = json.dumps({
            "media": "b3c22994-2eca-11e5-bd56-58b035f6b93d",
            "project": "c0bc66fa-2eca-11e5-a518-58b035f6b93d",
            "begin": 0,
            "end": 0,
            "type_title": "ann_type_test",
            "content": {
                "title": "ann_title_test",
                "description": "ann_description_test"
            },
            "meta": {
                "creator": "admin",
                "created": "2015-07-20T10:33:46.282Z"
            },
            "tags": [],
        })
        self.test_edition_prep_data_dict = {
            "media": "b3c22994-2eca-11e5-bd56-58b035f6b93d",
            "project": "c0bc66fa-2eca-11e5-a518-58b035f6b93d",
            "begin": 2,
            "end": 3,
            "content": {
                "title": "ann_title_test_edited",
                "description": "ann_description_test_edited"
            },
            "meta": {
                "creator": "admin",
                "created": "2015-07-20T10:33:46.282Z"
            },
            "tags": ["added_tag"],
        }

    def testPost(self):
        resp = self.api_client.client.post(reverse('api_dispatch_list', kwargs={'api_name':'1.0', 'resource_name':'annotations'}), content_type='application/json', data=self.test_annotation_json)
        self.assertHttpCreated(resp)
        created_ann_data = json.loads(resp.content)
        annotation = Segment.objects.get(project_id=created_ann_data["project"], iri_id=created_ann_data["media"], cutting_id=created_ann_data["type"], element_id=created_ann_data["id"])
        
        self.assertRegexpMatches(annotation.element_id, "s_[0-9a-f]{8}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{12}", "should match a guid prefixed with s_")
        self.assertEqual("ann_title_test", annotation.title)
        self.assertEqual("ann_description_test", annotation.abstract)
        self.assertEqual(0, annotation.start_ts)
        self.assertEqual(0, annotation.duration)
        self.assertEqual("admin", annotation.author)
        self.assertEqual("2015-07-20T10:33:46.282Z", annotation.date)
        self.assertEqual("", annotation.get_tags())
        
    def testPut(self):
        post_resp = self.api_client.client.post(reverse('api_dispatch_list', kwargs={'api_name':'1.0', 'resource_name':'annotations'}), content_type='application/json', data=self.test_annotation_json)
        
        ann_id = json.loads(post_resp.content)["id"]
        type_id = json.loads(post_resp.content)["type"]
        editing_data = self.test_edition_prep_data_dict
        editing_data["id"] = ann_id
        editing_data["type"] = type_id
        
        put_resp = self.api_client.client.put(reverse('api_dispatch_detail', kwargs={'api_name':'1.0', 'resource_name':'annotations', 'pk': ann_id}), content_type='application/json', data=json.dumps(editing_data))
        edited_ann_data = json.loads(put_resp.content)
        edited_annotation = Segment.objects.get(project_id=edited_ann_data["project"], iri_id=edited_ann_data["media"], cutting_id=edited_ann_data["type"], element_id=edited_ann_data["id"])
        
        self.assertEqual(ann_id, edited_annotation.element_id)
        self.assertEqual(type_id, edited_annotation.cutting_id)
        self.assertEqual("ann_title_test_edited", edited_annotation.title)
        self.assertEqual("ann_description_test_edited", edited_annotation.abstract)
        self.assertEqual(2, edited_annotation.start_ts)
        self.assertEqual(1, edited_annotation.duration) # begin 2, end 3, duration is 1
        self.assertEqual("admin", edited_annotation.author)
        self.assertEqual("2015-07-20T10:33:46.282Z", edited_annotation.date)
        self.assertEqual("added_tag", edited_annotation.get_tags())
        
        
    def tearDown(self):
        pass