"""
Call this like ``python create_python_env.py``; it will
refresh the project-boot.py script

-prerequisite:

- virtualenv
- distribute
- psycopg2 requires the PostgreSQL libpq libraries and the pg_config utility

- python project-boot.py --distribute --no-site-packages --index-url=http://pypi.websushi.org/ --clear --type-install=local <path_to_venv>
- For Linux :
python project-boot.py --unzip-setuptools --no-site-packages --index-url=http://pypi.websushi.org/ --clear --type-install=local <path_to_venv>

"""

import os
import subprocess
import re
import sys


here = os.path.dirname(os.path.abspath(__file__))
base_dir = here
script_name = os.path.join(base_dir, 'project-boot.py')

import virtualenv

# things to install
# - psycopg2 -> pip
# - PIL -> pip
# - pyxml -> pip
# - 4Suite-xml - easy_install ftp://ftp.4suite.org/pub/4Suite/4Suite-XML-1.0.2.tar.bz2
# - pylucene  - script

src_base = os.path.join(here,"res","src").replace("\\","/")
lib_path = os.path.abspath(os.path.join(here,"res","lib")).replace("\\","/")
patch_path = os.path.abspath(os.path.join(here,"res","patch")).replace("\\","/")

EXTRA_TEXT  = "URLS = { \n"

EXTRA_TEXT += "    'DISTRIBUTE' : { 'setup': 'distribute', 'url': 'http://pypi.python.org/packages/source/d/distribute/distribute-0.6.14.tar.gz', 'local': '"+ os.path.abspath(os.path.join(src_base,"distribute-0.6.14.tar.gz")).replace("\\","/")+"'},\n"
if sys.platform == 'win32':
    EXTRA_TEXT += "    'PSYCOPG2' : { 'setup': 'psycopg2','url': 'D:/wakimd/dev/hg/platform/virtualenv/web/res/src/psycopg2-2.0.10.win32-py2.6-pg8.3.7-release.zip', 'local': '"+ os.path.abspath(os.path.join(src_base,"psycopg2-2.0.10.win32-py2.6-pg8.3.7-release.zip")).replace("\\","/")+"'},\n"
else:
    EXTRA_TEXT += "    'PSYCOPG2' : { 'setup': 'psycopg2','url': 'http://initd.org/psycopg/tarballs/PSYCOPG-2-3/psycopg2-2.3.2.tar.gz', 'local': '"+ os.path.abspath(os.path.join(src_base,"psycopg2-2.3.2.tar.gz")).replace("\\","/")+"'},\n"
EXTRA_TEXT += "    'MYSQL' : { 'setup': 'mysql-python', 'url': 'http://sourceforge.net/projects/mysql-python/files/mysql-python/1.2.3/MySQL-python-1.2.3.tar.gz/download', 'local' : '"+ os.path.abspath(os.path.join(src_base,"MySQL-python-1.2.3.tar.gz")).replace("\\","/")+"'},\n"
if sys.platform == 'win32':
    EXTRA_TEXT += "    'PYLUCENE' : { 'setup': 'http://pylucene-win32-binary.googlecode.com/files/lucene-3.0.2-py2.6-win32.egg', 'local': '"+ os.path.abspath(os.path.join(src_base,"lucene-3.0.2-py2.6-win32.egg")).replace("\\","/")+"'},\n"
    EXTRA_TEXT += "    'JCC' : { 'setup': 'http://pylucene-win32-binary.googlecode.com/files/JCC-2.6-py2.6-win32.egg', 'local': '"+ os.path.abspath(os.path.join(src_base,"JCC-2.6-py2.6-win32.egg")).replace("\\","/")+"'},\n"
else:
    EXTRA_TEXT += "    'PYLUCENE' : { 'setup': 'http://apache.crihan.fr/dist/lucene/pylucene/pylucene-3.0.3-1-src.tar.gz', 'url': 'http://apache.crihan.fr/dist/lucene/pylucene/pylucene-3.0.3-1-src.tar.gz', 'local': '"+ os.path.abspath(os.path.join(src_base,"pylucene-3.0.3-1-src.tar.gz")).replace("\\","/")+"'},\n"
if sys.platform == 'win32':
    EXTRA_TEXT += "    'PIL' : { 'setup': 'pil', 'url': 'http://effbot.org/media/downloads/PIL-1.1.7.win32-py2.6.exe', 'local': '"+ os.path.abspath(os.path.join(src_base,"PIL-1.1.7.win32-py2.6.exe")).replace("\\","/")+"'},\n"
else:
    EXTRA_TEXT += "    'PIL' : { 'setup': 'pil', 'url': 'http://effbot.org/downloads/Imaging-1.1.7.tar.gz', 'local': '"+ os.path.abspath(os.path.join(src_base,"Imaging-1.1.7.tar.gz")).replace("\\","/")+"'},\n"
EXTRA_TEXT += "    'DJANGO' : { 'setup': 'django', 'url': 'http://www.djangoproject.com/download/1.2.4/tarball/', 'local': '"+ os.path.abspath(os.path.join(src_base,"Django-1.2.4.tar.gz")).replace("\\","/")+"'},\n"
EXTRA_TEXT += "    'JOGGING' : { 'setup': 'jogging', 'url': 'http://github.com/zain/jogging/tarball/v0.2.2', 'local': '"+ os.path.abspath(os.path.join(src_base,"jogging-0.2.2.tar.gz")).replace("\\","/")+"'},\n"
EXTRA_TEXT += "    'DJANGO-EXTENSIONS' : { 'setup': 'django-extensions', 'url':'https://github.com/django-extensions/django-extensions/tarball/0.6', 'local':'"+ os.path.abspath(os.path.join(src_base,"django-extensions-0.6.tar.gz")).replace("\\","/")+"' },\n"
EXTRA_TEXT += "    'DJANGO-REGISTRATION' : { 'setup': 'django-registration', 'url':'http://bitbucket.org/ubernostrum/django-registration/get/tip.tar.gz', 'local':'"+ os.path.abspath(os.path.join(src_base,"django-registration.tar.gz")).replace("\\","/")+"' },\n"
EXTRA_TEXT += "    'DJANGO-TAGGING' : { 'setup': 'django-tagging', 'url':'http://django-tagging.googlecode.com/files/django-tagging-0.3.1.tar.gz', 'local':'"+ os.path.abspath(os.path.join(src_base,"django-tagging-0.3.1.tar.gz")).replace("\\","/")+"' },\n"
EXTRA_TEXT += "    'DJANGO-PISTON' : { 'setup': 'django-piston', 'url':'http://bitbucket.org/jespern/django-piston/downloads/django-piston-0.2.2.tar.gz', 'local':'"+ os.path.abspath(os.path.join(src_base,"django-piston-0.2.2.tar.gz")).replace("\\","/")+"' },\n"
if sys.platform == 'win32':
    EXTRA_TEXT += "    'LXML' : { 'setup': 'lxml', 'url': 'http://pypi.python.org/packages/2.6/l/lxml/lxml-2.2.8-py2.6-win32.egg', 'local': '"+ os.path.abspath(os.path.join(src_base,"lxml-2.2.8-py2.6-win32.egg")).replace("\\","/")+"'},\n"
else:
    EXTRA_TEXT += "    'LXML' : { 'setup': 'lxml', 'url': '"+ os.path.abspath(os.path.join(src_base,"lxml_2.2.8.tar.gz"))+"', 'local': '"+ os.path.abspath(os.path.join(src_base,"lxml-2.2.8.tar.gz")).replace("\\","/")+"'},\n"
EXTRA_TEXT += "}\n"

EXTRA_TEXT += "import sys\n"
EXTRA_TEXT += "sys.path.append('"+lib_path+"')\n"

EXTRA_TEXT += """

import shutil
import tarfile
import zipfile
import urllib
import platform
import patch


INDEX_URL = 'http://pypi.python.org/simple/'


def extend_parser(parser):
    parser.add_option(
        '--index-url',
        metavar='INDEX_URL',
        dest='index_url',
        default='',
        help='base URL of Python Package Index')
    parser.add_option(
        '--type-install',
        metavar='type_install',
        dest='type_install',
        default='local',
        help='type install : local, url, setup')
    parser.add_option(
        '--ignore-packages',
        metavar='ignore_packages',
        dest='ignore_packages',
        default=None,
        help='list of comma separated keys for package to ignore')



def adjust_options(options, args):
    pass


def after_install(options, home_dir):
    home_dir, lib_dir, inc_dir, bin_dir = path_locations(home_dir)
    base_dir = os.path.dirname(home_dir)
    src_dir = join(home_dir, 'src')
    tmp_dir = join(home_dir, 'tmp')
    ensure_dir(src_dir)
    ensure_dir(tmp_dir)
    system_str = platform.system()
    
    res_source_key = options.type_install
    
    ignore_packages = []
    
    if options.ignore_packages :
        ignore_packages = options.ignore_packages.split(",")
    
    logger.indent += 2
    try:
        
        if 'PYLUCENE' not in ignore_packages and system_str != "Windows":
            #get pylucene
            logger.notify("Get Pylucene from %s " % URLS['PYLUCENE'][res_source_key])
            pylucene_src = os.path.join(src_dir,"pylucene.tar.gz")
            if res_source_key == 'local':
                shutil.copy(URLS['PYLUCENE'][res_source_key], pylucene_src)
            else:
                urllib.urlretrieve(URLS['PYLUCENE'][res_source_key], pylucene_src)
            tf = tarfile.open(pylucene_src,'r:gz')
            pylucene_base_path = os.path.join(src_dir,"pylucene") 
            logger.notify("Extract Pylucene to %s " % pylucene_base_path)
            tf.extractall(pylucene_base_path)
            tf.close()
            
            pylucene_src_path = os.path.join(pylucene_base_path, os.listdir(pylucene_base_path)[0])
            jcc_src_path = os.path.abspath(os.path.join(pylucene_src_path,"jcc"))
            
            #install jcc
    
            #patch for linux
            if system_str == 'Linux' :
                olddir = os.getcwd()
                patch_dest_path = os.path.join(lib_dir,'site-packages','setuptools-0.6c11-py'+'%s.%s' % (sys.version_info[0], sys.version_info[1])+'.egg')
                if os.path.isfile(patch_dest_path):
                    # must unzip egg
                    # rename file and etract all
                    shutil.move(patch_dest_path, patch_dest_path + ".zip")
                    zf = zipfile.ZipFile(patch_dest_path + ".zip",'r')
                    zf.extractall(patch_dest_path)
                    os.remove(patch_dest_path + ".zip")
                logger.notify("Patch jcc : %s " % (patch_dest_path))
                os.chdir(patch_dest_path)
                p = patch.fromfile(os.path.join(jcc_src_path,"jcc","patches","patch.43.0.6c11"))
                p.apply()
                os.chdir(olddir)
    
            logger.notify("Install jcc")
            call_subprocess([os.path.abspath(os.path.join(home_dir, 'bin', 'python')), 'setup.py', 'install'],
                            cwd=jcc_src_path,
                            filter_stdout=filter_python_develop,
                            show_stdout=True)
            #install pylucene
            
            logger.notify("Install pylucene")
            #modify makefile
            makefile_path = os.path.join(pylucene_src_path,"Makefile")
            logger.notify("Modify makefile %s " % makefile_path)
            shutil.move( makefile_path, makefile_path+"~" )
    
            destination= open( makefile_path, "w" )
            source= open( makefile_path+"~", "r" )
            destination.write("PREFIX_PYTHON="+os.path.abspath(home_dir)+"\\n")
            destination.write("ANT=ant\\n")
            destination.write("PYTHON=$(PREFIX_PYTHON)/bin/python\\n")
            
            if system_str == "Darwin":
                if sys.version_info >= (2,6):
                    destination.write("JCC=$(PYTHON) -m jcc.__main__ --shared --arch x86_64 --arch i386\\n")
                else:
                    destination.write("JCC=$(PYTHON) -m jcc --shared --arch x86_64 --arch i386\\n")
                destination.write("NUM_FILES=2\\n")
            elif system_str == "Windows":
                destination.write("JCC=$(PYTHON) -m jcc.__main__ --shared --arch x86_64 --arch i386\\n")
                destination.write("NUM_FILES=2\\n")
            else:
                if sys.version_info >= (2,6) and sys.version_info < (2,7):
                    destination.write("JCC=$(PYTHON) -m jcc.__main__ --shared\\n")
                else:
                    destination.write("JCC=$(PYTHON) -m jcc --shared\\n")
                destination.write("NUM_FILES=2\\n")
            for line in source:
                destination.write( line )
            source.close()
            destination.close()
            os.remove(makefile_path+"~" )
    
            logger.notify("pylucene make")
            call_subprocess(['make'],
                            cwd=os.path.abspath(pylucene_src_path),
                            filter_stdout=filter_python_develop,
                            show_stdout=True)
    
            logger.notify("pylucene make install")
            call_subprocess(['make', 'install'],
                            cwd=os.path.abspath(pylucene_src_path),
                            filter_stdout=filter_python_develop,
                            show_stdout=True)

        if system_str == 'Linux'  and 'DISTRIBUTE' not in ignore_packages:
            normal_install('DISTRIBUTE', 'pip', None, None, res_source_key, home_dir, tmp_dir)

        NORMAL_INSTALL = [ #(key,method, option_str, extra_env)
            ('MYSQL', 'pip', None, None),
            ('PIL', 'easy_install', None, None), 
            ('DJANGO','pip', None, None),
            ('JOGGING','pip', None, None),
            ('DJANGO-EXTENSIONS', 'pip', None, None),
            ('DJANGO-REGISTRATION', 'easy_install', '-Z', None),
            ('DJANGO-TAGGING', 'pip', None, None),
            ('DJANGO-PISTON', 'pip', None, None),
            ]

        if 'PYLUCENE' not in ignore_packages and system_str == "Windows":
            NORMAL_INSTALL.append(('JCC','easy_install',None,None))
            NORMAL_INSTALL.append(('PYLUCENE','easy_install',None,None))
             
        if system_str == "Darwin":
            NORMAL_INSTALL.append(('LXML', 'easy_install', None, {'STATIC_DEPS': 'true'}))
        else:
            NORMAL_INSTALL.append(('LXML', 'easy_install', None, None))
        
        if system_str == "Windows":
            #get psycopg2
            psycopg2_src = os.path.join(src_dir,"psycopg2.zip")
            shutil.copy(URLS['PSYCOPG2'][res_source_key], psycopg2_src)
            #extract psycopg2
            zf = zipfile.ZipFile(psycopg2_src)
            psycopg2_base_path = os.path.join(src_dir,"psycopg2")
            zf.extractall(psycopg2_base_path)
            zf.close()
            
            psycopg2_src_path = os.path.join(psycopg2_base_path, os.listdir(psycopg2_base_path)[0])
            shutil.copytree(os.path.join(psycopg2_src_path, 'psycopg2'), os.path.abspath(os.path.join(home_dir, 'Lib', 'psycopg2')))
            shutil.copy(os.path.join(psycopg2_src_path, 'psycopg2-2.0.10-py2.6.egg-info'), os.path.abspath(os.path.join(home_dir, 'Lib', 'site-packages')))
        else:
            NORMAL_INSTALL.append(('PSYCOPG2', 'pip', None, None))

            
        for key, method, option_str, extra_env in NORMAL_INSTALL:
            if key not in ignore_packages:
                normal_install(key, method, option_str, extra_env, res_source_key, home_dir, tmp_dir)
                        
        logger.notify("Clear source dir")
        shutil.rmtree(src_dir)

    finally:
        logger.indent -= 2
    script_dir = join(base_dir, bin_dir)
    logger.notify('Run "%s Package" to install new packages that provide builds'
                  % join(script_dir, 'easy_install'))


def normal_install(key, method, option_str, extra_env, res_source_key, home_dir, tmp_dir):
    logger.notify("Install %s from %s with %s" % (key,URLS[key][res_source_key],method))
    if method == 'pip':
        if sys.platform == 'win32':
            args = [os.path.abspath(os.path.join(home_dir, 'Scripts', 'pip')), 'install', '-E', os.path.abspath(home_dir), URLS[key][res_source_key]]
        else:
            args = [os.path.abspath(os.path.join(home_dir, 'bin', 'pip')), 'install', '-E', os.path.abspath(home_dir), URLS[key][res_source_key]]
        if option_str :
            args.insert(4,option_str)
        call_subprocess(args,
                cwd=os.path.abspath(tmp_dir),
                filter_stdout=filter_python_develop,
                show_stdout=True,
                extra_env=extra_env)
    else:
        if sys.platform == 'win32':
            args = [os.path.abspath(os.path.join(home_dir, 'Scripts', 'easy_install')), URLS[key][res_source_key]]
        else:
            args = [os.path.abspath(os.path.join(home_dir, 'bin', 'easy_install')), URLS[key][res_source_key]]
        if option_str :
            args.insert(1,option_str)
        call_subprocess(args,
                cwd=os.path.abspath(tmp_dir),
                filter_stdout=filter_python_develop,
                show_stdout=True,
                extra_env=extra_env)
    

def ensure_dir(dir):
    if not os.path.exists(dir):
        logger.notify('Creating directory %s' % dir)
        os.makedirs(dir)

def filter_python_develop(line):
    if not line.strip():
        return Logger.DEBUG
    for prefix in ['Searching for', 'Reading ', 'Best match: ', 'Processing ',
                   'Moving ', 'Adding ', 'running ', 'writing ', 'Creating ',
                   'creating ', 'Copying ']:
        if line.startswith(prefix):
            return Logger.DEBUG
    return Logger.NOTIFY
"""

def main():
    python_version = ".".join(map(str,sys.version_info[0:2]))
    text = virtualenv.create_bootstrap_script(EXTRA_TEXT, python_version=python_version)
    if os.path.exists(script_name):
        f = open(script_name)
        cur_text = f.read()
        f.close()
    else:
        cur_text = ''
    print 'Updating %s' % script_name
    if cur_text == 'text':
        print 'No update'
    else:
        print 'Script changed; updating...'
        f = open(script_name, 'w')
        f.write(text)
        f.close()

if __name__ == '__main__':
    main()

