
// initialize the app

var app = angular.module("recordApp", ['ngResource', 'ngRoute', 'pascalprecht.translate'])

app.service("Api", function($resource, context) {
    this.record = $resource(context.urls.record_api,
            {},
            {
                get: {
                    method: "GET",
                    isArray: false
                },
                save:{
                    method:"PUT",
                    isArray:false,
                    headers:{'X-CSRFToken':context.csrf_token} 
                } 
            });
});

app.service("RecordModel", function(Api, context) {    
    this.record = Api.record.get({recordId: context.record_id});
    this.uriLabels = context.uri_labels;
});

app.controller("RecordCtrl", function($scope, RecordModel, context){
    
    $scope.record = RecordModel.record;
    $scope.uriLabels = RecordModel.uriLabels;
    
        
    $scope.submitRecord = function() {
        $scope.record.$save({recordId: context.record_id});
    }
    
    $scope.removeFromList = function(uri, list) {
    	i = list.indexOf(uri);
    	if(i>=0){
    		list.splice(i, 1);
    	}
    };
});

app.controller("ThesaurusCtrl", function($scope, RecordModel) {

    $scope.record = RecordModel.record;
    $scope.uriLabels = RecordModel.uriLabels;
    $scope.addSubjectText = '';
    
    $scope.addSubject = function() {
        $scope.record.subjects.push($scope.addSubjectText);
        $scope.addSubjectText = '';
    };
    
    $scope.updateUriLabelDict = function(k,v) {
        $scope.uriLabels[k] = v;
    };
    
    
});

app.config(['$routeProvider', function($routeProvider) {
//    $routeProvider.when('/', {controller: 'RecordCtrl', templateUrl: 'partials/record.html'});
//    $routeProvider.otherwise({redirectTo: '/'});
  }]);

