# -*- coding: utf-8 -*-
'''
Created on Sep 2, 2013

@author: ymh
'''
from p4l.models import (Record, Title, Issn, Isbn, DocumentCode, Abstract, 
    AddedTitle, TitleMainDocument, Imprint, Collation, VolumeIssue, Periodical, 
    Meeting, SubjectMeeting, Serie, Url)
from rest_framework import serializers

class BaseTitleSerializer(serializers.ModelSerializer):
    class Meta:
        fields = ('title','lang')
    
class TitleSerializer(BaseTitleSerializer):    
    class Meta(BaseTitleSerializer.Meta):
        model = Title

class AddedTitleSerializer(BaseTitleSerializer):    
    class Meta(BaseTitleSerializer.Meta):
        model = AddedTitle

class TitleMainDocumentSerializer(BaseTitleSerializer):    
    class Meta(BaseTitleSerializer.Meta):
        model = TitleMainDocument

class IssnSerializer(serializers.ModelSerializer):
    class Meta:
        model = Issn
        fields = ('issn','lang')

class IsbnSerializer(serializers.ModelSerializer):
    class Meta:
        model = Isbn
        fields = ('isbn','lang')

class DocumentCodeSerializer(serializers.ModelSerializer):
    class Meta:
        model = DocumentCode
        fields = ('documentCode','lang')
        
class AbstractSerializer(serializers.ModelSerializer):
    class Meta:
        model = Abstract
        fields = ('abstract', 'lang')

class ImprintSerializer(serializers.ModelSerializer):
    class Meta:
        model = Imprint
        fields = ('imprintCity','publisher', 'imprintDate', 'lang')

class CollationSerializer(serializers.ModelSerializer):
    class Meta:
        model = Collation
        fields = ('collation', 'lang')

class VolumeIssueSerializer(serializers.ModelSerializer):
    class Meta:
        model = VolumeIssue
        fields = ('volume', 'number', 'lang')

class PeriodicalSerializer(serializers.ModelSerializer):
    class Meta:
        model = Periodical
        fields = ('label', 'lang')

class MeetingSerializer(serializers.ModelSerializer):
    class Meta:
        model = Meeting
        fields = ('label','meetingNumber', 'meetingPlace','meetingDate', 'meetingYear', 'lang')

class SubjectMeetingSerializer(serializers.ModelSerializer):
    class Meta:
        model = SubjectMeeting
        fields = ('label','meetingNumber', 'meetingPlace','meetingDate', 'meetingYear')

class SerieSerializer(serializers.ModelSerializer):
    class Meta:
        model = Serie
        fields = ('title', 'volume', 'lang')

class UrlSerializer(serializers.ModelSerializer):
    class Meta:
        model = Url
        fields = ('address', 'display', 'accessLevel')

class RecordSerializer(serializers.ModelSerializer):
    '''
    Serializer for record
    '''

    language = serializers.SlugRelatedField(read_only=False, slug_field='uri') 
    other_languages = serializers.SlugRelatedField(many=True, read_only=False, slug_field='uri')
    subjects = serializers.SlugRelatedField(many=True, read_only=False, slug_field='uri')
    themes = serializers.SlugRelatedField(many=True, read_only=False, slug_field='uri')
    countries = serializers.SlugRelatedField(many=True, read_only=False, slug_field='uri')
    projectNames = serializers.SlugRelatedField(many=True, read_only=False, slug_field='uri')
    subjectCorporateBodies = serializers.SlugRelatedField(many=True, read_only=False, slug_field='uri') 
    corporateAuthors = serializers.SlugRelatedField(many=True, read_only=False, slug_field='uri')
    titles = TitleSerializer(many=True, read_only=False)
    addedTitles = AddedTitleSerializer(many=True, read_only=False)
    issns = IssnSerializer(many=True, read_only=False)
    isbns = IsbnSerializer(many=True, read_only=False)
    documentCodes = DocumentCodeSerializer(many=True, read_only=False)
    abstracts = AbstractSerializer(many=True, read_only=False)
    titlesMainDocument = TitleMainDocumentSerializer(many=True, read_only=False)
    imprints = ImprintSerializer(many=True, read_only=False)
    collations = CollationSerializer(many=True, read_only=False)    
    volumeIssues = VolumeIssueSerializer(many=True, read_only=False)
    periodicals = PeriodicalSerializer(many=True, read_only=False)
    meetings = MeetingSerializer(many=True, read_only=False)
    subjectMeetings = SubjectMeetingSerializer(many=True, read_only=False)
    series = SerieSerializer(many=True, read_only=False)
    authors = serializers.SlugRelatedField(many=True, read_only=False, slug_field="name")
    subjectPersons = serializers.SlugRelatedField(many=True, read_only=False, slug_field="name")
    urls = UrlSerializer(many=True, read_only=False)

    class Meta:
        model = Record
        depth = 1
        read_only_fields = ('identifier', 'uri')
        fields = ("identifier", "uri", "language", "otherLanguages", "notes",
                  "editionStatement", "recordType","isDocumentPart",
                  "isMultilingual","subjects", "themes", "countries",
                  "projectNames", "subjectCorporateBodies", "corporateAuthors",
                  "titles", "issns", "isbns", "documentCodes", "abstracts",
                  "addedTitles", "titlesMainDocument", "imprints",
                  "collations", "volumeIssues", "periodicals", "meetings",
                  "subjectMeetings", "series", "authors", "subjectPersons",
                  "urls")        


    