# -*- coding: utf-8 -*-

from django.conf import settings
from django.core.management import BaseCommand
from p4l.models import Language
from p4l.utils import show_progress
import logging
import requests

logger = logging.getLogger(__name__)

class Command(BaseCommand):
    
    query = """
PREFIX skos:<http://www.w3.org/2004/02/skos/core#>
PREFIX rdf:<http://www.w3.org/1999/02/22-rdf-syntax-ns#>
PREFIX owl:<http://www.w3.org/2002/07/owl#>
PREFIX rdfs:<http://www.w3.org/2000/01/rdf-schema#>
SELECT ?uri ?label 
WHERE {
    ?uri skos:inScheme <http://www.iiep.unesco.org/plan4learning/scheme/Languages> .
    ?uri skos:prefLabel|skos:label ?label .
    FILTER (?uri = $root)
}
"""
    
    def fill_label(self):
        # Loads Subjects label from sparkl query
        langs = Language.objects.filter(label=None)
        total_langs = len(langs)
        writer = None
        i = 0
        found = 0
        for l in langs:
            i += 1
            logger.debug("1")
            logger.debug(l)
            logger.debug("2")
            logger.debug(l.language)
            res = requests.get(
                settings.SPARQL_QUERY_ENDPOINT,
                params={'query':self.query, 'timeout':10, '$root' : "<"+l.language+">"},
                headers={'accept':'application/sparql-results+json'},
            )
            if not res.ok:
                continue
            elif res.text:
                json_res = res.json()
                if 'results' in json_res and 'bindings' in json_res['results'] and len(json_res['results']['bindings'])>0:
                    # json_res['results']['bindings'] has several languages. If we find french, we save the french label.
                    # If not, we save the first one.
                    tmp_dict = {}
                    first_label = None
                    # We create a temporary dict with the lang code and the label
                    for b in json_res['results']['bindings']:
                        if 'label' in b and 'value' in b['label'] and 'xml:lang' in b['label']:
                            tmp_dict[b['label']['xml:lang']] = b['label']['value']
                            if not first_label:
                                first_label = b['label']['value']
                    if 'fr' in tmp_dict or first_label:
                        if 'fr' in tmp_dict:
                            l.label = tmp_dict['fr']
                        else:
                            l.label = first_label
                        lab = l.label
                        l.save()
                        found += 1
                        writer = show_progress(i, total_langs, lab, 50, writer=writer)
        print("Processing Subjects Sparql Done. %d found on %d" % (found, total_langs))

    def handle(self, *args, **options):
        self.fill_label()

