# -*- coding: utf-8 -*-

from django.conf import settings
from django.core.management import BaseCommand
from p4l.models import Country
from p4l.utils import show_progress
import logging
import requests

logger = logging.getLogger(__name__)

class Command(BaseCommand):
    
    query = """
PREFIX skos:<http://www.w3.org/2004/02/skos/core#>
PREFIX rdf:<http://www.w3.org/1999/02/22-rdf-syntax-ns#>
PREFIX owl:<http://www.w3.org/2002/07/owl#>
PREFIX rdfs:<http://www.w3.org/2000/01/rdf-schema#>
SELECT ?uri ?label 
WHERE {
    ?uri skos:inScheme <http://skos.um.es/unescothes/CS000/Countries> .
    ?uri skos:prefLabel|skos:label ?label .
    FILTER (?uri = $root)
}
"""
    
    def fill_label(self):
        # Loads Countries label from sparkl query
        countries = Country.objects.filter(label=None)
        total_countries = len(countries)
        writer = None
        i = 0
        found = 0
        for c in countries:
            i += 1
            res = requests.get(
                settings.SPARQL_QUERY_ENDPOINT,
                params={'query':self.query, 'timeout':10, '$root' : "<"+c.country+">"},
                headers={'accept':'application/sparql-results+json'},
            )
            if not res.ok:
                continue
            elif res.text:
                json_res = res.json()
                if 'results' in json_res and 'bindings' in json_res['results'] and len(json_res['results']['bindings'])>0:
                    # json_res['results']['bindings'] has several languages. If we find french, we save the french label.
                    # If not, we save the first one.
                    tmp_dict = {}
                    first_label = None
                    # We create a temporary dict with the lang code and the label
                    for b in json_res['results']['bindings']:
                        if 'label' in b and 'value' in b['label'] and 'xml:lang' in b['label']:
                            tmp_dict[b['label']['xml:lang']] = b['label']['value']
                            if not first_label:
                                first_label = b['label']['value']
                    if 'fr' in tmp_dict or first_label:
                        if 'fr' in tmp_dict:
                            c.label = tmp_dict['fr']
                        else:
                            c.label = first_label
                        l = c.label
                        c.save()
                        found += 1
                        writer = show_progress(i, total_countries, l, 50, writer=writer)
        print("Processing Subjects Sparql Done. %d found on %d" % (found, total_countries))

    def handle(self, *args, **options):
        self.fill_label()

