# -*- coding: utf-8 -*-
'''
Created on Sep 20, 2013

@author: ymh
'''

from haystack import indexes

from p4l.models import Record
from p4l.utils import strip_accents


class RecordIndex(indexes.SearchIndex, indexes.Indexable):

    text = indexes.CharField(document=True, use_template=True, stored=False)
    identifier = indexes.CharField(model_attr="identifier", stored=True)
    titles = indexes.MultiValueField(model_attr="get_titles", stored=False)
    titles_src = indexes.MultiValueField(model_attr="get_titles", stored=True, indexed=False)
    authors = indexes.MultiValueField(model_attr="get_authors", stored=False)
    
    years = indexes.MultiValueField(model_attr="get_imprints_years", indexed=False, stored=True)
    
    def prepare_titles(self, obj):
        return [strip_accents(v) for v in obj.get_titles()]

    def prepare_authors(self, obj):
        return [strip_accents(v) for v in obj.get_authors()]

    def get_model(self):
        return Record

    def get_updated_field(self):
        return "modification_date"
    
    def index_queryset(self, using=None):
        return Record.objects.using(using).all().prefetch_related("imprints","authors", "titles")