from rdflib.namespace import RDFS

from p4l.mapping.constants import IIEP, DCT
from p4l.mapping.serializers import (ModelSerializer, SimpleFieldSerializer, 
    BooleanFieldSerializer, RelatedFieldSerializer)


class ImprintSerializer(ModelSerializer):
    
    imprintCity = SimpleFieldSerializer(predicate=IIEP.imprintCity, lang_field='lang')
    publisher = SimpleFieldSerializer(predicate=IIEP.publisher, lang_field='lang')
    imprintDate = SimpleFieldSerializer(predicate=IIEP.imprintDate, lang_field='lang')


class VolumeIssueSerializer(ModelSerializer):
    volume = SimpleFieldSerializer(predicate=IIEP.volume, lang_field='lang')
    number = SimpleFieldSerializer(predicate=IIEP.number, lang_field='lang')


class MeetingSerializer(ModelSerializer):
    label = SimpleFieldSerializer(predicate=RDFS.label, lang_field='lang')
    meetingNumber = SimpleFieldSerializer(predicate=IIEP.meetingNumber, lang_field='lang')
    meetingPlace = SimpleFieldSerializer(predicate=IIEP.meetingPlace, lang_field='lang')
    meetingDate = SimpleFieldSerializer(predicate=IIEP.meetingDate, lang_field='lang')
    meetingYear = SimpleFieldSerializer(predicate=IIEP.meetingYear, lang_field='lang')

class SubjectMeetingSerializer(ModelSerializer):
    label = SimpleFieldSerializer(predicate=RDFS.label)
    meetingNumber = SimpleFieldSerializer(predicate=IIEP.meetingNumber)
    meetingPlace = SimpleFieldSerializer(predicate=IIEP.meetingPlace)
    meetingDate = SimpleFieldSerializer(predicate=IIEP.meetingDate)
    meetingYear = SimpleFieldSerializer(predicate=IIEP.meetingYear)


class SerieSerializer(ModelSerializer):
    title = SimpleFieldSerializer(predicate=DCT.title, lang_field='lang')
    volume = SimpleFieldSerializer(predicate=IIEP.volume, lang_field='lang')


class UrlSerializer(ModelSerializer):
    address = SimpleFieldSerializer(predicate=IIEP.address)
    display = SimpleFieldSerializer(predicate=IIEP.display)



class RecordSerializer(ModelSerializer):
    
    identifier = SimpleFieldSerializer(predicate=DCT.identifier)
    notes = SimpleFieldSerializer(predicate=IIEP.notes)
    editionStatement = SimpleFieldSerializer(predicate=IIEP.editionStatement)
    corporateAuthorLabel = SimpleFieldSerializer(predicate=IIEP.corporateAuthorLabel)
    recordType = SimpleFieldSerializer(predicate=DCT.type)
    isDocumentPart = BooleanFieldSerializer(predicate=IIEP.isDocumentPart)
    hidden = BooleanFieldSerializer(predicate=IIEP.hidden)
    restricted = BooleanFieldSerializer(predicate=IIEP.restricted)    

    language = RelatedFieldSerializer(many=False, value_field='uri', predicate=DCT.language) 
    otherLanguages = RelatedFieldSerializer(many=True, value_field='uri', predicate=IIEP.otherLanguage)
    subjects = RelatedFieldSerializer(many=True, value_field='uri', predicate=DCT.subject)
    themes = RelatedFieldSerializer(many=True, value_field='uri', predicate=IIEP.theme)
    countries = RelatedFieldSerializer(many=True, value_field='uri', predicate=IIEP.country)
    projectNames = RelatedFieldSerializer(many=True, value_field='uri', predicate=IIEP.projectName)
    subjectCorporateBodies = RelatedFieldSerializer(many=True, value_field='uri', predicate=IIEP.subjectCorporateBody) 
    corporateAuthors = RelatedFieldSerializer(many=True, value_field='uri', predicate=IIEP.corporateAuthor)
    audiences = RelatedFieldSerializer(many=True, value_field='uri', predicate=IIEP.audience)
    
    isbns = RelatedFieldSerializer(many=True, value_field='isbn', predicate=IIEP.isbn, lang_field='lang')
    issns = RelatedFieldSerializer(many=True, value_field='issn', predicate=IIEP.issn, lang_field='lang')
    collations = RelatedFieldSerializer(many=True, value_field='collation', predicate=IIEP.collation, lang_field='lang')
    documentCodes = RelatedFieldSerializer(many=True, value_field='documentCode', predicate=IIEP.documentCode, lang_field='lang')
    titles = RelatedFieldSerializer(many=True, value_field='title', predicate=IIEP.title, lang_field='lang')
    addedTitles = RelatedFieldSerializer(many=True, value_field='title', predicate=IIEP.addedTitle, lang_field='lang')
    titlesMainDocument = RelatedFieldSerializer(many=True, value_field='title', predicate=IIEP.titleMainDocument, lang_field='lang')
    abstracts = RelatedFieldSerializer(many=True, value_field='abstract', predicate=IIEP.abstract, lang_field='lang')
    periodicals = RelatedFieldSerializer(many=True, value_field='label', predicate=IIEP.periodical, lang_field='lang')
    authors = RelatedFieldSerializer(many=True, value_field='name', predicate=IIEP.author)
    subjectPersons = RelatedFieldSerializer(many=True, value_field='name', predicate=IIEP.subjectPerson)
    
    imprints = ImprintSerializer(many=True, predicate=IIEP.imprint)
    volumeIssues = VolumeIssueSerializer(many=True, predicate=IIEP.volumeIssue)
    meetings = MeetingSerializer(many=True, predicate=IIEP.meeting)
    subjectMeetings = SubjectMeetingSerializer(many=True, predicate=IIEP.subjectMeeting)
    series = SerieSerializer(many=True, predicate=IIEP.serie)
    urls = UrlSerializer(many=True, predicate=IIEP.url)
    
    
    class Meta:
        type = IIEP.Record
        uri_fieldname = "uri"
