# -*- coding: utf-8 -*-
#
# Copyright IRI (2013)
#
# contact@iri.centrepompidou.fr
#
# This software is governed by the CeCILL-B license under French law and
# abiding by the rules of distribution of free software.  You can  use, 
# modify and/ or redistribute the software under the terms of the CeCILL-B
# license as circulated by CEA, CNRS and INRIA at the following URL
# "http://www.cecill.info". 
#
# As a counterpart to the access to the source code and  rights to copy,
# modify and redistribute granted by the license, users are provided only
# with a limited warranty  and the software's author,  the holder of the
# economic rights,  and the successive licensors  have only  limited
# liability. 
#
# In this respect, the user's attention is drawn to the risks associated
# with loading,  using,  modifying and/or developing or reproducing the
# software by the user in light of its specific status of free software,
# that may mean  that it is complicated to manipulate,  and  that  also
# therefore means  that it is reserved for developers  and  experienced
# professionals having in-depth computer knowledge. Users are therefore
# encouraged to load and test the software's suitability as regards their
# requirements in conditions enabling the security of their systems and/or 
# data to be ensured and,  more generally, to use and operate it in the 
# same conditions as regards security. 
#
# The fact that you are presently reading this means that you have had
# knowledge of the CeCILL-B license and that you accept its terms.
#

from django import forms
from .widgets import SemanticTreeWidget, SemanticTagItWidget


class SubjectForm(forms.Form):
    # __reg__ is updated with the real regexp by the js
    subject = forms.CharField(required=True, label="Subjects", 
                          widget=SemanticTreeWidget(attrs={
                            'size':  25, 
                            'class': "form-control",
                            'data-url': "http://localhost:8080/openrdf-sesame/repositories/plan4learning",
                            'data-query':  
"""
PREFIX skos:<http://www.w3.org/2004/02/skos/core#>
PREFIX rdf:<http://www.w3.org/1999/02/22-rdf-syntax-ns#>
PREFIX owl:<http://www.w3.org/2002/07/owl#>
PREFIX rdfs:<http://www.w3.org/2000/01/rdf-schema#>
SELECT DISTINCT ?uri ?label
WHERE {
    ?uri a skos:Concept.
    ?uri skos:inScheme <http://skos.um.es/unescothes/CS000> .
    ?uri skos:prefLabel ?label.
    FILTER (lang(?label) = ?language).
    ?uri skos:prefLabel ?lab.
    FILTER regex (str(?lab), ?reg, 'i').
    FILTER (lang (?lab) = ?language).
    BIND (STRLEN(STRBEFORE (str(?lab), ?reg)) AS ?place).
    BIND (STRLEN(STR(?lab)) AS ?len)
}
ORDER BY ?place ?len ?lab
""",
                            'data-root-query':
"""
PREFIX skos:<http://www.w3.org/2004/02/skos/core#>
PREFIX rdf:<http://www.w3.org/1999/02/22-rdf-syntax-ns#>
PREFIX owl:<http://www.w3.org/2002/07/owl#>
PREFIX rdfs:<http://www.w3.org/2000/01/rdf-schema#>
SELECT DISTINCT ?uri ?label
WHERE {
    ?uri a skos:Collection ;
    skos:inScheme <http://skos.um.es/unescothes/CS000> ;    
    rdfs:label ?label .
    FILTER (lang(?label) = ?language). 
    FILTER NOT EXISTS { [skos:member ?uri] }
}
""",
                            'data-childs-query':
"""
PREFIX skos:<http://www.w3.org/2004/02/skos/core#>
PREFIX rdf:<http://www.w3.org/1999/02/22-rdf-syntax-ns#>
PREFIX owl:<http://www.w3.org/2002/07/owl#>
PREFIX rdfs:<http://www.w3.org/2000/01/rdf-schema#>
SELECT DISTINCT ?uri ?label
WHERE {
  ?uri skos:inScheme <http://skos.um.es/unescothes/CS000> .
  { ?uri a ?type
    FILTER (?type = skos:Collection || ?type = skos:Concept) }.
  ?root skos:narrower|skos:member ?uri.
  ?uri skos:prefLabel|rdfs:label ?label.
  FILTER (lang(?label) = ?language).
}
""",
                            'data-child-count-query':
"""
PREFIX skos:<http://www.w3.org/2004/02/skos/core#>
PREFIX rdf:<http://www.w3.org/1999/02/22-rdf-syntax-ns#>
PREFIX owl:<http://www.w3.org/2002/07/owl#>
PREFIX rdfs:<http://www.w3.org/2000/01/rdf-schema#>
SELECT (COUNT(?uri) as ?nb)
WHERE {
    ?uri skos:inScheme <http://skos.um.es/unescothes/CS000> .
    ?root skos:narrower|skos:member ?uri.
}
"""
                            }))




class SemForm(forms.Form):
    # __reg__ is updated with the real regexp by the js
    sem = forms.CharField(required=True, label="Dude, sem", 
                          widget=SemanticTreeWidget(attrs={
                            'size':  25, 
                            'class': "dude",
                            'data-url': "http://localhost:8080/openrdf-sesame/repositories/plan4learning",
                            'data-query':  
"""
PREFIX skos:<http://www.w3.org/2004/02/skos/core#>
PREFIX rdf:<http://www.w3.org/1999/02/22-rdf-syntax-ns#>
PREFIX owl:<http://www.w3.org/2002/07/owl#>
PREFIX rdfs:<http://www.w3.org/2000/01/rdf-schema#>
SELECT DISTINCT ?uri ?label
WHERE {
    ?uri a skos:Concept.
    ?uri skos:inScheme <http://skos.um.es/unescothes/CS000> .
    ?uri skos:prefLabel ?label.
    FILTER (lang(?label) = ?language).
    ?uri skos:prefLabel ?lab.
    FILTER regex (str(?lab), ?reg, 'i').
    FILTER (lang (?lab) = ?language).
    BIND (STRLEN(STRBEFORE (str(?lab), ?reg)) AS ?place).
    BIND (STRLEN(STR(?lab)) AS ?len)
}
ORDER BY ?place ?len ?lab
""",
                            'data-root-query':
"""
PREFIX skos:<http://www.w3.org/2004/02/skos/core#>
PREFIX rdf:<http://www.w3.org/1999/02/22-rdf-syntax-ns#>
PREFIX owl:<http://www.w3.org/2002/07/owl#>
PREFIX rdfs:<http://www.w3.org/2000/01/rdf-schema#>
SELECT DISTINCT ?uri ?label
WHERE {
    ?uri a skos:Collection ;
    skos:inScheme <http://skos.um.es/unescothes/CS000> ;    
    rdfs:label ?label .
    FILTER (lang(?label) = ?language). 
    FILTER NOT EXISTS { [skos:member ?uri] }
}
""",
                            'data-childs-query':
"""
PREFIX skos:<http://www.w3.org/2004/02/skos/core#>
PREFIX rdf:<http://www.w3.org/1999/02/22-rdf-syntax-ns#>
PREFIX owl:<http://www.w3.org/2002/07/owl#>
PREFIX rdfs:<http://www.w3.org/2000/01/rdf-schema#>
SELECT DISTINCT ?uri ?label
WHERE {
  ?uri skos:inScheme <http://skos.um.es/unescothes/CS000> .
  { ?uri a ?type
    FILTER (?type = skos:Collection || ?type = skos:Concept) }.
  ?root skos:narrower|skos:member ?uri.
  ?uri skos:prefLabel|rdfs:label ?label.
  FILTER (lang(?label) = ?language).
}
""",
                            'data-child-count-query':
"""
PREFIX skos:<http://www.w3.org/2004/02/skos/core#>
PREFIX rdf:<http://www.w3.org/1999/02/22-rdf-syntax-ns#>
PREFIX owl:<http://www.w3.org/2002/07/owl#>
PREFIX rdfs:<http://www.w3.org/2000/01/rdf-schema#>
SELECT (COUNT(?uri) as ?nb)
WHERE {
    ?uri skos:inScheme <http://skos.um.es/unescothes/CS000> .
    ?root skos:narrower|skos:member ?uri.
}
"""
                            }))
    iam = forms.CharField(required=True, label="Dude, iam", widget=SemanticTreeWidget(attrs={
                            'size':  25, 
                            'class': "dude",
                            'data-url': "http://localhost:8080/openrdf-sesame/repositories/plan4learning",
                            'data-query':  
"""
PREFIX skos:<http://www.w3.org/2004/02/skos/core#>
PREFIX rdf:<http://www.w3.org/1999/02/22-rdf-syntax-ns#>
PREFIX owl:<http://www.w3.org/2002/07/owl#>
PREFIX rdfs:<http://www.w3.org/2000/01/rdf-schema#>
SELECT DISTINCT ?uri ?label
WHERE {
    ?uri a skos:Concept.
    ?uri skos:inScheme <http://www.iiep.unesco.org/plan4learning/scheme/Themes> .
    ?uri skos:prefLabel ?label.
    FILTER (lang(?label) = ?language).
    ?uri skos:prefLabel ?lab.
    FILTER regex (str(?lab), ?reg, 'i').
    FILTER (lang (?lab) = ?language).
    BIND (STRLEN(STRBEFORE (str(?lab), ?reg)) AS ?place).
    BIND (STRLEN(STR(?lab)) AS ?len)
}
ORDER BY ?place ?len ?lab
""",
                            'data-root-query':
"""
PREFIX skos:<http://www.w3.org/2004/02/skos/core#>
PREFIX rdf:<http://www.w3.org/1999/02/22-rdf-syntax-ns#>
PREFIX owl:<http://www.w3.org/2002/07/owl#>
PREFIX rdfs:<http://www.w3.org/2000/01/rdf-schema#>
SELECT DISTINCT ?uri ?label
WHERE {
    ?uri a skos:Concept ;
    skos:inScheme <http://www.iiep.unesco.org/plan4learning/scheme/Themes> ;    
    skos:prefLabel ?label .
    FILTER (lang(?label) = ?language). 
    FILTER NOT EXISTS { [skos:narrower ?uri] }
}
""",
                            'data-childs-query':
"""
PREFIX skos:<http://www.w3.org/2004/02/skos/core#>
PREFIX rdf:<http://www.w3.org/1999/02/22-rdf-syntax-ns#>
PREFIX owl:<http://www.w3.org/2002/07/owl#>
PREFIX rdfs:<http://www.w3.org/2000/01/rdf-schema#>
SELECT DISTINCT ?uri ?label
WHERE {
  ?uri skos:inScheme <http://www.iiep.unesco.org/plan4learning/scheme/Themes> .
  { ?uri a ?type
    FILTER (?type = skos:Collection || ?type = skos:Concept) }.
  ?root skos:narrower|skos:member ?uri.
  ?uri skos:prefLabel|rdfs:label ?label.
  FILTER (lang(?label) = ?language).
}
""",
                            'data-child-count-query':
"""
PREFIX skos:<http://www.w3.org/2004/02/skos/core#>
PREFIX rdf:<http://www.w3.org/1999/02/22-rdf-syntax-ns#>
PREFIX owl:<http://www.w3.org/2002/07/owl#>
PREFIX rdfs:<http://www.w3.org/2000/01/rdf-schema#>
SELECT (COUNT(?uri) as ?nb)
WHERE {
    ?uri skos:inScheme <http://www.iiep.unesco.org/plan4learning/scheme/Themes> .
    ?root skos:narrower|skos:member ?uri.
}
"""
                            }))
    ntm = forms.CharField(required=True, label="Dude, ntm", widget=SemanticTagItWidget(attrs={
                            'size':  25, 
                            'class': "dude",
                            'data-url': "http://localhost:8080/openrdf-sesame/repositories/plan4learning",
                            'data-query':  
"""
PREFIX skos:<http://www.w3.org/2004/02/skos/core#>
PREFIX rdf:<http://www.w3.org/1999/02/22-rdf-syntax-ns#>
PREFIX owl:<http://www.w3.org/2002/07/owl#>
PREFIX rdfs:<http://www.w3.org/2000/01/rdf-schema#>
SELECT DISTINCT ?uri ?label
WHERE {
    ?uri a skos:Concept.
    ?uri skos:inScheme <http://www.iiep.unesco.org/plan4learning/scheme/Themes> .
    ?uri skos:prefLabel ?label.
    FILTER (lang(?label) = ?language).
    ?uri skos:prefLabel ?lab.
    FILTER regex (str(?lab), ?reg, 'i').
    FILTER (lang (?lab) = ?language).
    BIND (STRLEN(STRBEFORE (str(?lab), ?reg)) AS ?place).
    BIND (STRLEN(STR(?lab)) AS ?len)
}
ORDER BY ?place ?len ?lab
""",
                            'data-root-query':
"""
PREFIX skos:<http://www.w3.org/2004/02/skos/core#>
PREFIX rdf:<http://www.w3.org/1999/02/22-rdf-syntax-ns#>
PREFIX owl:<http://www.w3.org/2002/07/owl#>
PREFIX rdfs:<http://www.w3.org/2000/01/rdf-schema#>
SELECT DISTINCT ?uri ?label
WHERE {
    ?uri a skos:Concept ;
    skos:inScheme <http://www.iiep.unesco.org/plan4learning/scheme/Themes> ;    
    skos:prefLabel ?label .
    FILTER (lang(?label) = ?language). 
    FILTER NOT EXISTS { [skos:narrower ?uri] }
}
""",
                            'data-childs-query':
"""
PREFIX skos:<http://www.w3.org/2004/02/skos/core#>
PREFIX rdf:<http://www.w3.org/1999/02/22-rdf-syntax-ns#>
PREFIX owl:<http://www.w3.org/2002/07/owl#>
PREFIX rdfs:<http://www.w3.org/2000/01/rdf-schema#>
SELECT DISTINCT ?uri ?label
WHERE {
  ?uri skos:inScheme <http://www.iiep.unesco.org/plan4learning/scheme/Themes> .
  { ?uri a ?type
    FILTER (?type = skos:Collection || ?type = skos:Concept) }.
  ?root skos:narrower|skos:member ?uri.
  ?uri skos:prefLabel|rdfs:label ?label.
  FILTER (lang(?label) = ?language).
}
""",
                            'data-child-count-query':
"""
PREFIX skos:<http://www.w3.org/2004/02/skos/core#>
PREFIX rdf:<http://www.w3.org/1999/02/22-rdf-syntax-ns#>
PREFIX owl:<http://www.w3.org/2002/07/owl#>
PREFIX rdfs:<http://www.w3.org/2000/01/rdf-schema#>
SELECT (COUNT(?uri) as ?nb)
WHERE {
    ?uri skos:inScheme <http://www.iiep.unesco.org/plan4learning/scheme/Themes> .
    ?root skos:narrower|skos:member ?uri.
}
"""
                            }))



