# -*- coding: utf-8 -*-
'''
Created on Aug 30, 2013

@author: ymh
'''
from rdflib.graph import Graph
from rdflib.namespace import Namespace, RDF


DCT = Namespace("http://purl.org/dc/terms/")
IIEP = Namespace("http://www.iiep.unesco.org/plan4learning/model.owl#")
UNESCO = Namespace("http://www.iiep.unesco.org/Ontology/")

GRAPH_NAMESPACES = {
    'iiep': IIEP,
    'dct': DCT,
    'rdf': RDF
}

def get_empty_graph():
    record_graph = Graph()
    for prefix,uri in GRAPH_NAMESPACES.items():
        record_graph.bind(prefix,uri)
    return record_graph
