from django import forms
from .widgets import SemanticTreeWidget, SemanticTagItWidget


class SubjectForm(forms.Form):
    # __reg__ is updated with the real regexp by the js
    subject = forms.CharField(required=True, label="Subjects", 
                          widget=SemanticTreeWidget(attrs={
                            'size':  25, 
                            'class': "form-control",
                            'data-url': "http://localhost:8080/openrdf-sesame/repositories/plan4learning",
                            'data-query':  
"""
PREFIX skos:<http://www.w3.org/2004/02/skos/core#>
PREFIX rdf:<http://www.w3.org/1999/02/22-rdf-syntax-ns#>
PREFIX owl:<http://www.w3.org/2002/07/owl#>
PREFIX rdfs:<http://www.w3.org/2000/01/rdf-schema#>
SELECT DISTINCT ?uri ?label
WHERE {
    ?uri a skos:Concept.
    ?uri skos:inScheme <http://skos.um.es/unescothes/CS000> .
    ?uri skos:prefLabel ?label.
    FILTER (lang(?label) = ?language).
    ?uri skos:prefLabel ?lab.
    FILTER regex (str(?lab), ?reg, 'i').
    FILTER (lang (?lab) = ?language).
    BIND (STRLEN(STRBEFORE (str(?lab), ?reg)) AS ?place).
    BIND (STRLEN(STR(?lab)) AS ?len)
}
ORDER BY ?place ?len ?lab
""",
                            'data-root-query':
"""
PREFIX skos:<http://www.w3.org/2004/02/skos/core#>
PREFIX rdf:<http://www.w3.org/1999/02/22-rdf-syntax-ns#>
PREFIX owl:<http://www.w3.org/2002/07/owl#>
PREFIX rdfs:<http://www.w3.org/2000/01/rdf-schema#>
SELECT DISTINCT ?uri ?label
WHERE {
    ?uri a skos:Collection ;
    skos:inScheme <http://skos.um.es/unescothes/CS000> ;    
    rdfs:label ?label .
    FILTER (lang(?label) = ?language). 
    FILTER NOT EXISTS { [skos:member ?uri] }
}
""",
                            'data-childs-query':
"""
PREFIX skos:<http://www.w3.org/2004/02/skos/core#>
PREFIX rdf:<http://www.w3.org/1999/02/22-rdf-syntax-ns#>
PREFIX owl:<http://www.w3.org/2002/07/owl#>
PREFIX rdfs:<http://www.w3.org/2000/01/rdf-schema#>
SELECT DISTINCT ?uri ?label
WHERE {
  ?uri skos:inScheme <http://skos.um.es/unescothes/CS000> .
  { ?uri a ?type
    FILTER (?type = skos:Collection || ?type = skos:Concept) }.
  ?root skos:narrower|skos:member ?uri.
  ?uri skos:prefLabel|rdfs:label ?label.
  FILTER (lang(?label) = ?language).
}
""",
                            'data-child-count-query':
"""
PREFIX skos:<http://www.w3.org/2004/02/skos/core#>
PREFIX rdf:<http://www.w3.org/1999/02/22-rdf-syntax-ns#>
PREFIX owl:<http://www.w3.org/2002/07/owl#>
PREFIX rdfs:<http://www.w3.org/2000/01/rdf-schema#>
SELECT (COUNT(?uri) as ?nb)
WHERE {
    ?uri skos:inScheme <http://skos.um.es/unescothes/CS000> .
    ?root skos:narrower|skos:member ?uri.
}
"""
                            }))




class SemForm(forms.Form):
    # __reg__ is updated with the real regexp by the js
    sem = forms.CharField(required=True, label="Dude, sem", 
                          widget=SemanticTreeWidget(attrs={
                            'size':  25, 
                            'class': "dude",
                            'data-url': "http://localhost:8080/openrdf-sesame/repositories/plan4learning",
                            'data-query':  
"""
PREFIX skos:<http://www.w3.org/2004/02/skos/core#>
PREFIX rdf:<http://www.w3.org/1999/02/22-rdf-syntax-ns#>
PREFIX owl:<http://www.w3.org/2002/07/owl#>
PREFIX rdfs:<http://www.w3.org/2000/01/rdf-schema#>
SELECT DISTINCT ?uri ?label
WHERE {
    ?uri a skos:Concept.
    ?uri skos:inScheme <http://skos.um.es/unescothes/CS000> .
    ?uri skos:prefLabel ?label.
    FILTER (lang(?label) = ?language).
    ?uri skos:prefLabel ?lab.
    FILTER regex (str(?lab), ?reg, 'i').
    FILTER (lang (?lab) = ?language).
    BIND (STRLEN(STRBEFORE (str(?lab), ?reg)) AS ?place).
    BIND (STRLEN(STR(?lab)) AS ?len)
}
ORDER BY ?place ?len ?lab
""",
                            'data-root-query':
"""
PREFIX skos:<http://www.w3.org/2004/02/skos/core#>
PREFIX rdf:<http://www.w3.org/1999/02/22-rdf-syntax-ns#>
PREFIX owl:<http://www.w3.org/2002/07/owl#>
PREFIX rdfs:<http://www.w3.org/2000/01/rdf-schema#>
SELECT DISTINCT ?uri ?label
WHERE {
    ?uri a skos:Collection ;
    skos:inScheme <http://skos.um.es/unescothes/CS000> ;    
    rdfs:label ?label .
    FILTER (lang(?label) = ?language). 
    FILTER NOT EXISTS { [skos:member ?uri] }
}
""",
                            'data-childs-query':
"""
PREFIX skos:<http://www.w3.org/2004/02/skos/core#>
PREFIX rdf:<http://www.w3.org/1999/02/22-rdf-syntax-ns#>
PREFIX owl:<http://www.w3.org/2002/07/owl#>
PREFIX rdfs:<http://www.w3.org/2000/01/rdf-schema#>
SELECT DISTINCT ?uri ?label
WHERE {
  ?uri skos:inScheme <http://skos.um.es/unescothes/CS000> .
  { ?uri a ?type
    FILTER (?type = skos:Collection || ?type = skos:Concept) }.
  ?root skos:narrower|skos:member ?uri.
  ?uri skos:prefLabel|rdfs:label ?label.
  FILTER (lang(?label) = ?language).
}
""",
                            'data-child-count-query':
"""
PREFIX skos:<http://www.w3.org/2004/02/skos/core#>
PREFIX rdf:<http://www.w3.org/1999/02/22-rdf-syntax-ns#>
PREFIX owl:<http://www.w3.org/2002/07/owl#>
PREFIX rdfs:<http://www.w3.org/2000/01/rdf-schema#>
SELECT (COUNT(?uri) as ?nb)
WHERE {
    ?uri skos:inScheme <http://skos.um.es/unescothes/CS000> .
    ?root skos:narrower|skos:member ?uri.
}
"""
                            }))
    iam = forms.CharField(required=True, label="Dude, iam", widget=SemanticTreeWidget(attrs={
                            'size':  25, 
                            'class': "dude",
                            'data-url': "http://localhost:8080/openrdf-sesame/repositories/plan4learning",
                            'data-query':  
"""
PREFIX skos:<http://www.w3.org/2004/02/skos/core#>
PREFIX rdf:<http://www.w3.org/1999/02/22-rdf-syntax-ns#>
PREFIX owl:<http://www.w3.org/2002/07/owl#>
PREFIX rdfs:<http://www.w3.org/2000/01/rdf-schema#>
SELECT DISTINCT ?uri ?label
WHERE {
    ?uri a skos:Concept.
    ?uri skos:inScheme <http://www.iiep.unesco.org/plan4learning/scheme/Themes> .
    ?uri skos:prefLabel ?label.
    FILTER (lang(?label) = ?language).
    ?uri skos:prefLabel ?lab.
    FILTER regex (str(?lab), ?reg, 'i').
    FILTER (lang (?lab) = ?language).
    BIND (STRLEN(STRBEFORE (str(?lab), ?reg)) AS ?place).
    BIND (STRLEN(STR(?lab)) AS ?len)
}
ORDER BY ?place ?len ?lab
""",
                            'data-root-query':
"""
PREFIX skos:<http://www.w3.org/2004/02/skos/core#>
PREFIX rdf:<http://www.w3.org/1999/02/22-rdf-syntax-ns#>
PREFIX owl:<http://www.w3.org/2002/07/owl#>
PREFIX rdfs:<http://www.w3.org/2000/01/rdf-schema#>
SELECT DISTINCT ?uri ?label
WHERE {
    ?uri a skos:Concept ;
    skos:inScheme <http://www.iiep.unesco.org/plan4learning/scheme/Themes> ;    
    skos:prefLabel ?label .
    FILTER (lang(?label) = ?language). 
    FILTER NOT EXISTS { [skos:narrower ?uri] }
}
""",
                            'data-childs-query':
"""
PREFIX skos:<http://www.w3.org/2004/02/skos/core#>
PREFIX rdf:<http://www.w3.org/1999/02/22-rdf-syntax-ns#>
PREFIX owl:<http://www.w3.org/2002/07/owl#>
PREFIX rdfs:<http://www.w3.org/2000/01/rdf-schema#>
SELECT DISTINCT ?uri ?label
WHERE {
  ?uri skos:inScheme <http://www.iiep.unesco.org/plan4learning/scheme/Themes> .
  { ?uri a ?type
    FILTER (?type = skos:Collection || ?type = skos:Concept) }.
  ?root skos:narrower|skos:member ?uri.
  ?uri skos:prefLabel|rdfs:label ?label.
  FILTER (lang(?label) = ?language).
}
""",
                            'data-child-count-query':
"""
PREFIX skos:<http://www.w3.org/2004/02/skos/core#>
PREFIX rdf:<http://www.w3.org/1999/02/22-rdf-syntax-ns#>
PREFIX owl:<http://www.w3.org/2002/07/owl#>
PREFIX rdfs:<http://www.w3.org/2000/01/rdf-schema#>
SELECT (COUNT(?uri) as ?nb)
WHERE {
    ?uri skos:inScheme <http://www.iiep.unesco.org/plan4learning/scheme/Themes> .
    ?root skos:narrower|skos:member ?uri.
}
"""
                            }))
    ntm = forms.CharField(required=True, label="Dude, ntm", widget=SemanticTagItWidget(attrs={
                            'size':  25, 
                            'class': "dude",
                            'data-url': "http://localhost:8080/openrdf-sesame/repositories/plan4learning",
                            'data-query':  
"""
PREFIX skos:<http://www.w3.org/2004/02/skos/core#>
PREFIX rdf:<http://www.w3.org/1999/02/22-rdf-syntax-ns#>
PREFIX owl:<http://www.w3.org/2002/07/owl#>
PREFIX rdfs:<http://www.w3.org/2000/01/rdf-schema#>
SELECT DISTINCT ?uri ?label
WHERE {
    ?uri a skos:Concept.
    ?uri skos:inScheme <http://www.iiep.unesco.org/plan4learning/scheme/Themes> .
    ?uri skos:prefLabel ?label.
    FILTER (lang(?label) = ?language).
    ?uri skos:prefLabel ?lab.
    FILTER regex (str(?lab), ?reg, 'i').
    FILTER (lang (?lab) = ?language).
    BIND (STRLEN(STRBEFORE (str(?lab), ?reg)) AS ?place).
    BIND (STRLEN(STR(?lab)) AS ?len)
}
ORDER BY ?place ?len ?lab
""",
                            'data-root-query':
"""
PREFIX skos:<http://www.w3.org/2004/02/skos/core#>
PREFIX rdf:<http://www.w3.org/1999/02/22-rdf-syntax-ns#>
PREFIX owl:<http://www.w3.org/2002/07/owl#>
PREFIX rdfs:<http://www.w3.org/2000/01/rdf-schema#>
SELECT DISTINCT ?uri ?label
WHERE {
    ?uri a skos:Concept ;
    skos:inScheme <http://www.iiep.unesco.org/plan4learning/scheme/Themes> ;    
    skos:prefLabel ?label .
    FILTER (lang(?label) = ?language). 
    FILTER NOT EXISTS { [skos:narrower ?uri] }
}
""",
                            'data-childs-query':
"""
PREFIX skos:<http://www.w3.org/2004/02/skos/core#>
PREFIX rdf:<http://www.w3.org/1999/02/22-rdf-syntax-ns#>
PREFIX owl:<http://www.w3.org/2002/07/owl#>
PREFIX rdfs:<http://www.w3.org/2000/01/rdf-schema#>
SELECT DISTINCT ?uri ?label
WHERE {
  ?uri skos:inScheme <http://www.iiep.unesco.org/plan4learning/scheme/Themes> .
  { ?uri a ?type
    FILTER (?type = skos:Collection || ?type = skos:Concept) }.
  ?root skos:narrower|skos:member ?uri.
  ?uri skos:prefLabel|rdfs:label ?label.
  FILTER (lang(?label) = ?language).
}
""",
                            'data-child-count-query':
"""
PREFIX skos:<http://www.w3.org/2004/02/skos/core#>
PREFIX rdf:<http://www.w3.org/1999/02/22-rdf-syntax-ns#>
PREFIX owl:<http://www.w3.org/2002/07/owl#>
PREFIX rdfs:<http://www.w3.org/2000/01/rdf-schema#>
SELECT (COUNT(?uri) as ?nb)
WHERE {
    ?uri skos:inScheme <http://www.iiep.unesco.org/plan4learning/scheme/Themes> .
    ?root skos:narrower|skos:member ?uri.
}
"""
                            }))



