from django.conf.urls import patterns, include, url
from django.contrib import admin
from django.contrib.auth import urls as auth_urls
from django.contrib.auth.decorators import login_required
from p4l.views import RecordListView, RecordDetailView, RecordEditView, RecordDeleteView,\
    RecordNewView

js_info_dict = {
    'packages': ('p4l',),
    'domain': 'django',
}

admin.autodiscover()

urlpatterns = patterns('',
    url(r'^$', login_required(RecordListView.as_view()), name='p4l_home'),
    url(r'^auth/', include(auth_urls)),
    url(r'^record/view/(?P<slug>\w+)$', login_required(RecordDetailView.as_view()), name='p4l_record_view'),
    url(r'^record/edit/(?P<slug>\w+)$', login_required(RecordEditView.as_view()), name='p4l_record_edit'),
    url(r'^record/new$', login_required(RecordNewView.as_view()), name='p4l_record_new'),
    url(r'^record/delete/(?P<slug>\w+)$', login_required(RecordDeleteView.as_view()), name='p4l_record_delete'),
    url(r'^api/', include('p4l.api.urls')),

    url(r'^i18n/', include('django.conf.urls.i18n')),
    url(r'^jsi18n/$', 'django.views.i18n.javascript_catalog', js_info_dict),
    url(r'^admin/', include(admin.site.urls)),
    
)