# -*- coding: utf-8 -*-
'''
Created on Feb 22, 2013

@author: ymh
'''
from django.conf import settings
from django.db import models
from haystack import signals

import p4l.models.signals


class P4lSignalProcessor(signals.BaseSignalProcessor):
    
    def handle_delete(self, sender, instance, **kwargs):
        if getattr(settings, "REALTIME_INDEXING", True):
            signals.BaseSignalProcessor.handle_delete(self, sender, instance, **kwargs)
    
    def handle_save(self, sender, instance, **kwargs):
        if getattr(settings, "REALTIME_INDEXING", True):
            signals.BaseSignalProcessor.handle_save(self, sender, instance, **kwargs)
    
    def __connect_signals(self, klass):        
        p4l.models.signals.record_saved.connect(self.handle_save, sender=klass)
        models.signals.post_delete.connect(self.handle_delete, sender=klass)        

    def __disconnect_signals(self, klass):
        p4l.models.signals.record_saved.disconnect(self.handle_save, sender=klass)
        models.signals.post_delete.disconnect(self.handle_delete, sender=klass)

    
    def setup(self):
        #put import here to avoid circular         
        from p4l.models.data import Record
        self.__connect_signals(Record)



    def teardown(self):

        from p4l.models.data import Record
        self.__disconnect_signals(Record)
        