# -*- coding: utf-8 -*-
'''
Created on Sep 20, 2013

@author: ymh
'''

from haystack import indexes

from p4l.models import Record
from p4l.utils import strip_accents, get_labels_for_uris, safe_cache_key

from django.core.cache import get_cache
from django.conf import settings
import logging

logger = logging.getLogger(__name__)

def get_organizations_label(uris):
    cache = get_cache('indexation')
    
    res = {}
    missing_uris = []
    
    for uri in uris: 
        label = cache.get(safe_cache_key(uri))
        if label is not None:
            res[uri] = label
        else:
            missing_uris.append(uri)
            
    new_labels = get_labels_for_uris(missing_uris, settings.RDF_SCHEMES['organization'], None, True)
    for k,v in new_labels.iteritems():
        cache.set(safe_cache_key(k),v)
        res[k] = v
    
    return res


class RecordIndex(indexes.SearchIndex, indexes.Indexable):    

    text = indexes.CharField(document=True, use_template=True, stored=False)
    identifier = indexes.CharField(model_attr="identifier", stored=True)
    titles = indexes.MultiValueField(model_attr="get_titles", stored=False)
    titles_src = indexes.MultiValueField(model_attr="get_titles", stored=True, indexed=False)
    authors = indexes.MultiValueField(model_attr="all_authors", stored=False)
    
    years = indexes.MultiValueField(model_attr="get_imprints_years", indexed=False, stored=True)
    
    def prepare(self, obj):
        authors = obj.get_authors() + get_organizations_label(obj.get_corporate_authors()).values()
        obj.all_authors = [strip_accents(unicode(v)) for v in authors] 
        return indexes.SearchIndex.prepare(self, obj)
    
    def prepare_titles(self, obj):
        return [strip_accents(v) for v in obj.get_titles()]

    def get_model(self):
        return Record

    def get_updated_field(self):
        return "modification_date"
    
    def index_queryset(self, using=None):
        return Record.objects.using(using).all().prefetch_related("imprints","authors", "titles", "corporateAuthors")