# -*- coding: utf-8 -*-
'''
Created on Sep 20, 2013

@author: ymh
'''
from django.conf import settings
from django.template.context import RequestContext
from haystack.query import SearchQuerySet
from haystack.views import SearchView, search_view_factory

from p4l.search.forms import RecordSearchForm


class RecordSearchView(SearchView):
    
    def __init__(self, template=None, load_all=True, form_class=None, searchqueryset=None, context_class=RequestContext, results_per_page=None):
        record_searchQuerySet = SearchQuerySet().order_by('identifier')
        template = "p4l/p4l_home.html"
        results_per_page= settings.NB_RECORDS_BY_PAGE
        form_class = RecordSearchForm
        SearchView.__init__(self, template=template, load_all=False, form_class=form_class, searchqueryset=record_searchQuerySet, context_class=context_class, results_per_page=results_per_page)

    @classmethod
    def as_view(cls):
        return search_view_factory(view_class=cls)