# -*- coding: utf-8 -*-
'''
Created on Sep 2, 2013

@author: ymh
'''
from p4l.api.serializers import RecordSerializer
from p4l.models import Record
from rest_framework import viewsets

class RecordViewSet(viewsets.ModelViewSet):
    '''
    API endpoint that allow Record to be viewed or edited
    '''
    def pre_save(self, obj):
        viewsets.ModelViewSet.pre_save(self, obj)
        if self.request and hasattr(self.request, 'user') and self.request.user:
            obj.modified_by =  self.request.user

    queryset = Record.objects.all()
    serializer_class = RecordSerializer
    lookup_field = 'identifier'
