# -*- coding: utf-8 -*-
'''
Created on Aug 27, 2013

@author: tc
'''

from django.conf import settings
#from django.core.paginator import Paginator, InvalidPage, EmptyPage
#from django.db.models import Count
#from django.http.response import HttpResponse, HttpResponseForbidden
from django.shortcuts import get_object_or_404
from django.views.generic import ListView, DetailView#, View
#from django.views.generic.list import MultipleObjectMixin
from .models import Record
from .forms import RecordFilterForm
import logging


logger = logging.getLogger(__name__)

class RecordListView(ListView):
    
    queryset = Record.objects.select_related("language").prefetch_related('titles').distinct()  # @UndefinedVariable
    paginate_by = settings.NB_RECORDS_BY_PAGE
    template_name = "p4l/p4l_home.html"
    form_class = RecordFilterForm
    
    
    def get_context_data(self, **kwargs):
        context = ListView.get_context_data(self, **kwargs)
        context['filter_form'] = self.form_class()
        # Add filter params from GET params
        filter_params = {}
        if 'title' in self.request.GET:
            filter_params['title'] = self.request.GET['title']
        context['filter_params'] = filter_params
        return context
    
    def get_queryset(self):
        qs = super(RecordListView, self).get_queryset()
        filter_form = self.form_class(self.request.GET)
        if filter_form.is_valid():
            return filter_form.get_filter_qs(qs)
        else:
            return qs


class RecordDetailView(DetailView):
    
    model = Record
    template_name = "p4l/p4l_record_view.html"
    slug_field = "uri" # Even if it is useless because we override get_objet
    
    def get_object(self, queryset=None):
        if "uri" not in self.request.GET:
            raise AttributeError(u"Record view must be called uri GET parameter")
        
        return get_object_or_404(Record.objects.select_related("language"), uri=self.request.GET["uri"])

