
// initialize the app

var app = angular.module("recordApp", ['ngResource', 'ngRoute', 'pascalprecht.translate'])

app.service("Api", function($resource, context) {
    this.record = $resource(context.urls.record_api,
            {},
            {
                get: {
                    method: "GET",
                    isArray: false
                },
                save:{
                    method:"PUT",
                    isArray:false,
                    headers:{'X-CSRFToken':context.csrf_token} 
                } 
            });
});

app.service("RecordModel", function(Api, context) {    
    this.record = Api.record.get({recordId: context.record_id});
    this.uriLabels = context.uri_labels;
});

app.directive('objectForm', function(RecordModel, context) {
    return {
        restrict: 'E',
        replace: true,
        transclude: true,
        scope: {
            obj:"=editedObject",
            onOk: "&"
        },
        //templateUrl: context.urls.base_static+'p4l/templates/imprintForm.html',
        templateUrl: function(tElement, tAttrs) {
            return context.urls.base_static+'p4l/templates/'+ tAttrs.templateName +'.html';  
        },
        link: function(scope, element, attrs) {
            
        }
    };
});

app.controller("RecordCtrl", function($scope, RecordModel, context){
    
    $scope.record = RecordModel.record;
    $scope.uriLabels = RecordModel.uriLabels;
    $scope.editedImprint = null;
    
        
    $scope.submitRecord = function() {
        $scope.record.$save({recordId: context.record_id});
    }
    
    $scope.removeFromList = function(uri, list) {
    	i = list.indexOf(uri);
    	if(i>=0){
    		list.splice(i, 1);
    	}
    };
    
    $scope.setEditedObject = function(obj, prop) {
        $scope[prop] = obj;
    }
    
    $scope.newEditedObject = function(templ, list, prop) {
        list.push(templ);
        $scope[prop] = templ;
    }
    
});

app.directive('addSemUri', function(RecordModel, context){
  return {
      restrict: 'E',
      replace: true,
      transclude: true,
      scope: {
    	  listname:"@",
    	  list:"=",
      },
      templateUrl: function(tElement, tAttrs) {
          return context.urls.base_static+'p4l/templates/addSemanticUriForm.html';  
      },
      link: function($scope, $element, $attrs) {
    	  // Get queries attributes from $scope listname and context query dict
    	  attr_dict = context.query_dicts[$scope.listname];
    	  for (var k in attr_dict){
			  if (attr_dict.hasOwnProperty(k)) {
			      $scope[k] = attr_dict[k];
			  }
		  }
    	  // initalize autocomplete and browse thesaurus events
    	  init_autocomplete();
    	  // We have to apply because init_browse needs the real ids and not {{ $id }}
    	  $scope.$apply();
    	  init_browse();
      },
      controller: function($scope, $element, $attrs, $transclude, RecordModel){
	    $scope.record = RecordModel.record;
	    $scope.uriLabels = RecordModel.uriLabels;
	    $scope.addUriText = '';
	    
	    $scope.addUriToList = function() {
	    	$scope.list.push($scope.addUriText);
	        $scope.addUriText = '';
	    };
	    
	    $scope.updateUriLabelDict = function(k,v) {
	        $scope.uriLabels[k] = v;
	    };
      }
    }
  });

app.config(['$routeProvider', function($routeProvider) {
//    $routeProvider.when('/', {controller: 'RecordCtrl', templateUrl: 'partials/record.html'});
//    $routeProvider.otherwise({redirectTo: '/'});
  }]);

