# -*- coding: utf-8 -*-
'''
Created on Aug 04, 2013

@author: ymh
'''
from django.conf import settings
from django.contrib.auth.models import AbstractUser
from django.contrib.auth.signals import user_logged_in
from django.db import models
from django.dispatch.dispatcher import receiver

class User(AbstractUser):
    language = models.CharField(max_length=2, default=settings.LANGUAGE_CODE[:2])
    
    class Meta:
        app_label = 'p4l'

@receiver(user_logged_in)
def lang(sender, **kwargs):
    user = kwargs.get('user', None)
    request = kwargs.get('request', None)    
    if user and request:
        request.session['django_language'] = user.language or settings.LANGUAGE_CODE[:2]
