"use strict";
// initialize the app

var app = angular.module("recordApp", ['ngResource', 'ngRoute', 'pascalprecht.translate'])

app.service("Api", function($resource, context) {
    this.record = $resource(context.urls.record_api,
            {},
            {
                get: {
                    method: "GET",
                    isArray: false
                },
                save:{
                    method:"PUT",
                    isArray:false,
                    headers:{'X-CSRFToken':context.csrf_token} 
                } 
            });
});

app.service("RecordModel", function(Api, context) {    
    this.record = Api.record.get({recordId: context.record_id});
    this.uriLabels = context.uri_labels;
});


app.directive('objectDisp', ['$compile', '$http', '$templateCache', 'context', function($compile, $http, $templateCache, context) {

    var getTemplate = function(templateName) {
        var templateLoader,
        templateUrl = context.urls.base_static+'p4l/templates/'+templateName+'.html';
        templateLoader = $http.get(templateUrl, {cache: $templateCache});

        return templateLoader;
    }

    var linker = function(scope, element, attrs) {

        var loader = getTemplate(scope.dispTemplate);

        var promise = loader.success(function(html) {
            element.html(html);
        }).then(function (response) {
            element.replaceWith($compile(element.html())(scope));
        });
    }

    return {
        restrict: 'E',
        scope: {
            dispTemplate: "=",
            obj: "="
        },
        link: linker
    };
}]);


app.directive('objectList', function(RecordModel, context) {
    return {
        restrict: 'E',
        replace: true,
        transclude: true,
        scope: {
            list:"=objectList",
            dispTemplate: "@dispTemplate",
            formTemplate: "@formTemplate",
            objectFields: "@objectFields"
        },
        controller: function($scope, $element, $attrs, $transclude) {
            $scope.getStaticTemplateUrl = function(templateName) {
                return context.urls.base_static+'p4l/templates/'+templateName+".html";
            }
            $scope.getEmptyObjectFromList = function(fieldList) {
                var res = {};
                for ( var field in fieldList) {
                    res[field] = "";
                }
                return res;
            }
        },
        templateUrl: context.urls.base_static+'p4l/templates/objectList.html',  
        link: function($scope, $element, $attrs) {
            $scope.editedObj = null;
            
            $scope.getEmptyObject = function() {
                return $scope.getEmptyObjectFromList(angular.fromJson($scope.objectFields));
            };

            $scope.setEditedObject = function(obj) {
                $scope.editedObj = obj;
            }
            
            $scope.newEditedObject = function() {
                var newObj = $scope.getEmptyObject();
                $scope.list.push(newObj);
                $scope.setEditedObject(newObj);
            };
            
            $scope.removeFromList = function(obj) {
                var i = $scope.list.indexOf(obj);
                if(i>=0){
                    $scope.list.splice(i, 1);
                }
                $scope.setEditedObject(null);
            }
                        
            $scope.onOk = function() {
                $scope.setEditedObject(null);
            }
            
        }
    };
});


app.directive('addSemUri', function(RecordModel, context, $timeout){
  return {
      restrict: 'E',
      replace: true,
      transclude: true,
      scope: {
    	  listname:"@",
    	  list:"=",
    	  placeholder:"@",
      },
      templateUrl: function(tElement, tAttrs) {
          return context.urls.base_static+'p4l/templates/addSemanticUriForm.html';  
      },
      link: function($scope, $element, $attrs) {
    	  // Get queries attributes from $scope listname and context query dict
    	  var attr_dict = context.query_dicts[$scope.listname];
    	  for (var k in attr_dict){
			  if (attr_dict.hasOwnProperty(k)) {
			      $scope[k] = attr_dict[k];
			  }
		  }
		  $scope.formVisible = false;
    	  // initalize autocomplete and browse thesaurus events
    	  // We have to timeout because init_browse needs the real ids and not {{ $id }}
    	  // NB : scope.apply generates bug
    	  $timeout(function(){
    		  init_autocomplete();
    		  init_browse();
          }, 0);
      },
      controller: function($scope, $element, $attrs, $transclude, RecordModel){
	    $scope.record = RecordModel.record;
	    $scope.uriLabels = RecordModel.uriLabels;
	    $scope.addUriText = '';
	    
	    $scope.addUriToList = function() {
	    	$scope.list.push($scope.addUriText);
	        $scope.addUriText = '';
	    };
	    $scope.removeFromList = function(obj) {
            var i = $scope.list.indexOf(obj);
            if(i>=0){
                $scope.list.splice(i, 1);
            }
        }
	    
	    $scope.updateUriLabelDict = function(k,v) {
	        $scope.uriLabels[k] = v;
	    };
      }
    }
});

app.directive('simpleSemUri', function(RecordModel, context, $timeout) {
    return {
        restrict: 'E',
        replace: true,
        transclude: true,
        scope: {
            listname:"@",
            val:"=",
            placeholder:"@",
        },
        templateUrl: function(tElement, tAttrs) {
            return context.urls.base_static+'p4l/templates/simpleSemanticUriForm.html';  
        },
        link: function($scope, $element, $attrs) {
            // Get queries attributes from $scope listname and context query dict
            var attr_dict = context.query_dicts[$scope.listname];
            for (var k in attr_dict){
                if (attr_dict.hasOwnProperty(k)) {
                    $scope[k] = attr_dict[k];
                }
            }
            $scope.formVisible = false;
            // initalize autocomplete and browse thesaurus events
            // We have to timeout because init_browse needs the real ids and not {{ $id }}
            // NB : scope.apply generates bug
            $timeout(function(){
                init_autocomplete();
                init_browse();
            }, 0);
        },
        controller: function($scope, $element, $attrs, $transclude, RecordModel) {
            $scope.record = RecordModel.record;
            $scope.uriLabels = RecordModel.uriLabels;
            $scope.addUriText = '';

            $scope.updateVal = function() {
                $scope.val = $scope.addUriText;
            };

            $scope.updateUriLabelDict = function(k,v) {
                $scope.uriLabels[k] = v;
            };
        }
    };
});

app.directive('languagesListInput', function(RecordModel, context) {
    return {
        restrict: 'E',
        replace: true,
        transclude: true,
        scope: {
        	obj:"=",
        },
        templateUrl: function(tElement, tAttrs) {
            return context.urls.base_static+'p4l/templates/languagesListInput.html';  
        },
        link: function($scope, $element, $attrs) {
            // Get list from context languages_list
            $scope.list = context.languages_list;
        }
    };
});

app.controller("RecordCtrl", function($scope, RecordModel, context){
    
    $scope.record = RecordModel.record;
    $scope.uriLabels = RecordModel.uriLabels;    
        
    $scope.submitRecord = function() {
        $scope.record.$save({recordId: context.record_id});
    }
    
    
});

app.config(['$routeProvider', function($routeProvider) {
//    $routeProvider.when('/', {controller: 'RecordCtrl', templateUrl: 'partials/record.html'});
//    $routeProvider.otherwise({redirectTo: '/'});
  }]);

