
// initialize the app

var app = angular.module("recordApp", ['ngResource', 'ngRoute', 'pascalprecht.translate'])

app.service("Api", function($resource, context) {
    this.record = $resource(context.urls.record_api,
            {},
            {
                get: {
                    method: "GET",
                    isArray: false
                },
                save:{
                    method:"PUT",
                    isArray:false,
                    headers:{'X-CSRFToken':context.csrf_token} 
                } 
            });
});

app.service("RecordModel", function(Api, context) {    
    this.record = Api.record.get({recordId: context.record_id});
    this.uriLabels = context.uri_labels;
});

app.directive('objectForm', function(RecordModel, context) {
    return {
        restrict: 'E',
        replace: true,
        transclude: true,
        scope: {
            obj:"=editedObject",
            onOk: "&"
        },
        //templateUrl: context.urls.base_static+'p4l/templates/imprintForm.html',
        templateUrl: function(tElement, tAttrs) {
            return context.urls.base_static+'p4l/templates/'+ tAttrs.templateName +'.html';  
        },
        link: function(scope, element, attrs) {
            
        }
    };
});

app.controller("RecordCtrl", function($scope, RecordModel, context){
    
    $scope.record = RecordModel.record;
    $scope.uriLabels = RecordModel.uriLabels;
    $scope.editedImprint = null;
    
        
    $scope.submitRecord = function() {
        $scope.record.$save({recordId: context.record_id});
    }
    
    $scope.removeFromList = function(uri, list) {
    	i = list.indexOf(uri);
    	if(i>=0){
    		list.splice(i, 1);
    	}
    };
    
    $scope.setEditedObject = function(obj, prop) {
        $scope[prop] = obj;
    }
    
    $scope.newEditedObject = function(templ, list, prop) {
        list.push(templ);
        $scope[prop] = templ;
    }
    
});

app.controller("ThesaurusCtrl", function($scope, RecordModel) {

    $scope.record = RecordModel.record;
    $scope.uriLabels = RecordModel.uriLabels;
    $scope.addSubjectText = '';
    
    $scope.addSubject = function() {
        $scope.record.subjects.push($scope.addSubjectText);
        $scope.addSubjectText = '';
    };
    
    $scope.updateUriLabelDict = function(k,v) {
        $scope.uriLabels[k] = v;
    };
    
    
});

app.config(['$routeProvider', function($routeProvider) {
//    $routeProvider.when('/', {controller: 'RecordCtrl', templateUrl: 'partials/record.html'});
//    $routeProvider.otherwise({redirectTo: '/'});
  }]);

