
// initialize the app

var app = angular.module("recordApp", ['ngResource', 'pascalprecht.translate'])

app.service("Api", function($resource, context) {
    this.record = $resource(context.urls.record_api);
});

app.controller("RecordCtrl", function($scope, Api, context){
    $scope.record = Api.record.get({recordId: context.record_id});
    $scope.uriLabels = context.uri_labels;
    
    $scope.addSubject = function() {
    	$scope.record.subjects.push($scope.addSubjectText);
    	$scope.addSubjectText = '';
    };
    
    $scope.updateUriLabelDict = function(k,v) {
    	$scope.uriLabels[k] = v;
    };
    
    $scope.removeSubject = function(uri) {
    	i = $scope.record.subjects.indexOf(uri);
    	if(i>=0){
    		$scope.record.subjects.splice(i, 1);
    	}
    };
});

app.config(['$routeProvider', function($routeProvider) {
//    $routeProvider.when('/', {controller: 'RecordCtrl', templateUrl: 'partials/record.html'});
//    $routeProvider.otherwise({redirectTo: '/'});
  }]);

