"""
Some useful form widgets
"""

from django import forms
from django.core.exceptions import ValidationError
from django.forms.util import flatatt
from django.utils.html import format_html
from django.utils.encoding import force_text
from django.utils.translation import ugettext as _

import logging
logger = logging.getLogger(__name__)

class SemanticTreeWidget(forms.TextInput):
    """
    A widget that enables to request semantic trees
    """
    
    class Media:
        css = {
            'all': ('semantictree/semantictree.css',)
        }
        js = ('semantictree/semantictree.js',)
    
    # The user can add css classes but we always add "semantic-tree" class
    def render(self, name, value, attrs=None):
        if value is None:
            value = ''
        final_attrs = self.build_attrs(attrs, type=self.input_type, name=name)
        # Test if class attr is here
        if "class" in final_attrs:
            final_attrs["class"] += " semantic-tree"
        else:
            final_attrs["class"] = "semantic-tree"
        if value != '':
            # Only add the 'value' attribute if a value is non-empty.
            final_attrs['value'] = force_text(self._format_value(value))
        final_attrs['placeholder'] = _("Search")
        input_res = format_html('<input{0} />', flatatt(final_attrs))
        
        if "data-url" not in final_attrs or "data-query" not in final_attrs or "data-root-query" not in final_attrs or "data-childs-query" not in final_attrs or "data-child-count-query" not in final_attrs:
            raise ValidationError(_('"data-url", "data-query", "data-root-query", "data-childs-query" and "data-child-count-query" must be set in CharField configuration'))
        dialog_text = _("Browse")
        
        dialog_res = "<span id=\"dialog-link-container-" + final_attrs["name"] + "\" class=\"dialog-link-container ui-state-default ui-corner-all\"><a href=\"#\" id=\"dialog-link-" + final_attrs["name"] + "\" class=\"dialog-link\" title=\"%s\">%s</a></span>" % (dialog_text,dialog_text)
        dialog_res += '<span id="dialog-' + final_attrs["name"] + '" class="dialog" title="Select term"><span id="term-tree-' + final_attrs["name"] + '"></span></span>'
        
        return input_res + " " + _("or") + " " + dialog_res


class SemanticTagItWidget(forms.TextInput):
    """
    A widget that enables to request semantic trees
    """
    
    class Media:
        css = {
            'all': ('semantictree/semantictree.css',)
        }
        js = ('semantictree/semantictree.js',)
    
    # The user can add css classes but we always add "semantic-tree" class
    def render(self, name, value, attrs=None):
        if value is None:
            value = ''
        final_attrs = self.build_attrs(attrs, type=self.input_type, name=name)
        # Test if class attr is here
        if "class" in final_attrs:
            final_attrs["class"] += " semantic-tree-tagit"
        else:
            final_attrs["class"] = "semantic-tree-tagit"
        if value != '':
            # Only add the 'value' attribute if a value is non-empty.
            final_attrs['value'] = force_text(self._format_value(value))
        
        input_res = format_html('<input{0} />', flatatt(final_attrs))
        
        if "data-url" not in final_attrs or "data-query" not in final_attrs or "data-root-query" not in final_attrs or "data-childs-query" not in final_attrs or "data-child-count-query" not in final_attrs:
            raise ValidationError(_('"data-url", "data-query", "data-root-query", "data-childs-query" and "data-child-count-query" must be set in CharField configuration'))
        dialog_text = _("Browse")
        
        dialog_res = "<span id=\"dialog-link-container-" + final_attrs["name"] + "\" class=\"dialog-link-container ui-state-default ui-corner-all\"><a href=\"#\" id=\"dialog-link-" + final_attrs["name"] + "\" class=\"dialog-link\" title=\"%s\">%s</a></span>" % (dialog_text,dialog_text)
        dialog_res += '<span id="dialog-' + final_attrs["name"] + '" class="dialog" title="Select term"><span id="term-tree-' + final_attrs["name"] + '"></span></span>'
        
        return input_res + " " + _("or") + " " + dialog_res