from django.contrib import admin
from django.contrib.auth.admin import UserAdmin as AuthUserAdmin
from django.utils.translation import gettext_lazy as _
from p4l.models import User
from p4l.forms import UserChangeForm, UserCreationform

class UserAdmin(AuthUserAdmin):
    form = UserChangeForm
    add_form = UserCreationform
    fieldsets = tuple(list(AuthUserAdmin.fieldsets) + [(_('language'), {'fields':('language',)})])


admin.site.register(User, UserAdmin)


