
// Création de l'objet Relations
var annuaire = new Relations();

// Premier exemple : Coloriage

var tableDessin = d3.select("#dessin tbody");
var i = 0, j = 0, ligs = 1;

function focus(objet) {
	objet.style("opacity", 0.5);
}

function blur(objet) {
	objet.style("opacity", 1);
}

var cell = null, ligne = tableDessin.select("tr");
function ajouterCouleur(couleur) {
	if (i==ligs) {
		if (j==0) {
			ligne = tableDessin.append("tr");
		}

		cell = ligne.append("td");
		
		if (++j==ligs) {
			j = 0;
			i = 0;
			++ligs;
		}
	}
	else {
		tableDessin.selectAll("tr").each(function(d, index) {
			if (index==i) {
				cell = d3.select(this).append("td");
			}
		});
		++i;
	}

	cell.style("background-color", couleur);
	// on ajoute des actions en plus sur les boutons de couleur 
	annuaire.add("cellule" + (ligs*ligs + i + j), cell)
		.bindTo("mouseover", "bouton."+couleur, focus)
		.bindTo("mouseout", "bouton."+couleur, blur);
	//console.log("i : "+i+"; j : "+j+"; ligs : "+ligs);
}

// on enregistre les boutons de couleurs avec des actions pour ajouter une case
// de couleur au tableau
annuaire.add("bouton.red", d3.select("#couleurs .rouge"))
	.click(function() { ajouterCouleur("red"); });
annuaire.add("bouton.green", d3.select("#couleurs .vert"))
	.click(function() { ajouterCouleur("green"); });
annuaire.add("bouton.blue", d3.select("#couleurs .bleu"))
	.click(function() { ajouterCouleur("blue"); });



// Deuxième exemple : Piano

// fonction pour colorier les touches
function toucheAppuyee(touche) {
	if (touche.classed("enfonce")) {
		touche.classed("enfonce", false);
	}
	else {
		touche.classed("enfonce", true);
	}
}

// On enregistre les touches du piano (li) et on leur associe sur elles-mêmes
// une action
d3.selectAll("#piano li").each(function(datum, index) {
	var item = d3.select(this);
	annuaire.add("touche" + (index + 1), item).click(toucheAppuyee);
});

// On conditionne un bouton reset pour remettre en blanc toutes
// les touches grâce à la méthode each
var message = "";
function resetBouton(objet, details) {
	if (objet.classed("enfonce")) {
		objet.classed("enfonce", false);
		if (""!=message) {
			message+= ",";
		}
		message+= details[1];
	}
}

// On parcourt par une boucle each toutes les touches du piano
annuaire.add("bouton.reset", d3.select("#piano button"))
	.click(function() {
		message = "";
		annuaire.each("touche[[digit]]", resetBouton, true);
		alert("les touches "+message+ " ont été relevées");
	});