
// On cr�e l'objet relations qui va nous permettre d'ajouter des animations et des effets sur les cases de treemap
var r = new Relations();

var couleurs = new Couleurs(20);

//*
var parametresStreamgraphTimeline = {
	name: "streamgraphTimeline",
	selector: "#streamgraphTimeline",
	activerSelection : true,
	activerTimeline: true,
	activerCurseur: true,
	hauteur: 50,
	largeur: 800,
	relations: r,
	couleurs: couleurs
};

var streamgraphTimeline = new Streamgraph(json.clusters, parametresStreamgraphTimeline);
//*/

//*
var parametresTreemap = {
	name: "treemap",
	selector: "#treemap",
	hauteur: 400,
	largeur: 800,
	relations: r,
	template: {
		selector: "#streamgraphTemplate",
		directives: {
			"img@src": "urlImage",
			"img@title": "titreArticle",
			"img@alt": "titreArticle",
			"img@width": "widthImage",
			"img@height": "heightImage",
			"img@style+": "cssOffsetImage",
			"p.title": "titreArticle",
			"p.title@style+": "cssWidthArticle"
		}
	},
	couleurs: couleurs
};
var treemap = new Treemap(json, parametresTreemap);
//*/

//*
r.get("streamgraphTimeline").bind("selectionResize", "treemap", 
		function(objet, params) { objet.transition(params[0], params[1]); });

function placerCurseur(cluster) {
	streamgraphTimeline.placerCurseur(parseInt(cluster.attr("datetime")), 'index');
	streamgraphTimeline.showCursor();
}

function cacherCurseur() {
	streamgraphTimeline.hideCursor();
}

for (var i = 0; i<10; ++i) {
	var cluster = r.get("treemap.cluster." + i);
	cluster.mouseover(treemap.focus)
		.mouseout(treemap.blur)
		.mouseover(placerCurseur)
		.mouseout(cacherCurseur);
}
//*/