function Relations() {
	this.items = {};
}

Relations.prototype = {
	add: function(id, element) {
		return this.items[id] = new Connector(element, id, this);
	},
	
	remove: function(id) {
		
	},
	
	get: function(id) {
		return this.items[id];
	},
	
	execute: function(id, event, eventParameters) {
		var functions = this.get(id).listenedEvents[event];
		for(var i =0; i<functions.length; ++i) {
			var item = this.get(functions[i][0]);
			if (!item.locked) {
				functions[i][1](item.element, eventParameters);
			}
		}
	}
};

function Connector(object, id, manager) {
	this.manager = manager;
	this.element = object;
	this.id = id;
	this.listenedEvents = {};
	this.locked = false;
}

Connector.prototype = {
	bind: function(event, id, action) {
		if (undefined==action) {
			this.bind(event, this.id, id);
		}
		else {
			if (undefined!=this.listenedEvents[event]) {
				this.listenedEvents[event].push([id, action]);
			}
			else {
				var object = this;
				this.listenedEvents[event] = [[id, action]];
				this.element.on(event, function() {
					object.manager.execute(object.id, event, arguments);
				}) ;
			}
		}
		
		return this;
	},
	
	bindTo: function(event, id, action) {
		this.manager.get(id).bind(event, this.id, action);
		
		return this;
	},
	
	unbind: function(id, event) {
		return this;
	},
	
	click: function(id, action) {
		return this.bind("click", id, action);
	},
	
	dblclick: function(id, action) {
		return this.bind("dblclick", id, action);
	},
	
	mouseover: function(id, action) {
		return this.bind("mouseover", id, action);
	},
	
	mouseout: function(id, action) {
		return this.bind("mouseout", id, action);
	},
	
	lock: function() {		
		this.locked = true;
	},
	
	unlock: function() {
		this.locked = false;
	}
}
