﻿# Cartographie
## Que fait le module ?
Le moteur de recherche développé par le CEA-LIST fait ressortir, au travers de leur démarche d’indexation et de classification des articles, certaines caractéristiques qui s’avèrent très adaptées à la visualisation des données sous forme d’une cartographie.
En effet, on peut faire assez intuitivement les modélisations suivantes  :

+ une pondération quantifiant l’importance d’un article se traduira par le rayon du nœud, à un facteur près ;
+ une relation de similarité entre les différents articles, basée sur un rapprochement sémantique (même thématique, images représentant un même personnage ou objet, etc.) influera sur la proximité entre deux des articles de la carte ;
+ enfin le découpage en clusters thématiques sera représenté par un découpage en zones colorées de la carte et des nœuds.

Pour le développement de cet outil, nous nous sommes appuyés sur l’objet Force-Directed Graph de la librairie d3.js. Cet outil calcule pour un nuage de points reliés par des liens, une trajectoire prenant en compte des forces de rappel sur les liens, de répulsion entre les points, ainsi que de frottements pour amortir le mouvement. On associe aux liens une valeur reflétant la similarité de deux articles, valeur dont le graphe va essayer de se rapprocher le plus possible – selon la compatibilité avec les autres liens. Un groupement par clusters se fait donc assez naturellement, mais la carte mettra aussi en relief des similarités entre articles de clusters différents.

Par la suite, une autre méthode de calcul des points a été implémentée, l’Analyse en Composantes Curvilignes. Cette méthode se fait côté serveur, le module prend alors les positions des points en argument.

Parallèlement, le coloriage des clusters en arrière-plan s’appuie sur la librairie paper.js, une librairie optimisée pour le dessin géométrique. Le coloriage est fait dans un objet canvas.
___________________
## Module
<iframe src="../toolkit/exemples/cartographie/cartographie.html" width="1140" height="900" frameborder="1" ></iframe>

<script>
 setInterval(function(){
   $( "#md-left-column" ).hide();
   },1000);
</script>