
// Création d'un jeu de couleurs manuellement
var jeuCouleurs = new Couleurs([
"red", "green", "blue", "rgb(124, 46, 197)", "#f13580e"
]);

var list = d3.select("#manuel");
for (var i = 0; i<5; ++i) {
	list.append("li")
		.text(jeuCouleurs.get(i))
		.style("color", jeuCouleurs.get(i));
}

// jeu de couleurs aléatoires, on prend 5 couleurs
var couleursAleatoires = new Couleurs(5);

var tableau = d3.select("#aleatoire");
for (var i = 0; i<6; ++i) {
	var ligne = tableau.append("tr");
	for (var j = 0; j<6; ++j) {
		ligne.append("td")
			.style("background-color", couleursAleatoires.get(i*6 + j))
			.style("padding", "10px")
			.text(i*6 + j);
	}
}

// dégradé de couleurs: on crée un jeu de 10 tons de gris
// du noir au blanc
var degrade = new Couleurs("#000000", "#ffffff", 10);

list = d3.select("#degrade");
for (var i = 1; i<11; ++i) {
	var item = list.append("li");
	item.append("span")
			.classed("square", true)
			.style("background-color", degrade.get(i));
	item.append("span").text(degrade.get(i));
}