from django.conf.urls import patterns, include, url
from django.conf import settings

# Uncomment the next two lines to enable the admin:
from django.contrib import admin
#import django.contrib.auth.views



admin.autodiscover()

urlpatterns = patterns('',
    url(r'^streamgraph/', 'document.views.streamgraph'),
    url(r'^recherche/$', 'document.views.treemap'),
    
    #url(r'^recherche/(?P<query>-?\d+)/(?P<key1>-?\d+)/$', 'document.views.treemap'),
    url(r'^annotations_document', 'document.views.get_annotations'),
    # Modify the "public" attribute of a documentary file
    url(r'^documentary_file_visibility/', 'document.views.documentary_file_visibility'),
     # Delete a documentary file
    #url(r'^documentary_file_delete/', 'document.views.documentary_file_delete'),
    # Delete a documentary file
    url(r'^documentary_file_delete/(?P<docId>\d+)/$', 'document.views.documentary_file_delete'),
    # Modify a documentary file
    url(r'^documentary_file_modify/', 'document.views.documentary_file_modify'),
    # Create a documentary file
    url(r'^documentary_file_create/', 'document.views.documentary_file_create'),
    # Annotate a documentary file
    url(r'^documentary_file_annotation_create/', 'document.views.create_annotation_on_documentary_file'),
    # Delete an annotate a documentary file
    url(r'^documentary_file_annotation_delete/', 'document.views.delete_annotation_on_documentary_file'),
    # Get documentary files of a user
    url(r'^documentary_files/$', 'document.views.documentary_files'),
    
    #url(r'^documentary_files/(?P<myuser>\w+)/(?P<offset>\d+)/(?P<count>\d+)/$', 'document.views.documentary_files'),
    url(r'^documentary_files/(?P<myuser>\w+)/$', 'document.views.documentary_files',name='dossiers'),
    url(r'^documentary_files/(?P<myuser>\w+)/(?P<docId>\d+)/$', 'document.views.get_documentary_file', name='dossier'),
     url(r'^documentary_files/(?P<myuser>\w+)/(?P<cluster>\d+)/(?P<offset>\d+)/(?P<count>\d+)/(?P<docId>\d+)/$', 'document.views.get_documentary_file', name='docOfDossier'),
     # Delete an annotation on a cluster
    url(r'^cluster_annotation_delete/', 'document.views.cluster_annotation_delete'),
     # Create an annotation on a cluster
    url(r'^cluster_annotation_create/', 'document.views.cluster_annotation_create'),
     # Create an annotation on a document
    url(r'^document_annotation_create/', 'document.views.document_annotation_create'),
    # Delete an annotation on a document
    url(r'^document_annotation_delete/', 'document.views.document_annotation_delete'),
    # Documents of a cluster with annotations
    url(r'^documents_cluster/$', 'document.views.get_documents_with_annotations'),
    url(r'^documents_cluster/(?P<query>\d+)/(?P<cluster>\d+)/(?P<offset>\d+)/(?P<count>\d+)', 'document.views.get_documents_with_annotations'),
    
    # Documents of a cluster with annotations
    #url(r'^documentary_file/(?P<id>\d)', 'document.views.get_documentary_file'),
    
    # List of clusters of a documentary file
    url(r'^clusters', 'document.views.get_clusters'),
    
    url(r'^mesdossiersDoc', 'document.views.get_mesdossiersDoc'),

    #  to enable the admin:
    url(r'^admin/', include(admin.site.urls)),
    
    # Login / logout.
    (r'^login/$', 'document.views.login_view'),
    (r'^logout/$', 'document.views.logout_view'),
    
    (r'^documentary_file_user_update/$', 'document.views.documentary_file_user_update'),
    
    # Main page
    url(r'^article/(?P<id_article>\d+)/$', 'document.views.article', name='article'),
    
    # Main page
    url(r'^$', 'document.views.document_main_page', name='main-page'),
    url(r'^(?P<query>\d+)/(?P<cluster>\d+)/(?P<offset>\d+)/(?P<count>\d+)/(?P<docId>\d+)', 'document.views.document_main_page', name='docwithannotatins'),
    #url(r'^(?P<id>\d+)', 'document.views.document_main_page'name='dossier')),
   
)

urlpatterns += patterns('',
        (r'^images/(?P<path>.*)$', 'django.views.static.serve',
        {'document_root': settings.STATIC_DOC_ROOT}),    
)

urlpatterns += patterns('',
        (r'^media/(?P<path>.*)$', 'django.views.static.serve',
        {'document_root': settings.MEDIA_ROOT}),    
)




