#! /usr/bin/env python
#encoding:UTF-8
import os
import urllib
import logging
import simplejson
import json
import urllib2
import time
import ast
import pickle
#import pdb

from datetime import datetime 
#from pysimplesoap.client import SoapClient

from django.conf import settings
from django.core.cache import cache
from mediapartdb.MediapartReader import MediapartReader
from dataparser.ClientSearchAttributes import ClientSearchAttributes
from dataparser.WebLabParser import WebLabParser
from document.models import Annotationcluster
from document.models import Cluster

from document.models import Documentaryfile
logger = logging.getLogger('document')

class Searcher(object):

    def __init__(self, request):
        self.request = request
           
    def streamgraph(self):
        logger.info('streamgraph')
        attr = ClientSearchAttributes(self.request)
        if attr.get_filtre() == 'dossierDocOk':
            docId = self.request.POST['docId']
            try:
                documentaryfile = Documentaryfile.objects.get(pk=docId)
                list_concepts = documentaryfile.list_concepts
                concepts_with_detailed_documents_list = documentaryfile.concepts_with_detailed_documents_list
            except Documentaryfile.DoesNotExist:
                json = '{"Error": "Invalid documentary id"}'
                list_concepts = []
                concepts_with_detailed_documents_list = []
        else:
            list_concepts, concepts_with_detailed_documents_list = self.get_concepts_and_documents(attr)
        # Building of the json for the streamgraph
        
        streamgraph_json = self.build_filtered_streamgraph_(list_concepts, concepts_with_detailed_documents_list, attr)
        treemap_json = self.build_filtered_treemap_(list_concepts, concepts_with_detailed_documents_list, attr)
        self.request.session['jsonTreemap'] = treemap_json
        self.request.session['jsonStreamgraph'] = streamgraph_json
        return streamgraph_json
    
    def treemap(self):
        logger.info('treemap!!')
        #logger.info(self.request)
        attr = ClientSearchAttributes(self.request)
        if attr.get_filtre() == 'dossierDocOk':
            docId = self.request.POST['docId']
            try:
                documentaryfile = Documentaryfile.objects.get(pk=docId)
                list_concepts = documentaryfile.list_concepts
                concepts_with_detailed_documents_list = documentaryfile.concepts_with_detailed_documents_list
            except Documentaryfile.DoesNotExist:
                json = '{"Error": "Invalid documentary id"}'
                list_concepts = []
                concepts_with_detailed_documents_list = []
        else:
            list_concepts, concepts_with_detailed_documents_list = self.get_concepts_and_documents(attr)
        logger.info('list_concepts treemap = '+str(list_concepts))
        logger.info('concepts_with_detailed_documents_list treemap= '+str(concepts_with_detailed_documents_list))
        # Parse the response to build the json for the treemap
        treemap_json = self.build_filtered_treemap_(list_concepts, concepts_with_detailed_documents_list, attr)
        streamgraph_json = self.build_filtered_streamgraph_(list_concepts, concepts_with_detailed_documents_list, attr)
        self.request.session['jsonStreamgraph'] = streamgraph_json
        self.request.session['jsonTreemap'] = treemap_json
        
        if  self.request.session['refreshOnly'] == True or attr.get_filtre() == 'ok':
            self.request.session['refreshOnly'] = False
       
        return treemap_json
    
    def get_concepts_and_documents(self, attr):
        logger.info('get_concepts_and_documents')
        #if id == 0:
        if self.request.session['refreshOnly'] == True or attr.get_filtre() == 'ok':
            logger.info('refreshOnly  TRUE============================ ')
            key1 = self.request.session['key1']
            query_id = self.request.session['query_id']   
        else:
            logger.info('get_concepts_and_documents2')
            key1 = attr.get_hash_value_from_text_image()
            query_id = attr.get_hash_value()
                    
        self.request.session['query_id'] = int(query_id)
        self.request.session['key1'] = int(key1)
       
        #Test if the hash value is in the cache
        if cache.get(key1) == None:
            logger.info('cache empty')
            list_concepts, concepts_with_detailed_documents_list = self.searchDataFromWebLab_(attr)
            cache.set(key1, (list_concepts,concepts_with_detailed_documents_list), 60*60)
            cache.set(query_id, {'weblab_data_key':key1, 'filtering_params':attr.get_filtering_params()}, 60*60)
        else:
            logger.info("cache not empty")
            context = cache.get(key1)
            if context:
                list_concepts,concepts_with_detailed_documents_list = context
                cache.set(query_id, {'weblab_data_key':key1, 'filtering_params':attr.get_filtering_params()}, 60*60)
            else:
                logger.info("context empty")
                list_concepts = []
                concepts_with_detailed_documents_list = []       
        
        return list_concepts,concepts_with_detailed_documents_list
    
    def searchDataFromWebLab_(self, attr):
        # get the image from the HTTP-POST or from an URL
        self.requestImageLocalPath = self.getImageLocalPath(attr)
        
        # Build the WEBLAB request
        searchInputValue = self.build_request_(attr)
              
        # Soap call            
        if settings.SIMULATE_WEBLAB:
            if attr.get_text() == 'sarko':
                response = self.simulate_response_v4_()
            else:
                response = self.simulate_response_v3_()
                
        else:
            req = urllib2.Request("http://localhost:10000",headers = {"SOAPAction": "search","Content-Type": "text/xml;charset=UTF-8","Expect": "100 continue disabled"},
                              data = searchInputValue)
            try:
                handle = urllib2.urlopen(req)
                response = handle.read()
            except Exception, err:
                logger.info(' Error: '+str(err)) 

        #logger.info(' Response!!!!!!!!!!! '+str(response)) 
        # Delete the image analyzed by the CEA
        if self.requestImageLocalPath != '':
            os.remove(self.requestImageLocalPath)
            
        # Parse the response 
        weblab_parser = WebLabParser()
        list_concepts, concepts_with_documents_list = weblab_parser.parse(response)
        #logger.info(' list_concepts!!!!!!!!!!! '+str(list_concepts))
        #logger.info(' concepts_with_documents_list!!!!!!!!!!! '+str(concepts_with_documents_list))  
        # Get dates of the documents
        # return a list: [[(docid1,date1), (docid2,date2), ...],[(docid11,date11), (docid22,date22), ...], ...]
        #documents_dates_concepts_list = self.get_documents_dates_(concepts_with_documents_list)  
       
        concepts_with_detailed_documents_list = self.add_doc_information_(concepts_with_documents_list)   
        logger.info(' concepts_with_detailed_documents_list!!!!!!!!!!! '+str(concepts_with_detailed_documents_list))  
        return list_concepts, concepts_with_detailed_documents_list   
         
    def getImageLocalPath(self, attr):
        imageLocalPath = ''
        for key in self.request.FILES.keys():    
            image_obj = self.request.FILES[key]
            imageLocalPath = '%s/requestImages/%s' % (settings.STATICFILES_DIRS[0], image_obj.name)
            fd = open(imageLocalPath, 'wb')
            fd.write(image_obj.read())
            fd.close()
        
        if imageLocalPath == '':
            # No image uploaded in the HTTP-POST
            image_url = attr.get_picture_url()
            if image_url != '':
                # An url is defined in the HTTP-POST parameter
                segments = image_url.rpartition('/')
                image_name = segments[2]
                imageLocalPath = '%s/requestImages/%s' % (settings.STATICFILES_DIRS[0], image_name)
                fd = open(imageLocalPath,'wb')
                try:
                    fd.write(urllib.urlopen(image_url).read())
                except Exception, err:
                    logger.info(' Error: '+str(err))
                    imageLocalPath = ''
                fd.close()       
        return imageLocalPath
                
    def build_request_(self,attr):
        text = attr.get_text()
        image_path = self.requestImageLocalPath
        
        offset = 0
        limit = 20
        
        searchInputValue ='<soapenv:Envelope xmlns:soapenv="http://schemas.xmlsoap.org/soap/envelope/" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns:sear="http://weblab.ow2.org/core/1.2/services/searcher" xmlns:model="http://weblab.ow2.org/core/1.2/model#"><soapenv:Header/><soapenv:Body><sear:searchArgs>'
        searchInputValue += '<usageContext>uc</usageContext><query xsi:type="model:SimilarityQuery" uri="periplus://simquery" weight="1.0"><resource uri="periplus://simquery/resource" xsi:type="model:Document">'
        #Text
        searchInputValue += '<mediaUnit xsi:type="model:Text" uri="periplus://simquery/resource/text">'
        searchInputValue += '<annotation uri="periplus://simquery/resource/text/annotation"><data><rdf:RDF xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:dc="http://purl.org/dc/elements/1.1/"><rdf:Description rdf:about="periplus://simquery/resource/text"><dc:language>fre</dc:language><rdf:type rdf:resource="DocumentCluster"/> </rdf:Description></rdf:RDF></data></annotation>'
        searchInputValue += '<content>' + text + '</content>'
        searchInputValue += '</mediaUnit>'
        #Image
        if image_path != '':
            searchInputValue += '<mediaUnit xsi:type="model:Image" uri="periplus://simquery/resource/image">'
            searchInputValue += '<annotation uri="periplus://simquery/resource/image/annotation"><data><rdf:RDF xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#"><rdf:Description rdf:about="simquery/resource/image">'
            searchInputValue += '<wlp:hasNativeContent>' + image_path + '</wlp:hasNativeContent>' 
            searchInputValue += '</rdf:Description></rdf:RDF></data></annotation>'
            searchInputValue += '</mediaUnit>'
  
        searchInputValue += '</resource></query>'
        searchInputValue += '<offset>'+ str(offset) + '</offset><limit>' + str(limit) +'</limit></sear:searchArgs></soapenv:Body></soapenv:Envelope>'
        return searchInputValue
     
    def simulate_response_(self):
               
        res = '<SOAP-ENV:Envelope xmlns:SOAP-ENV="http://schemas.xmlsoap.org/soap/envelope/" xmlns:SOAP-ENC="http://schemas.xmlsoap.org/soap/encoding/" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns:xsd="http://www.w3.org/2001/XMLSchema" xmlns:model="http://weblab.ow2.org/core/1.2/model#" xmlns:searcher="http://weblab.ow2.org/core/1.2/services/searcher" xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#">   <SOAP-ENV:Body>     <searcher:searchReturn xsi:type="searcher:searchArgs">       <resultSet uri="periplus://myresult">         <annotation uri="periplus://myresult/pok">           <data>             <rdf:RDF xmlns:wls="http://weblab.ow2.org/core/1.2/ontology/retrieval#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#">               <rdf:Description rdf:about="periplus://myresult">                 <wls:hasQueryOffset>0</wls:hasQueryOffset>                 <wls:hasNumberOfResults>3</wls:hasNumberOfResults>                 <wls:isResultOf rdf:resource="periplus://myquery" />                 <wls:hasHit rdf:resource="periplus://myquery/concept:0/hit:0" />                 <wls:hasHit rdf:resource="periplus://myquery/concept:0/hit:1" />                 <wls:hasHit rdf:resource="periplus://myquery/concept:1/hit:0" />               </rdf:Description>               <rdf:Description rdf:about="periplus://myquery/concept:0">                 <wls:hasNumberOfResults>2</wls:hasNumberOfResults>                 <wls:hasDescription><![CDATA[Neo-impressionism]]></wls:hasDescription>  <dc:title>Le neo-impressionism</dc:title>             </rdf:Description>               <rdf:Bag rdf:about="periplus://myquery/concept:0">                 <rdf:li rdf:resource="periplus://myquery/concept:0/hit:0" />                 <rdf:li rdf:resource="periplus://myquery/concept:0/hit:1" />               </rdf:Bag>               <rdf:Description rdf:about="periplus://myquery/concept:1">                 <wls:hasNumberOfResults>1</wls:hasNumberOfResults>                 <wls:hasDescription><![CDATA[Post-modernism]]></wls:hasDescription> <dc:title>Le post-modernism</dc:title>              </rdf:Description>               <rdf:Bag rdf:about="periplus://myquery/concept:1">                 <rdf:li rdf:resource="periplus://myquery/concept:1/hit:0" />               </rdf:Bag>               <rdf:Description rdf:about="periplus://myquery/concept:0/hit:0">                 <wls:inResultSetHit rdf:resource="periplus://myresult"/>                 <wls:isLinkedTo rdf:resource="periplus://fileRepository/resource_1"/>                 <wls:hasDescription><![CDATA[Neo-impressionism was coined by French art critic Felix Feneon in 1886 to describe an art movement founded by Georges Seurat. Seurat s greatest masterpiece...]]></wls:hasDescription>                 <wls:hasScore>0.7</wls:hasScore>                 <wls:hasRank>2</wls:hasRank>  <dc:identifier>149</dc:identifier>               <rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/>               </rdf:Description>               <rdf:Description rdf:about="periplus://myquery/concept:0/hit:1">                 <wls:inResultSetHit rdf:resource="periplus://myresult"/>                 <wls:isLinkedTo rdf:resource="periplus://fileRepository/resource_2"/>                 <wls:hasRelevantMediaUnit rdf:resource="periplus://fileRepository/resource_2/image_1" />                 <wls:hasDescription><![CDATA[Neo-Impressionism, initiated by Georges Seurat and transformed by Paul Signac, codified a new langage essential to the modernism of 20th century art.]]></wls:hasDescription>                 <wls:hasScore>0.875411158</wls:hasScore>                 <wls:hasRank>1</wls:hasRank>  <dc:identifier>155</dc:identifier>               <rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/>               </rdf:Description>               <rdf:Description rdf:about="periplus://myquery/concept:1/hit:0">                 <wls:inResultSetHit rdf:resource="periplus://myresult"/>                 <wls:isLinkedTo rdf:resource="periplus://fileRepository/resource_3"/>                 <wls:hasDescription><![CDATA[Neo-Impressionism (a.k.a. Divisionism or Pointillism) is a movement and a style. It is a subdivision of the larger avant-garde movement called Post-Impressionism.]]></wls:hasDescription>                 <wls:hasScore>0.9</wls:hasScore>                 <wls:hasRank>1</wls:hasRank>   <dc:identifier>141</dc:identifier>              <rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/>               </rdf:Description>             </rdf:RDF>           </data>         </annotation>         <resource xsi:type="model:Document" uri="periplus://fileRepository/resource_1">           <annotation uri="periplus://fileRepository/resource_1/annotation_1">             <data>               <rdf:RDF xmlns:wls="http://weblab.ow2.org/core/1.2/ontology/retrieval#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#">                 <rdf:Description rdf:about="periplus://fileRepository/resource_1">                   <dc:source>Wikipedia</dc:source>                   <wlp:hasNativeContent>/path/to/my/file/repository/file1337.html</wlp:hasNativeContent>                 </rdf:Description>               </rdf:RDF>             </data>           </annotation>         </resource>         <resource xsi:type="model:Document" uri="periplus://fileRepository/resource_2">           <annotation uri="periplus://fileRepository/resource_2/annotation_1">             <data>               <rdf:RDF xmlns:wls="http://weblab.ow2.org/core/1.2/ontology/retrieval#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#">                 <rdf:Description rdf:about="periplus://fileRepository/resource_2">                   <dc:source>http://www.impressionniste.net/neo-impressionism.htm</dc:source>                   <wlp:hasNativeContent>/path/to/my/file/repository/file1223.html</wlp:hasNativeContent>                 </rdf:Description>               </rdf:RDF>             </data>           </annotation>           <mediaUnit xsi:type="model:Image" uri="periplus://fileRepository/resource_2/image_1">             <annotation uri="periplus://fileRepository/resource_2/annotation_1">               <data>                 <rdf:RDF xmlns:wls="http://weblab.ow2.org/core/1.2/ontology/retrieval#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#">                   <rdf:Description rdf:about="periplus://fileRepository/resource_2">                     <wlp:hasExposedContent>/path/where/image/is/stored/img1223-1.jpg</wlp:hasExposedContent>                   </rdf:Description>                   <rdf:Description rdf:about="periplus://fileRepository/resource_2/image_1/scene_1">                     <dc:type>SCENE</dc:type>                   </rdf:Description>                   <rdf:Description rdf:about="periplus://fileRepository/resource_2/image_1/scene_2">                     <dc:type>SCENE</dc:type>                   </rdf:Description>                   <rdf:Bag rdf:about="periplus://fileRepository/resource_2/image_1/scene_1">                     <rdf:li rdf:resource="periplus://fileRepository/resource_2/image_1/scene_1/descr_1" />                     <rdf:li rdf:resource="periplus://fileRepository/resource_2/image_1/scene_1/descr_2" />                   </rdf:Bag>                   <rdf:Bag rdf:about="periplus://fileRepository/resource_2/image_1/scene_2">                     <rdf:li rdf:resource="periplus://fileRepository/resource_2/image_1/scene_2/descr_1" />                   </rdf:Bag>                   <rdf:Description rdf:about="periplus://fileRepository/resource_2/image_1/scene_1/descr_1">                     <dc:title>day</dc:title>                     <wls:hasScore>0.912</wls:hasScore>                   </rdf:Description>                   <rdf:Description rdf:about="periplus://fileRepository/resource_2/image_1/scene_1/descr_2">                     <dc:title>outside</dc:title>                     <wls:hasScore>0.847</wls:hasScore>                   </rdf:Description>                   <rdf:Description rdf:about="periplus://fileRepository/resource_2/image_1/scene_2/descr_1">                     <dc:title>urban</dc:title>                     <wls:hasScore>0.117</wls:hasScore>                   </rdf:Description>                 </rdf:RDF>               </data>             </annotation>           </mediaUnit>         </resource>         <resource xsi:type="model:Document" uri="periplus://fileRepository/resource_3">           <annotation uri="periplus://fileRepository/resource_3/annotation_1">             <data>               <rdf:RDF xmlns:wls="http://weblab.ow2.org/core/1.2/ontology/retrieval#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#">                 <rdf:Description rdf:about="periplus://fileRepository/resource_3">                   <dc:source>http://arthistory.about.com/od/modernarthistory/a/Neo-Impressionism-Art-History-101-Basics.htm</dc:source>                   <wlp:hasNativeContent>/path/to/my/file/repository/file10001.html</wlp:hasNativeContent>                 </rdf:Description>               </rdf:RDF>             </data>           </annotation>            <mediaUnit xsi:type="model:Image" uri="periplus://fileRepository/resource_3/image_1">             <annotation uri="periplus://fileRepository/resource_3/image_1/annotation_1">               <data>                 <rdf:RDF xmlns:wls="http://weblab.ow2.org/core/1.2/ontology/retrieval#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#">                   <rdf:Description rdf:about="periplus://fileRepository/resource_3/image_1">                     <wlp:hasExposedContent>/path/where/image/is/stored/img10001-1.jpg</wlp:hasExposedContent>                   </rdf:Description>                   <rdf:Description rdf:about="periplus://fileRepository/resource_3/image_1/object_1">                     <wls:hasRelevantSegment rdf:resource="periplus://fileRepository/resource_3/image_1/segment_1" />                     <dc:type>OBJECT</dc:type>                   </rdf:Description>                   <rdf:Bag rdf:about="periplus://fileRepository/resource_3/image_1/object_1">                     <rdf:li rdf:resource="periplus://fileRepository/resource_3/image_1/object_1/descr_1" />                     <rdf:li rdf:resource="periplus://fileRepository/resource_3/image_1/object_1/descr_2" />                   </rdf:Bag>                   <rdf:Description rdf:about="periplus://fileRepository/resource_3/image_1/object_1/descr_1">                     <dc:title>tree</dc:title>                     <wls:hasScore>0.99</wls:hasScore>                   </rdf:Description>                   <rdf:Description rdf:about="periplus://fileRepository/resource_3/image_1/object_1/descr_2">                     <dc:title>pine tree</dc:title>                     <wls:hasScore>0.44</wls:hasScore>                   </rdf:Description>                 </rdf:RDF>               </data>             </annotation>             <segment xsi:type="model:SpatialSegment" uri="periplus://fileRepository/resource_3/image_1/segment_1">               <coordinate x="12" y="14" />               <coordinate x="24" y="52" />             </segment>           </mediaUnit>           <mediaUnit xsi:type="model:Video" uri="periplus://fileRepository/resource_3/video_1">             <annotation uri="periplus://fileRepository/resource_3/video_1/annotation_1">               <data>                 <rdf:RDF xmlns:wls="http://weblab.ow2.org/core/1.2/ontology/retrieval#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#">                   <rdf:Description rdf:about="periplus://fileRepository/resource_3/video_1">                     <wlp:hasExposedContent>/path/where/video/is/stored/vid10001-1.avi</wlp:hasExposedContent>                     <wls:hasRelevantSegment rdf:resource="periplus://fileRepository/resource_3/video_1/segment_1" />                   </rdf:Description>                   <rdf:Description rdf:about="periplus://fileRepository/resource_3/video_1/shot_1">                     <wls:hasRelevantSegment rdf:resource="periplus://fileRepository/resource_3/video_1/segment_2" />                     <wlp:hasExposedContent>/path/to/a/key/image.jpg</wlp:hasExposedContent>                     <dc:type>SHOT</dc:type>                   </rdf:Description>                   <rdf:Bag rdf:about="periplus://fileRepository/resource_3/video_1/shot_1">                     <rdf:li rdf:resource="periplus://fileRepository/resource_3/video_1/shot_1/descr_1" />                     <rdf:li rdf:resource="periplus://fileRepository/resource_3/video_1/shot_1/descr_2" />                   </rdf:Bag>                   <rdf:Description rdf:about="periplus://fileRepository/resource_3/video_1/shot_1/descr_1">                     <dc:title>news report</dc:title>                     <wls:hasScore>0.87</wls:hasScore>                   </rdf:Description>                   <rdf:Description rdf:about="periplus://fileRepository/resource_3/video_1/shot_1/descr_2">                     <dc:title>CNN</dc:title>                     <wls:hasScore>0.51</wls:hasScore>                   </rdf:Description>                 </rdf:RDF>               </data>             </annotation>             <segment xsi:type="model:TemporalSegment" uri="periplus://fileRepository/resource_3/video_1/segment_1" start="10" end="14700" />             <segment xsi:type="model:SpatioTemporalSegment" uri="periplus://fileRepository/resource_3/video_1/segment_2" start="1000" end="3700" >               <coordinate x="0" y="1" />               <coordinate x="27" y="360" />             </segment>           </mediaUnit>         </resource>       </resultSet>     </searcher:searchReturn>   </SOAP-ENV:Body> </SOAP-ENV:Envelope>'
        return res 
    
    def simulate_response_v2_(self):
        
        '''res = '<soapenv:Envelope xmlns:soapenv="http://schemas.xmlsoap.org/soap/envelope/"><soapenv:Body><sear:searchReturn xmlns:model="http://weblab.ow2.org/core/1.2/model#" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns:sear="http://weblab.ow2.org/core/1.2/services/searcher" xmlns:soapenv="http://schemas.xmlsoap.org/soap/envelope/"><resultSet uri="periplus://simquery/result" xmlns:model="http://weblab.ow2.org/core/1.2/model#" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"><annotation uri="periplus://simquery/result/annotation"><data><rdf:RDF xmlns:wlr="http://weblab.ow2.org/core/1.2/ontology/retrieval#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://simquery/result/hit:7"><wlr:inResultSetHit rdf:resource="periplus://simquery/result"/><wlr:isLinkedTo rdf:resource="periplus://resource:7"/><wlr:hasDescription>Les coulisses du debat Sarkozy-Hollande. Rendez-vous traditionnel avant le deuxieme tour de la presidentielle, le debat </wlr:hasDescription><wlr:hasScore>0</wlr:hasScore><wlr:hasRank>1</wlr:hasRank><dc:identifier>test16.txt</dc:identifier><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/hit:2"><wlr:inResultSetHit rdf:resource="periplus://simquery/result"/><wlr:isLinkedTo rdf:resource="periplus://resource:2"/><wlr:hasDescription>Un debat qui conclut sept mois d affrontement.Voici les sujets sur lesquels Francois Hollande et Nicolas Sarkozy etaient atten</wlr:hasDescription><wlr:hasScore>0</wlr:hasScore><wlr:hasRank>2</wlr:hasRank><dc:identifier>test11.txt</dc:identifier><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/hit:4"><wlr:inResultSetHit rdf:resource="periplus://simquery/result"/><wlr:isLinkedTo rdf:resource="periplus://resource:4"/><wlr:hasDescription>Second tour : Hollande maintient son avance sur Sarkozy. Francois Hollande l\u2019emporterait avec 54% (-0,5 point) des voix contre 46% a Nic</wlr:hasDescription><wlr:hasScore>0</wlr:hasScore><wlr:hasRank>3</wlr:hasRank><dc:identifier>149</dc:identifier><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/hit:11"><wlr:inResultSetHit rdf:resource="periplus://simquery/result"/><wlr:isLinkedTo rdf:resource="periplus://resource:11"/><wlr:hasDescription>La cote de Sarkozy en hausse  chez les sympathisants du FN.Le president-candidat gagne 23 points de cote de confiance aupres des partisans</wlr:hasDescription><wlr:hasScore>0</wlr:hasScore><wlr:hasRank>4</wlr:hasRank><dc:identifier>test1.txt</dc:identifier><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/hit:17"><wlr:inResultSetHit rdf:resource="periplus://simquery/result"/><wlr:isLinkedTo rdf:resource="periplus://resource:17"/><wlr:hasDescription>Comment Sarkozy et Hollande ont prepare le debat. Le favori de la presidentielle et le president-candidat debattront ce mercredi</wlr:hasDescription><wlr:hasScore>0</wlr:hasScore><wlr:hasRank>5</wlr:hasRank><dc:identifier>155</dc:identifier><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/hit:21"><wlr:inResultSetHit rdf:resource="periplus://simquery/result"/><wlr:isLinkedTo rdf:resource="periplus://resource:21"/><wlr:hasDescription>Economistes, sans parti pris ideologique, nous soutenons Sarkozy. Nicolas Sarkozy nous semble le mieux capable de prendre l avenir a bras-le-cor</wlr:hasDescription><wlr:hasScore>0</wlr:hasScore><wlr:hasRank>6</wlr:hasRank><dc:identifier>test8.txt</dc:identifier><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/cluster:0"><wlr:hasNumberOfResults>2</wlr:hasNumberOfResults><wlr:hasDescription>Francois le grand gagnant !</wlr:hasDescription><rdf:type rdf:resource="DocumentCluster"/><dc:title>Elections</dc:title></rdf:Description><rdf:Bag rdf:about="periplus://simquery/result/cluster:0"><rdf:li rdf:resource="periplus://simquery/result/hit:17"/><rdf:li rdf:resource="periplus://simquery/result/hit:4"/></rdf:Bag><rdf:Description rdf:about="periplus://simquery/result"><wlr:hasQueryOffset>0</wlr:hasQueryOffset><wlr:hasNumberOfResults>6</wlr:hasNumberOfResults><wlr:isResultOf rdf:resource="periplus://simquery"/><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/model#ResultSet"/><wlr:hasHit rdf:resource="periplus://simquery/result/hit:7"/><wlr:hasHit rdf:resource="periplus://simquery/result/hit:2"/><wlr:hasHit rdf:resource="periplus://simquery/result/hit:4"/><wlr:hasHit rdf:resource="periplus://simquery/result/hit:11"/><wlr:hasHit rdf:resource="periplus://simquery/result/hit:17"/><wlr:hasHit rdf:resource="periplus://simquery/result/hit:21"/></rdf:Description></rdf:RDF></data></annotation><resource uri="periplus://resource:7" xsi:type="model:Document"><annotation uri="periplus://resource:7/annot:0"><data><rdf:RDF xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://resource:7"><wlp:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/7</wlp:hasNativeContent></rdf:Description></rdf:RDF></data></annotation></resource><resource uri="periplus://resource:2" xsi:type="model:Document"><annotation uri="periplus://resource:2/annot:0"><data><rdf:RDF xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://resource:2"><wlp:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/2</wlp:hasNativeContent></rdf:Description></rdf:RDF></data></annotation></resource><resource uri="periplus://resource:4" xsi:type="model:Document"><annotation uri="periplus://resource:4/annot:0"><data><rdf:RDF xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://resource:4"><wlp:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/4</wlp:hasNativeContent></rdf:Description></rdf:RDF></data></annotation></resource><resource uri="periplus://resource:11" xsi:type="model:Document"><annotation uri="periplus://resource:11/annot:0"><data><rdf:RDF xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://resource:11"><wlp:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/11</wlp:hasNativeContent></rdf:Description></rdf:RDF></data></annotation></resource><resource uri="periplus://resource:17" xsi:type="model:Document"><annotation uri="periplus://resource:17/annot:0"><data><rdf:RDF xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://resource:17"><wlp:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/17</wlp:hasNativeContent></rdf:Description></rdf:RDF></data></annotation></resource><resource uri="periplus://resource:21" xsi:type="model:Document"><annotation uri="periplus://resource:21/annot:0"><data><rdf:RDF xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://resource:21"><wlp:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/21</wlp:hasNativeContent></rdf:Description></rdf:RDF></data></annotation></resource></resultSet></sear:searchReturn></soapenv:Body></soapenv:Envelope>'''
        '''res = '<soapenv:Envelope xmlns:soapenv="http://schemas.xmlsoap.org/soap/envelope/"><soapenv:Body><sear:searchReturn xmlns:model="http://weblab.ow2.org/core/1.2/model#" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns:sear="http://weblab.ow2.org/core/1.2/services/searcher" xmlns:soapenv="http://schemas.xmlsoap.org/soap/envelope/"><resultSet uri="periplus://simquery/result" xmlns:model="http://weblab.ow2.org/core/1.2/model#" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"><annotation uri="periplus://simquery/result/annotation"><data><rdf:RDF xmlns:wlr="http://weblab.ow2.org/core/1.2/ontology/retrieval#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://simquery/result/hit:7"><wlr:inResultSetHit rdf:resource="periplus://simquery/result"/><wlr:isLinkedTo rdf:resource="periplus://resource:7"/><wlr:hasDescription>Les coulisses du debat Sarkozy-Hollande. Rendez-vous traditionnel avant le deuxieme tour de la presidentielle, le debat </wlr:hasDescription><wlr:hasScore>0</wlr:hasScore><wlr:hasRank>1</wlr:hasRank><dc:identifier>test16.txt</dc:identifier><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/hit:2"><wlr:inResultSetHit rdf:resource="periplus://simquery/result"/><wlr:isLinkedTo rdf:resource="periplus://resource:2"/><wlr:hasDescription>Un debat qui conclut sept mois d affrontement.Voici les sujets sur lesquels Francois Hollande et Nicolas Sarkozy etaient atten</wlr:hasDescription><wlr:hasScore>0</wlr:hasScore><wlr:hasRank>2</wlr:hasRank><dc:identifier>test11.txt</dc:identifier><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/hit:4"><wlr:inResultSetHit rdf:resource="periplus://simquery/result"/><wlr:isLinkedTo rdf:resource="periplus://resource:4"/><wlr:hasDescription>Second tour : Hollande maintient son avance sur Sarkozy. Francois Hollande l\u2019emporterait avec 54% (-0,5 point) des voix contre 46% a Nic</wlr:hasDescription><wlr:hasScore>0</wlr:hasScore><wlr:hasRank>3</wlr:hasRank><dc:identifier>149</dc:identifier><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/hit:11"><wlr:inResultSetHit rdf:resource="periplus://simquery/result"/><wlr:isLinkedTo rdf:resource="periplus://resource:11"/><wlr:hasDescription>La cote de Sarkozy en hausse  chez les sympathisants du FN.Le president-candidat gagne 23 points de cote de confiance aupres des partisans</wlr:hasDescription><wlr:hasScore>0</wlr:hasScore><wlr:hasRank>4</wlr:hasRank><dc:identifier>test1.txt</dc:identifier><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/hit:17"><wlr:inResultSetHit rdf:resource="periplus://simquery/result"/><wlr:isLinkedTo rdf:resource="periplus://resource:17"/><wlr:hasDescription>Comment Sarkozy et Hollande ont prepare le debat. Le favori de la presidentielle et le president-candidat debattront ce mercredi</wlr:hasDescription><wlr:hasScore>0</wlr:hasScore><wlr:hasRank>5</wlr:hasRank><dc:identifier>155</dc:identifier><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/hit:21"><wlr:inResultSetHit rdf:resource="periplus://simquery/result"/><wlr:isLinkedTo rdf:resource="periplus://resource:21"/><wlr:hasDescription>Economistes, sans parti pris ideologique, nous soutenons Sarkozy. Nicolas Sarkozy nous semble le mieux capable de prendre l avenir a bras-le-cor</wlr:hasDescription><wlr:hasScore>0</wlr:hasScore><wlr:hasRank>6</wlr:hasRank><dc:identifier>test8.txt</dc:identifier><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/cluster:0"><wlr:hasNumberOfResults>2</wlr:hasNumberOfResults><wlr:hasDescription>Francois le grand gagnant</wlr:hasDescription><rdf:type rdf:resource="DocumentCluster"/><dc:title>Elections</dc:title></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/cluster:1"><wlr:hasNumberOfResults>2</wlr:hasNumberOfResults><wlr:hasDescription>Francois le grand gagnant</wlr:hasDescription><rdf:type rdf:resource="DocumentCluster"/><dc:title>Hollande gagnant</dc:title></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/cluster:2"><wlr:hasNumberOfResults>2</wlr:hasNumberOfResults><wlr:hasDescription>Francois le grand gagnant</wlr:hasDescription><rdf:type rdf:resource="DocumentCluster"/><dc:title>Un avenir ?</dc:title></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/cluster:3"><wlr:hasNumberOfResults>2</wlr:hasNumberOfResults><wlr:hasDescription>Francois le grand gagnant</wlr:hasDescription><rdf:type rdf:resource="DocumentCluster"/><dc:title>New !</dc:title></rdf:Description><rdf:Bag rdf:about="periplus://simquery/result/cluster:0"><rdf:li rdf:resource="periplus://simquery/result/hit:17"/><rdf:li rdf:resource="periplus://simquery/result/hit:4"/></rdf:Bag><rdf:Bag rdf:about="periplus://simquery/result/cluster:1"><rdf:li rdf:resource="periplus://simquery/result/hit:17"/><rdf:li rdf:resource="periplus://simquery/result/hit:4"/></rdf:Bag><rdf:Bag rdf:about="periplus://simquery/result/cluster:2"><rdf:li rdf:resource="periplus://simquery/result/hit:17"/><rdf:li rdf:resource="periplus://simquery/result/hit:4"/></rdf:Bag><rdf:Bag rdf:about="periplus://simquery/result/cluster:3"><rdf:li rdf:resource="periplus://simquery/result/hit:17"/><rdf:li rdf:resource="periplus://simquery/result/hit:4"/></rdf:Bag><rdf:Description rdf:about="periplus://simquery/result"><wlr:hasQueryOffset>0</wlr:hasQueryOffset><wlr:hasNumberOfResults>6</wlr:hasNumberOfResults><wlr:isResultOf rdf:resource="periplus://simquery"/><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/model#ResultSet"/><wlr:hasHit rdf:resource="periplus://simquery/result/hit:7"/><wlr:hasHit rdf:resource="periplus://simquery/result/hit:2"/><wlr:hasHit rdf:resource="periplus://simquery/result/hit:4"/><wlr:hasHit rdf:resource="periplus://simquery/result/hit:11"/><wlr:hasHit rdf:resource="periplus://simquery/result/hit:17"/><wlr:hasHit rdf:resource="periplus://simquery/result/hit:21"/></rdf:Description></rdf:RDF></data></annotation><resource uri="periplus://resource:7" xsi:type="model:Document"><annotation uri="periplus://resource:7/annot:0"><data><rdf:RDF xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://resource:7"><wlp:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/7</wlp:hasNativeContent></rdf:Description></rdf:RDF></data></annotation></resource><resource uri="periplus://resource:2" xsi:type="model:Document"><annotation uri="periplus://resource:2/annot:0"><data><rdf:RDF xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://resource:2"><wlp:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/2</wlp:hasNativeContent></rdf:Description></rdf:RDF></data></annotation></resource><resource uri="periplus://resource:4" xsi:type="model:Document"><annotation uri="periplus://resource:4/annot:0"><data><rdf:RDF xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://resource:4"><wlp:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/4</wlp:hasNativeContent></rdf:Description></rdf:RDF></data></annotation></resource><resource uri="periplus://resource:11" xsi:type="model:Document"><annotation uri="periplus://resource:11/annot:0"><data><rdf:RDF xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://resource:11"><wlp:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/11</wlp:hasNativeContent></rdf:Description></rdf:RDF></data></annotation></resource><resource uri="periplus://resource:17" xsi:type="model:Document"><annotation uri="periplus://resource:17/annot:0"><data><rdf:RDF xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://resource:17"><wlp:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/17</wlp:hasNativeContent></rdf:Description></rdf:RDF></data></annotation></resource><resource uri="periplus://resource:21" xsi:type="model:Document"><annotation uri="periplus://resource:21/annot:0"><data><rdf:RDF xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://resource:21"><wlp:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/21</wlp:hasNativeContent></rdf:Description></rdf:RDF></data></annotation></resource></resultSet></sear:searchReturn></soapenv:Body></soapenv:Envelope>'''
        res = '<soapenv:Envelope xmlns:soapenv="http://schemas.xmlsoap.org/soap/envelope/"><soapenv:Body><sear:searchReturn xmlns:model="http://weblab.ow2.org/core/1.2/model#" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns:sear="http://weblab.ow2.org/core/1.2/services/searcher" xmlns:soapenv="http://schemas.xmlsoap.org/soap/envelope/"><resultSet uri="periplus://simquery/result" xmlns:model="http://weblab.ow2.org/core/1.2/model#" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"><annotation uri="periplus://simquery/result/annotation"><data><rdf:RDF xmlns:wlr="http://weblab.ow2.org/core/1.2/ontology/retrieval#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://simquery/result/hit:656"><wlr:inResultSetHit rdf:resource="periplus://simquery/result"/><wlr:isLinkedTo rdf:resource="periplus://resource:656"/><wlr:hasDescription>Bien sur, il n\'a rien fait comme prevu. Pour la remise du Prix Charle</wlr:hasDescription><wlr:hasScore>1</wlr:hasScore><wlr:hasRank>1</wlr:hasRank><dc:identifier>12844</dc:identifier><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/hit:1206"><wlr:inResultSetHit rdf:resource="periplus://simquery/result"/><wlr:isLinkedTo rdf:resource="periplus://resource:1206"/><wlr:hasDescription>Crises de nerfs a l\'Elysee. Depuis dix jours, Nicolas Sar</wlr:hasDescription><wlr:hasScore>1</wlr:hasScore><wlr:hasRank>2</wlr:hasRank><dc:identifier>17715</dc:identifier><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/hit:1209"><wlr:inResultSetHit rdf:resource="periplus://simquery/result"/><wlr:isLinkedTo rdf:resource="periplus://resource:1209"/><wlr:hasDescription>Crises de nerfs a l\'Elysee. Depuis dix jours, Nicolas Sar</wlr:hasDescription><wlr:hasScore>1</wlr:hasScore><wlr:hasRank>3</wlr:hasRank><dc:identifier>17752</dc:identifier><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/hit:1263"><wlr:inResultSetHit rdf:resource="periplus://simquery/result"/><wlr:isLinkedTo rdf:resource="periplus://resource:1263"/><wlr:hasDescription>Dessin de Damien Glez: Le president syrien Bachar al-Assad arrive a Paris pour assister, le 13 juillet, au sommet de l\'Union mediterraneenne. Mardi, dans un entretien au F</wlr:hasDescription><wlr:hasScore>1</wlr:hasScore><wlr:hasRank>4</wlr:hasRank><dc:identifier>18210</dc:identifier><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/hit:1329"><wlr:inResultSetHit rdf:resource="periplus://simquery/result"/><wlr:isLinkedTo rdf:resource="periplus://resource:1329"/><wlr:hasDescription>Pas besoin de longs discours, le choc des photos suffira. Voici les covers elyseennes d</wlr:hasDescription><wlr:hasScore>1</wlr:hasScore><wlr:hasRank>5</wlr:hasRank><dc:identifier>18759</dc:identifier><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/hit:1364"><wlr:inResultSetHit rdf:resource="periplus://simquery/result"/><wlr:isLinkedTo rdf:resource="periplus://resource:1364"/><wlr:hasDescription>Cliquer sur les liens pour afficher les articles: Le recit de cette journee et les commentaires audio a chaud des deputes et les reactions au vote de Jack Lang. En acces libre, Le parti pris</wlr:hasDescription><wlr:hasScore>1</wlr:hasScore><wlr:hasRank>6</wlr:hasRank><dc:identifier>18963</dc:identifier><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/hit:2150"><wlr:inResultSetHit rdf:resource="periplus://simquery/result"/><wlr:isLinkedTo rdf:resource="periplus://resource:2150"/><wlr:hasDescription>Pendant des mois, l\'hyperactivite, l\'arrogance et le style bling-bling du president francais ont enerve nos voisins europeens. La presse internationale crit</wlr:hasDescription><wlr:hasScore>1</wlr:hasScore><wlr:hasRank>7</wlr:hasRank><dc:identifier>26028</dc:identifier><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/hit:3051"><wlr:inResultSetHit rdf:resource="periplus://simquery/result"/><wlr:isLinkedTo rdf:resource="periplus://resource:3051"/><wlr:hasDescription>&quot;Traumatisant&quot;, &quot;choquant&quot;. Les mots de Violaine Roussel,</wlr:hasDescription><wlr:hasScore>1</wlr:hasScore><wlr:hasRank>8</wlr:hasRank><dc:identifier>34053</dc:identifier><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/hit:3229"><wlr:inResultSetHit rdf:resource="periplus://simquery/result"/><wlr:isLinkedTo rdf:resource="periplus://resource:3229"/><wlr:hasDescription>Aujourd\'hui au Mexique, Nicolas Sarkozy a voulu se saisir de ce dossier, qui a fait l\'objet d\'une debut de mobilisation sur le web, sur l\'impulsion d\'un site, cree par les parents de Florence Cassez. Depuis le Palais presidentiel</wlr:hasDescription><wlr:hasScore>1</wlr:hasScore><wlr:hasRank>9</wlr:hasRank><dc:identifier>36049</dc:identifier><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/hit:3525"><wlr:inResultSetHit rdf:resource="periplus://simquery/result"/><wlr:isLinkedTo rdf:resource="periplus://resource:3525"/><wlr:hasDescription>Le nouveau Sarkoshow a fait jaser la presse occidentale. Mercredi 16 avril, au cours d</wlr:hasDescription><wlr:hasScore>1</wlr:hasScore><wlr:hasRank>10</wlr:hasRank><dc:identifier>39028</dc:identifier><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/hit:3841"><wlr:inResultSetHit rdf:resource="periplus://simquery/result"/><wlr:isLinkedTo rdf:resource="periplus://resource:3841"/><wlr:hasDescription>Yvan Colonna poursuivait le president de la Republique, mercredi 3 juin, a Paris, pour atteinte a sa &quot;presomption d\'innocence&quot;. Le tribunal devra dire si Nic</wlr:hasDescription><wlr:hasScore>1</wlr:hasScore><wlr:hasRank>11</wlr:hasRank><dc:identifier>42028</dc:identifier><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/hit:4015"><wlr:inResultSetHit rdf:resource="periplus://simquery/result"/><wlr:isLinkedTo rdf:resource="periplus://resource:4015"/><wlr:hasDescription>L\'affaire n\'avait, jusque-la, jamais ete ebruitee. Le nom du president de la Rep</wlr:hasDescription><wlr:hasScore>1</wlr:hasScore><wlr:hasRank>12</wlr:hasRank><dc:identifier>43509</dc:identifier><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/hit:4238"><wlr:inResultSetHit rdf:resource="periplus://simquery/result"/><wlr:isLinkedTo rdf:resource="periplus://resource:4238"/><wlr:hasDescription>Avec la fin de l\'hospitalisation de Nicolas Sarkozy, sorti du Val-de-Grace lundi 27 juillet vers midi, une question titille: quelle lecon le chef de l\'Etat en tirera-t-il? Pour certains ministres, l\'affaire est entendue: cet incident, qui marque le &quot;surmenage&quot; du President de la Republique, doit l\'amener a lever le pied. L\'opposition, pour sa part, p</wlr:hasDescription><wlr:hasScore>1</wlr:hasScore><wlr:hasRank>13</wlr:hasRank><dc:identifier>45556</dc:identifier><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/hit:4548"><wlr:inResultSetHit rdf:resource="periplus://simquery/result"/><wlr:isLinkedTo rdf:resource="periplus://resource:4548"/><wlr:hasDescription>Le 19 octobre 2006, celui qui n\'etait encore que ministre de l\'interieur declarait solennellement au journal de 20 heures de TF1: &quot;J\'ai ete accuse pendant dix-neuf mois par la justice de mon pays, sur la base du mensonge d\'un corbeau qui s\'etait allie avec un juge, d\'avoir un compte a l\'etranger.&quot; Pourtant, aux yeux de plusie</wlr:hasDescription><wlr:hasScore>1</wlr:hasScore><wlr:hasRank>14</wlr:hasRank><dc:identifier>56842</dc:identifier><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/hit:4722"><wlr:inResultSetHit rdf:resource="periplus://simquery/result"/><wlr:isLinkedTo rdf:resource="periplus://resource:4722"/><wlr:hasDescription>Dans un livre a paraitre (Justice, le ministere infernal, par Mathieu Delahousse, Flammarion), un court passage eclaire les coulisses du dossier Clearstream tel qu\'il est gere par la Presidence de la Republique. &quot;Le President veut en avoir l</wlr:hasDescription><wlr:hasScore>1</wlr:hasScore><wlr:hasRank>15</wlr:hasRank><dc:identifier>64587</dc:identifier><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/hit:4741"><wlr:inResultSetHit rdf:resource="periplus://simquery/result"/><wlr:isLinkedTo rdf:resource="periplus://resource:4741"/><wlr:hasDescription>La replique est anthologique. Mardi matin, Nicolas Sarkozy </wlr:hasDescription><wlr:hasScore>1</wlr:hasScore><wlr:hasRank>16</wlr:hasRank><dc:identifier>65797</dc:identifier><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/hit:4763"><wlr:inResultSetHit rdf:resource="periplus://simquery/result"/><wlr:isLinkedTo rdf:resource="periplus://resource:4763"/><wlr:hasDescription>Nicolas Sarkozy a surpris son monde, jeudi 15 octobre, en se rendant a Gandrange (Moselle). En visite le 4 fevrier 2008, </wlr:hasDescription><wlr:hasScore>1</wlr:hasScore><wlr:hasRank>17</wlr:hasRank><dc:identifier>66452</dc:identifier><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/hit:4767"><wlr:inResultSetHit rdf:resource="periplus://simquery/result"/><wlr:isLinkedTo rdf:resource="periplus://resource:4767"/><wlr:hasDescription>Petitions, videos loufoques, parodies, manifestations, sit-in, etc. Depuis l\'annonce de sa candid</wlr:hasDescription><wlr:hasScore>1</wlr:hasScore><wlr:hasRank>18</wlr:hasRank><dc:identifier>66528</dc:identifier><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/hit:5483"><wlr:inResultSetHit rdf:resource="periplus://simquery/result"/><wlr:isLinkedTo rdf:resource="periplus://resource:5483"/><wlr:hasDescription>Trois mois apres le proces, la justice doit rendre sa decision dans l\'affaire Clearstream jeudi 28 janvier. Ironie du sort, c\'est precise</wlr:hasDescription><wlr:hasScore>1</wlr:hasScore><wlr:hasRank>19</wlr:hasRank><dc:identifier>73799</dc:identifier><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/hit:5874"><wlr:inResultSetHit rdf:resource="periplus://simquery/result"/><wlr:isLinkedTo rdf:resource="periplus://resource:5874"/><wlr:hasDescription>Voici trois chronologies rassemblant quelque 350 dates qui retracent la premiere partie du mandat de Nicolas Sarkozy. Realisees par la redaction de</wlr:hasDescription><wlr:hasScore>1</wlr:hasScore><wlr:hasRank>20</wlr:hasRank><dc:identifier>78735</dc:identifier><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/cluster:0"><wlr:hasNumberOfResults>1</wlr:hasNumberOfResults><wlr:isLinkedTo rdf:resource="periplus://cluster:0"/><wlr:hasScore>0</wlr:hasScore><wlr:hasDescription>Mon cluster 0</wlr:hasDescription><dc:title>Cluster 0</dc:title><rdf:type rdf:resource="DocumentCluster"/></rdf:Description><rdf:Bag rdf:about="periplus://simquery/result/cluster:0"><rdf:li rdf:resource="periplus://simquery/result/hit:656"/></rdf:Bag><rdf:Description rdf:about="periplus://simquery/result/cluster:1"><wlr:hasNumberOfResults>1</wlr:hasNumberOfResults><wlr:isLinkedTo rdf:resource="periplus://cluster:1"/><wlr:hasScore>0</wlr:hasScore><wlr:hasDescription>Mon cluster 1</wlr:hasDescription><dc:title>Cluster 1</dc:title><rdf:type rdf:resource="DocumentCluster"/></rdf:Description><rdf:Bag rdf:about="periplus://simquery/result/cluster:1"><rdf:li rdf:resource="periplus://simquery/result/hit:1206"/></rdf:Bag><rdf:Description rdf:about="periplus://simquery/result/cluster:2"><wlr:hasNumberOfResults>1</wlr:hasNumberOfResults><wlr:isLinkedTo rdf:resource="periplus://cluster:2"/><wlr:hasScore>0</wlr:hasScore><wlr:hasDescription>Mon cluster 3</wlr:hasDescription><dc:title>Cluster 3</dc:title><rdf:type rdf:resource="DocumentCluster"/></rdf:Description><rdf:Bag rdf:about="periplus://simquery/result/cluster:2"><rdf:li rdf:resource="periplus://simquery/result/hit:1209"/></rdf:Bag><rdf:Description rdf:about="periplus://simquery/result/cluster:3"><wlr:hasNumberOfResults>1</wlr:hasNumberOfResults><wlr:isLinkedTo rdf:resource="periplus://cluster:3"/><wlr:hasScore>0</wlr:hasScore><wlr:hasDescription>No summary available</wlr:hasDescription><dc:title>No title available</dc:title><rdf:type rdf:resource="DocumentCluster"/></rdf:Description><rdf:Bag rdf:about="periplus://simquery/result/cluster:3"><rdf:li rdf:resource="periplus://simquery/result/hit:1263"/></rdf:Bag><rdf:Description rdf:about="periplus://simquery/result/cluster:4"><wlr:hasNumberOfResults>1</wlr:hasNumberOfResults><wlr:isLinkedTo rdf:resource="periplus://cluster:4"/><wlr:hasScore>0</wlr:hasScore><wlr:hasDescription>No summary available</wlr:hasDescription><dc:title>No title available</dc:title><rdf:type rdf:resource="DocumentCluster"/></rdf:Description><rdf:Bag rdf:about="periplus://simquery/result/cluster:4"><rdf:li rdf:resource="periplus://simquery/result/hit:1329"/></rdf:Bag><rdf:Description rdf:about="periplus://simquery/result/cluster:5"><wlr:hasNumberOfResults>1</wlr:hasNumberOfResults><wlr:isLinkedTo rdf:resource="periplus://cluster:5"/><wlr:hasScore>0</wlr:hasScore><wlr:hasDescription>No summary available</wlr:hasDescription><dc:title>No title available</dc:title><rdf:type rdf:resource="DocumentCluster"/></rdf:Description><rdf:Bag rdf:about="periplus://simquery/result/cluster:5"><rdf:li rdf:resource="periplus://simquery/result/hit:1364"/></rdf:Bag><rdf:Description rdf:about="periplus://simquery/result/cluster:6"><wlr:hasNumberOfResults>1</wlr:hasNumberOfResults><wlr:isLinkedTo rdf:resource="periplus://cluster:6"/><wlr:hasScore>0</wlr:hasScore><wlr:hasDescription>No summary available</wlr:hasDescription><dc:title>No title available</dc:title><rdf:type rdf:resource="DocumentCluster"/></rdf:Description><rdf:Bag rdf:about="periplus://simquery/result/cluster:6"><rdf:li rdf:resource="periplus://simquery/result/hit:2150"/></rdf:Bag><rdf:Description rdf:about="periplus://simquery/result/cluster:7"><wlr:hasNumberOfResults>1</wlr:hasNumberOfResults><wlr:isLinkedTo rdf:resource="periplus://cluster:7"/><wlr:hasScore>0</wlr:hasScore><wlr:hasDescription>No summary available</wlr:hasDescription><dc:title>No title available</dc:title><rdf:type rdf:resource="DocumentCluster"/></rdf:Description><rdf:Bag rdf:about="periplus://simquery/result/cluster:7"><rdf:li rdf:resource="periplus://simquery/result/hit:3051"/></rdf:Bag><rdf:Description rdf:about="periplus://simquery/result/cluster:8"><wlr:hasNumberOfResults>1</wlr:hasNumberOfResults><wlr:isLinkedTo rdf:resource="periplus://cluster:8"/><wlr:hasScore>0</wlr:hasScore><wlr:hasDescription>No summary available</wlr:hasDescription><dc:title>No title available</dc:title><rdf:type rdf:resource="DocumentCluster"/></rdf:Description><rdf:Bag rdf:about="periplus://simquery/result/cluster:8"><rdf:li rdf:resource="periplus://simquery/result/hit:3229"/></rdf:Bag><rdf:Description rdf:about="periplus://simquery/result/cluster:9"><wlr:hasNumberOfResults>1</wlr:hasNumberOfResults><wlr:isLinkedTo rdf:resource="periplus://cluster:9"/><wlr:hasScore>0</wlr:hasScore><wlr:hasDescription>No summary available</wlr:hasDescription><dc:title>No title available</dc:title><rdf:type rdf:resource="DocumentCluster"/></rdf:Description><rdf:Bag rdf:about="periplus://simquery/result/cluster:9"><rdf:li rdf:resource="periplus://simquery/result/hit:3525"/></rdf:Bag><rdf:Description rdf:about="periplus://simquery/result/cluster:10"><wlr:hasNumberOfResults>1</wlr:hasNumberOfResults><wlr:isLinkedTo rdf:resource="periplus://cluster:10"/><wlr:hasScore>0</wlr:hasScore><wlr:hasDescription>No summary available</wlr:hasDescription><dc:title>No title available</dc:title><rdf:type rdf:resource="DocumentCluster"/></rdf:Description><rdf:Bag rdf:about="periplus://simquery/result/cluster:10"><rdf:li rdf:resource="periplus://simquery/result/hit:3841"/></rdf:Bag><rdf:Description rdf:about="periplus://simquery/result/cluster:11"><wlr:hasNumberOfResults>1</wlr:hasNumberOfResults><wlr:isLinkedTo rdf:resource="periplus://cluster:11"/><wlr:hasScore>0</wlr:hasScore><wlr:hasDescription>No summary available</wlr:hasDescription><dc:title>No title available</dc:title><rdf:type rdf:resource="DocumentCluster"/></rdf:Description><rdf:Bag rdf:about="periplus://simquery/result/cluster:11"><rdf:li rdf:resource="periplus://simquery/result/hit:4015"/></rdf:Bag><rdf:Description rdf:about="periplus://simquery/result/cluster:12"><wlr:hasNumberOfResults>1</wlr:hasNumberOfResults><wlr:isLinkedTo rdf:resource="periplus://cluster:12"/><wlr:hasScore>0</wlr:hasScore><wlr:hasDescription>No summary available</wlr:hasDescription><dc:title>No title available</dc:title><rdf:type rdf:resource="DocumentCluster"/></rdf:Description><rdf:Bag rdf:about="periplus://simquery/result/cluster:12"><rdf:li rdf:resource="periplus://simquery/result/hit:4238"/></rdf:Bag><rdf:Description rdf:about="periplus://simquery/result/cluster:13"><wlr:hasNumberOfResults>1</wlr:hasNumberOfResults><wlr:isLinkedTo rdf:resource="periplus://cluster:13"/><wlr:hasScore>0</wlr:hasScore><wlr:hasDescription>No summary available</wlr:hasDescription><dc:title>No title available</dc:title><rdf:type rdf:resource="DocumentCluster"/></rdf:Description><rdf:Bag rdf:about="periplus://simquery/result/cluster:13"><rdf:li rdf:resource="periplus://simquery/result/hit:4548"/></rdf:Bag><rdf:Description rdf:about="periplus://simquery/result/cluster:14"><wlr:hasNumberOfResults>1</wlr:hasNumberOfResults><wlr:isLinkedTo rdf:resource="periplus://cluster:14"/><wlr:hasScore>0</wlr:hasScore><wlr:hasDescription>No summary available</wlr:hasDescription><dc:title>No title available</dc:title><rdf:type rdf:resource="DocumentCluster"/></rdf:Description><rdf:Bag rdf:about="periplus://simquery/result/cluster:14"><rdf:li rdf:resource="periplus://simquery/result/hit:4722"/></rdf:Bag><rdf:Description rdf:about="periplus://simquery/result/cluster:15"><wlr:hasNumberOfResults>1</wlr:hasNumberOfResults><wlr:isLinkedTo rdf:resource="periplus://cluster:15"/><wlr:hasScore>0</wlr:hasScore><wlr:hasDescription>No summary available</wlr:hasDescription><dc:title>No title available</dc:title><rdf:type rdf:resource="DocumentCluster"/></rdf:Description><rdf:Bag rdf:about="periplus://simquery/result/cluster:15"><rdf:li rdf:resource="periplus://simquery/result/hit:4741"/></rdf:Bag><rdf:Description rdf:about="periplus://simquery/result/cluster:16"><wlr:hasNumberOfResults>1</wlr:hasNumberOfResults><wlr:isLinkedTo rdf:resource="periplus://cluster:16"/><wlr:hasScore>0</wlr:hasScore><wlr:hasDescription>No summary available</wlr:hasDescription><dc:title>No title available</dc:title><rdf:type rdf:resource="DocumentCluster"/></rdf:Description><rdf:Bag rdf:about="periplus://simquery/result/cluster:16"><rdf:li rdf:resource="periplus://simquery/result/hit:4763"/></rdf:Bag><rdf:Description rdf:about="periplus://simquery/result/cluster:17"><wlr:hasNumberOfResults>1</wlr:hasNumberOfResults><wlr:isLinkedTo rdf:resource="periplus://cluster:17"/><wlr:hasScore>0</wlr:hasScore><wlr:hasDescription>No summary available</wlr:hasDescription><dc:title>No title available</dc:title><rdf:type rdf:resource="DocumentCluster"/></rdf:Description><rdf:Bag rdf:about="periplus://simquery/result/cluster:17"><rdf:li rdf:resource="periplus://simquery/result/hit:4767"/></rdf:Bag><rdf:Description rdf:about="periplus://simquery/result/cluster:18"><wlr:hasNumberOfResults>1</wlr:hasNumberOfResults><wlr:isLinkedTo rdf:resource="periplus://cluster:18"/><wlr:hasScore>0</wlr:hasScore><wlr:hasDescription>No summary available</wlr:hasDescription><dc:title>No title available</dc:title><rdf:type rdf:resource="DocumentCluster"/></rdf:Description><rdf:Bag rdf:about="periplus://simquery/result/cluster:18"><rdf:li rdf:resource="periplus://simquery/result/hit:5483"/></rdf:Bag><rdf:Description rdf:about="periplus://simquery/result/cluster:19"><wlr:hasNumberOfResults>1</wlr:hasNumberOfResults><wlr:isLinkedTo rdf:resource="periplus://cluster:19"/><wlr:hasScore>0</wlr:hasScore><wlr:hasDescription>No summary available</wlr:hasDescription><dc:title>No title available</dc:title><rdf:type rdf:resource="DocumentCluster"/></rdf:Description><rdf:Bag rdf:about="periplus://simquery/result/cluster:19"><rdf:li rdf:resource="periplus://simquery/result/hit:5874"/></rdf:Bag><rdf:Description rdf:about="periplus://simquery/result"><wlr:hasQueryOffset>0</wlr:hasQueryOffset><wlr:hasNumberOfResults>20</wlr:hasNumberOfResults><wlr:isResultOf rdf:resource="periplus://simquery"/><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/model#ResultSet"/><wlr:hasHit rdf:resource="periplus://simquery/result/hit:656"/><wlr:hasHit rdf:resource="periplus://simquery/result/hit:1206"/><wlr:hasHit rdf:resource="periplus://simquery/result/hit:1209"/><wlr:hasHit rdf:resource="periplus://simquery/result/hit:1263"/><wlr:hasHit rdf:resource="periplus://simquery/result/hit:1329"/><wlr:hasHit rdf:resource="periplus://simquery/result/hit:1364"/><wlr:hasHit rdf:resource="periplus://simquery/result/hit:2150"/><wlr:hasHit rdf:resource="periplus://simquery/result/hit:3051"/><wlr:hasHit rdf:resource="periplus://simquery/result/hit:3229"/><wlr:hasHit rdf:resource="periplus://simquery/result/hit:3525"/><wlr:hasHit rdf:resource="periplus://simquery/result/hit:3841"/><wlr:hasHit rdf:resource="periplus://simquery/result/hit:4015"/><wlr:hasHit rdf:resource="periplus://simquery/result/hit:4238"/><wlr:hasHit rdf:resource="periplus://simquery/result/hit:4548"/><wlr:hasHit rdf:resource="periplus://simquery/result/hit:4722"/><wlr:hasHit rdf:resource="periplus://simquery/result/hit:4741"/><wlr:hasHit rdf:resource="periplus://simquery/result/hit:4763"/><wlr:hasHit rdf:resource="periplus://simquery/result/hit:4767"/><wlr:hasHit rdf:resource="periplus://simquery/result/hit:5483"/><wlr:hasHit rdf:resource="periplus://simquery/result/hit:5874"/></rdf:Description></rdf:RDF></data></annotation><resource uri="periplus://resource:656" xsi:type="model:Document"><annotation uri="periplus://resource:656/annot:0"><data><rdf:RDF xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://resource:656"><wlp:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/656</wlp:hasNativeContent></rdf:Description></rdf:RDF></data></annotation></resource><resource uri="periplus://resource:1206" xsi:type="model:Document"><annotation uri="periplus://resource:1206/annot:0"><data><rdf:RDF xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://resource:1206"><wlp:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/1206</wlp:hasNativeContent></rdf:Description></rdf:RDF></data></annotation></resource><resource uri="periplus://resource:1209" xsi:type="model:Document"><annotation uri="periplus://resource:1209/annot:0"><data><rdf:RDF xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://resource:1209"><wlp:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/1209</wlp:hasNativeContent></rdf:Description></rdf:RDF></data></annotation></resource><resource uri="periplus://resource:1263" xsi:type="model:Document"><annotation uri="periplus://resource:1263/annot:0"><data><rdf:RDF xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://resource:1263"><wlp:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/1263</wlp:hasNativeContent></rdf:Description></rdf:RDF></data></annotation></resource><resource uri="periplus://resource:1329" xsi:type="model:Document"><annotation uri="periplus://resource:1329/annot:0"><data><rdf:RDF xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://resource:1329"><wlp:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/1329</wlp:hasNativeContent></rdf:Description></rdf:RDF></data></annotation></resource><resource uri="periplus://resource:1364" xsi:type="model:Document"><annotation uri="periplus://resource:1364/annot:0"><data><rdf:RDF xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://resource:1364"><wlp:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/1364</wlp:hasNativeContent></rdf:Description></rdf:RDF></data></annotation></resource><resource uri="periplus://resource:2150" xsi:type="model:Document"><annotation uri="periplus://resource:2150/annot:0"><data><rdf:RDF xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://resource:2150"><wlp:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/2150</wlp:hasNativeContent></rdf:Description></rdf:RDF></data></annotation></resource><resource uri="periplus://resource:3051" xsi:type="model:Document"><annotation uri="periplus://resource:3051/annot:0"><data><rdf:RDF xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://resource:3051"><wlp:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/3051</wlp:hasNativeContent></rdf:Description></rdf:RDF></data></annotation></resource><resource uri="periplus://resource:3229" xsi:type="model:Document"><annotation uri="periplus://resource:3229/annot:0"><data><rdf:RDF xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://resource:3229"><wlp:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/3229</wlp:hasNativeContent></rdf:Description></rdf:RDF></data></annotation></resource><resource uri="periplus://resource:3525" xsi:type="model:Document"><annotation uri="periplus://resource:3525/annot:0"><data><rdf:RDF xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://resource:3525"><wlp:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/3525</wlp:hasNativeContent></rdf:Description></rdf:RDF></data></annotation></resource><resource uri="periplus://resource:3841" xsi:type="model:Document"><annotation uri="periplus://resource:3841/annot:0"><data><rdf:RDF xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://resource:3841"><wlp:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/3841</wlp:hasNativeContent></rdf:Description></rdf:RDF></data></annotation></resource><resource uri="periplus://resource:4015" xsi:type="model:Document"><annotation uri="periplus://resource:4015/annot:0"><data><rdf:RDF xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://resource:4015"><wlp:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/4015</wlp:hasNativeContent></rdf:Description></rdf:RDF></data></annotation></resource><resource uri="periplus://resource:4238" xsi:type="model:Document"><annotation uri="periplus://resource:4238/annot:0"><data><rdf:RDF xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://resource:4238"><wlp:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/4238</wlp:hasNativeContent></rdf:Description></rdf:RDF></data></annotation></resource><resource uri="periplus://resource:4548" xsi:type="model:Document"><annotation uri="periplus://resource:4548/annot:0"><data><rdf:RDF xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://resource:4548"><wlp:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/4548</wlp:hasNativeContent></rdf:Description></rdf:RDF></data></annotation></resource><resource uri="periplus://resource:4722" xsi:type="model:Document"><annotation uri="periplus://resource:4722/annot:0"><data><rdf:RDF xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://resource:4722"><wlp:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/4722</wlp:hasNativeContent></rdf:Description></rdf:RDF></data></annotation></resource><resource uri="periplus://resource:4741" xsi:type="model:Document"><annotation uri="periplus://resource:4741/annot:0"><data><rdf:RDF xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://resource:4741"><wlp:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/4741</wlp:hasNativeContent></rdf:Description></rdf:RDF></data></annotation></resource><resource uri="periplus://resource:4763" xsi:type="model:Document"><annotation uri="periplus://resource:4763/annot:0"><data><rdf:RDF xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://resource:4763"><wlp:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/4763</wlp:hasNativeContent></rdf:Description></rdf:RDF></data></annotation></resource><resource uri="periplus://resource:4767" xsi:type="model:Document"><annotation uri="periplus://resource:4767/annot:0"><data><rdf:RDF xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://resource:4767"><wlp:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/4767</wlp:hasNativeContent></rdf:Description></rdf:RDF></data></annotation></resource><resource uri="periplus://resource:5483" xsi:type="model:Document"><annotation uri="periplus://resource:5483/annot:0"><data><rdf:RDF xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://resource:5483"><wlp:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/5483</wlp:hasNativeContent></rdf:Description></rdf:RDF></data></annotation></resource><resource uri="periplus://resource:5874" xsi:type="model:Document"><annotation uri="periplus://resource:5874/annot:0"><data><rdf:RDF xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://resource:5874"><wlp:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/5874</wlp:hasNativeContent></rdf:Description></rdf:RDF></data></annotation></resource></resultSet></sear:searchReturn></soapenv:Body></soapenv:Envelope>'
        return res   
    
    def simulate_response_v3_(self):
        
        '''res = '<soapenv:Envelope xmlns:soapenv="http://schemas.xmlsoap.org/soap/envelope/"><soapenv:Body><sear:searchReturn xmlns:model="http://weblab.ow2.org/core/1.2/model#" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns:sear="http://weblab.ow2.org/core/1.2/services/searcher" xmlns:soapenv="http://schemas.xmlsoap.org/soap/envelope/"><resultSet uri="periplus://simquery/result" xmlns:model="http://weblab.ow2.org/core/1.2/model#" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"><annotation uri="periplus://simquery/result/annotation"><data><rdf:RDF xmlns:wlr="http://weblab.ow2.org/core/1.2/ontology/retrieval#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://simquery/result/hit:7"><wlr:inResultSetHit rdf:resource="periplus://simquery/result"/><wlr:isLinkedTo rdf:resource="periplus://resource:7"/><wlr:hasDescription>Les coulisses du debat Sarkozy-Hollande. Rendez-vous traditionnel avant le deuxieme tour de la presidentielle, le debat </wlr:hasDescription><wlr:hasScore>0</wlr:hasScore><wlr:hasRank>1</wlr:hasRank><dc:identifier>test16.txt</dc:identifier><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/hit:2"><wlr:inResultSetHit rdf:resource="periplus://simquery/result"/><wlr:isLinkedTo rdf:resource="periplus://resource:2"/><wlr:hasDescription>Un debat qui conclut sept mois d affrontement.Voici les sujets sur lesquels Francois Hollande et Nicolas Sarkozy etaient atten</wlr:hasDescription><wlr:hasScore>0</wlr:hasScore><wlr:hasRank>2</wlr:hasRank><dc:identifier>test11.txt</dc:identifier><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/hit:4"><wlr:inResultSetHit rdf:resource="periplus://simquery/result"/><wlr:isLinkedTo rdf:resource="periplus://resource:4"/><wlr:hasDescription>Second tour : Hollande maintient son avance sur Sarkozy. Francois Hollande l\u2019emporterait avec 54% (-0,5 point) des voix contre 46% a Nic</wlr:hasDescription><wlr:hasScore>0</wlr:hasScore><wlr:hasRank>3</wlr:hasRank><dc:identifier>149</dc:identifier><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/hit:11"><wlr:inResultSetHit rdf:resource="periplus://simquery/result"/><wlr:isLinkedTo rdf:resource="periplus://resource:11"/><wlr:hasDescription>La cote de Sarkozy en hausse  chez les sympathisants du FN.Le president-candidat gagne 23 points de cote de confiance aupres des partisans</wlr:hasDescription><wlr:hasScore>0</wlr:hasScore><wlr:hasRank>4</wlr:hasRank><dc:identifier>test1.txt</dc:identifier><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/hit:17"><wlr:inResultSetHit rdf:resource="periplus://simquery/result"/><wlr:isLinkedTo rdf:resource="periplus://resource:17"/><wlr:hasDescription>Comment Sarkozy et Hollande ont prepare le debat. Le favori de la presidentielle et le president-candidat debattront ce mercredi</wlr:hasDescription><wlr:hasScore>0</wlr:hasScore><wlr:hasRank>5</wlr:hasRank><dc:identifier>155</dc:identifier><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/hit:21"><wlr:inResultSetHit rdf:resource="periplus://simquery/result"/><wlr:isLinkedTo rdf:resource="periplus://resource:21"/><wlr:hasDescription>Economistes, sans parti pris ideologique, nous soutenons Sarkozy. Nicolas Sarkozy nous semble le mieux capable de prendre l avenir a bras-le-cor</wlr:hasDescription><wlr:hasScore>0</wlr:hasScore><wlr:hasRank>6</wlr:hasRank><dc:identifier>test8.txt</dc:identifier><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/cluster:0"><wlr:hasNumberOfResults>2</wlr:hasNumberOfResults><wlr:hasDescription>Francois le grand gagnant !</wlr:hasDescription><rdf:type rdf:resource="DocumentCluster"/><dc:title>Elections</dc:title></rdf:Description><rdf:Bag rdf:about="periplus://simquery/result/cluster:0"><rdf:li rdf:resource="periplus://simquery/result/hit:17"/><rdf:li rdf:resource="periplus://simquery/result/hit:4"/></rdf:Bag><rdf:Description rdf:about="periplus://simquery/result"><wlr:hasQueryOffset>0</wlr:hasQueryOffset><wlr:hasNumberOfResults>6</wlr:hasNumberOfResults><wlr:isResultOf rdf:resource="periplus://simquery"/><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/model#ResultSet"/><wlr:hasHit rdf:resource="periplus://simquery/result/hit:7"/><wlr:hasHit rdf:resource="periplus://simquery/result/hit:2"/><wlr:hasHit rdf:resource="periplus://simquery/result/hit:4"/><wlr:hasHit rdf:resource="periplus://simquery/result/hit:11"/><wlr:hasHit rdf:resource="periplus://simquery/result/hit:17"/><wlr:hasHit rdf:resource="periplus://simquery/result/hit:21"/></rdf:Description></rdf:RDF></data></annotation><resource uri="periplus://resource:7" xsi:type="model:Document"><annotation uri="periplus://resource:7/annot:0"><data><rdf:RDF xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://resource:7"><wlp:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/7</wlp:hasNativeContent></rdf:Description></rdf:RDF></data></annotation></resource><resource uri="periplus://resource:2" xsi:type="model:Document"><annotation uri="periplus://resource:2/annot:0"><data><rdf:RDF xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://resource:2"><wlp:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/2</wlp:hasNativeContent></rdf:Description></rdf:RDF></data></annotation></resource><resource uri="periplus://resource:4" xsi:type="model:Document"><annotation uri="periplus://resource:4/annot:0"><data><rdf:RDF xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://resource:4"><wlp:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/4</wlp:hasNativeContent></rdf:Description></rdf:RDF></data></annotation></resource><resource uri="periplus://resource:11" xsi:type="model:Document"><annotation uri="periplus://resource:11/annot:0"><data><rdf:RDF xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://resource:11"><wlp:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/11</wlp:hasNativeContent></rdf:Description></rdf:RDF></data></annotation></resource><resource uri="periplus://resource:17" xsi:type="model:Document"><annotation uri="periplus://resource:17/annot:0"><data><rdf:RDF xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://resource:17"><wlp:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/17</wlp:hasNativeContent></rdf:Description></rdf:RDF></data></annotation></resource><resource uri="periplus://resource:21" xsi:type="model:Document"><annotation uri="periplus://resource:21/annot:0"><data><rdf:RDF xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://resource:21"><wlp:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/21</wlp:hasNativeContent></rdf:Description></rdf:RDF></data></annotation></resource></resultSet></sear:searchReturn></soapenv:Body></soapenv:Envelope>'''
        '''res = '<soapenv:Envelope xmlns:soapenv="http://schemas.xmlsoap.org/soap/envelope/"><soapenv:Body><sear:searchReturn xmlns:model="http://weblab.ow2.org/core/1.2/model#" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns:sear="http://weblab.ow2.org/core/1.2/services/searcher" xmlns:soapenv="http://schemas.xmlsoap.org/soap/envelope/"><resultSet uri="periplus://simquery/result" xmlns:model="http://weblab.ow2.org/core/1.2/model#" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"><annotation uri="periplus://simquery/result/annotation"><data><rdf:RDF xmlns:wlr="http://weblab.ow2.org/core/1.2/ontology/retrieval#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://simquery/result/hit:7"><wlr:inResultSetHit rdf:resource="periplus://simquery/result"/><wlr:isLinkedTo rdf:resource="periplus://resource:7"/><wlr:hasDescription>Les coulisses du debat Sarkozy-Hollande. Rendez-vous traditionnel avant le deuxieme tour de la presidentielle, le debat </wlr:hasDescription><wlr:hasScore>0</wlr:hasScore><wlr:hasRank>1</wlr:hasRank><dc:identifier>test16.txt</dc:identifier><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/hit:2"><wlr:inResultSetHit rdf:resource="periplus://simquery/result"/><wlr:isLinkedTo rdf:resource="periplus://resource:2"/><wlr:hasDescription>Un debat qui conclut sept mois d affrontement.Voici les sujets sur lesquels Francois Hollande et Nicolas Sarkozy etaient atten</wlr:hasDescription><wlr:hasScore>0</wlr:hasScore><wlr:hasRank>2</wlr:hasRank><dc:identifier>test11.txt</dc:identifier><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/hit:4"><wlr:inResultSetHit rdf:resource="periplus://simquery/result"/><wlr:isLinkedTo rdf:resource="periplus://resource:4"/><wlr:hasDescription>Second tour : Hollande maintient son avance sur Sarkozy. Francois Hollande l\u2019emporterait avec 54% (-0,5 point) des voix contre 46% a Nic</wlr:hasDescription><wlr:hasScore>0</wlr:hasScore><wlr:hasRank>3</wlr:hasRank><dc:identifier>149</dc:identifier><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/hit:11"><wlr:inResultSetHit rdf:resource="periplus://simquery/result"/><wlr:isLinkedTo rdf:resource="periplus://resource:11"/><wlr:hasDescription>La cote de Sarkozy en hausse  chez les sympathisants du FN.Le president-candidat gagne 23 points de cote de confiance aupres des partisans</wlr:hasDescription><wlr:hasScore>0</wlr:hasScore><wlr:hasRank>4</wlr:hasRank><dc:identifier>test1.txt</dc:identifier><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/hit:17"><wlr:inResultSetHit rdf:resource="periplus://simquery/result"/><wlr:isLinkedTo rdf:resource="periplus://resource:17"/><wlr:hasDescription>Comment Sarkozy et Hollande ont prepare le debat. Le favori de la presidentielle et le president-candidat debattront ce mercredi</wlr:hasDescription><wlr:hasScore>0</wlr:hasScore><wlr:hasRank>5</wlr:hasRank><dc:identifier>155</dc:identifier><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/hit:21"><wlr:inResultSetHit rdf:resource="periplus://simquery/result"/><wlr:isLinkedTo rdf:resource="periplus://resource:21"/><wlr:hasDescription>Economistes, sans parti pris ideologique, nous soutenons Sarkozy. Nicolas Sarkozy nous semble le mieux capable de prendre l avenir a bras-le-cor</wlr:hasDescription><wlr:hasScore>0</wlr:hasScore><wlr:hasRank>6</wlr:hasRank><dc:identifier>test8.txt</dc:identifier><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/cluster:0"><wlr:hasNumberOfResults>2</wlr:hasNumberOfResults><wlr:hasDescription>Francois le grand gagnant</wlr:hasDescription><rdf:type rdf:resource="DocumentCluster"/><dc:title>Elections</dc:title></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/cluster:1"><wlr:hasNumberOfResults>2</wlr:hasNumberOfResults><wlr:hasDescription>Francois le grand gagnant</wlr:hasDescription><rdf:type rdf:resource="DocumentCluster"/><dc:title>Hollande gagnant</dc:title></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/cluster:2"><wlr:hasNumberOfResults>2</wlr:hasNumberOfResults><wlr:hasDescription>Francois le grand gagnant</wlr:hasDescription><rdf:type rdf:resource="DocumentCluster"/><dc:title>Un avenir ?</dc:title></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/cluster:3"><wlr:hasNumberOfResults>2</wlr:hasNumberOfResults><wlr:hasDescription>Francois le grand gagnant</wlr:hasDescription><rdf:type rdf:resource="DocumentCluster"/><dc:title>New !</dc:title></rdf:Description><rdf:Bag rdf:about="periplus://simquery/result/cluster:0"><rdf:li rdf:resource="periplus://simquery/result/hit:17"/><rdf:li rdf:resource="periplus://simquery/result/hit:4"/></rdf:Bag><rdf:Bag rdf:about="periplus://simquery/result/cluster:1"><rdf:li rdf:resource="periplus://simquery/result/hit:17"/><rdf:li rdf:resource="periplus://simquery/result/hit:4"/></rdf:Bag><rdf:Bag rdf:about="periplus://simquery/result/cluster:2"><rdf:li rdf:resource="periplus://simquery/result/hit:17"/><rdf:li rdf:resource="periplus://simquery/result/hit:4"/></rdf:Bag><rdf:Bag rdf:about="periplus://simquery/result/cluster:3"><rdf:li rdf:resource="periplus://simquery/result/hit:17"/><rdf:li rdf:resource="periplus://simquery/result/hit:4"/></rdf:Bag><rdf:Description rdf:about="periplus://simquery/result"><wlr:hasQueryOffset>0</wlr:hasQueryOffset><wlr:hasNumberOfResults>6</wlr:hasNumberOfResults><wlr:isResultOf rdf:resource="periplus://simquery"/><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/model#ResultSet"/><wlr:hasHit rdf:resource="periplus://simquery/result/hit:7"/><wlr:hasHit rdf:resource="periplus://simquery/result/hit:2"/><wlr:hasHit rdf:resource="periplus://simquery/result/hit:4"/><wlr:hasHit rdf:resource="periplus://simquery/result/hit:11"/><wlr:hasHit rdf:resource="periplus://simquery/result/hit:17"/><wlr:hasHit rdf:resource="periplus://simquery/result/hit:21"/></rdf:Description></rdf:RDF></data></annotation><resource uri="periplus://resource:7" xsi:type="model:Document"><annotation uri="periplus://resource:7/annot:0"><data><rdf:RDF xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://resource:7"><wlp:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/7</wlp:hasNativeContent></rdf:Description></rdf:RDF></data></annotation></resource><resource uri="periplus://resource:2" xsi:type="model:Document"><annotation uri="periplus://resource:2/annot:0"><data><rdf:RDF xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://resource:2"><wlp:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/2</wlp:hasNativeContent></rdf:Description></rdf:RDF></data></annotation></resource><resource uri="periplus://resource:4" xsi:type="model:Document"><annotation uri="periplus://resource:4/annot:0"><data><rdf:RDF xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://resource:4"><wlp:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/4</wlp:hasNativeContent></rdf:Description></rdf:RDF></data></annotation></resource><resource uri="periplus://resource:11" xsi:type="model:Document"><annotation uri="periplus://resource:11/annot:0"><data><rdf:RDF xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://resource:11"><wlp:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/11</wlp:hasNativeContent></rdf:Description></rdf:RDF></data></annotation></resource><resource uri="periplus://resource:17" xsi:type="model:Document"><annotation uri="periplus://resource:17/annot:0"><data><rdf:RDF xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://resource:17"><wlp:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/17</wlp:hasNativeContent></rdf:Description></rdf:RDF></data></annotation></resource><resource uri="periplus://resource:21" xsi:type="model:Document"><annotation uri="periplus://resource:21/annot:0"><data><rdf:RDF xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://resource:21"><wlp:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/21</wlp:hasNativeContent></rdf:Description></rdf:RDF></data></annotation></resource></resultSet></sear:searchReturn></soapenv:Body></soapenv:Envelope>'''
        #res = '<soapenv:Envelope xmlns:soapenv="http://schemas.xmlsoap.org/soap/envelope/"><soapenv:Body><sear:searchReturn xmlns:model="http://weblab.ow2.org/core/1.2/model#" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns:sear="http://weblab.ow2.org/core/1.2/services/searcher" xmlns:soapenv="http://schemas.xmlsoap.org/soap/envelope/"><resultSet uri="periplus://simquery/result" xmlns:model="http://weblab.ow2.org/core/1.2/model#" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"><annotation uri="periplus://simquery/result/annotation"><data><rdf:RDF xmlns:wlr="http://weblab.ow2.org/core/1.2/ontology/retrieval#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://simquery/result/hit:656"><wlr:inResultSetHit rdf:resource="periplus://simquery/result"/><wlr:isLinkedTo rdf:resource="periplus://resource:656"/><wlr:hasDescription>Bien sur, il n\'a rien fait comme prevu. Pour la remise du Prix Charle</wlr:hasDescription><wlr:hasScore>1</wlr:hasScore><wlr:hasRank>1</wlr:hasRank><dc:identifier>12844</dc:identifier><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/hit:1206"><wlr:inResultSetHit rdf:resource="periplus://simquery/result"/><wlr:isLinkedTo rdf:resource="periplus://resource:1206"/><wlr:hasDescription>Crises de nerfs a l\'Elysee. Depuis dix jours, Nicolas Sar</wlr:hasDescription><wlr:hasScore>1</wlr:hasScore><wlr:hasRank>2</wlr:hasRank><dc:identifier>17715</dc:identifier><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/hit:1209"><wlr:inResultSetHit rdf:resource="periplus://simquery/result"/><wlr:isLinkedTo rdf:resource="periplus://resource:1209"/><wlr:hasDescription>Crises de nerfs a l\'Elysee. Depuis dix jours, Nicolas Sar</wlr:hasDescription><wlr:hasScore>1</wlr:hasScore><wlr:hasRank>3</wlr:hasRank><dc:identifier>17752</dc:identifier><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/hit:1263"><wlr:inResultSetHit rdf:resource="periplus://simquery/result"/><wlr:isLinkedTo rdf:resource="periplus://resource:1263"/><wlr:hasDescription>Dessin de Damien Glez: Le president syrien Bachar al-Assad arrive a Paris pour assister, le 13 juillet, au sommet de l\'Union mediterraneenne. Mardi, dans un entretien au F</wlr:hasDescription><wlr:hasScore>1</wlr:hasScore><wlr:hasRank>4</wlr:hasRank><dc:identifier>18210</dc:identifier><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/hit:1329"><wlr:inResultSetHit rdf:resource="periplus://simquery/result"/><wlr:isLinkedTo rdf:resource="periplus://resource:1329"/><wlr:hasDescription>Pas besoin de longs discours, le choc des photos suffira. Voici les covers elyseennes d</wlr:hasDescription><wlr:hasScore>1</wlr:hasScore><wlr:hasRank>5</wlr:hasRank><dc:identifier>18759</dc:identifier><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/hit:1364"><wlr:inResultSetHit rdf:resource="periplus://simquery/result"/><wlr:isLinkedTo rdf:resource="periplus://resource:1364"/><wlr:hasDescription>Cliquer sur les liens pour afficher les articles: Le recit de cette journee et les commentaires audio a chaud des deputes et les reactions au vote de Jack Lang. En acces libre, Le parti pris</wlr:hasDescription><wlr:hasScore>1</wlr:hasScore><wlr:hasRank>6</wlr:hasRank><dc:identifier>18963</dc:identifier><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/hit:2150"><wlr:inResultSetHit rdf:resource="periplus://simquery/result"/><wlr:isLinkedTo rdf:resource="periplus://resource:2150"/><wlr:hasDescription>Pendant des mois, l\'hyperactivite, l\'arrogance et le style bling-bling du president francais ont enerve nos voisins europeens. La presse internationale crit</wlr:hasDescription><wlr:hasScore>1</wlr:hasScore><wlr:hasRank>7</wlr:hasRank><dc:identifier>26028</dc:identifier><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/hit:3051"><wlr:inResultSetHit rdf:resource="periplus://simquery/result"/><wlr:isLinkedTo rdf:resource="periplus://resource:3051"/><wlr:hasDescription>&quot;Traumatisant&quot;, &quot;choquant&quot;. Les mots de Violaine Roussel,</wlr:hasDescription><wlr:hasScore>1</wlr:hasScore><wlr:hasRank>8</wlr:hasRank><dc:identifier>34053</dc:identifier><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/hit:3229"><wlr:inResultSetHit rdf:resource="periplus://simquery/result"/><wlr:isLinkedTo rdf:resource="periplus://resource:3229"/><wlr:hasDescription>Aujourd\'hui au Mexique, Nicolas Sarkozy a voulu se saisir de ce dossier, qui a fait l\'objet d\'une debut de mobilisation sur le web, sur l\'impulsion d\'un site, cree par les parents de Florence Cassez. Depuis le Palais presidentiel</wlr:hasDescription><wlr:hasScore>1</wlr:hasScore><wlr:hasRank>9</wlr:hasRank><dc:identifier>36049</dc:identifier><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/hit:3525"><wlr:inResultSetHit rdf:resource="periplus://simquery/result"/><wlr:isLinkedTo rdf:resource="periplus://resource:3525"/><wlr:hasDescription>Le nouveau Sarkoshow a fait jaser la presse occidentale. Mercredi 16 avril, au cours d</wlr:hasDescription><wlr:hasScore>1</wlr:hasScore><wlr:hasRank>10</wlr:hasRank><dc:identifier>39028</dc:identifier><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/hit:3841"><wlr:inResultSetHit rdf:resource="periplus://simquery/result"/><wlr:isLinkedTo rdf:resource="periplus://resource:3841"/><wlr:hasDescription>Yvan Colonna poursuivait le president de la Republique, mercredi 3 juin, a Paris, pour atteinte a sa &quot;presomption d\'innocence&quot;. Le tribunal devra dire si Nic</wlr:hasDescription><wlr:hasScore>1</wlr:hasScore><wlr:hasRank>11</wlr:hasRank><dc:identifier>42028</dc:identifier><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/hit:4015"><wlr:inResultSetHit rdf:resource="periplus://simquery/result"/><wlr:isLinkedTo rdf:resource="periplus://resource:4015"/><wlr:hasDescription>L\'affaire n\'avait, jusque-la, jamais ete ebruitee. Le nom du president de la Rep</wlr:hasDescription><wlr:hasScore>1</wlr:hasScore><wlr:hasRank>12</wlr:hasRank><dc:identifier>43509</dc:identifier><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/hit:4238"><wlr:inResultSetHit rdf:resource="periplus://simquery/result"/><wlr:isLinkedTo rdf:resource="periplus://resource:4238"/><wlr:hasDescription>Avec la fin de l\'hospitalisation de Nicolas Sarkozy, sorti du Val-de-Grace lundi 27 juillet vers midi, une question titille: quelle lecon le chef de l\'Etat en tirera-t-il? Pour certains ministres, l\'affaire est entendue: cet incident, qui marque le &quot;surmenage&quot; du President de la Republique, doit l\'amener a lever le pied. L\'opposition, pour sa part, p</wlr:hasDescription><wlr:hasScore>1</wlr:hasScore><wlr:hasRank>13</wlr:hasRank><dc:identifier>45556</dc:identifier><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/hit:4548"><wlr:inResultSetHit rdf:resource="periplus://simquery/result"/><wlr:isLinkedTo rdf:resource="periplus://resource:4548"/><wlr:hasDescription>Le 19 octobre 2006, celui qui n\'etait encore que ministre de l\'interieur declarait solennellement au journal de 20 heures de TF1: &quot;J\'ai ete accuse pendant dix-neuf mois par la justice de mon pays, sur la base du mensonge d\'un corbeau qui s\'etait allie avec un juge, d\'avoir un compte a l\'etranger.&quot; Pourtant, aux yeux de plusie</wlr:hasDescription><wlr:hasScore>1</wlr:hasScore><wlr:hasRank>14</wlr:hasRank><dc:identifier>56842</dc:identifier><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/hit:4722"><wlr:inResultSetHit rdf:resource="periplus://simquery/result"/><wlr:isLinkedTo rdf:resource="periplus://resource:4722"/><wlr:hasDescription>Dans un livre a paraitre (Justice, le ministere infernal, par Mathieu Delahousse, Flammarion), un court passage eclaire les coulisses du dossier Clearstream tel qu\'il est gere par la Presidence de la Republique. &quot;Le President veut en avoir l</wlr:hasDescription><wlr:hasScore>1</wlr:hasScore><wlr:hasRank>15</wlr:hasRank><dc:identifier>64587</dc:identifier><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/hit:4741"><wlr:inResultSetHit rdf:resource="periplus://simquery/result"/><wlr:isLinkedTo rdf:resource="periplus://resource:4741"/><wlr:hasDescription>La replique est anthologique. Mardi matin, Nicolas Sarkozy </wlr:hasDescription><wlr:hasScore>1</wlr:hasScore><wlr:hasRank>16</wlr:hasRank><dc:identifier>65797</dc:identifier><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/hit:4763"><wlr:inResultSetHit rdf:resource="periplus://simquery/result"/><wlr:isLinkedTo rdf:resource="periplus://resource:4763"/><wlr:hasDescription>Nicolas Sarkozy a surpris son monde, jeudi 15 octobre, en se rendant a Gandrange (Moselle). En visite le 4 fevrier 2008, </wlr:hasDescription><wlr:hasScore>1</wlr:hasScore><wlr:hasRank>17</wlr:hasRank><dc:identifier>66452</dc:identifier><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/hit:4767"><wlr:inResultSetHit rdf:resource="periplus://simquery/result"/><wlr:isLinkedTo rdf:resource="periplus://resource:4767"/><wlr:hasDescription>Petitions, videos loufoques, parodies, manifestations, sit-in, etc. Depuis l\'annonce de sa candid</wlr:hasDescription><wlr:hasScore>1</wlr:hasScore><wlr:hasRank>18</wlr:hasRank><dc:identifier>66528</dc:identifier><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/hit:5483"><wlr:inResultSetHit rdf:resource="periplus://simquery/result"/><wlr:isLinkedTo rdf:resource="periplus://resource:5483"/><wlr:hasDescription>Trois mois apres le proces, la justice doit rendre sa decision dans l\'affaire Clearstream jeudi 28 janvier. Ironie du sort, c\'est precise</wlr:hasDescription><wlr:hasScore>1</wlr:hasScore><wlr:hasRank>19</wlr:hasRank><dc:identifier>73799</dc:identifier><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/hit:5874"><wlr:inResultSetHit rdf:resource="periplus://simquery/result"/><wlr:isLinkedTo rdf:resource="periplus://resource:5874"/><wlr:hasDescription>Voici trois chronologies rassemblant quelque 350 dates qui retracent la premiere partie du mandat de Nicolas Sarkozy. Realisees par la redaction de</wlr:hasDescription><wlr:hasScore>1</wlr:hasScore><wlr:hasRank>20</wlr:hasRank><dc:identifier>78735</dc:identifier><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/cluster:0"><wlr:hasNumberOfResults>1</wlr:hasNumberOfResults><wlr:isLinkedTo rdf:resource="periplus://cluster:0"/><wlr:hasScore>0</wlr:hasScore><wlr:hasDescription>Mon cluster 0</wlr:hasDescription><dc:title>Cluster 0</dc:title><rdf:type rdf:resource="DocumentCluster"/></rdf:Description><rdf:Bag rdf:about="periplus://simquery/result/cluster:0"><rdf:li rdf:resource="periplus://simquery/result/hit:656"/></rdf:Bag><rdf:Description rdf:about="periplus://simquery/result/cluster:1"><wlr:hasNumberOfResults>1</wlr:hasNumberOfResults><wlr:isLinkedTo rdf:resource="periplus://cluster:1"/><wlr:hasScore>0</wlr:hasScore><wlr:hasDescription>Mon cluster 1</wlr:hasDescription><dc:title>HAHA le Cluster 1</dc:title><rdf:type rdf:resource="DocumentCluster"/></rdf:Description><rdf:Bag rdf:about="periplus://simquery/result/cluster:1"><rdf:li rdf:resource="periplus://simquery/result/hit:1206"/></rdf:Bag><rdf:Description rdf:about="periplus://simquery/result/cluster:2"><wlr:hasNumberOfResults>1</wlr:hasNumberOfResults><wlr:isLinkedTo rdf:resource="periplus://cluster:2"/><wlr:hasScore>0</wlr:hasScore><wlr:hasDescription>HOUHOU Mon cluster 3</wlr:hasDescription><dc:title>Cluster 3</dc:title><rdf:type rdf:resource="DocumentCluster"/></rdf:Description><rdf:Bag rdf:about="periplus://simquery/result/cluster:2"><rdf:li rdf:resource="periplus://simquery/result/hit:1209"/></rdf:Bag><rdf:Description rdf:about="periplus://simquery/result/cluster:3"><wlr:hasNumberOfResults>1</wlr:hasNumberOfResults><wlr:isLinkedTo rdf:resource="periplus://cluster:3"/><wlr:hasScore>0</wlr:hasScore><wlr:hasDescription>Coucou Sarko</wlr:hasDescription><dc:title>Sarko</dc:title><rdf:type rdf:resource="DocumentCluster"/></rdf:Description><rdf:Bag rdf:about="periplus://simquery/result/cluster:3"><rdf:li rdf:resource="periplus://simquery/result/hit:1263"/></rdf:Bag><rdf:Description rdf:about="periplus://simquery/result/cluster:4"><wlr:hasNumberOfResults>1</wlr:hasNumberOfResults><wlr:isLinkedTo rdf:resource="periplus://cluster:4"/><wlr:hasScore>0</wlr:hasScore><wlr:hasDescription>Ha Hollande</wlr:hasDescription><dc:title>Hollande gagnant</dc:title><rdf:type rdf:resource="DocumentCluster"/></rdf:Description><rdf:Bag rdf:about="periplus://simquery/result/cluster:4"><rdf:li rdf:resource="periplus://simquery/result/hit:1329"/></rdf:Bag><rdf:Description rdf:about="periplus://simquery/result/cluster:5"><wlr:hasNumberOfResults>1</wlr:hasNumberOfResults><wlr:isLinkedTo rdf:resource="periplus://cluster:5"/><wlr:hasScore>0</wlr:hasScore><wlr:hasDescription>No summary available</wlr:hasDescription><dc:title>No title available</dc:title><rdf:type rdf:resource="DocumentCluster"/></rdf:Description><rdf:Bag rdf:about="periplus://simquery/result/cluster:5"><rdf:li rdf:resource="periplus://simquery/result/hit:1364"/></rdf:Bag><rdf:Description rdf:about="periplus://simquery/result/cluster:6"><wlr:hasNumberOfResults>1</wlr:hasNumberOfResults><wlr:isLinkedTo rdf:resource="periplus://cluster:6"/><wlr:hasScore>0</wlr:hasScore><wlr:hasDescription>No summary available</wlr:hasDescription><dc:title>No title available</dc:title><rdf:type rdf:resource="DocumentCluster"/></rdf:Description><rdf:Bag rdf:about="periplus://simquery/result/cluster:6"><rdf:li rdf:resource="periplus://simquery/result/hit:2150"/></rdf:Bag><rdf:Description rdf:about="periplus://simquery/result/cluster:7"><wlr:hasNumberOfResults>1</wlr:hasNumberOfResults><wlr:isLinkedTo rdf:resource="periplus://cluster:7"/><wlr:hasScore>0</wlr:hasScore><wlr:hasDescription>No summary available</wlr:hasDescription><dc:title>No title available</dc:title><rdf:type rdf:resource="DocumentCluster"/></rdf:Description><rdf:Bag rdf:about="periplus://simquery/result/cluster:7"><rdf:li rdf:resource="periplus://simquery/result/hit:3051"/></rdf:Bag><rdf:Description rdf:about="periplus://simquery/result/cluster:8"><wlr:hasNumberOfResults>1</wlr:hasNumberOfResults><wlr:isLinkedTo rdf:resource="periplus://cluster:8"/><wlr:hasScore>0</wlr:hasScore><wlr:hasDescription>No summary available</wlr:hasDescription><dc:title>No title available</dc:title><rdf:type rdf:resource="DocumentCluster"/></rdf:Description><rdf:Bag rdf:about="periplus://simquery/result/cluster:8"><rdf:li rdf:resource="periplus://simquery/result/hit:3229"/></rdf:Bag><rdf:Description rdf:about="periplus://simquery/result/cluster:9"><wlr:hasNumberOfResults>1</wlr:hasNumberOfResults><wlr:isLinkedTo rdf:resource="periplus://cluster:9"/><wlr:hasScore>0</wlr:hasScore><wlr:hasDescription>No summary available</wlr:hasDescription><dc:title>No title available</dc:title><rdf:type rdf:resource="DocumentCluster"/></rdf:Description><rdf:Bag rdf:about="periplus://simquery/result/cluster:9"><rdf:li rdf:resource="periplus://simquery/result/hit:3525"/></rdf:Bag><rdf:Description rdf:about="periplus://simquery/result/cluster:10"><wlr:hasNumberOfResults>1</wlr:hasNumberOfResults><wlr:isLinkedTo rdf:resource="periplus://cluster:10"/><wlr:hasScore>0</wlr:hasScore><wlr:hasDescription>No summary available</wlr:hasDescription><dc:title>No title available</dc:title><rdf:type rdf:resource="DocumentCluster"/></rdf:Description><rdf:Bag rdf:about="periplus://simquery/result/cluster:10"><rdf:li rdf:resource="periplus://simquery/result/hit:3841"/></rdf:Bag><rdf:Description rdf:about="periplus://simquery/result/cluster:11"><wlr:hasNumberOfResults>1</wlr:hasNumberOfResults><wlr:isLinkedTo rdf:resource="periplus://cluster:11"/><wlr:hasScore>0</wlr:hasScore><wlr:hasDescription>No summary available</wlr:hasDescription><dc:title>No title available</dc:title><rdf:type rdf:resource="DocumentCluster"/></rdf:Description><rdf:Bag rdf:about="periplus://simquery/result/cluster:11"><rdf:li rdf:resource="periplus://simquery/result/hit:4015"/></rdf:Bag><rdf:Description rdf:about="periplus://simquery/result/cluster:12"><wlr:hasNumberOfResults>1</wlr:hasNumberOfResults><wlr:isLinkedTo rdf:resource="periplus://cluster:12"/><wlr:hasScore>0</wlr:hasScore><wlr:hasDescription>No summary available</wlr:hasDescription><dc:title>No title available</dc:title><rdf:type rdf:resource="DocumentCluster"/></rdf:Description><rdf:Bag rdf:about="periplus://simquery/result/cluster:12"><rdf:li rdf:resource="periplus://simquery/result/hit:4238"/></rdf:Bag><rdf:Description rdf:about="periplus://simquery/result/cluster:13"><wlr:hasNumberOfResults>1</wlr:hasNumberOfResults><wlr:isLinkedTo rdf:resource="periplus://cluster:13"/><wlr:hasScore>0</wlr:hasScore><wlr:hasDescription>No summary available</wlr:hasDescription><dc:title>No title available</dc:title><rdf:type rdf:resource="DocumentCluster"/></rdf:Description><rdf:Bag rdf:about="periplus://simquery/result/cluster:13"><rdf:li rdf:resource="periplus://simquery/result/hit:4548"/></rdf:Bag><rdf:Description rdf:about="periplus://simquery/result/cluster:14"><wlr:hasNumberOfResults>1</wlr:hasNumberOfResults><wlr:isLinkedTo rdf:resource="periplus://cluster:14"/><wlr:hasScore>0</wlr:hasScore><wlr:hasDescription>No summary available</wlr:hasDescription><dc:title>No title available</dc:title><rdf:type rdf:resource="DocumentCluster"/></rdf:Description><rdf:Bag rdf:about="periplus://simquery/result/cluster:14"><rdf:li rdf:resource="periplus://simquery/result/hit:4722"/></rdf:Bag><rdf:Description rdf:about="periplus://simquery/result/cluster:15"><wlr:hasNumberOfResults>1</wlr:hasNumberOfResults><wlr:isLinkedTo rdf:resource="periplus://cluster:15"/><wlr:hasScore>0</wlr:hasScore><wlr:hasDescription>No summary available</wlr:hasDescription><dc:title>No title available</dc:title><rdf:type rdf:resource="DocumentCluster"/></rdf:Description><rdf:Bag rdf:about="periplus://simquery/result/cluster:15"><rdf:li rdf:resource="periplus://simquery/result/hit:4741"/></rdf:Bag><rdf:Description rdf:about="periplus://simquery/result/cluster:16"><wlr:hasNumberOfResults>1</wlr:hasNumberOfResults><wlr:isLinkedTo rdf:resource="periplus://cluster:16"/><wlr:hasScore>0</wlr:hasScore><wlr:hasDescription>No summary available</wlr:hasDescription><dc:title>No title available</dc:title><rdf:type rdf:resource="DocumentCluster"/></rdf:Description><rdf:Bag rdf:about="periplus://simquery/result/cluster:16"><rdf:li rdf:resource="periplus://simquery/result/hit:4763"/></rdf:Bag><rdf:Description rdf:about="periplus://simquery/result/cluster:17"><wlr:hasNumberOfResults>1</wlr:hasNumberOfResults><wlr:isLinkedTo rdf:resource="periplus://cluster:17"/><wlr:hasScore>0</wlr:hasScore><wlr:hasDescription>No summary available</wlr:hasDescription><dc:title>No title available</dc:title><rdf:type rdf:resource="DocumentCluster"/></rdf:Description><rdf:Bag rdf:about="periplus://simquery/result/cluster:17"><rdf:li rdf:resource="periplus://simquery/result/hit:4767"/></rdf:Bag><rdf:Description rdf:about="periplus://simquery/result/cluster:18"><wlr:hasNumberOfResults>1</wlr:hasNumberOfResults><wlr:isLinkedTo rdf:resource="periplus://cluster:18"/><wlr:hasScore>0</wlr:hasScore><wlr:hasDescription>No summary available</wlr:hasDescription><dc:title>No title available</dc:title><rdf:type rdf:resource="DocumentCluster"/></rdf:Description><rdf:Bag rdf:about="periplus://simquery/result/cluster:18"><rdf:li rdf:resource="periplus://simquery/result/hit:5483"/></rdf:Bag><rdf:Description rdf:about="periplus://simquery/result/cluster:19"><wlr:hasNumberOfResults>1</wlr:hasNumberOfResults><wlr:isLinkedTo rdf:resource="periplus://cluster:19"/><wlr:hasScore>0</wlr:hasScore><wlr:hasDescription>No summary available</wlr:hasDescription><dc:title>No title available</dc:title><rdf:type rdf:resource="DocumentCluster"/></rdf:Description><rdf:Bag rdf:about="periplus://simquery/result/cluster:19"><rdf:li rdf:resource="periplus://simquery/result/hit:5874"/></rdf:Bag><rdf:Description rdf:about="periplus://simquery/result"><wlr:hasQueryOffset>0</wlr:hasQueryOffset><wlr:hasNumberOfResults>20</wlr:hasNumberOfResults><wlr:isResultOf rdf:resource="periplus://simquery"/><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/model#ResultSet"/><wlr:hasHit rdf:resource="periplus://simquery/result/hit:656"/><wlr:hasHit rdf:resource="periplus://simquery/result/hit:1206"/><wlr:hasHit rdf:resource="periplus://simquery/result/hit:1209"/><wlr:hasHit rdf:resource="periplus://simquery/result/hit:1263"/><wlr:hasHit rdf:resource="periplus://simquery/result/hit:1329"/><wlr:hasHit rdf:resource="periplus://simquery/result/hit:1364"/><wlr:hasHit rdf:resource="periplus://simquery/result/hit:2150"/><wlr:hasHit rdf:resource="periplus://simquery/result/hit:3051"/><wlr:hasHit rdf:resource="periplus://simquery/result/hit:3229"/><wlr:hasHit rdf:resource="periplus://simquery/result/hit:3525"/><wlr:hasHit rdf:resource="periplus://simquery/result/hit:3841"/><wlr:hasHit rdf:resource="periplus://simquery/result/hit:4015"/><wlr:hasHit rdf:resource="periplus://simquery/result/hit:4238"/><wlr:hasHit rdf:resource="periplus://simquery/result/hit:4548"/><wlr:hasHit rdf:resource="periplus://simquery/result/hit:4722"/><wlr:hasHit rdf:resource="periplus://simquery/result/hit:4741"/><wlr:hasHit rdf:resource="periplus://simquery/result/hit:4763"/><wlr:hasHit rdf:resource="periplus://simquery/result/hit:4767"/><wlr:hasHit rdf:resource="periplus://simquery/result/hit:5483"/><wlr:hasHit rdf:resource="periplus://simquery/result/hit:5874"/></rdf:Description></rdf:RDF></data></annotation><resource uri="periplus://resource:656" xsi:type="model:Document"><annotation uri="periplus://resource:656/annot:0"><data><rdf:RDF xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://resource:656"><wlp:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/656</wlp:hasNativeContent></rdf:Description></rdf:RDF></data></annotation></resource><resource uri="periplus://resource:1206" xsi:type="model:Document"><annotation uri="periplus://resource:1206/annot:0"><data><rdf:RDF xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://resource:1206"><wlp:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/1206</wlp:hasNativeContent></rdf:Description></rdf:RDF></data></annotation></resource><resource uri="periplus://resource:1209" xsi:type="model:Document"><annotation uri="periplus://resource:1209/annot:0"><data><rdf:RDF xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://resource:1209"><wlp:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/1209</wlp:hasNativeContent></rdf:Description></rdf:RDF></data></annotation></resource><resource uri="periplus://resource:1263" xsi:type="model:Document"><annotation uri="periplus://resource:1263/annot:0"><data><rdf:RDF xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://resource:1263"><wlp:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/1263</wlp:hasNativeContent></rdf:Description></rdf:RDF></data></annotation></resource><resource uri="periplus://resource:1329" xsi:type="model:Document"><annotation uri="periplus://resource:1329/annot:0"><data><rdf:RDF xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://resource:1329"><wlp:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/1329</wlp:hasNativeContent></rdf:Description></rdf:RDF></data></annotation></resource><resource uri="periplus://resource:1364" xsi:type="model:Document"><annotation uri="periplus://resource:1364/annot:0"><data><rdf:RDF xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://resource:1364"><wlp:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/1364</wlp:hasNativeContent></rdf:Description></rdf:RDF></data></annotation></resource><resource uri="periplus://resource:2150" xsi:type="model:Document"><annotation uri="periplus://resource:2150/annot:0"><data><rdf:RDF xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://resource:2150"><wlp:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/2150</wlp:hasNativeContent></rdf:Description></rdf:RDF></data></annotation></resource><resource uri="periplus://resource:3051" xsi:type="model:Document"><annotation uri="periplus://resource:3051/annot:0"><data><rdf:RDF xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://resource:3051"><wlp:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/3051</wlp:hasNativeContent></rdf:Description></rdf:RDF></data></annotation></resource><resource uri="periplus://resource:3229" xsi:type="model:Document"><annotation uri="periplus://resource:3229/annot:0"><data><rdf:RDF xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://resource:3229"><wlp:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/3229</wlp:hasNativeContent></rdf:Description></rdf:RDF></data></annotation></resource><resource uri="periplus://resource:3525" xsi:type="model:Document"><annotation uri="periplus://resource:3525/annot:0"><data><rdf:RDF xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://resource:3525"><wlp:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/3525</wlp:hasNativeContent></rdf:Description></rdf:RDF></data></annotation></resource><resource uri="periplus://resource:3841" xsi:type="model:Document"><annotation uri="periplus://resource:3841/annot:0"><data><rdf:RDF xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://resource:3841"><wlp:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/3841</wlp:hasNativeContent></rdf:Description></rdf:RDF></data></annotation></resource><resource uri="periplus://resource:4015" xsi:type="model:Document"><annotation uri="periplus://resource:4015/annot:0"><data><rdf:RDF xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://resource:4015"><wlp:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/4015</wlp:hasNativeContent></rdf:Description></rdf:RDF></data></annotation></resource><resource uri="periplus://resource:4238" xsi:type="model:Document"><annotation uri="periplus://resource:4238/annot:0"><data><rdf:RDF xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://resource:4238"><wlp:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/4238</wlp:hasNativeContent></rdf:Description></rdf:RDF></data></annotation></resource><resource uri="periplus://resource:4548" xsi:type="model:Document"><annotation uri="periplus://resource:4548/annot:0"><data><rdf:RDF xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://resource:4548"><wlp:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/4548</wlp:hasNativeContent></rdf:Description></rdf:RDF></data></annotation></resource><resource uri="periplus://resource:4722" xsi:type="model:Document"><annotation uri="periplus://resource:4722/annot:0"><data><rdf:RDF xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://resource:4722"><wlp:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/4722</wlp:hasNativeContent></rdf:Description></rdf:RDF></data></annotation></resource><resource uri="periplus://resource:4741" xsi:type="model:Document"><annotation uri="periplus://resource:4741/annot:0"><data><rdf:RDF xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://resource:4741"><wlp:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/4741</wlp:hasNativeContent></rdf:Description></rdf:RDF></data></annotation></resource><resource uri="periplus://resource:4763" xsi:type="model:Document"><annotation uri="periplus://resource:4763/annot:0"><data><rdf:RDF xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://resource:4763"><wlp:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/4763</wlp:hasNativeContent></rdf:Description></rdf:RDF></data></annotation></resource><resource uri="periplus://resource:4767" xsi:type="model:Document"><annotation uri="periplus://resource:4767/annot:0"><data><rdf:RDF xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://resource:4767"><wlp:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/4767</wlp:hasNativeContent></rdf:Description></rdf:RDF></data></annotation></resource><resource uri="periplus://resource:5483" xsi:type="model:Document"><annotation uri="periplus://resource:5483/annot:0"><data><rdf:RDF xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://resource:5483"><wlp:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/5483</wlp:hasNativeContent></rdf:Description></rdf:RDF></data></annotation></resource><resource uri="periplus://resource:5874" xsi:type="model:Document"><annotation uri="periplus://resource:5874/annot:0"><data><rdf:RDF xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://resource:5874"><wlp:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/5874</wlp:hasNativeContent></rdf:Description></rdf:RDF></data></annotation></resource></resultSet></sear:searchReturn></soapenv:Body></soapenv:Envelope>'
        res = '<soapenv:Envelope xmlns:soapenv="http://schemas.xmlsoap.org/soap/envelope/"><soapenv:Body><sear:searchReturn xmlns:model="http://weblab.ow2.org/core/1.2/model#" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns:sear="http://weblab.ow2.org/core/1.2/services/searcher" xmlns:soapenv="http://schemas.xmlsoap.org/soap/envelope/"><resultSet uri="periplus://simquery/result" xmlns:model="http://weblab.ow2.org/core/1.2/model#" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"><annotation uri="periplus://simquery/result/annotation"><data><rdf:RDF xmlns:wlr="http://weblab.ow2.org/core/1.2/ontology/retrieval#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://simquery/result/hit:3883"><wlr:inResultSetHit rdf:resource="periplus://simquery/result"/><wlr:isLinkedTo rdf:resource="periplus://resource:3883"/><wlr:hasDescription>Proche de Ségolène Royal, François Rebsamen a un temps envisagé de faire le trait-d\'union avec les amis de François Hollande pour renverser Martine Aubry de la direction du PS. Rentré dans le rang, il n\'en </wlr:hasDescription><wlr:hasScore>1</wlr:hasScore><wlr:hasRank>1</wlr:hasRank><dc:identifier>42360</dc:identifier><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/hit:3256"><wlr:inResultSetHit rdf:resource="periplus://simquery/result"/><wlr:isLinkedTo rdf:resource="periplus://resource:3256"/><wlr:hasDescription>Du 16 au 22 mars, les quelque 70.000 adhérents franciliens (rev</wlr:hasDescription><mediaUnit xsi:type="model:Image"><wlr:hasNativeContent>http://static.mediapart.fr/files/imagecache/300_pixels/Marine%20Turchi/3253562677_526473474b_m.jpg</wlr:hasNativeContent></mediaUnit><mediaUnit xsi:type="model:Image"><wlr:hasNativeContent>http://static.mediapart.fr/files/imagecache/475_pixels/La%20r%C3%A9daction%20Mediapart/paille.png</wlr:hasNativeContent></mediaUnit><wlr:hasScore>0.970595</wlr:hasScore><wlr:hasRank>2</wlr:hasRank><dc:identifier>36313</dc:identifier><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/hit:3328"><wlr:inResultSetHit rdf:resource="periplus://simquery/result"/><wlr:isLinkedTo rdf:resource="periplus://resource:3328"/><wlr:hasDescription>Sans surprise, Valérie Pécresse l\'a largement emporté, dimanche 22 mars, sur son collègue Roger Karoutchi lors de la primaire organisée chez les militants UMP de l\'Ile-de-France. Entre le 16 et le 22 mars, 48</wlr:hasDescription><mediaUnit xsi:type="model:Image"><wlr:hasNativeContent>http://static.mediapart.fr/files/imagecache/300_pixels/Marine%20Turchi/3253562677_526473474b_m.jpg</wlr:hasNativeContent></mediaUnit><mediaUnit xsi:type="model:Image"><wlr:hasNativeContent>http://static.mediapart.fr/files/imagecache/475_pixels/La%20r%C3%A9daction%20Mediapart/paille.png</wlr:hasNativeContent></mediaUnit><wlr:hasScore>0.970595</wlr:hasScore><wlr:hasRank>3</wlr:hasRank><dc:identifier>37060</dc:identifier><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/hit:3844"><wlr:inResultSetHit rdf:resource="periplus://simquery/result"/><wlr:isLinkedTo rdf:resource="periplus://resource:3844"/><wlr:hasDescription>Du changement de statut de La Poste, il n\'a été que peu question durant la campagne des élections européennes, comme si la réforme avait pris du retard ou n\'était plus d\'actualité. Et pourtant, il n\'en est rien</wlr:hasDescription><mediaUnit xsi:type="model:Image"><wlr:hasNativeContent>http://static.mediapart.fr/files/Laurent Mauduit/Image 8_13.png</wlr:hasNativeContent></mediaUnit><mediaUnit xsi:type="model:Image"><wlr:hasNativeContent>http://static.mediapart.fr/files/imagecache/475_pixels/La%20r%C3%A9daction%20Mediapart/paille.png</wlr:hasNativeContent></mediaUnit><wlr:hasScore>0.961693</wlr:hasScore><wlr:hasRank>4</wlr:hasRank><dc:identifier>42059</dc:identifier><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/hit:271"><wlr:inResultSetHit rdf:resource="periplus://simquery/result"/><wlr:isLinkedTo rdf:resource="periplus://resource:271"/><wlr:hasDescription>Jeudi 27 mars, dans la soirée, Nicolas Sarkozy a finalement promis que l\'Assemblée nationale pourrait débattre de sa décision toute fraîche d\'envoyer des soldats supplémentaires en Afghanistan (probablement un millier). Notifiée la veille outre-manc</wlr:hasDescription><wlr:hasScore>0.95304</wlr:hasScore><wlr:hasRank>5</wlr:hasRank><dc:identifier>5581</dc:identifier><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/hit:1732"><wlr:inResultSetHit rdf:resource="periplus://simquery/result"/><wlr:isLinkedTo rdf:resource="periplus://resource:1732"/><wlr:hasDescription>(Si la fin de cette page s\'affiche mal, rafraîchissez votre écran- touche F5) A l\'époque, l\'Unita avait contesté par les armes le résultat favorable au MPLA, replongeant le pays dans la guerre. Le combat des deux ex-compagn</wlr:hasDescription><mediaUnit xsi:type="model:Image"><wlr:hasNativeContent>http://static.mediapart.fr/files/imagecache/475_pixels/Fran%C3%A7ois%20Bonnet/ango.jpg</wlr:hasNativeContent></mediaUnit><mediaUnit xsi:type="model:Image"><wlr:hasNativeContent>http://static.mediapart.fr/files/imagecache/475_pixels/La%20r%C3%A9daction%20Mediapart/paille.png</wlr:hasNativeContent></mediaUnit><wlr:hasScore>0.944239</wlr:hasScore><wlr:hasRank>6</wlr:hasRank><dc:identifier>22545</dc:identifier><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/hit:5803"><wlr:inResultSetHit rdf:resource="periplus://simquery/result"/><wlr:isLinkedTo rdf:resource="periplus://resource:5803"/><wlr:hasDescription>Lot de consolation pour la droite : La Guyane basculerait. Selon des chiffres encore pro</wlr:hasDescription><mediaUnit xsi:type="model:Image"><wlr:hasNativeContent>http://static.mediapart.fr/files/imagecache/300_pixels/La%20r%C3%A9daction%20Mediapart/rejet.png</wlr:hasNativeContent></mediaUnit><mediaUnit xsi:type="model:Image"><wlr:hasNativeContent>http://static.mediapart.fr/files/imagecache/475_pixels/La%20r%C3%A9daction%20Mediapart/paille.png</wlr:hasNativeContent></mediaUnit><wlr:hasScore>0.939834</wlr:hasScore><wlr:hasRank>7</wlr:hasRank><dc:identifier>78083</dc:identifier><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/hit:1744"><wlr:inResultSetHit rdf:resource="periplus://simquery/result"/><wlr:isLinkedTo rdf:resource="periplus://resource:1744"/><wlr:hasDescription>Une bombe dort au pôle financier du tribunal de grande instance de Paris. Les juges Françoise Desset et</wlr:hasDescription><mediaUnit xsi:type="model:Image"><wlr:hasNativeContent>http://static.mediapart.fr/files/imagecache/475_pixels/Fabrice%20Arfi/bpc140dcn.jpg</wlr:hasNativeContent></mediaUnit><mediaUnit xsi:type="model:Image"><wlr:hasNativeContent>http://static.mediapart.fr/files/imagecache/475_pixels/La%20r%C3%A9daction%20Mediapart/paille.png</wlr:hasNativeContent></mediaUnit><wlr:hasScore>0.936393</wlr:hasScore><wlr:hasRank>8</wlr:hasRank><dc:identifier>22631</dc:identifier><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/hit:1745"><wlr:inResultSetHit rdf:resource="periplus://simquery/result"/><wlr:isLinkedTo rdf:resource="periplus://resource:1745"/><wlr:hasDescription>Une bombe dort au pôle financier du tribunal de Paris. Les juges Françoise Desset et</wlr:hasDescription><mediaUnit xsi:type="model:Image"><wlr:hasNativeContent>http://static.mediapart.fr/files/imagecache/225_pixels/Fabrice%20Arfi/sarko_0.png</wlr:hasNativeContent></mediaUnit><mediaUnit xsi:type="model:Image"><wlr:hasNativeContent>http://static.mediapart.fr/files/imagecache/475_pixels/La%20r%C3%A9daction%20Mediapart/paille.png</wlr:hasNativeContent></mediaUnit><wlr:hasScore>0.935581</wlr:hasScore><wlr:hasRank>9</wlr:hasRank><dc:identifier>22632</dc:identifier><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/hit:96"><wlr:inResultSetHit rdf:resource="periplus://simquery/result"/><wlr:isLinkedTo rdf:resource="periplus://resource:96"/><wlr:hasDescription>C\'était le 18 mars 2001. Au soir du second tour des él</wlr:hasDescription><wlr:hasScore>0.930653</wlr:hasScore><wlr:hasRank>10</wlr:hasRank><dc:identifier>423</dc:identifier><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/hit:4210"><wlr:inResultSetHit rdf:resource="periplus://simquery/result"/><wlr:isLinkedTo rdf:resource="periplus://resource:4210"/><wlr:hasDescription>L\'échange épistolaire entre Martine Aubry et Manuel Valls a ouvert la compétition des égos au PS. Mais la présidente de la régi</wlr:hasDescription><wlr:hasScore>0.930653</wlr:hasScore><wlr:hasRank>11</wlr:hasRank><dc:identifier>45247</dc:identifier><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/hit:3972"><wlr:inResultSetHit rdf:resource="periplus://simquery/result"/><wlr:isLinkedTo rdf:resource="periplus://resource:3972"/><wlr:hasDescription>L\'affaire de Karachi qui préoccupe au plus haut sommet de l\'Etat est apparue au détour d\'une enquête purement financière, qui recèle potentiellement en elle-même d\'autres scandales d\'Etat, largement évoqués par Mediapart voilà déjà neuf mois. Les juges du pôle financier p</wlr:hasDescription><wlr:hasScore>0.930406</wlr:hasScore><wlr:hasRank>12</wlr:hasRank><dc:identifier>43103</dc:identifier><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/hit:3973"><wlr:inResultSetHit rdf:resource="periplus://simquery/result"/><wlr:isLinkedTo rdf:resource="periplus://resource:3973"/><wlr:hasDescription>L\'affaire de Karachi qui préoccupe au plus haut sommet de l\'Etat est apparue au détour d\'une enquête purement financière, qui recèle potentiellement en elle-même d\'autres scandales d\'Etat, largement évoqués par Mediapart voilà déjà neuf mois. Les juges du pôle financier p</wlr:hasDescription><wlr:hasScore>0.930406</wlr:hasScore><wlr:hasRank>13</wlr:hasRank><dc:identifier>43104</dc:identifier><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/hit:2475"><wlr:inResultSetHit rdf:resource="periplus://simquery/result"/><wlr:isLinkedTo rdf:resource="periplus://resource:2475"/><wlr:hasDescription>Mardi 2 décembre, dans un sous-sol de l\'Assemblée nationale, Martine Aubry a délivré une feuille de route toute fraîche aux députés socialistes. &quot;On redémarre, on est en marc</wlr:hasDescription><wlr:hasScore>0.928015</wlr:hasScore><wlr:hasRank>14</wlr:hasRank><dc:identifier>28930</dc:identifier><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/hit:3789"><wlr:inResultSetHit rdf:resource="periplus://simquery/result"/><wlr:isLinkedTo rdf:resource="periplus://resource:3789"/><wlr:hasDescription>&quot;Dans une telle campagne où les petites phrases et les effets médiatiques semblent plus compter que le fond, de belles images au 20 heures ne peuvent pas faire de mal.&quot; Ce commentaire d\'un dirigean</wlr:hasDescription><mediaUnit xsi:type="model:Image"><wlr:hasNativeContent>http://static.mediapart.fr/files/imagecache/300_pixels/St%C3%A9phane%20Alli%C3%A8s/Image%205_5.png</wlr:hasNativeContent></mediaUnit><mediaUnit xsi:type="model:Image"><wlr:hasNativeContent>http://static.mediapart.fr/files/imagecache/475_pixels/La%20r%C3%A9daction%20Mediapart/paille.png</wlr:hasNativeContent></mediaUnit><wlr:hasScore>0.928015</wlr:hasScore><wlr:hasRank>15</wlr:hasRank><dc:identifier>41525</dc:identifier><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/hit:5767"><wlr:inResultSetHit rdf:resource="periplus://simquery/result"/>  <wlr:isLinkedTo rdf:resource="periplus://resource:5767"/><wlr:hasDescription>Elle n\'est pas encore la plus chouette du monde, mais la gauche française a au moins évité d\'être la plus bête, au moment de discuter unité avant le second tour des régionales. Mardi à 18h, dix-huit listes </wlr:hasDescription><wlr:hasScore>0.927953</wlr:hasScore><wlr:hasRank>16</wlr:hasRank><dc:identifier>77730</dc:identifier><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/hit:1036"><wlr:inResultSetHit rdf:resource="periplus://simquery/result"/><wlr:isLinkedTo rdf:resource="periplus://resource:1036"/><wlr:hasDescription>N\'en doutons pas, la semaine sociale sera à la contestation tous azimuts et, si le sujet n\'était pas grave et sérieux, un esprit malicieux pourrait voir dans ce tintamarre une nouvelle expression des contradictions françaises. A nouveau se pose le problème</wlr:hasDescription><wlr:hasScore>0.926465</wlr:hasScore><wlr:hasRank>17</wlr:hasRank><dc:identifier>16313</dc:identifier><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/hit:133"><wlr:inResultSetHit rdf:resource="periplus://simquery/result"/><wlr:isLinkedTo rdf:resource="periplus://resource:133"/><wlr:hasDescription>Face au pouvoir central incarné par le sarkozysme et ses dépendances, s\'installe un contre-pouvoir territorial porté par le socialisme et ses associés. La France est &quot; coupée en deu</wlr:hasDescription><wlr:hasScore>0.924092</wlr:hasScore><wlr:hasRank>18</wlr:hasRank><dc:identifier>603</dc:identifier><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/hit:3675"><wlr:inResultSetHit rdf:resource="periplus://simquery/result"/><wlr:isLinkedTo rdf:resource="periplus://resource:3675"/><wlr:hasDescription>Il faudra songer à remercier Nicolas Sarkozy. Sa pratique du pouvoir, sa ge</wlr:hasDescription><wlr:hasScore>0.914044</wlr:hasScore><wlr:hasRank>19</wlr:hasRank><dc:identifier>40407</dc:identifier><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/hit:5828"><wlr:inResultSetHit rdf:resource="periplus://simquery/result"/><wlr:isLinkedTo rdf:resource="periplus://resource:5828"/><wlr:hasDescription>Jacques Julliard, 77 ans, entre en dissidence. Figure historique de la &quot;deux</wlr:hasDescription><mediaUnit xsi:type="model:Image"><wlr:hasNativeContent>http://static.mediapart.fr/files/imagecache/250_pixels/St%C3%A9phane%20Alli%C3%A8s/julliard.png</wlr:hasNativeContent></mediaUnit><mediaUnit xsi:type="model:Image"><wlr:hasNativeContent>http://static.mediapart.fr/files/imagecache/475_pixels/La%20r%C3%A9daction%20Mediapart/paille.png</wlr:hasNativeContent></mediaUnit><wlr:hasScore>0.907456</wlr:hasScore><wlr:hasRank>20</wlr:hasRank><dc:identifier>78268</dc:identifier><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/hit:3993"><wlr:inResultSetHit rdf:resource="periplus://simquery/result"/><wlr:isLinkedTo rdf:resource="periplus://resource:3993"/><wlr:hasDescription>&quot;Vive la France !&quot; Après quarante minutes, Nicolas Sarkozy en a terminé avec son &quot;grand&quot; discours du Congrès. Sous les applaudissements - p</wlr:hasDescription><wlr:hasScore>0.898695</wlr:hasScore><wlr:hasRank>21</wlr:hasRank><dc:identifier>43349</dc:identifier><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/hit:4870"><wlr:inResultSetHit rdf:resource="periplus://simquery/result"/><wlr:isLinkedTo rdf:resource="periplus://resource:4870"/><wlr:hasDescription>Mais pas question pour l\'ancien président de se faire piéger à l\'antenne sur les affaires de la mairie de Paris, qui vont donc être jugées: l\'opération de communication a été soigneusement préparée, avec une promotion restreinte, en terrain connu : un hebdomadaire (Le Point sort les bonnes feuilles mercredi), un quotidien (Le Figaro aura les honneurs d\'une interview jeudi), une radio (Europe 1, au micro de Jean-Pierre Elkabbach), et une télévision (il sera l\'invité de Michel Drucker dans &quot;Vivement Dimanche&quot;, sur France 2, le 29 novembre). Le livre a été envoyé au com</wlr:hasDescription><mediaUnit xsi:type="model:Image"><wlr:hasNativeContent>http://static.mediapart.fr/files/imagecache/225_pixels/Marine%20Turchi/9782841113934.jpg</wlr:hasNativeContent></mediaUnit><mediaUnit xsi:type="model:Image"><wlr:hasNativeContent>http://static.mediapart.fr/files/imagecache/475_pixels/La%20r%C3%A9daction%20Mediapart/paille.png</wlr:hasNativeContent></mediaUnit><wlr:hasScore>0.895167</wlr:hasScore><wlr:hasRank>22</wlr:hasRank><dc:identifier>67685</dc:identifier><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/hit:2156"><wlr:inResultSetHit rdf:resource="periplus://simquery/result"/><wlr:isLinkedTo rdf:resource="periplus://resource:2156"/><wlr:hasDescription>Les débats s\'enchaînent au PS, sans que les équilibres internes ne paraissent évoluer. L\'incertitude persiste, aucun</wlr:hasDescription><wlr:hasScore>0.886579</wlr:hasScore><wlr:hasRank>23</wlr:hasRank><dc:identifier>26098</dc:identifier><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/hit:3849"><wlr:inResultSetHit rdf:resource="periplus://simquery/result"/><wlr:isLinkedTo rdf:resource="periplus://resource:3849"/><wlr:hasDescription>&quot;Celui qui gagne, c\'est celui qui arrive en tête&quot;, a rappelé Xavier Bertrand, le secrétaire général de l\'UMP, lors du dernier meeting européen de la majorité, jeudi soir, porte de Versailles, à Paris (lire notre article). On le sait déjà, dimanche soi</wlr:hasDescription><wlr:hasScore>0.885014</wlr:hasScore><wlr:hasRank>24</wlr:hasRank><dc:identifier>42094</dc:identifier><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/hit:3802"><wlr:inResultSetHit rdf:resource="periplus://simquery/result"/><wlr:isLinkedTo rdf:resource="periplus://resource:3802"/><wlr:hasDescription>Eparpiller les européennes façon puzzle, pour mieux les neutraliser : gaullistes et socialistes l\'avaient rêvé, le giscardien Raffarin l\'a fait. Le procès était instruit depu</wlr:hasDescription><wlr:hasScore>0.881176</wlr:hasScore><wlr:hasRank>25</wlr:hasRank><dc:identifier>41650</dc:identifier><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/hit:1320"><wlr:inResultSetHit rdf:resource="periplus://simquery/result"/><wlr:isLinkedTo rdf:resource="periplus://resource:1320"/><wlr:hasDescription>&quot;Nous hésitions entre le non et le non; ce sera non&quot;, a ironisé le sénateur socialiste Bernard Frimat, mercredi 16 juillet, en réponse à l\'interview de Nicolas Sarkozy sur la réforme des institutions, annonçant in extremis dans Le Monde quelques initiatives en faveur des droits de l\'opposition. Ces déclarations présidentiel</wlr:hasDescription><mediaUnit xsi:type="model:Image"><wlr:hasNativeContent>http://static.mediapart.fr/files/Mathilde Mathieu/Image 2_2.png</wlr:hasNativeContent></mediaUnit><mediaUnit xsi:type="model:Image"><wlr:hasNativeContent>http://static.mediapart.fr/files/imagecache/475_pixels/La%20r%C3%A9daction%20Mediapart/paille.png</wlr:hasNativeContent></mediaUnit><wlr:hasScore>0.878407</wlr:hasScore><wlr:hasRank>26</wlr:hasRank><dc:identifier>18705</dc:identifier><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/hit:1015"><wlr:inResultSetHit rdf:resource="periplus://simquery/result"/><wlr:isLinkedTo rdf:resource="periplus://resource:1015"/><wlr:hasDescription>Jeudi soir, sur le plateau d\'&quot;A vous de juger&quot;, sur France 2, la photo de famille de l\'UMP était parfaite. Derrière François Fillon, inv</wlr:hasDescription><wlr:hasScore>0.871634</wlr:hasScore><wlr:hasRank>27</wlr:hasRank><dc:identifier>16105</dc:identifier><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/hit:4397"><wlr:inResultSetHit rdf:resource="periplus://simquery/result"/><wlr:isLinkedTo rdf:resource="periplus://resource:4397"/><wlr:hasDescription>L\'alliance est de circonstances mais elle contraint la première secrétaire à réagir. Eparpillée depuis quelques mo</wlr:hasDescription><wlr:hasScore>0.869736</wlr:hasScore><wlr:hasRank>28</wlr:hasRank><dc:identifier>49377</dc:identifier><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/hit:4618"><wlr:inResultSetHit rdf:resource="periplus://simquery/result"/><wlr:isLinkedTo rdf:resource="periplus://resource:4618"/><wlr:hasDescription>Une fois de plus, Nicolas Sarkozy a profité d\'une tribune internationale - en l\'occurrence l\'assemblée générale annuelle des Nations unies à New York - pour tenir un langage extrêmement ferme à l\'attention de l\'Iran. Mais, alors que le président </wlr:hasDescription><wlr:hasScore>0.868531</wlr:hasScore><wlr:hasRank>29</wlr:hasRank><dc:identifier>59562</dc:identifier><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/hit:397"><wlr:inResultSetHit rdf:resource="periplus://simquery/result"/><wlr:isLinkedTo rdf:resource="periplus://resource:397"/><wlr:hasDescription>Les &quot; réformistes &quot; les plus conséquents à gauche ne sont pas toujours ceux que l\'on croit. Les premières réactions autou</wlr:hasDescription><wlr:hasScore>0.867952</wlr:hasScore><wlr:hasRank>30</wlr:hasRank><dc:identifier>10623</dc:identifier><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/hit:4285"><wlr:inResultSetHit rdf:resource="periplus://simquery/result"/><wlr:isLinkedTo rdf:resource="periplus://resource:4285"/><wlr:hasDescription>Deuxième volet de notre enquête sur les raisons de la crise du parti socialiste et les relations qu\'il entretient avec les milieux de la recherche (vous pouvez lire le premier volet en cliquant ici). Mediapart a voulu interroger </wlr:hasDescription><mediaUnit xsi:type="model:Image"><wlr:hasNativeContent>http://static.mediapart.fr/files/imagecache/150_pixels/Sylvain%20Bourmeau/Matonti%20F.jpg</wlr:hasNativeContent></mediaUnit><mediaUnit xsi:type="model:Image"><wlr:hasNativeContent>http://static.mediapart.fr/files/imagecache/475_pixels/La%20r%C3%A9daction%20Mediapart/paille.png</wlr:hasNativeContent></mediaUnit><wlr:hasScore>0.867451</wlr:hasScore><wlr:hasRank>31</wlr:hasRank><dc:identifier>45812</dc:identifier><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/hit:1668"><wlr:inResultSetHit rdf:resource="periplus://simquery/result"/><wlr:isLinkedTo rdf:resource="periplus://resource:1668"/><wlr:hasDescription>Quand personne ne croyait trop que le RSA aboutirait, il faisait l\'objet de rares débats. Tant qu\'il s\'expérimentait da</wlr:hasDescription><wlr:hasScore>0.865544</wlr:hasScore><wlr:hasRank>32</wlr:hasRank><dc:identifier>21885</dc:identifier><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/hit:2129"><wlr:inResultSetHit rdf:resource="periplus://simquery/result"/><wlr:isLinkedTo rdf:resource="periplus://resource:2129"/><wlr:hasDescription>Edouard Balladur répondait, mercredi 22 octobre, sur le gravier de l\'Elysée à quelques questions sur les objectifs et le programme de la nouvelle mission que venait de lui confier Nicolas Sarkozy. Quelques minutes plus tôt, le</wlr:hasDescription><wlr:hasScore>0.865544</wlr:hasScore><wlr:hasRank>33</wlr:hasRank><dc:identifier>25866</dc:identifier><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/hit:5351"><wlr:inResultSetHit rdf:resource="periplus://simquery/result"/><wlr:isLinkedTo rdf:resource="periplus://resource:5351"/><wlr:hasDescription>&quot;Dans quelques années nous dirons: il y a l\'UMP et il y a le Nouveau Centre&quot;, a assuré Hervé Morin, lors des voeux aux cadres de son parti, lundi 18 janvier. Chaque année, le discours est</wlr:hasDescription><mediaUnit xsi:type="model:Image"><wlr:hasNativeContent>http://static.mediapart.fr/files/Marine Turchi/udf.png</wlr:hasNativeContent></mediaUnit><mediaUnit xsi:type="model:Image"><wlr:hasNativeContent>http://static.mediapart.fr/files/imagecache/475_pixels/La%20r%C3%A9daction%20Mediapart/paille.png</wlr:hasNativeContent></mediaUnit><wlr:hasScore>0.865421</wlr:hasScore><wlr:hasRank>34</wlr:hasRank><dc:identifier>72565</dc:identifier><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/hit:4904"><wlr:inResultSetHit rdf:resource="periplus://simquery/result"/><wlr:isLinkedTo rdf:resource="periplus://resource:4904"/><wlr:hasDescription>François Hollande fait le bilan. Dans un livre d\'entretien ave</wlr:hasDescription><wlr:hasScore>0.86539</wlr:hasScore><wlr:hasRank>35</wlr:hasRank><dc:identifier>67950</dc:identifier><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/hit:1797"><wlr:inResultSetHit rdf:resource="periplus://simquery/result"/><wlr:isLinkedTo rdf:resource="periplus://resource:1797"/><wlr:hasDescription>Le fichage politique en France, c\'est fini ! C\'est du moins la promesse lancée par la ministre de l\'intérieur, devant l\'Assemblée nationale. Au gré d\'une réécriture compl</wlr:hasDescription><wlr:hasScore>0.865269</wlr:hasScore><wlr:hasRank>36</wlr:hasRank><dc:identifier>23106</dc:identifier><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/hit:1176"><wlr:inResultSetHit rdf:resource="periplus://simquery/result"/><wlr:isLinkedTo rdf:resource="periplus://resource:1176"/><wlr:hasDescription>Les parlementaires UMP, jusqu\'ici divisés sur la réforme des institutions, semblent avoir déniché un compromis sur le \&quot;dossier turc\&quot;, validé mardi 1er juillet par François Fillon. Les sénateurs, révulsés à l\'i</wlr:hasDescription><mediaUnit xsi:type="model:Image"><wlr:hasNativeContent>http://static.mediapart.fr/files/Mathilde Mathieu/Image 6_3.png</wlr:hasNativeContent></mediaUnit><mediaUnit xsi:type="model:Image"><wlr:hasNativeContent>http://static.mediapart.fr/files/imagecache/475_pixels/La%20r%C3%A9daction%20Mediapart/paille.png</wlr:hasNativeContent></mediaUnit><wlr:hasScore>0.865142</wlr:hasScore><wlr:hasRank>37</wlr:hasRank><dc:identifier>17508</dc:identifier><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/hit:571"><wlr:inResultSetHit rdf:resource="periplus://simquery/result"/><wlr:isLinkedTo rdf:resource="periplus://resource:571"/><wlr:hasDescription>Avocat, Jean-Pierre Mignard est président de l\'association Désirs d\'avenir depuis novembre 2007. Vieil ami de François Holland</wlr:hasDescription><wlr:hasScore>0.860128</wlr:hasScore><wlr:hasRank>38</wlr:hasRank><dc:identifier>12169</dc:identifier><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/hit:3676"><wlr:inResultSetHit rdf:resource="periplus://simquery/result"/><wlr:isLinkedTo rdf:resource="periplus://resource:3676"/><wlr:hasDescription>Comme un mauvais moment à passer. Depuis son entrée en campagne</wlr:hasDescription><wlr:hasScore>0.858979</wlr:hasScore><wlr:hasRank>39</wlr:hasRank><dc:identifier>40411</dc:identifier><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/hit:3799"><wlr:inResultSetHit rdf:resource="periplus://simquery/result"/><wlr:isLinkedTo rdf:resource="periplus://resource:3799"/><wlr:hasDescription>Une porcelaine (d\'une entreprise viennoise en difficulté) contre une statue africaine (de &quot;femme debout&quot;). Par cet échange de cadeaux, M</wlr:hasDescription><mediaUnit xsi:type="model:Image"><wlr:hasNativeContent>http://static.mediapart.fr/files/imagecache/300_pixels/St%C3%A9phane%20Alli%C3%A8s/ResizedImage383255-IMG0707.JPG</wlr:hasNativeContent></mediaUnit><mediaUnit xsi:type="model:Image"><wlr:hasNativeContent>http://static.mediapart.fr/files/imagecache/475_pixels/La%20r%C3%A9daction%20Mediapart/paille.png</wlr:hasNativeContent></mediaUnit><wlr:hasScore>0.858373</wlr:hasScore><wlr:hasRank>40</wlr:hasRank><dc:identifier>41634</dc:identifier><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/hit:3646"><wlr:inResultSetHit rdf:resource="periplus://simquery/result"/><wlr:isLinkedTo rdf:resource="periplus://resource:3646"/><wlr:hasDescription>Il a recueilli plus de 18% des voix au premier tour de l\'élection présidentielle de 2007. Les sondages le créditent de </wlr:hasDescription><mediaUnit xsi:type="model:Image"><wlr:hasNativeContent>http://static.mediapart.fr/files/imagecache/300_pixels/Marine%20Turchi/800px-Francois_bayrou_forum_democrate_seignosse_20070916_f_1.jpg</wlr:hasNativeContent></mediaUnit><mediaUnit xsi:type="model:Image"><wlr:hasNativeContent>http://static.mediapart.fr/files/imagecache/475_pixels/La%20r%C3%A9daction%20Mediapart/paille.png</wlr:hasNativeContent></mediaUnit><wlr:hasScore>0.858245</wlr:hasScore><wlr:hasRank>41</wlr:hasRank><dc:identifier>40117</dc:identifier><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/hit:1535"><wlr:inResultSetHit rdf:resource="periplus://simquery/result"/><wlr:isLinkedTo rdf:resource="periplus://resource:1535"/><wlr:hasDescription>Nicolas Sarkozy et le gouvernement ont-t-ils bien perçu ce qui s\'est joué dans l\'environnement international? A lire les discours, à observer les décisions, la question se posait depuis un an ; la publication par l\'Insee du recul de 0,3% du PIB au deuxième trimestre et de la destruction de 12.000 emplois, avec les réaction</wlr:hasDescription><wlr:hasScore>0.856629</wlr:hasScore><wlr:hasRank>42</wlr:hasRank><dc:identifier>20563</dc:identifier><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/hit:2361"><wlr:inResultSetHit rdf:resource="periplus://simquery/result"/><wlr:isLinkedTo rdf:resource="periplus://resource:2361"/><wlr:hasDescription>A la veille de l\'élection du nouveau premier secrétaire socialiste, on n\'a jamais autant parlé\8230 du MoDem. Mardi, interrogée sur France </wlr:hasDescription><wlr:hasScore>0.856416</wlr:hasScore><wlr:hasRank>43</wlr:hasRank><dc:identifier>28041</dc:identifier><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/hit:2441"><wlr:inResultSetHit rdf:resource="periplus://simquery/result"/><wlr:isLinkedTo rdf:resource="periplus://resource:2441"/><wlr:hasDescription>A Paris, l\'UMP a des airs de parti socialiste, en cette période de renouvellement de la fédération. La semaine passée, les adhére</wlr:hasDescription><wlr:hasScore>0.854737</wlr:hasScore><wlr:hasRank>44</wlr:hasRank><dc:identifier>28692</dc:identifier><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/hit:5005"><wlr:inResultSetHit rdf:resource="periplus://simquery/result"/><wlr:isLinkedTo rdf:resource="periplus://resource:5005"/><wlr:hasDescription>La droite a longtemps détesté les panthéonisations. En 1908, celle de Zola fit de</wlr:hasDescription><mediaUnit xsi:type="model:Image"><wlr:hasNativeContent>http://static.mediapart.fr/files/imagecache/300_pixels/Sophie%20Dufau/pantheon-de-paris.jpg</wlr:hasNativeContent></mediaUnit><mediaUnit xsi:type="model:Image"><wlr:hasNativeContent>http://static.mediapart.fr/files/imagecache/475_pixels/La%20r%C3%A9daction%20Mediapart/paille.png</wlr:hasNativeContent></mediaUnit><wlr:hasScore>0.854737</wlr:hasScore><wlr:hasRank>45</wlr:hasRank><dc:identifier>69111</dc:identifier><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/hit:3556"><wlr:inResultSetHit rdf:resource="periplus://simquery/result"/><wlr:isLinkedTo rdf:resource="periplus://resource:3556"/><wlr:hasDescription>Martine Aubry en avait sans doute rêvé, Poul Nyrup Rasmussen l\'a fait. Le parti socialiste a enfin r</wlr:hasDescription><wlr:hasScore>0.854005</wlr:hasScore><wlr:hasRank>46</wlr:hasRank><dc:identifier>39274</dc:identifier><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/hit:47"><wlr:inResultSetHit rdf:resource="periplus://simquery/result"/><wlr:isLinkedTo rdf:resource="periplus://resource:47"/><wlr:hasDescription>C\'est assurément une crise atypique que traverse, en France, la presse quotidienne. Irruption de la gratuité et d</wlr:hasDescription><wlr:hasScore>0.853189</wlr:hasScore><wlr:hasRank>47</wlr:hasRank><dc:identifier>200</dc:identifier><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/hit:2185"><wlr:inResultSetHit rdf:resource="periplus://simquery/result"/><wlr:isLinkedTo rdf:resource="periplus://resource:2185"/><wlr:hasDescription>Il y a peu, les &quot;carnets noirs&quot; d\'Yves Bertrand et le fichier Edvige ravivaient le spectre de la police secrète. Dans le même temps, un servic</wlr:hasDescription><wlr:hasScore>0.852803</wlr:hasScore><wlr:hasRank>48</wlr:hasRank><dc:identifier>26509</dc:identifier><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/hit:2278"><wlr:inResultSetHit rdf:resource="periplus://simquery/result"/><wlr:isLinkedTo rdf:resource="periplus://resource:2278"/><wlr:hasDescription>Les grands esprits socialistes se sont reposés, au lendemain d\'une longue nuit électorale. Si Ségolène Royal arrive en t</wlr:hasDescription><wlr:hasScore>0.85201</wlr:hasScore><wlr:hasRank>49</wlr:hasRank><dc:identifier>27180</dc:identifier><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/hit:1902"><wlr:inResultSetHit rdf:resource="periplus://simquery/result"/><wlr:isLinkedTo rdf:resource="periplus://resource:1902"/><wlr:hasDescription>En pleine panique financière, les responsables politiques retrouvent la parole. Après la réunion de crise ce </wlr:hasDescription><wlr:hasScore>0.851838</wlr:hasScore><wlr:hasRank>50</wlr:hasRank><dc:identifier>23938</dc:identifier><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/hit:288"><wlr:inResultSetHit rdf:resource="periplus://simquery/result"/><wlr:isLinkedTo rdf:resource="periplus://resource:288"/><wlr:hasDescription>L\'UMP et le PS sont des jumeaux dizygotes. Ils ne sont pas issus du même</wlr:hasDescription><wlr:hasScore>0.848327</wlr:hasScore><wlr:hasRank>51</wlr:hasRank><dc:identifier>9624</dc:identifier><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/hit:1093"><wlr:inResultSetHit rdf:resource="periplus://simquery/result"/><wlr:isLinkedTo rdf:resource="periplus://resource:1093"/><wlr:hasDescription>Il dit vouloir rendre des comptes, démontrer combien les députés socialistes se sont montrés utiles depuis un an au Palais-Bourbon. Jean-Marc Ayrault organisera </wlr:hasDescription><mediaUnit xsi:type="model:Image"><wlr:hasNativeContent>http://static.mediapart.fr/files/Mathilde Mathieu/229180457_9db20a3f47_m.jpg</wlr:hasNativeContent></mediaUnit><mediaUnit xsi:type="model:Image"><wlr:hasNativeContent>http://static.mediapart.fr/files/imagecache/475_pixels/La%20r%C3%A9daction%20Mediapart/paille.png</wlr:hasNativeContent></mediaUnit><wlr:hasScore>0.847377</wlr:hasScore><wlr:hasRank>52</wlr:hasRank><dc:identifier>16697</dc:identifier><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/hit:1462"><wlr:inResultSetHit rdf:resource="periplus://simquery/result"/><wlr:isLinkedTo rdf:resource="periplus://resource:1462"/><wlr:hasDescription>Les ministres sont partis en vacances mais il en est resté un, le porte-parole du gouvernement, Luc Chatel, pour faire le service après-vente des lois en cascade votées par le Parlement depuis un an. &quot;De grandes batailles idéolog</wlr:hasDescription><mediaUnit xsi:type="model:Image"><wlr:hasNativeContent>http://static.mediapart.fr/files/imagecache/475_pixels/Mathieu%20Magnaudeix/Image%203_7.png</wlr:hasNativeContent></mediaUnit><mediaUnit xsi:type="model:Image"><wlr:hasNativeContent>http://static.mediapart.fr/files/imagecache/475_pixels/La%20r%C3%A9daction%20Mediapart/paille.png</wlr:hasNativeContent></mediaUnit><wlr:hasScore>0.847377</wlr:hasScore><wlr:hasRank>53</wlr:hasRank><dc:identifier>19657</dc:identifier><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/hit:2179"><wlr:inResultSetHit rdf:resource="periplus://simquery/result"/><wlr:isLinkedTo rdf:resource="periplus://resource:2179"/><wlr:hasDescription>Sitôt que l\'on a su que le taux de rémunération du Livret A allait baisser le 1er février prochain, de 4% actuellement à sans doute 3,5% et peut-être même 3%, cela a été un véritable tir de barrage. Comprenant qu\'en pleine tourm</wlr:hasDescription><wlr:hasScore>0.847377</wlr:hasScore><wlr:hasRank>54</wlr:hasRank><dc:identifier>26409</dc:identifier><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/hit:1403"><wlr:inResultSetHit rdf:resource="periplus://simquery/result"/><wlr:isLinkedTo rdf:resource="periplus://resource:1403"/><wlr:hasDescription>La \&quot;nouvelle\&quot; Constitution, parue jeudi 24 juillet au Journal officiel, fait littéralement jubiler Jean-François Copé. (Téléchargez ici le calendri</wlr:hasDescription><wlr:hasScore>0.845198</wlr:hasScore><wlr:hasRank>55</wlr:hasRank><dc:identifier>19199</dc:identifier><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/hit:2501"><wlr:inResultSetHit rdf:resource="periplus://simquery/result"/><wlr:isLinkedTo rdf:resource="periplus://resource:2501"/><wlr:hasDescription>Jeudi 4 décembre, l\'Assemblée nationale est entrée dans le vif du sujet, en adoptant deux mesures clés du projet de loi sur l\'audiovisuel public, qui prévoient la désignation et la révocation par le chef de l\'Etat des patrons de France Télévisions, de Radio France et d\'AEF (la holding regroupant France 24, RFI et TV5 Monde). Sur l\'article 8 (fixant le pr</wlr:hasDescription><wlr:hasScore>0.845198</wlr:hasScore><wlr:hasRank>56</wlr:hasRank><dc:identifier>29095</dc:identifier><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/hit:4470"><wlr:inResultSetHit rdf:resource="periplus://simquery/result"/><wlr:isLinkedTo rdf:resource="periplus://resource:4470"/><wlr:hasDescription>De notre envoyée spéciale à La Grande-Motte  Pour éviter qu\'écologistes et socialistes fassent une OPA sur le Modem, sorti très affaibli des élections européennes, Bayrou leur a lancé une &quot;offre publique de dialogue&quot;, dimanche 6 septembre, en clôture de l\'université d\'été du mouvement, organisée à La Grande-Motte. Par son discours, il a signé </wlr:hasDescription><wlr:hasScore>0.844449</wlr:hasScore><wlr:hasRank>57</wlr:hasRank><dc:identifier>53657</dc:identifier><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/hit:5881"><wlr:inResultSetHit rdf:resource="periplus://simquery/result"/><wlr:isLinkedTo rdf:resource="periplus://resource:5881"/><wlr:hasDescription>&quot;Je ne rentre pas au gouvernement dans les meilleures conditions, ni de popularité, ni de finances publiques&quot;, a reconnu le nouveau ministre du budget, sur Europe1, jeudi matin. Il aurait pu ajouter: &quot;ni de </wlr:hasDescription><mediaUnit xsi:type="model:Image"><wlr:hasNativeContent>http://static.mediapart.fr/files/imagecache/300_pixels/Marine%20Turchi/baroin_sarkozy.jpg</wlr:hasNativeContent></mediaUnit><mediaUnit xsi:type="model:Image"><wlr:hasNativeContent>http://static.mediapart.fr/files/imagecache/475_pixels/La%20r%C3%A9daction%20Mediapart/paille.png</wlr:hasNativeContent></mediaUnit><wlr:hasScore>0.842533</wlr:hasScore><wlr:hasRank>58</wlr:hasRank><dc:identifier>78812</dc:identifier><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/hit:3533"><wlr:inResultSetHit rdf:resource="periplus://simquery/result"/><wlr:isLinkedTo rdf:resource="periplus://resource:3533"/><wlr:hasDescription>A l\'Elysée, on affirme que Dominique de Villepin ne fait pas peur. On prétend même qu\'il n\'a qu\'</wlr:hasDescription><mediaUnit xsi:type="model:Image"><wlr:hasNativeContent>http://static.mediapart.fr/files/imagecache/475_pixels/Marine%20Turchi/2083.jpg</wlr:hasNativeContent></mediaUnit><mediaUnit xsi:type="model:Image"><wlr:hasNativeContent>http://static.mediapart.fr/files/imagecache/475_pixels/La%20r%C3%A9daction%20Mediapart/paille.png</wlr:hasNativeContent></mediaUnit><wlr:hasScore>0.84111</wlr:hasScore><wlr:hasRank>59</wlr:hasRank><dc:identifier>39104</dc:identifier><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/hit:1978"><wlr:inResultSetHit rdf:resource="periplus://simquery/result"/><wlr:isLinkedTo rdf:resource="periplus://resource:1978"/><wlr:hasDescription>Aucune faillite retentissante, pas d\'annonce de menaces supplémentaires sur l\'économie malgré les prix de l\'immobilier qui commencent à chuter et l\'Islande qui se liquéfie. A Paris notamment, les marché</wlr:hasDescription><wlr:hasScore>0.837822</wlr:hasScore><wlr:hasRank>60</wlr:hasRank><dc:identifier>24554</dc:identifier><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/hit:5120"><wlr:inResultSetHit rdf:resource="periplus://simquery/result"/><wlr:isLinkedTo rdf:resource="periplus://resource:5120"/><wlr:hasDescription>Des élus qui claquent la porte de l\'UMP, des conseillers qui quittent sur la pointe des pieds l\'Elysée... Les annonces de ce lundi 7 </wlr:hasDescription><wlr:hasScore>0.837822</wlr:hasScore><wlr:hasRank>61</wlr:hasRank><dc:identifier>70129</dc:identifier><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/hit:154"><wlr:inResultSetHit rdf:resource="periplus://simquery/result"/><wlr:isLinkedTo rdf:resource="periplus://resource:154"/><wlr:hasDescription>Face au pouvoir central incarné par le sarkozysme et ses dépendances, s\'installe un contre-pouvoir territorial porté par le socialisme et ses associés. La France est &quot; coupée en deu</wlr:hasDescription><wlr:hasScore>0.837729</wlr:hasScore><wlr:hasRank>62</wlr:hasRank><dc:identifier>748</dc:identifier><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/hit:3862"><wlr:inResultSetHit rdf:resource="periplus://simquery/result"/><wlr:isLinkedTo rdf:resource="periplus://resource:3862"/><wlr:hasDescription>De midi à minuit, dans la journée du dimanche 7 juin, la rédaction de Mediapart a tenu la chronique, minute par minute, de la journée électorale. Vous pouvez lire ci-dessous, </wlr:hasDescription><mediaUnit xsi:type="model:Image"><wlr:hasNativeContent>http://static.mediapart.fr/files/imagecache/475_pixels/La%20r%C3%A9daction%20Mediapart/Image%206_2.png</wlr:hasNativeContent></mediaUnit><mediaUnit xsi:type="model:Image"><wlr:hasNativeContent>http://static.mediapart.fr/files/imagecache/475_pixels/La%20r%C3%A9daction%20Mediapart/paille.png</wlr:hasNativeContent></mediaUnit><wlr:hasScore>0.836646</wlr:hasScore><wlr:hasRank>63</wlr:hasRank><dc:identifier>42258</dc:identifier><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/hit:5246"><wlr:inResultSetHit rdf:resource="periplus://simquery/result"/><wlr:isLinkedTo rdf:resource="periplus://resource:5246"/><wlr:hasDescription>&quot;Les gnomes de Francfort&quot;, par exemple, qualificatif de Jean-Pierre Chevènement à l\'encontre des dirigeants de la Banque centrale européenne, gardienne du fameux traité de &quot;MasTrique&quot;. Il y a le savoureux &quot;Le parti</wlr:hasDescription><mediaUnit xsi:type="model:Image"><wlr:hasNativeContent>http://static.mediapart.fr/files/imagecache/225_pixels/Fran%C3%A7ois%20Bonnet/couv.png</wlr:hasNativeContent></mediaUnit><mediaUnit xsi:type="model:Image"><wlr:hasNativeContent>http://static.mediapart.fr/files/imagecache/475_pixels/La%20r%C3%A9daction%20Mediapart/paille.png</wlr:hasNativeContent></mediaUnit><wlr:hasScore>0.829268</wlr:hasScore><wlr:hasRank>64</wlr:hasRank><dc:identifier>71364</dc:identifier><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/hit:5506"><wlr:inResultSetHit rdf:resource="periplus://simquery/result"/><wlr:isLinkedTo rdf:resource="periplus://resource:5506"/><wlr:hasDescription>Changement express de stratégie, négociations interminables pour boucler des listes, choix contestés en Ile-de-France, affaire Clearstream qui déchire la majorité. A moins de deux mois du scrut</wlr:hasDescription><mediaUnit xsi:type="model:Image"><wlr:hasNativeContent>http://static.mediapart.fr/files/imagecache/475_pixels/Marine%20Turchi/conseil_national_UMP.jpg</wlr:hasNativeContent></mediaUnit><mediaUnit xsi:type="model:Image"><wlr:hasNativeContent>http://static.mediapart.fr/files/imagecache/475_pixels/La%20r%C3%A9daction%20Mediapart/paille.png</wlr:hasNativeContent></mediaUnit><wlr:hasScore>0.829268</wlr:hasScore><wlr:hasRank>65</wlr:hasRank><dc:identifier>74059</dc:identifier><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/hit:1524"><wlr:inResultSetHit rdf:resource="periplus://simquery/result"/><wlr:isLinkedTo rdf:resource="periplus://resource:1524"/><wlr:hasDescription>Les autruches sortent enfin la tête de terre. Contrairement à l\'antienne op</wlr:hasDescription><wlr:hasScore>0.827191</wlr:hasScore><wlr:hasRank>66</wlr:hasRank><dc:identifier>20496</dc:identifier><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/hit:1614"><wlr:inResultSetHit rdf:resource="periplus://simquery/result"/><wlr:isLinkedTo rdf:resource="periplus://resource:1614"/><wlr:hasDescription>Elle a la voix toute chevrotante, Monique. Mégaphone en main, cette inst</wlr:hasDescription><wlr:hasScore>0.825859</wlr:hasScore><wlr:hasRank>67</wlr:hasRank><dc:identifier>21353</dc:identifier><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/hit:3576"><wlr:inResultSetHit rdf:resource="periplus://simquery/result"/><wlr:isLinkedTo rdf:resource="periplus://resource:3576"/><wlr:hasDescription>&quot;La politique est de retour ! Ces élections seront politiques&quot;, a prévenu Xavier Bertrand en marge du premier meeting européen de l\'UMP, mardi soir, à Rueil-Malmaison (Hauts-de-Seine). Le but était clair : ramener </wlr:hasDescription><wlr:hasScore>0.825809</wlr:hasScore><wlr:hasRank>68</wlr:hasRank><dc:identifier>39518</dc:identifier><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/hit:5922"><wlr:inResultSetHit rdf:resource="periplus://simquery/result"/><wlr:isLinkedTo rdf:resource="periplus://resource:5922"/><wlr:hasDescription>Même s\'il est un ami de Nicolas Sarkozy et un client d\'Alain Minc, Stéphane Courbit est depuis quelque temps bien malheureux en affaires. Après avoir acquis une partic</wlr:hasDescription><wlr:hasScore>0.825159</wlr:hasScore><wlr:hasRank>69</wlr:hasRank><dc:identifier>79317</dc:identifier><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/hit:5786"><wlr:inResultSetHit rdf:resource="periplus://simquery/result"/><wlr:isLinkedTo rdf:resource="periplus://resource:5786"/><wlr:hasDescription>La rumeur circule depuis quelques jours - le site internet Wansquare s\'en est fait le premier l\'écho, et après lui Le Point - et nous en avons obtenu une confirmation de très bonne source: Yazid Sabeg, l\'actuel commissaire à la diversité et à l\'égalité des chances, devrait succéder à Anne Lauvergeon à la tête d\'Areva, le champion du nucléaire français. Selon nos informations, cette</wlr:hasDescription><wlr:hasScore>0.824374</wlr:hasScore><wlr:hasRank>70</wlr:hasRank><dc:identifier>77916</dc:identifier><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/hit:4453"><wlr:inResultSetHit rdf:resource="periplus://simquery/result"/><wlr:isLinkedTo rdf:resource="periplus://resource:4453"/><wlr:hasDescription>Après avoir passé son été à tempêter, menaçant de démissionner de la direction ou d\'en appeler aux militants pour imposer les primaires ouvertes qu\'il promeut dans un livre (Comment sauver la gauche, au Seuil, avec Olivier Ferrand), Arnaud Montebourg est finalement l\'un des grands gagnants des universités d\'été de La Rochelle. Même si son forcing a irrité </wlr:hasDescription><wlr:hasScore>0.824323</wlr:hasScore><wlr:hasRank>71</wlr:hasRank><dc:identifier>52502</dc:identifier><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/hit:347"><wlr:inResultSetHit rdf:resource="periplus://simquery/result"/><wlr:isLinkedTo rdf:resource="periplus://resource:347"/><wlr:hasDescription>L\'accueil de guérilleros des Forces armées révolutionnaires en Colombie (FARC) sur le territoire français : voilà la probable clef diplomatique de la tentative de libération d\'Ingrid Betancourt qui est en train de se jouer en Amérique du Sud. L\'Elysée a annoncé, mercredi </wlr:hasDescription><wlr:hasScore>0.823627</wlr:hasScore><wlr:hasRank>72</wlr:hasRank><dc:identifier>10057</dc:identifier><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/hit:600"><wlr:inResultSetHit rdf:resource="periplus://simquery/result"/><wlr:isLinkedTo rdf:resource="periplus://resource:600"/><wlr:hasDescription>En matière culturelle, le candidat à l\'élection présidentielle Nicolas Sarkozy s\'était limité au strict minimum. Deux promesses saillantes, en</wlr:hasDescription><wlr:hasScore>0.823627</wlr:hasScore><wlr:hasRank>73</wlr:hasRank><dc:identifier>12369</dc:identifier><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/hit:3200"><wlr:inResultSetHit rdf:resource="periplus://simquery/result"/><wlr:isLinkedTo rdf:resource="periplus://resource:3200"/><wlr:hasDescription>&quot;Je suis quelqu\'un de souple dans mes charentaises&quot;, plaisante Valérie Pécresse sur France Culture en février 2009, en contrepoint du fameux &quot;droit dans mes bottes&quot; d\'Alain Juppé en pleine crise de la réforme des retraites en 1995. Cette souplesse en chaussons </wlr:hasDescription><mediaUnit xsi:type="model:Image"><wlr:hasNativeContent>http://static.mediapart.fr/files/imagecache/475_pixels/Jade%20Lindgaard/lussault.jpg</wlr:hasNativeContent></mediaUnit><mediaUnit xsi:type="model:Image"><wlr:hasNativeContent>http://static.mediapart.fr/files/imagecache/475_pixels/La%20r%C3%A9daction%20Mediapart/paille.png</wlr:hasNativeContent></mediaUnit><wlr:hasScore>0.823627</wlr:hasScore><wlr:hasRank>74</wlr:hasRank><dc:identifier>35718</dc:identifier><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/hit:4458"><wlr:inResultSetHit rdf:resource="periplus://simquery/result"/><wlr:isLinkedTo rdf:resource="periplus://resource:4458"/><wlr:hasDescription>Jean-Pierre Mignard quitte la présidence de Désirs d\'avenir désormais assumée par Ségolène Royal elle-même, qui entend transformer l\'association en &quot;ONG européenne&quot; proche d\'une fondation type think tank, comme le précise un communiqué publié jeudi 3 septembre. Dans un entretien à Mediapart</wlr:hasDescription><wlr:hasScore>0.823627</wlr:hasScore><wlr:hasRank>75</wlr:hasRank><dc:identifier>53147</dc:identifier><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/hit:4698"><wlr:inResultSetHit rdf:resource="periplus://simquery/result"/><wlr:isLinkedTo rdf:resource="periplus://resource:4698"/><wlr:hasDescription>Alors que la session parlementaire est à peine réunie, que les sujets foisonnent allant des suites de la crise économique au colossal déficit budgétaire en passant par la réforme des collectivités locales, quel est l\'un des tout premiers sujets que le gouvernement décide d\'inscrire à l\'ordre du jour de l\'Assemblée nationale? L\'ouverture du marché des jeux en ligne et la fin du monopole de l\'Etat sur ce secteur.&quot;Nous avons pour ambition que </wlr:hasDescription><wlr:hasScore>0.823627</wlr:hasScore><wlr:hasRank>76</wlr:hasRank><dc:identifier>63657</dc:identifier><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/hit:4823"><wlr:inResultSetHit rdf:resource="periplus://simquery/result"/><wlr:isLinkedTo rdf:resource="periplus://resource:4823"/><wlr:hasDescription>&quot;Je ne dirai rien sur les élections au PS, ce serait désagréable&quot;, ironisait Jean Sarkozy, vendredi, au conseil général des Hauts-de-Seine, lors de son discours de candidat au poste d\'administrateur de l\'Epad. A l\'UMP, on se plaît à renvoy</wlr:hasDescription><mediaUnit xsi:type="model:Image"><wlr:hasNativeContent>http://static.mediapart.fr/files/Michel Dalloni/tableau_primaires_ump.png</wlr:hasNativeContent></mediaUnit><mediaUnit xsi:type="model:Image"><wlr:hasNativeContent>http://static.mediapart.fr/files/imagecache/475_pixels/La%20r%C3%A9daction%20Mediapart/paille.png</wlr:hasNativeContent></mediaUnit><wlr:hasScore>0.823127</wlr:hasScore><wlr:hasRank>77</wlr:hasRank><dc:identifier>67076</dc:identifier><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/hit:4272"><wlr:inResultSetHit rdf:resource="periplus://simquery/result"/><wlr:isLinkedTo rdf:resource="periplus://resource:4272"/><wlr:hasDescription>Oublions Jack Lang, Bernard-Henri Lévy et leurs imprécations sur la mort assurée du Parti socialiste. Laissons à Max Gallo, ancien </wlr:hasDescription><mediaUnit xsi:type="model:Image"><wlr:hasNativeContent>http://static.mediapart.fr/files/imagecache/150_pixels/Sylvain%20Bourmeau/Assayag%20J.jpg</wlr:hasNativeContent></mediaUnit><mediaUnit xsi:type="model:Image"><wlr:hasNativeContent>http://static.mediapart.fr/files/imagecache/475_pixels/La%20r%C3%A9daction%20Mediapart/paille.png</wlr:hasNativeContent></mediaUnit><wlr:hasScore>0.822925</wlr:hasScore><wlr:hasRank>78</wlr:hasRank><dc:identifier>45740</dc:identifier><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/hit:2577"><wlr:inResultSetHit rdf:resource="periplus://simquery/result"/><wlr:isLinkedTo rdf:resource="periplus://resource:2577"/><wlr:hasDescription>Attention, un train peut en cacher un autre. L\'arrivée de Patrick Devedjia</wlr:hasDescription><wlr:hasScore>0.819154</wlr:hasScore><wlr:hasRank>79</wlr:hasRank><dc:identifier>29621</dc:identifier><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/hit:4728"><wlr:inResultSetHit rdf:resource="periplus://simquery/result"/><wlr:isLinkedTo rdf:resource="periplus://resource:4728"/><wlr:hasDescription>L\'ex-judoka David Douillet, engagé sous les couleurs du parti présidentiel, a écrasé le premier tour de l\'élection législative partielle organisée dimanche 11 octobre, dans la 12e circonscription des Yvelines, en captant 44,2% des voix, soit le double du candidat socialiste et maire de Poissy, Frédérik Bernard, qui a recueilli 21,9% des bulletins. Le candidat d\'Europe-Ecologie</wlr:hasDescription><wlr:hasScore>0.818169</wlr:hasScore><wlr:hasRank>80</wlr:hasRank><dc:identifier>65097</dc:identifier><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/hit:5490"><wlr:inResultSetHit rdf:resource="periplus://simquery/result"/><wlr:isLinkedTo rdf:resource="periplus://resource:5490"/><wlr:hasDescription>Jeudi, l\'UMP était plus bavarde sur la dernière sortie du socialiste Georges Frêche que sur la relaxe de Dominique de Villepin dans le procès Clearstream. Connu pour dégainer des commu</wlr:hasDescription><wlr:hasScore>0.818169</wlr:hasScore><wlr:hasRank>81</wlr:hasRank><dc:identifier>73885</dc:identifier><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/hit:4341"><wlr:inResultSetHit rdf:resource="periplus://simquery/result"/><wlr:isLinkedTo rdf:resource="periplus://resource:4341"/><wlr:hasDescription>Plus de trois mois après le revers des élections européennes, où il a recueilli à peine 16,48%, devançant d\'une rien les listes Europe-Ecologie, et à quelques jours de son université d\'été de La Rochelle (28-30 août), il n\'est pas certain que le parti socialiste a retrouvé confiance, sérénité et cohésion. Entre les silences de Ségolèn</wlr:hasDescription><wlr:hasScore>0.817228</wlr:hasScore><wlr:hasRank>82</wlr:hasRank><dc:identifier>46602</dc:identifier><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/hit:2286"><wlr:inResultSetHit rdf:resource="periplus://simquery/result"/><wlr:isLinkedTo rdf:resource="periplus://resource:2286"/><wlr:hasDescription>Lundi 10 novembre au matin, une délégation du Cran, conseil représentatif des associations noires, est reçue à l\'Elysée. Pas par le président, ni par </wlr:hasDescription><wlr:hasScore>0.817157</wlr:hasScore><wlr:hasRank>83</wlr:hasRank><dc:identifier>27334</dc:identifier><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/hit:3510"><wlr:inResultSetHit rdf:resource="periplus://simquery/result"/><wlr:isLinkedTo rdf:resource="periplus://resource:3510"/><wlr:hasDescription>&quot;Une caravane mobile pour montrer que l\'Europe peut mobiliser.&quot; Lundi 20 avril, le secrétair</wlr:hasDescription><mediaUnit xsi:type="model:Image"><wlr:hasNativeContent>http://static.mediapart.fr/files/imagecache/225_pixels/Marine%20Turchi/Image%202_6.png</wlr:hasNativeContent></mediaUnit><mediaUnit xsi:type="model:Image"><wlr:hasNativeContent>http://static.mediapart.fr/files/imagecache/475_pixels/La%20r%C3%A9daction%20Mediapart/paille.png</wlr:hasNativeContent></mediaUnit><wlr:hasScore>0.817157</wlr:hasScore><wlr:hasRank>84</wlr:hasRank><dc:identifier>38947</dc:identifier><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/hit:4201"><wlr:inResultSetHit rdf:resource="periplus://simquery/result"/><wlr:isLinkedTo rdf:resource="periplus://resource:4201"/><wlr:hasDescription>Martin Hirsch a pris un coup de jeune. Tel un étudiant cherchant un </wlr:hasDescription><mediaUnit xsi:type="model:Image"><wlr:hasNativeContent>http://static.mediapart.fr/files/imagecache/225_pixels/Micha%C3%ABl%20Hajdenberg/Image%2031.png</wlr:hasNativeContent></mediaUnit><mediaUnit xsi:type="model:Image"><wlr:hasNativeContent>http://static.mediapart.fr/files/imagecache/475_pixels/La%20r%C3%A9daction%20Mediapart/paille.png</wlr:hasNativeContent></mediaUnit><wlr:hasScore>0.817157</wlr:hasScore><wlr:hasRank>85</wlr:hasRank><dc:identifier>45166</dc:identifier><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/hit:4545"><wlr:inResultSetHit rdf:resource="periplus://simquery/result"/><wlr:isLinkedTo rdf:resource="periplus://resource:4545"/><wlr:hasDescription>Il aura fallu deux ans pour que Nicolas Sarkozy fasse son mea-culpa sur les empreintes génétiques réservées aux étrangers souhaitant rejoindre leur famille en France. Lors d\'une rencontre à l\'Élys</wlr:hasDescription><wlr:hasScore>0.815821</wlr:hasScore><wlr:hasRank>86</wlr:hasRank><dc:identifier>56762</dc:identifier><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/hit:4513"><wlr:inResultSetHit rdf:resource="periplus://simquery/result"/><wlr:isLinkedTo rdf:resource="periplus://resource:4513"/><wlr:hasDescription>Il a été l\'une des stars de \8220l\'ouverture socialiste\8221 durant l\'été, participant aux meetings de François Hollande (à Lorient en juin) puis de Vincent Peillon (à Marseille en août). Désormais ressorti de l\'anony</wlr:hasDescription><wlr:hasScore>0.814434</wlr:hasScore><wlr:hasRank>87</wlr:hasRank><dc:identifier>55167</dc:identifier><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/hit:446"><wlr:inResultSetHit rdf:resource="periplus://simquery/result"/><wlr:isLinkedTo rdf:resource="periplus://resource:446"/><wlr:hasDescription>L\'inusable Michel Charasse exclu du PS? La fédération socialiste du Puy-de-Dôme en a voté la demande jeudi soir, à une large majorité du conseil fédéral (42 voix contre 14). Mais l\'ancien ministre du Bud</wlr:hasDescription><wlr:hasScore>0.814077</wlr:hasScore><wlr:hasRank>88</wlr:hasRank><dc:identifier>11001</dc:identifier><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/hit:2312"><wlr:inResultSetHit rdf:resource="periplus://simquery/result"/><wlr:isLinkedTo rdf:resource="periplus://resource:2312"/><wlr:hasDescription>Ces derniers jours, le bruit s\'est répandu comme une traînée de poudre dans la maison socialiste: &quot;La presse people débarque au congrès!&quot; Les journalistes de Voici seraient déjà en route pour Reims, bardés de magnétos... Interrogé, le service de pr</wlr:hasDescription><mediaUnit xsi:type="model:Image"><wlr:hasNativeContent>http://static.mediapart.fr/files/Mathilde Mathieu/tiny_3119_couv.jpg</wlr:hasNativeContent></mediaUnit><mediaUnit xsi:type="model:Image"><wlr:hasNativeContent>http://static.mediapart.fr/files/imagecache/475_pixels/La%20r%C3%A9daction%20Mediapart/paille.png</wlr:hasNativeContent></mediaUnit><wlr:hasScore>0.814077</wlr:hasScore><wlr:hasRank>89</wlr:hasRank><dc:identifier>27639</dc:identifier><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/hit:5488"><wlr:inResultSetHit rdf:resource="periplus://simquery/result"/><wlr:isLinkedTo rdf:resource="periplus://resource:5488"/><wlr:hasDescription>Si le parti socialiste n\'est toujours pas un long fleuve tranquille, il parvient tout de même à ne pas se noyer dans les eaux troubles de la division. En adoptant mardi soir une po</wlr:hasDescription><wlr:hasScore>0.814077</wlr:hasScore><wlr:hasRank>90</wlr:hasRank><dc:identifier>73823</dc:identifier><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/hit:2075"><wlr:inResultSetHit rdf:resource="periplus://simquery/result"/><wlr:isLinkedTo rdf:resource="periplus://resource:2075"/><wlr:hasDescription>La Caisse d\'épargne, qui a révélé une perte de 600 millions d\'euros dans des opérations de marché, doit réunir son conseil de surveillance, dimanche 19 octobre, dans l\'après-midi, afin de se prononcer sur le sort de la direction et notamment celui du président du directoire de la Caisse nationale des Caisses d\'épargne (CNCE), Charles Milhaud.Dans un entretien, publié par</wlr:hasDescription><wlr:hasScore>0.813793</wlr:hasScore><wlr:hasRank>91</wlr:hasRank><dc:identifier>25510</dc:identifier><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/hit:487"><wlr:inResultSetHit rdf:resource="periplus://simquery/result"/><wlr:isLinkedTo rdf:resource="periplus://resource:487"/><wlr:hasDescription>Du &quot;les caisses sont vides&quot; de Nicolas Sarkozy au &quot;pays en faillite&quot; de François Fillon, le triste état des finances publiques françaises alimente la chronique par intermittence. Mais derrière le propos polit</wlr:hasDescription><wlr:hasScore>0.811021</wlr:hasScore><wlr:hasRank>92</wlr:hasRank><dc:identifier>11333</dc:identifier><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/hit:1799"><wlr:inResultSetHit rdf:resource="periplus://simquery/result"/><wlr:isLinkedTo rdf:resource="periplus://resource:1799"/><wlr:hasDescription>Adieu levées de fourches, déversements de lisier, saccages de bâtiments administratifs et autres violences à agents de la force publique : la grande agriculture française semble être entrée dans l\'ère du lobbying à visage humain. Et elle a choisi pour annonce</wlr:hasDescription><wlr:hasScore>0.811021</wlr:hasScore><wlr:hasRank>93</wlr:hasRank><dc:identifier>23127</dc:identifier><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/hit:1976"><wlr:inResultSetHit rdf:resource="periplus://simquery/result"/><wlr:isLinkedTo rdf:resource="periplus://resource:1976"/><wlr:hasDescription>Mais où est donc passée la gauche? Cette époque de tempête et de crise devrait être faste pour elle. Alors que le capitalisme trav</wlr:hasDescription><wlr:hasScore>0.811021</wlr:hasScore><wlr:hasRank>94</wlr:hasRank><dc:identifier>24528</dc:identifier><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/hit:5753"><wlr:inResultSetHit rdf:resource="periplus://simquery/result"/><wlr:isLinkedTo rdf:resource="periplus://resource:5753"/><wlr:hasDescription>Chez Europe Ecologie, beaucoup ne le disent qu\'à demi-mot, mais ils sont déçus: tous auraient aimé dépasser les 16% des européennes de 2009. Tout juste débarqué de son ma</wlr:hasDescription><mediaUnit xsi:type="model:Image"><wlr:hasNativeContent>http://static.mediapart.fr/files/imagecache/300_pixels/La%20r%C3%A9daction%20Mediapart/besson-photo.jpg</wlr:hasNativeContent></mediaUnit><mediaUnit xsi:type="model:Image"><wlr:hasNativeContent>http://static.mediapart.fr/files/imagecache/475_pixels/La%20r%C3%A9daction%20Mediapart/paille.png</wlr:hasNativeContent></mediaUnit><wlr:hasScore>0.810912</wlr:hasScore><wlr:hasRank>95</wlr:hasRank><dc:identifier>77546</dc:identifier><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/hit:1592"><wlr:inResultSetHit rdf:resource="periplus://simquery/result"/><wlr:isLinkedTo rdf:resource="periplus://resource:1592"/><wlr:hasDescription>Certains auront peut-être du mal à le croire, mais, à quelques heures de l\'ouverture de la Convention démocrate de Denver, chargée d\'investir officiellement Barack Obama, ce dernier n\'est pas encore assuré d\'accéder à la Maison Blanche. Les 200.000 Allemands qui lui</wlr:hasDescription><mediaUnit xsi:type="model:Image"><wlr:hasNativeContent>http://static.mediapart.fr/files/imagecache/475_pixels/Thomas%20Cantaloube/photos/Image%203_4.png</wlr:hasNativeContent></mediaUnit><mediaUnit xsi:type="model:Image"><wlr:hasNativeContent>http://static.mediapart.fr/files/imagecache/475_pixels/La%20r%C3%A9daction%20Mediapart/paille.png</wlr:hasNativeContent></mediaUnit><wlr:hasScore>0.810167</wlr:hasScore><wlr:hasRank>96</wlr:hasRank><dc:identifier>21133</dc:identifier><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/hit:1600"><wlr:inResultSetHit rdf:resource="periplus://simquery/result"/><wlr:isLinkedTo rdf:resource="periplus://resource:1600"/><wlr:hasDescription>On prête à Talleyrand ce mot: \&quot;Quand je m\'examine, je m\'inquiète. Quand je me compare, je me ra</wlr:hasDescription><wlr:hasScore>0.804479</wlr:hasScore><wlr:hasRank>97</wlr:hasRank><dc:identifier>21227</dc:identifier><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/hit:5548"><wlr:inResultSetHit rdf:resource="periplus://simquery/result"/><wlr:isLinkedTo rdf:resource="periplus://resource:5548"/><wlr:hasDescription>De notre envoyée spéciale en Paca, Ce jour-là, en campagne sur le site nucléaire du Tricastin, Europe Ecologie vient mesurer la radioactivité et déposer une gerbe de fleurs: &quot;Ci-gît la santé publique!&quot;... Des candidats aux régionale</wlr:hasDescription><mediaUnit xsi:type="model:Image"><wlr:hasNativeContent>http://static.mediapart.fr/files/imagecache/475_pixels/Mathilde%20Mathieu/vichnievsky5.jpg</wlr:hasNativeContent></mediaUnit><mediaUnit xsi:type="model:Image"><wlr:hasNativeContent>http://static.mediapart.fr/files/imagecache/475_pixels/La%20r%C3%A9daction%20Mediapart/paille.png</wlr:hasNativeContent></mediaUnit><wlr:hasScore>0.802372</wlr:hasScore><wlr:hasRank>98</wlr:hasRank><dc:identifier>74485</dc:identifier><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/hit:2290"><wlr:inResultSetHit rdf:resource="periplus://simquery/result"/><wlr:isLinkedTo rdf:resource="periplus://resource:2290"/><wlr:hasDescription>Difficile construction d\'alliances majoritaires, au parti socialiste. Après le vote des motions et </wlr:hasDescription><wlr:hasScore>0.801553</wlr:hasScore><wlr:hasRank>99</wlr:hasRank><dc:identifier>27360</dc:identifier><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/hit:2033"><wlr:inResultSetHit rdf:resource="periplus://simquery/result"/><wlr:isLinkedTo rdf:resource="periplus://resource:2033"/><wlr:hasDescription>Soudain, un week-end, le travail du dimanche est devenu priorité nationale. Dimanche dernier, le ministre</wlr:hasDescription><mediaUnit xsi:type="model:Image"><wlr:hasNativeContent>http://static.mediapart.fr/files/imagecache/475_pixels/Mathieu%20Magnaudeix/Image%208_2.png</wlr:hasNativeContent></mediaUnit><mediaUnit xsi:type="model:Image"><wlr:hasNativeContent>http://static.mediapart.fr/files/imagecache/475_pixels/La%20r%C3%A9daction%20Mediapart/paille.png</wlr:hasNativeContent></mediaUnit><wlr:hasScore>0.801468</wlr:hasScore><wlr:hasRank>100</wlr:hasRank><dc:identifier>25201</dc:identifier><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/cluster:0"><wlr:hasNumberOfResults>19</wlr:hasNumberOfResults><wlr:isLinkedTo rdf:resource="periplus://cluster:0"/><wlr:hasScore>1</wlr:hasScore><wlr:hasDescription>Proche de Ségolène Royal, François Rebsamen a un temps envisagé de faire le trait-d\'union avec les amis de François Hollande pour renverser Martine Aubry de la direction du PS. Rentré dans le rang</wlr:hasDescription><mediaUnit xsi:type="model:Image"><wlr:hasNativeContent>http://static.mediapart.fr/files/imagecache/300_pixels/St%C3%A9phane%20Alli%C3%A8s/ResizedImage383255-IMG0707.JPG</wlr:hasNativeContent></mediaUnit><mediaUnit xsi:type="model:Image"><wlr:hasNativeContent>http://static.mediapart.fr/files/Mathilde Mathieu/229180457_9db20a3f47_m.jpg</wlr:hasNativeContent></mediaUnit><dc:title>HALALALALA le PS</dc:title><rdf:type rdf:resource="DocumentCluster"/></rdf:Description><rdf:Bag rdf:about="periplus://simquery/result/cluster:0"><rdf:li rdf:resource="periplus://simquery/result/hit:3883"/><rdf:li rdf:resource="periplus://simquery/result/hit:2475"/><rdf:li rdf:resource="periplus://simquery/result/hit:4210"/><rdf:li rdf:resource="periplus://simquery/result/hit:2156"/><rdf:li rdf:resource="periplus://simquery/result/hit:3676"/><rdf:li rdf:resource="periplus://simquery/result/hit:3799"/><rdf:li rdf:resource="periplus://simquery/result/hit:2278"/><rdf:li rdf:resource="periplus://simquery/result/hit:1093"/><rdf:li rdf:resource="periplus://simquery/result/hit:1600"/><rdf:li rdf:resource="periplus://simquery/result/hit:2290"/><rdf:li rdf:resource="periplus://simquery/result/hit:4285"/><rdf:li rdf:resource="periplus://simquery/result/hit:571"/><rdf:li rdf:resource="periplus://simquery/result/hit:4458"/><rdf:li rdf:resource="periplus://simquery/result/hit:4272"/><rdf:li rdf:resource="periplus://simquery/result/hit:446"/><rdf:li rdf:resource="periplus://simquery/result/hit:2312"/><rdf:li rdf:resource="periplus://simquery/result/hit:5488"/><rdf:li rdf:resource="periplus://simquery/result/hit:4513"/><rdf:li rdf:resource="periplus://simquery/result/hit:4728"/></rdf:Bag><rdf:Description rdf:about="periplus://simquery/result/cluster:1"><wlr:hasNumberOfResults>9</wlr:hasNumberOfResults><wlr:isLinkedTo rdf:resource="periplus://cluster:1"/><wlr:hasScore>0.970595</wlr:hasScore><wlr:hasDescription>Lot de consolation pour la droite : La Guyane basculerait. Selon des chiffres encore</wlr:hasDescription><mediaUnit xsi:type="model:Image"><wlr:hasNativeContent>http://static.mediapart.fr/files/imagecache/300_pixels/La%20r%C3%A9daction%20Mediapart/rejet.png</wlr:hasNativeContent></mediaUnit><mediaUnit xsi:type="model:Image"><wlr:hasNativeContent>http://static.mediapart.fr/files/imagecache/475_pixels/La%20r%C3%A9daction%20Mediapart/paille.png</wlr:hasNativeContent></mediaUnit><dc:title>Les élections nationales</dc:title><rdf:type rdf:resource="DocumentCluster"/></rdf:Description><rdf:Bag rdf:about="periplus://simquery/result/cluster:1"><rdf:li rdf:resource="periplus://simquery/result/hit:5803"/><rdf:li rdf:resource="periplus://simquery/result/hit:5767"/><rdf:li rdf:resource="periplus://simquery/result/hit:5548"/><rdf:li rdf:resource="periplus://simquery/result/hit:133"/><rdf:li rdf:resource="periplus://simquery/result/hit:3256"/><rdf:li rdf:resource="periplus://simquery/result/hit:3328"/><rdf:li rdf:resource="periplus://simquery/result/hit:4397"/><rdf:li rdf:resource="periplus://simquery/result/hit:96"/><rdf:li rdf:resource="periplus://simquery/result/hit:5506"/></rdf:Bag><rdf:Description rdf:about="periplus://simquery/result/cluster:2"><wlr:hasNumberOfResults>25</wlr:hasNumberOfResults><wlr:isLinkedTo rdf:resource="periplus://cluster:2"/><wlr:hasScore>0.961693</wlr:hasScore><wlr:hasDescription>Du changement de statut de La Poste, il n\'a été que peu question durant la campagne des élections européennes, comme si la réforme avait pris du retard ou n\'était plus d\'actualité. Et pourtant, il n\'en est rien</wlr:hasDescription><mediaUnit xsi:type="model:Image"><wlr:hasNativeContent>http://static.mediapart.fr/files/Laurent Mauduit/Image 8_13.png</wlr:hasNativeContent></mediaUnit><dc:title>gouvernement Parti socialiste</dc:title><rdf:type rdf:resource="DocumentCluster"/></rdf:Description><rdf:Bag rdf:about="periplus://simquery/result/cluster:2"><rdf:li rdf:resource="periplus://simquery/result/hit:3844"/><rdf:li rdf:resource="periplus://simquery/result/hit:2129"/><rdf:li rdf:resource="periplus://simquery/result/hit:2441"/><rdf:li rdf:resource="periplus://simquery/result/hit:5120"/><rdf:li rdf:resource="periplus://simquery/result/hit:2501"/><rdf:li rdf:resource="periplus://simquery/result/hit:1462"/><rdf:li rdf:resource="periplus://simquery/result/hit:1797"/><rdf:li rdf:resource="periplus://simquery/result/hit:2185"/><rdf:li rdf:resource="periplus://simquery/result/hit:397"/><rdf:li rdf:resource="periplus://simquery/result/hit:1668"/><rdf:li rdf:resource="periplus://simquery/result/hit:1036"/><rdf:li rdf:resource="periplus://simquery/result/hit:1614"/><rdf:li rdf:resource="periplus://simquery/result/hit:1535"/><rdf:li rdf:resource="periplus://simquery/result/hit:1320"/><rdf:li rdf:resource="periplus://simquery/result/hit:1176"/><rdf:li rdf:resource="periplus://simquery/result/hit:1403"/><rdf:li rdf:resource="periplus://simquery/result/hit:2179"/><rdf:li rdf:resource="periplus://simquery/result/hit:1976"/><rdf:li rdf:resource="periplus://simquery/result/hit:154"/><rdf:li rdf:resource="periplus://simquery/result/hit:47"/><rdf:li rdf:resource="periplus://simquery/result/hit:347"/><rdf:li rdf:resource="periplus://simquery/result/hit:2033"/><rdf:li rdf:resource="periplus://simquery/result/hit:4698"/><rdf:li rdf:resource="periplus://simquery/result/hit:4201"/><rdf:li rdf:resource="periplus://simquery/result/hit:4545"/></rdf:Bag><rdf:Description rdf:about="periplus://simquery/result/cluster:3"><wlr:hasNumberOfResults>4</wlr:hasNumberOfResults><wlr:isLinkedTo rdf:resource="periplus://cluster:3"/><wlr:hasScore>0.936393</wlr:hasScore><wlr:hasDescription>Une bombe dort au pôle financier du tribunal de grande instance de Paris. Les juges Françoise Desset et</wlr:hasDescription><mediaUnit xsi:type="model:Image"><wlr:hasNativeContent>http://static.mediapart.fr/files/imagecache/475_pixels/Fabrice%20Arfi/article_photo_1218010950574-1-0.jpg</wlr:hasNativeContent></mediaUnit><dc:title>affaire de Karachi</dc:title><rdf:type rdf:resource="DocumentCluster"/></rdf:Description><rdf:Bag rdf:about="periplus://simquery/result/cluster:3"><rdf:li rdf:resource="periplus://simquery/result/hit:1744"/><rdf:li rdf:resource="periplus://simquery/result/hit:1745"/><rdf:li rdf:resource="periplus://simquery/result/hit:3972"/><rdf:li rdf:resource="periplus://simquery/result/hit:3973"/></rdf:Bag><rdf:Description rdf:about="periplus://simquery/result/cluster:4"><wlr:hasNumberOfResults>9</wlr:hasNumberOfResults><wlr:isLinkedTo rdf:resource="periplus://cluster:4"/><wlr:hasScore>0.928015</wlr:hasScore><wlr:hasDescription>&quot;Dans une telle campagne où les petites phrases et les effets médiatiques semblent plus compter que le fond, de belles images au 20 heures ne peuvent pas faire de mal.&quot; Ce commentaire d\'un dirigean</wlr:hasDescription><mediaUnit xsi:type="model:Image"><wlr:hasNativeContent>http://static.mediapart.fr/files/imagecache/300_pixels/St%C3%A9phane%20Alli%C3%A8s/Image%205_5.png</wlr:hasNativeContent></mediaUnit><dc:title>campagne des européennes</dc:title><rdf:type rdf:resource="DocumentCluster"/></rdf:Description><rdf:Bag rdf:about="periplus://simquery/result/cluster:4"><rdf:li rdf:resource="periplus://simquery/result/hit:3789"/><rdf:li rdf:resource="periplus://simquery/result/hit:3556"/><rdf:li rdf:resource="periplus://simquery/result/hit:3849"/><rdf:li rdf:resource="periplus://simquery/result/hit:3802"/><rdf:li rdf:resource="periplus://simquery/result/hit:3576"/><rdf:li rdf:resource="periplus://simquery/result/hit:5753"/><rdf:li rdf:resource="periplus://simquery/result/hit:3862"/><rdf:li rdf:resource="periplus://simquery/result/hit:4341"/><rdf:li rdf:resource="periplus://simquery/result/hit:3510"/></rdf:Bag><rdf:Description rdf:about="periplus://simquery/result/cluster:5"><wlr:hasNumberOfResults>10</wlr:hasNumberOfResults><wlr:isLinkedTo rdf:resource="periplus://cluster:5"/><wlr:hasScore>0.914044</wlr:hasScore><wlr:hasDescription>L\'UMP et le PS sont des jumeaux dizygotes. Ils ne sont pas issus du même</wlr:hasDescription><mediaUnit xsi:type="model:Image"><wlr:hasNativeContent>http://static.mediapart.fr/files/imagecache/475_pixels/Marine%20Turchi/2083.jpg</wlr:hasNativeContent></mediaUnit><dc:title>UMP</dc:title><rdf:type rdf:resource="DocumentCluster"/></rdf:Description><rdf:Bag rdf:about="periplus://simquery/result/cluster:5"><rdf:li rdf:resource="periplus://simquery/result/hit:288"/><rdf:li rdf:resource="periplus://simquery/result/hit:3675"/><rdf:li rdf:resource="periplus://simquery/result/hit:3993"/><rdf:li rdf:resource="periplus://simquery/result/hit:1015"/><rdf:li rdf:resource="periplus://simquery/result/hit:3533"/><rdf:li rdf:resource="periplus://simquery/result/hit:600"/><rdf:li rdf:resource="periplus://simquery/result/hit:3200"/><rdf:li rdf:resource="periplus://simquery/result/hit:2577"/><rdf:li rdf:resource="periplus://simquery/result/hit:4823"/><rdf:li rdf:resource="periplus://simquery/result/hit:5490"/></rdf:Bag><rdf:Description rdf:about="periplus://simquery/result/cluster:6"><wlr:hasNumberOfResults>6</wlr:hasNumberOfResults><wlr:isLinkedTo rdf:resource="periplus://cluster:6"/><wlr:hasScore>0.907456</wlr:hasScore><wlr:hasDescription>Jacques Julliard, 77 ans, entre en dissidence. Figure historique de la &quot;deux</wlr:hasDescription><mediaUnit xsi:type="model:Image"><wlr:hasNativeContent>http://static.mediapart.fr/files/imagecache/250_pixels/St%C3%A9phane%20Alli%C3%A8s/julliard.png</wlr:hasNativeContent></mediaUnit><mediaUnit xsi:type="model:Image"><wlr:hasNativeContent>http://static.mediapart.fr/files/imagecache/300_pixels/Marine%20Turchi/chirac_balladur.png</wlr:hasNativeContent></mediaUnit><dc:title>livre</dc:title><rdf:type rdf:resource="DocumentCluster"/></rdf:Description><rdf:Bag rdf:about="periplus://simquery/result/cluster:6"><rdf:li rdf:resource="periplus://simquery/result/hit:5828"/><rdf:li rdf:resource="periplus://simquery/result/hit:4870"/><rdf:li rdf:resource="periplus://simquery/result/hit:5246"/><rdf:li rdf:resource="periplus://simquery/result/hit:4453"/><rdf:li rdf:resource="periplus://simquery/result/hit:4904"/><rdf:li rdf:resource="periplus://simquery/result/hit:5005"/></rdf:Bag><rdf:Description rdf:about="periplus://simquery/result/cluster:7"><wlr:hasNumberOfResults>4</wlr:hasNumberOfResults><wlr:isLinkedTo rdf:resource="periplus://cluster:7"/><wlr:hasScore>0.865421</wlr:hasScore><wlr:hasDescription>&quot;Dans quelques années nous dirons: il y a l\'UMP et il y a le Nouveau Centre&quot;, a assuré Hervé Morin, lors des voeux aux cadres de son parti, lundi 18 janvier. Chaque année, le discours est</wlr:hasDescription><mediaUnit xsi:type="model:Image"><wlr:hasNativeContent>http://static.mediapart.fr/files/Marine%20Turchi/udf.png</wlr:hasNativeContent></mediaUnit><mediaUnit xsi:type="model:Image"><wlr:hasNativeContent>http://static.mediapart.fr/files/imagecache/150_pixels/Marine%20Turchi/Dominique_villepin_1.jpg</wlr:hasNativeContent></mediaUnit><dc:title>Nouveau Centre Modem</dc:title><rdf:type rdf:resource="DocumentCluster"/></rdf:Description><rdf:Bag rdf:about="periplus://simquery/result/cluster:7"><rdf:li rdf:resource="periplus://simquery/result/hit:5351"/><rdf:li rdf:resource="periplus://simquery/result/hit:3646"/><rdf:li rdf:resource="periplus://simquery/result/hit:2361"/><rdf:li rdf:resource="periplus://simquery/result/hit:4470"/></rdf:Bag><rdf:Description rdf:about="periplus://simquery/result/cluster:8"><wlr:hasNumberOfResults>6</wlr:hasNumberOfResults><wlr:isLinkedTo rdf:resource="periplus://cluster:8"/><wlr:hasScore>0.851838</wlr:hasScore><wlr:hasDescription>En pleine panique financière, les responsables politiques retrouvent la parole. Après la réunion de crise ce </wlr:hasDescription><mediaUnit xsi:type="model:Image"><wlr:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/3883</wlr:hasNativeContent></mediaUnit><mediaUnit xsi:type="model:Image"><wlr:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/3256</wlr:hasNativeContent></mediaUnit><dc:title>panique financière</dc:title><rdf:type rdf:resource="DocumentCluster"/></rdf:Description><rdf:Bag rdf:about="periplus://simquery/result/cluster:8"><rdf:li rdf:resource="periplus://simquery/result/hit:1902"/><rdf:li rdf:resource="periplus://simquery/result/hit:5881"/><rdf:li rdf:resource="periplus://simquery/result/hit:1978"/><rdf:li rdf:resource="periplus://simquery/result/hit:1524"/><rdf:li rdf:resource="periplus://simquery/result/hit:2075"/><rdf:li rdf:resource="periplus://simquery/result/hit:487"/></rdf:Bag><rdf:Description rdf:about="periplus://simquery/result/cluster:9"><wlr:hasNumberOfResults>8</wlr:hasNumberOfResults><wlr:isLinkedTo rdf:resource="periplus://cluster:9"/><wlr:hasScore>0.95304</wlr:hasScore><wlr:hasDescription>No summary available</wlr:hasDescription><dc:title>etc.</dc:title><rdf:type rdf:resource="DocumentCluster"/></rdf:Description><rdf:Bag rdf:about="periplus://simquery/result/cluster:9"><rdf:li rdf:resource="periplus://simquery/result/hit:271"/><rdf:li rdf:resource="periplus://simquery/result/hit:1799"/><rdf:li rdf:resource="periplus://simquery/result/hit:1732"/><rdf:li rdf:resource="periplus://simquery/result/hit:4618"/><rdf:li rdf:resource="periplus://simquery/result/hit:5922"/><rdf:li rdf:resource="periplus://simquery/result/hit:5786"/><rdf:li rdf:resource="periplus://simquery/result/hit:1592"/><rdf:li rdf:resource="periplus://simquery/result/hit:2286"/></rdf:Bag><rdf:Description rdf:about="periplus://simquery/result"><wlr:hasQueryOffset>0</wlr:hasQueryOffset><wlr:hasNumberOfResults>100</wlr:hasNumberOfResults><wlr:isResultOf rdf:resource="periplus://simquery"/><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/model#ResultSet"/><wlr:hasHit rdf:resource="periplus://simquery/result/hit:3883"/><wlr:hasHit rdf:resource="periplus://simquery/result/hit:3256"/><wlr:hasHit rdf:resource="periplus://simquery/result/hit:3328"/><wlr:hasHit rdf:resource="periplus://simquery/result/hit:3844"/><wlr:hasHit rdf:resource="periplus://simquery/result/hit:271"/><wlr:hasHit rdf:resource="periplus://simquery/result/hit:1732"/><wlr:hasHit rdf:resource="periplus://simquery/result/hit:5803"/><wlr:hasHit rdf:resource="periplus://simquery/result/hit:1744"/><wlr:hasHit rdf:resource="periplus://simquery/result/hit:1745"/><wlr:hasHit rdf:resource="periplus://simquery/result/hit:96"/><wlr:hasHit rdf:resource="periplus://simquery/result/hit:4210"/><wlr:hasHit rdf:resource="periplus://simquery/result/hit:3972"/><wlr:hasHit rdf:resource="periplus://simquery/result/hit:3973"/><wlr:hasHit rdf:resource="periplus://simquery/result/hit:2475"/><wlr:hasHit rdf:resource="periplus://simquery/result/hit:3789"/><wlr:hasHit rdf:resource="periplus://simquery/result/hit:5767"/><wlr:hasHit rdf:resource="periplus://simquery/result/hit:1036"/><wlr:hasHit rdf:resource="periplus://simquery/result/hit:133"/><wlr:hasHit rdf:resource="periplus://simquery/result/hit:3675"/><wlr:hasHit rdf:resource="periplus://simquery/result/hit:5828"/><wlr:hasHit rdf:resource="periplus://simquery/result/hit:3993"/><wlr:hasHit rdf:resource="periplus://simquery/result/hit:4870"/><wlr:hasHit rdf:resource="periplus://simquery/result/hit:2156"/><wlr:hasHit rdf:resource="periplus://simquery/result/hit:3849"/><wlr:hasHit rdf:resource="periplus://simquery/result/hit:3802"/><wlr:hasHit rdf:resource="periplus://simquery/result/hit:1320"/><wlr:hasHit rdf:resource="periplus://simquery/result/hit:1015"/><wlr:hasHit rdf:resource="periplus://simquery/result/hit:4397"/><wlr:hasHit rdf:resource="periplus://simquery/result/hit:4618"/><wlr:hasHit rdf:resource="periplus://simquery/result/hit:397"/><wlr:hasHit rdf:resource="periplus://simquery/result/hit:4285"/><wlr:hasHit rdf:resource="periplus://simquery/result/hit:1668"/><wlr:hasHit rdf:resource="periplus://simquery/result/hit:2129"/><wlr:hasHit rdf:resource="periplus://simquery/result/hit:5351"/><wlr:hasHit rdf:resource="periplus://simquery/result/hit:4904"/><wlr:hasHit rdf:resource="periplus://simquery/result/hit:1797"/><wlr:hasHit rdf:resource="periplus://simquery/result/hit:1176"/><wlr:hasHit rdf:resource="periplus://simquery/result/hit:571"/><wlr:hasHit rdf:resource="periplus://simquery/result/hit:3676"/><wlr:hasHit rdf:resource="periplus://simquery/result/hit:3799"/><wlr:hasHit rdf:resource="periplus://simquery/result/hit:3646"/><wlr:hasHit rdf:resource="periplus://simquery/result/hit:1535"/><wlr:hasHit rdf:resource="periplus://simquery/result/hit:2361"/><wlr:hasHit rdf:resource="periplus://simquery/result/hit:2441"/><wlr:hasHit rdf:resource="periplus://simquery/result/hit:5005"/><wlr:hasHit rdf:resource="periplus://simquery/result/hit:3556"/><wlr:hasHit rdf:resource="periplus://simquery/result/hit:47"/><wlr:hasHit rdf:resource="periplus://simquery/result/hit:2185"/><wlr:hasHit rdf:resource="periplus://simquery/result/hit:2278"/><wlr:hasHit rdf:resource="periplus://simquery/result/hit:1902"/><wlr:hasHit rdf:resource="periplus://simquery/result/hit:288"/><wlr:hasHit rdf:resource="periplus://simquery/result/hit:1093"/><wlr:hasHit rdf:resource="periplus://simquery/result/hit:1462"/><wlr:hasHit rdf:resource="periplus://simquery/result/hit:2179"/><wlr:hasHit rdf:resource="periplus://simquery/result/hit:1403"/><wlr:hasHit rdf:resource="periplus://simquery/result/hit:2501"/><wlr:hasHit rdf:resource="periplus://simquery/result/hit:4470"/><wlr:hasHit rdf:resource="periplus://simquery/result/hit:5881"/><wlr:hasHit rdf:resource="periplus://simquery/result/hit:3533"/><wlr:hasHit rdf:resource="periplus://simquery/result/hit:1978"/><wlr:hasHit rdf:resource="periplus://simquery/result/hit:5120"/><wlr:hasHit rdf:resource="periplus://simquery/result/hit:154"/><wlr:hasHit rdf:resource="periplus://simquery/result/hit:3862"/><wlr:hasHit rdf:resource="periplus://simquery/result/hit:5246"/><wlr:hasHit rdf:resource="periplus://simquery/result/hit:5506"/><wlr:hasHit rdf:resource="periplus://simquery/result/hit:1524"/><wlr:hasHit rdf:resource="periplus://simquery/result/hit:1614"/><wlr:hasHit rdf:resource="periplus://simquery/result/hit:3576"/><wlr:hasHit rdf:resource="periplus://simquery/result/hit:5922"/><wlr:hasHit rdf:resource="periplus://simquery/result/hit:5786"/><wlr:hasHit rdf:resource="periplus://simquery/result/hit:4453"/><wlr:hasHit rdf:resource="periplus://simquery/result/hit:347"/><wlr:hasHit rdf:resource="periplus://simquery/result/hit:600"/><wlr:hasHit rdf:resource="periplus://simquery/result/hit:3200"/><wlr:hasHit rdf:resource="periplus://simquery/result/hit:4458"/><wlr:hasHit rdf:resource="periplus://simquery/result/hit:4698"/><wlr:hasHit rdf:resource="periplus://simquery/result/hit:4823"/><wlr:hasHit rdf:resource="periplus://simquery/result/hit:4272"/><wlr:hasHit rdf:resource="periplus://simquery/result/hit:2577"/><wlr:hasHit rdf:resource="periplus://simquery/result/hit:4728"/><wlr:hasHit rdf:resource="periplus://simquery/result/hit:5490"/><wlr:hasHit rdf:resource="periplus://simquery/result/hit:4341"/><wlr:hasHit rdf:resource="periplus://simquery/result/hit:2286"/><wlr:hasHit rdf:resource="periplus://simquery/result/hit:3510"/><wlr:hasHit rdf:resource="periplus://simquery/result/hit:4201"/><wlr:hasHit rdf:resource="periplus://simquery/result/hit:4545"/><wlr:hasHit rdf:resource="periplus://simquery/result/hit:4513"/><wlr:hasHit rdf:resource="periplus://simquery/result/hit:446"/><wlr:hasHit rdf:resource="periplus://simquery/result/hit:2312"/><wlr:hasHit rdf:resource="periplus://simquery/result/hit:5488"/><wlr:hasHit rdf:resource="periplus://simquery/result/hit:2075"/><wlr:hasHit rdf:resource="periplus://simquery/result/hit:487"/><wlr:hasHit rdf:resource="periplus://simquery/result/hit:1799"/><wlr:hasHit rdf:resource="periplus://simquery/result/hit:1976"/><wlr:hasHit rdf:resource="periplus://simquery/result/hit:5753"/><wlr:hasHit rdf:resource="periplus://simquery/result/hit:1592"/><wlr:hasHit rdf:resource="periplus://simquery/result/hit:1600"/><wlr:hasHit rdf:resource="periplus://simquery/result/hit:5548"/><wlr:hasHit rdf:resource="periplus://simquery/result/hit:2290"/><wlr:hasHit rdf:resource="periplus://simquery/result/hit:2033"/></rdf:Description></rdf:RDF></data></annotation><resource uri="periplus://resource:3883" xsi:type="model:Document"><annotation uri="periplus://resource:3883/annot:0"><data><rdf:RDF xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://resource:3883"><wlp:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/3883</wlp:hasNativeContent></rdf:Description></rdf:RDF></data></annotation></resource><resource uri="periplus://resource:3256" xsi:type="model:Document"><annotation uri="periplus://resource:3256/annot:0"><data><rdf:RDF xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://resource:3256"><wlp:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/3256</wlp:hasNativeContent></rdf:Description></rdf:RDF></data></annotation></resource><resource uri="periplus://resource:3328" xsi:type="model:Document"><annotation uri="periplus://resource:3328/annot:0"><data><rdf:RDF xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://resource:3328"><wlp:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/3328</wlp:hasNativeContent></rdf:Description></rdf:RDF></data></annotation></resource><resource uri="periplus://resource:3844" xsi:type="model:Document"><annotation uri="periplus://resource:3844/annot:0"><data><rdf:RDF xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://resource:3844"><wlp:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/3844</wlp:hasNativeContent></rdf:Description></rdf:RDF></data></annotation></resource><resource uri="periplus://resource:271" xsi:type="model:Document"><annotation uri="periplus://resource:271/annot:0"><data><rdf:RDF xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://resource:271"><wlp:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/271</wlp:hasNativeContent></rdf:Description></rdf:RDF></data></annotation></resource><resource uri="periplus://resource:1732" xsi:type="model:Document"><annotation uri="periplus://resource:1732/annot:0"><data><rdf:RDF xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://resource:1732"><wlp:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/1732</wlp:hasNativeContent></rdf:Description></rdf:RDF></data></annotation></resource><resource uri="periplus://resource:5803" xsi:type="model:Document"><annotation uri="periplus://resource:5803/annot:0"><data><rdf:RDF xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://resource:5803"><wlp:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/5803</wlp:hasNativeContent></rdf:Description></rdf:RDF></data></annotation></resource><resource uri="periplus://resource:1744" xsi:type="model:Document"><annotation uri="periplus://resource:1744/annot:0"><data><rdf:RDF xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://resource:1744"><wlp:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/1744</wlp:hasNativeContent></rdf:Description></rdf:RDF></data></annotation></resource><resource uri="periplus://resource:1745" xsi:type="model:Document"><annotation uri="periplus://resource:1745/annot:0"><data><rdf:RDF xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://resource:1745"><wlp:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/1745</wlp:hasNativeContent></rdf:Description></rdf:RDF></data></annotation></resource><resource uri="periplus://resource:96" xsi:type="model:Document"><annotation uri="periplus://resource:96/annot:0"><data><rdf:RDF xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://resource:96"><wlp:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/96</wlp:hasNativeContent></rdf:Description></rdf:RDF></data></annotation></resource><resource uri="periplus://resource:4210" xsi:type="model:Document"><annotation uri="periplus://resource:4210/annot:0"><data><rdf:RDF xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://resource:4210"><wlp:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/4210</wlp:hasNativeContent></rdf:Description></rdf:RDF></data></annotation></resource><resource uri="periplus://resource:3972" xsi:type="model:Document"><annotation uri="periplus://resource:3972/annot:0"><data><rdf:RDF xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://resource:3972"><wlp:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/3972</wlp:hasNativeContent></rdf:Description></rdf:RDF></data></annotation></resource><resource uri="periplus://resource:3973" xsi:type="model:Document"><annotation uri="periplus://resource:3973/annot:0"><data><rdf:RDF xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://resource:3973"><wlp:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/3973</wlp:hasNativeContent></rdf:Description></rdf:RDF></data></annotation></resource><resource uri="periplus://resource:2475" xsi:type="model:Document"><annotation uri="periplus://resource:2475/annot:0"><data><rdf:RDF xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://resource:2475"><wlp:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/2475</wlp:hasNativeContent></rdf:Description></rdf:RDF></data></annotation></resource><resource uri="periplus://resource:3789" xsi:type="model:Document"><annotation uri="periplus://resource:3789/annot:0"><data><rdf:RDF xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://resource:3789"><wlp:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/3789</wlp:hasNativeContent></rdf:Description></rdf:RDF></data></annotation></resource><resource uri="periplus://resource:5767" xsi:type="model:Document"><annotation uri="periplus://resource:5767/annot:0"><data><rdf:RDF xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://resource:5767"><wlp:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/5767</wlp:hasNativeContent></rdf:Description></rdf:RDF></data></annotation></resource><resource uri="periplus://resource:1036" xsi:type="model:Document"><annotation uri="periplus://resource:1036/annot:0"><data><rdf:RDF xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://resource:1036"><wlp:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/1036</wlp:hasNativeContent></rdf:Description></rdf:RDF></data></annotation></resource><resource uri="periplus://resource:133" xsi:type="model:Document"><annotation uri="periplus://resource:133/annot:0"><data><rdf:RDF xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://resource:133"><wlp:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/133</wlp:hasNativeContent></rdf:Description></rdf:RDF></data></annotation></resource><resource uri="periplus://resource:3675" xsi:type="model:Document"><annotation uri="periplus://resource:3675/annot:0"><data><rdf:RDF xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://resource:3675"><wlp:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/3675</wlp:hasNativeContent></rdf:Description></rdf:RDF></data></annotation></resource><resource uri="periplus://resource:5828" xsi:type="model:Document"><annotation uri="periplus://resource:5828/annot:0"><data><rdf:RDF xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://resource:5828"><wlp:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/5828</wlp:hasNativeContent></rdf:Description></rdf:RDF></data></annotation></resource><resource uri="periplus://resource:3993" xsi:type="model:Document"><annotation uri="periplus://resource:3993/annot:0"><data><rdf:RDF xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://resource:3993"><wlp:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/3993</wlp:hasNativeContent></rdf:Description></rdf:RDF></data></annotation></resource><resource uri="periplus://resource:4870" xsi:type="model:Document"><annotation uri="periplus://resource:4870/annot:0"><data><rdf:RDF xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://resource:4870"><wlp:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/4870</wlp:hasNativeContent></rdf:Description></rdf:RDF></data></annotation></resource><resource uri="periplus://resource:2156" xsi:type="model:Document"><annotation uri="periplus://resource:2156/annot:0"><data><rdf:RDF xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://resource:2156"><wlp:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/2156</wlp:hasNativeContent></rdf:Description></rdf:RDF></data></annotation></resource><resource uri="periplus://resource:3849" xsi:type="model:Document"><annotation uri="periplus://resource:3849/annot:0"><data><rdf:RDF xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://resource:3849"><wlp:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/3849</wlp:hasNativeContent></rdf:Description></rdf:RDF></data></annotation></resource><resource uri="periplus://resource:3802" xsi:type="model:Document"><annotation uri="periplus://resource:3802/annot:0"><data><rdf:RDF xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://resource:3802"><wlp:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/3802</wlp:hasNativeContent></rdf:Description></rdf:RDF></data></annotation></resource><resource uri="periplus://resource:1320" xsi:type="model:Document"><annotation uri="periplus://resource:1320/annot:0"><data><rdf:RDF xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://resource:1320"><wlp:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/1320</wlp:hasNativeContent></rdf:Description></rdf:RDF></data></annotation></resource><resource uri="periplus://resource:1015" xsi:type="model:Document"><annotation uri="periplus://resource:1015/annot:0"><data><rdf:RDF xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://resource:1015"><wlp:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/1015</wlp:hasNativeContent></rdf:Description></rdf:RDF></data></annotation></resource><resource uri="periplus://resource:4397" xsi:type="model:Document"><annotation uri="periplus://resource:4397/annot:0"><data><rdf:RDF xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://resource:4397"><wlp:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/4397</wlp:hasNativeContent></rdf:Description></rdf:RDF></data></annotation></resource><resource uri="periplus://resource:4618" xsi:type="model:Document"><annotation uri="periplus://resource:4618/annot:0"><data><rdf:RDF xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://resource:4618"><wlp:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/4618</wlp:hasNativeContent></rdf:Description></rdf:RDF></data></annotation></resource><resource uri="periplus://resource:397" xsi:type="model:Document"><annotation uri="periplus://resource:397/annot:0"><data><rdf:RDF xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://resource:397"><wlp:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/397</wlp:hasNativeContent></rdf:Description></rdf:RDF></data></annotation></resource><resource uri="periplus://resource:4285" xsi:type="model:Document"><annotation uri="periplus://resource:4285/annot:0"><data><rdf:RDF xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://resource:4285"><wlp:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/4285</wlp:hasNativeContent></rdf:Description></rdf:RDF></data></annotation></resource><resource uri="periplus://resource:1668" xsi:type="model:Document"><annotation uri="periplus://resource:1668/annot:0"><data><rdf:RDF xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://resource:1668"><wlp:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/1668</wlp:hasNativeContent></rdf:Description></rdf:RDF></data></annotation></resource><resource uri="periplus://resource:2129" xsi:type="model:Document"><annotation uri="periplus://resource:2129/annot:0"><data><rdf:RDF xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://resource:2129"><wlp:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/2129</wlp:hasNativeContent></rdf:Description></rdf:RDF></data></annotation></resource><resource uri="periplus://resource:5351" xsi:type="model:Document"><annotation uri="periplus://resource:5351/annot:0"><data><rdf:RDF xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://resource:5351"><wlp:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/5351</wlp:hasNativeContent></rdf:Description></rdf:RDF></data></annotation></resource><resource uri="periplus://resource:4904" xsi:type="model:Document"><annotation uri="periplus://resource:4904/annot:0"><data><rdf:RDF xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://resource:4904"><wlp:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/4904</wlp:hasNativeContent></rdf:Description></rdf:RDF></data></annotation></resource><resource uri="periplus://resource:1797" xsi:type="model:Document"><annotation uri="periplus://resource:1797/annot:0"><data><rdf:RDF xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://resource:1797"><wlp:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/1797</wlp:hasNativeContent></rdf:Description></rdf:RDF></data></annotation></resource><resource uri="periplus://resource:1176" xsi:type="model:Document"><annotation uri="periplus://resource:1176/annot:0"><data><rdf:RDF xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://resource:1176"><wlp:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/1176</wlp:hasNativeContent></rdf:Description></rdf:RDF></data></annotation></resource><resource uri="periplus://resource:571" xsi:type="model:Document"><annotation uri="periplus://resource:571/annot:0"><data><rdf:RDF xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://resource:571"><wlp:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/571</wlp:hasNativeContent></rdf:Description></rdf:RDF></data></annotation></resource><resource uri="periplus://resource:3676" xsi:type="model:Document"><annotation uri="periplus://resource:3676/annot:0"><data><rdf:RDF xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://resource:3676"><wlp:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/3676</wlp:hasNativeContent></rdf:Description></rdf:RDF></data></annotation></resource><resource uri="periplus://resource:3799" xsi:type="model:Document"><annotation uri="periplus://resource:3799/annot:0"><data><rdf:RDF xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://resource:3799"><wlp:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/3799</wlp:hasNativeContent></rdf:Description></rdf:RDF></data></annotation></resource><resource uri="periplus://resource:3646" xsi:type="model:Document"><annotation uri="periplus://resource:3646/annot:0"><data><rdf:RDF xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://resource:3646"><wlp:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/3646</wlp:hasNativeContent></rdf:Description></rdf:RDF></data></annotation></resource><resource uri="periplus://resource:1535" xsi:type="model:Document"><annotation uri="periplus://resource:1535/annot:0"><data><rdf:RDF xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://resource:1535"><wlp:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/1535</wlp:hasNativeContent></rdf:Description></rdf:RDF></data></annotation></resource><resource uri="periplus://resource:2361" xsi:type="model:Document"><annotation uri="periplus://resource:2361/annot:0"><data><rdf:RDF xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://resource:2361"><wlp:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/2361</wlp:hasNativeContent></rdf:Description></rdf:RDF></data></annotation></resource><resource uri="periplus://resource:2441" xsi:type="model:Document"><annotation uri="periplus://resource:2441/annot:0"><data><rdf:RDF xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://resource:2441"><wlp:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/2441</wlp:hasNativeContent></rdf:Description></rdf:RDF></data></annotation></resource><resource uri="periplus://resource:5005" xsi:type="model:Document"><annotation uri="periplus://resource:5005/annot:0"><data><rdf:RDF xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://resource:5005"><wlp:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/5005</wlp:hasNativeContent></rdf:Description></rdf:RDF></data></annotation></resource><resource uri="periplus://resource:3556" xsi:type="model:Document"><annotation uri="periplus://resource:3556/annot:0"><data><rdf:RDF xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://resource:3556"><wlp:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/3556</wlp:hasNativeContent></rdf:Description></rdf:RDF></data></annotation></resource><resource uri="periplus://resource:47" xsi:type="model:Document"><annotation uri="periplus://resource:47/annot:0"><data><rdf:RDF xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://resource:47"><wlp:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/47</wlp:hasNativeContent></rdf:Description></rdf:RDF></data></annotation></resource><resource uri="periplus://resource:2185" xsi:type="model:Document"><annotation uri="periplus://resource:2185/annot:0"><data><rdf:RDF xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://resource:2185"><wlp:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/2185</wlp:hasNativeContent></rdf:Description></rdf:RDF></data></annotation></resource><resource uri="periplus://resource:2278" xsi:type="model:Document"><annotation uri="periplus://resource:2278/annot:0"><data><rdf:RDF xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://resource:2278"><wlp:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/2278</wlp:hasNativeContent></rdf:Description></rdf:RDF></data></annotation></resource><resource uri="periplus://resource:1902" xsi:type="model:Document"><annotation uri="periplus://resource:1902/annot:0"><data><rdf:RDF xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://resource:1902"><wlp:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/1902</wlp:hasNativeContent></rdf:Description></rdf:RDF></data></annotation></resource><resource uri="periplus://resource:288" xsi:type="model:Document"><annotation uri="periplus://resource:288/annot:0"><data><rdf:RDF xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://resource:288"><wlp:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/288</wlp:hasNativeContent></rdf:Description></rdf:RDF></data></annotation></resource><resource uri="periplus://resource:1093" xsi:type="model:Document"><annotation uri="periplus://resource:1093/annot:0"><data><rdf:RDF xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://resource:1093"><wlp:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/1093</wlp:hasNativeContent></rdf:Description></rdf:RDF></data></annotation></resource><resource uri="periplus://resource:1462" xsi:type="model:Document"><annotation uri="periplus://resource:1462/annot:0"><data><rdf:RDF xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://resource:1462"><wlp:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/1462</wlp:hasNativeContent></rdf:Description></rdf:RDF></data></annotation></resource><resource uri="periplus://resource:2179" xsi:type="model:Document"><annotation uri="periplus://resource:2179/annot:0"><data><rdf:RDF xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://resource:2179"><wlp:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/2179</wlp:hasNativeContent></rdf:Description></rdf:RDF></data></annotation></resource><resource uri="periplus://resource:1403" xsi:type="model:Document"><annotation uri="periplus://resource:1403/annot:0"><data><rdf:RDF xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://resource:1403"><wlp:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/1403</wlp:hasNativeContent></rdf:Description></rdf:RDF></data></annotation></resource><resource uri="periplus://resource:2501" xsi:type="model:Document"><annotation uri="periplus://resource:2501/annot:0"><data><rdf:RDF xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://resource:2501"><wlp:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/2501</wlp:hasNativeContent></rdf:Description></rdf:RDF></data></annotation></resource><resource uri="periplus://resource:4470" xsi:type="model:Document"><annotation uri="periplus://resource:4470/annot:0"><data><rdf:RDF xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://resource:4470"><wlp:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/4470</wlp:hasNativeContent></rdf:Description></rdf:RDF></data></annotation></resource><resource uri="periplus://resource:5881" xsi:type="model:Document"><annotation uri="periplus://resource:5881/annot:0"><data><rdf:RDF xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://resource:5881"><wlp:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/5881</wlp:hasNativeContent></rdf:Description></rdf:RDF></data></annotation></resource><resource uri="periplus://resource:3533" xsi:type="model:Document"><annotation uri="periplus://resource:3533/annot:0"><data><rdf:RDF xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://resource:3533"><wlp:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/3533</wlp:hasNativeContent></rdf:Description></rdf:RDF></data></annotation></resource><resource uri="periplus://resource:1978" xsi:type="model:Document"><annotation uri="periplus://resource:1978/annot:0"><data><rdf:RDF xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://resource:1978"><wlp:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/1978</wlp:hasNativeContent></rdf:Description></rdf:RDF></data></annotation></resource><resource uri="periplus://resource:5120" xsi:type="model:Document"><annotation uri="periplus://resource:5120/annot:0"><data><rdf:RDF xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://resource:5120"><wlp:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/5120</wlp:hasNativeContent></rdf:Description></rdf:RDF></data></annotation></resource><resource uri="periplus://resource:154" xsi:type="model:Document"><annotation uri="periplus://resource:154/annot:0"><data><rdf:RDF xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://resource:154"><wlp:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/154</wlp:hasNativeContent></rdf:Description></rdf:RDF></data></annotation></resource><resource uri="periplus://resource:3862" xsi:type="model:Document"><annotation uri="periplus://resource:3862/annot:0"><data><rdf:RDF xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://resource:3862"><wlp:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/3862</wlp:hasNativeContent></rdf:Description></rdf:RDF></data></annotation></resource><resource uri="periplus://resource:5246" xsi:type="model:Document"><annotation uri="periplus://resource:5246/annot:0"><data><rdf:RDF xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://resource:5246"><wlp:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/5246</wlp:hasNativeContent></rdf:Description></rdf:RDF></data></annotation></resource><resource uri="periplus://resource:5506" xsi:type="model:Document"><annotation uri="periplus://resource:5506/annot:0"><data><rdf:RDF xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://resource:5506"><wlp:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/5506</wlp:hasNativeContent></rdf:Description></rdf:RDF></data></annotation></resource><resource uri="periplus://resource:1524" xsi:type="model:Document"><annotation uri="periplus://resource:1524/annot:0"><data><rdf:RDF xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://resource:1524"><wlp:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/1524</wlp:hasNativeContent></rdf:Description></rdf:RDF></data></annotation></resource><resource uri="periplus://resource:1614" xsi:type="model:Document"><annotation uri="periplus://resource:1614/annot:0"><data><rdf:RDF xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://resource:1614"><wlp:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/1614</wlp:hasNativeContent></rdf:Description></rdf:RDF></data></annotation></resource><resource uri="periplus://resource:3576" xsi:type="model:Document"><annotation uri="periplus://resource:3576/annot:0"><data><rdf:RDF xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://resource:3576"><wlp:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/3576</wlp:hasNativeContent></rdf:Description></rdf:RDF></data></annotation></resource><resource uri="periplus://resource:5922" xsi:type="model:Document"><annotation uri="periplus://resource:5922/annot:0"><data><rdf:RDF xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://resource:5922"><wlp:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/5922</wlp:hasNativeContent></rdf:Description></rdf:RDF></data></annotation></resource><resource uri="periplus://resource:5786" xsi:type="model:Document"><annotation uri="periplus://resource:5786/annot:0"><data><rdf:RDF xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://resource:5786"><wlp:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/5786</wlp:hasNativeContent></rdf:Description></rdf:RDF></data></annotation></resource><resource uri="periplus://resource:4453" xsi:type="model:Document"><annotation uri="periplus://resource:4453/annot:0"><data><rdf:RDF xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://resource:4453"><wlp:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/4453</wlp:hasNativeContent></rdf:Description></rdf:RDF></data></annotation></resource><resource uri="periplus://resource:347" xsi:type="model:Document"><annotation uri="periplus://resource:347/annot:0"><data><rdf:RDF xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://resource:347"><wlp:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/347</wlp:hasNativeContent></rdf:Description></rdf:RDF></data></annotation></resource><resource uri="periplus://resource:600" xsi:type="model:Document"><annotation uri="periplus://resource:600/annot:0"><data><rdf:RDF xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://resource:600"><wlp:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/600</wlp:hasNativeContent></rdf:Description></rdf:RDF></data></annotation></resource><resource uri="periplus://resource:3200" xsi:type="model:Document"><annotation uri="periplus://resource:3200/annot:0"><data><rdf:RDF xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://resource:3200"><wlp:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/3200</wlp:hasNativeContent></rdf:Description></rdf:RDF></data></annotation></resource><resource uri="periplus://resource:4458" xsi:type="model:Document"><annotation uri="periplus://resource:4458/annot:0"><data><rdf:RDF xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://resource:4458"><wlp:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/4458</wlp:hasNativeContent></rdf:Description></rdf:RDF></data></annotation></resource><resource uri="periplus://resource:4698" xsi:type="model:Document"><annotation uri="periplus://resource:4698/annot:0"><data><rdf:RDF xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://resource:4698"><wlp:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/4698</wlp:hasNativeContent></rdf:Description></rdf:RDF></data></annotation></resource><resource uri="periplus://resource:4823" xsi:type="model:Document"><annotation uri="periplus://resource:4823/annot:0"><data><rdf:RDF xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://resource:4823"><wlp:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/4823</wlp:hasNativeContent></rdf:Description></rdf:RDF></data></annotation></resource><resource uri="periplus://resource:4272" xsi:type="model:Document"><annotation uri="periplus://resource:4272/annot:0"><data><rdf:RDF xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://resource:4272"><wlp:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/4272</wlp:hasNativeContent></rdf:Description></rdf:RDF></data></annotation></resource><resource uri="periplus://resource:2577" xsi:type="model:Document"><annotation uri="periplus://resource:2577/annot:0"><data><rdf:RDF xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://resource:2577"><wlp:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/2577</wlp:hasNativeContent></rdf:Description></rdf:RDF></data></annotation></resource><resource uri="periplus://resource:4728" xsi:type="model:Document"><annotation uri="periplus://resource:4728/annot:0"><data><rdf:RDF xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://resource:4728"><wlp:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/4728</wlp:hasNativeContent></rdf:Description></rdf:RDF></data></annotation></resource><resource uri="periplus://resource:5490" xsi:type="model:Document"><annotation uri="periplus://resource:5490/annot:0"><data><rdf:RDF xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://resource:5490"><wlp:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/5490</wlp:hasNativeContent></rdf:Description></rdf:RDF></data></annotation></resource><resource uri="periplus://resource:4341" xsi:type="model:Document"><annotation uri="periplus://resource:4341/annot:0"><data><rdf:RDF xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://resource:4341"><wlp:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/4341</wlp:hasNativeContent></rdf:Description></rdf:RDF></data></annotation></resource><resource uri="periplus://resource:2286" xsi:type="model:Document"><annotation uri="periplus://resource:2286/annot:0"><data><rdf:RDF xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://resource:2286"><wlp:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/2286</wlp:hasNativeContent></rdf:Description></rdf:RDF></data></annotation></resource><resource uri="periplus://resource:3510" xsi:type="model:Document"><annotation uri="periplus://resource:3510/annot:0"><data><rdf:RDF xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://resource:3510"><wlp:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/3510</wlp:hasNativeContent></rdf:Description></rdf:RDF></data></annotation></resource><resource uri="periplus://resource:4201" xsi:type="model:Document"><annotation uri="periplus://resource:4201/annot:0"><data><rdf:RDF xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://resource:4201"><wlp:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/4201</wlp:hasNativeContent></rdf:Description></rdf:RDF></data></annotation></resource><resource uri="periplus://resource:4545" xsi:type="model:Document"><annotation uri="periplus://resource:4545/annot:0"><data><rdf:RDF xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://resource:4545"><wlp:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/4545</wlp:hasNativeContent></rdf:Description></rdf:RDF></data></annotation></resource><resource uri="periplus://resource:4513" xsi:type="model:Document"><annotation uri="periplus://resource:4513/annot:0"><data><rdf:RDF xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://resource:4513"><wlp:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/4513</wlp:hasNativeContent></rdf:Description></rdf:RDF></data></annotation></resource><resource uri="periplus://resource:446" xsi:type="model:Document"><annotation uri="periplus://resource:446/annot:0"><data><rdf:RDF xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://resource:446"><wlp:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/446</wlp:hasNativeContent></rdf:Description></rdf:RDF></data></annotation></resource><resource uri="periplus://resource:2312" xsi:type="model:Document"><annotation uri="periplus://resource:2312/annot:0"><data><rdf:RDF xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://resource:2312"><wlp:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/2312</wlp:hasNativeContent></rdf:Description></rdf:RDF></data></annotation></resource><resource uri="periplus://resource:5488" xsi:type="model:Document"><annotation uri="periplus://resource:5488/annot:0"><data><rdf:RDF xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://resource:5488"><wlp:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/5488</wlp:hasNativeContent></rdf:Description></rdf:RDF></data></annotation></resource><resource uri="periplus://resource:2075" xsi:type="model:Document"><annotation uri="periplus://resource:2075/annot:0"><data><rdf:RDF xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://resource:2075"><wlp:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/2075</wlp:hasNativeContent></rdf:Description></rdf:RDF></data></annotation></resource><resource uri="periplus://resource:487" xsi:type="model:Document"><annotation uri="periplus://resource:487/annot:0"><data><rdf:RDF xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://resource:487"><wlp:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/487</wlp:hasNativeContent></rdf:Description></rdf:RDF></data></annotation></resource><resource uri="periplus://resource:1799" xsi:type="model:Document"><annotation uri="periplus://resource:1799/annot:0"><data><rdf:RDF xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://resource:1799"><wlp:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/1799</wlp:hasNativeContent></rdf:Description></rdf:RDF></data></annotation></resource><resource uri="periplus://resource:1976" xsi:type="model:Document"><annotation uri="periplus://resource:1976/annot:0"><data><rdf:RDF xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://resource:1976"><wlp:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/1976</wlp:hasNativeContent></rdf:Description></rdf:RDF></data></annotation></resource><resource uri="periplus://resource:5753" xsi:type="model:Document"><annotation uri="periplus://resource:5753/annot:0"><data><rdf:RDF xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://resource:5753"><wlp:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/5753</wlp:hasNativeContent></rdf:Description></rdf:RDF></data></annotation></resource><resource uri="periplus://resource:1592" xsi:type="model:Document"><annotation uri="periplus://resource:1592/annot:0"><data><rdf:RDF xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://resource:1592"><wlp:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/1592</wlp:hasNativeContent></rdf:Description></rdf:RDF></data></annotation></resource><resource uri="periplus://resource:1600" xsi:type="model:Document"><annotation uri="periplus://resource:1600/annot:0"><data><rdf:RDF xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://resource:1600"><wlp:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/1600</wlp:hasNativeContent></rdf:Description></rdf:RDF></data></annotation></resource><resource uri="periplus://resource:5548" xsi:type="model:Document"><annotation uri="periplus://resource:5548/annot:0"><data><rdf:RDF xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://resource:5548"><wlp:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/5548</wlp:hasNativeContent></rdf:Description></rdf:RDF></data></annotation></resource><resource uri="periplus://resource:2290" xsi:type="model:Document"><annotation uri="periplus://resource:2290/annot:0"><data><rdf:RDF xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://resource:2290"><wlp:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/2290</wlp:hasNativeContent></rdf:Description></rdf:RDF></data></annotation></resource><resource uri="periplus://resource:2033" xsi:type="model:Document"><annotation uri="periplus://resource:2033/annot:0"><data><rdf:RDF xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://resource:2033"><wlp:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/2033</wlp:hasNativeContent></rdf:Description></rdf:RDF></data></annotation></resource></resultSet></sear:searchReturn></soapenv:Body></soapenv:Envelope>'
        return res
    
    def simulate_response_v4_(self):
        '''res = '<soapenv:Envelope xmlns:soapenv="http://schemas.xmlsoap.org/soap/envelope/"><soapenv:Body><sear:searchReturn xmlns:model="http://weblab.ow2.org/core/1.2/model#" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns:sear="http://weblab.ow2.org/core/1.2/services/searcher" xmlns:soapenv="http://schemas.xmlsoap.org/soap/envelope/"><resultSet uri="periplus://simquery/result" xmlns:model="http://weblab.ow2.org/core/1.2/model#" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"><annotation uri="periplus://simquery/result/annotation"><data><rdf:RDF xmlns:wlr="http://weblab.ow2.org/core/1.2/ontology/retrieval#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://simquery/result/hit:3883"><wlr:inResultSetHit rdf:resource="periplus://simquery/result"/><wlr:isLinkedTo rdf:resource="periplus://resource:3883"/><wlr:hasDescription>Proche de S�gol�ne Royal, Fran�ois Rebsamen a un temps envisag� de faire le trait-d\'union avec les amis de Fran�ois Hollande pour renverser Martine Aubry de la direction du PS. Rentr� dans le rang, il n\'en </wlr:hasDescription><wlr:hasScore>1</wlr:hasScore><wlr:hasRank>1</wlr:hasRank><dc:identifier>42360</dc:identifier><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/hit:3256"><wlr:inResultSetHit rdf:resource="periplus://simquery/result"/><wlr:isLinkedTo rdf:resource="periplus://resource:3256"/><wlr:hasDescription>Du 16 au 22 mars, les quelque 70.000 adh�rents franciliens (rev</wlr:hasDescription><wlr:hasScore>0.970595</wlr:hasScore><wlr:hasRank>2</wlr:hasRank><dc:identifier>36313</dc:identifier><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/hit:3328"><wlr:inResultSetHit rdf:resource="periplus://simquery/result"/><wlr:isLinkedTo rdf:resource="periplus://resource:3328"/><wlr:hasDescription>Sans surprise, Val�rie P�cresse l\'a largement emport�, dimanche 22 mars, sur son coll�gue Roger Karoutchi lors de la primaire organis�e chez les militants UMP de l\'Ile-de-France. Entre le 16 et le 22 mars, 48</wlr:hasDescription><wlr:hasScore>0.970595</wlr:hasScore><wlr:hasRank>3</wlr:hasRank><dc:identifier>37060</dc:identifier><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/hit:3844"><wlr:inResultSetHit rdf:resource="periplus://simquery/result"/><wlr:isLinkedTo rdf:resource="periplus://resource:3844"/><wlr:hasDescription>Du changement de statut de La Poste, il n\'a �t� que peu question durant la campagne des �lections europ�ennes, comme si la r�forme avait pris du retard ou n\'�tait plus d\'actualit�. Et pourtant, il n\'en est rien</wlr:hasDescription><wlr:hasScore>0.961693</wlr:hasScore><wlr:hasRank>4</wlr:hasRank><dc:identifier>42059</dc:identifier><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/hit:271"><wlr:inResultSetHit rdf:resource="periplus://simquery/result"/><wlr:isLinkedTo rdf:resource="periplus://resource:271"/><wlr:hasDescription>Jeudi 27 mars, dans la soir�e, Nicolas Sarkozy a finalement promis que l\'Assembl�e nationale pourrait d�battre de sa d�cision toute fra�che d\'envoyer des soldats suppl�mentaires en Afghanistan (probablement un millier). Notifi�e la veille outre-manc</wlr:hasDescription><wlr:hasScore>0.95304</wlr:hasScore><wlr:hasRank>5</wlr:hasRank><dc:identifier>5581</dc:identifier><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/hit:1732"><wlr:inResultSetHit rdf:resource="periplus://simquery/result"/><wlr:isLinkedTo rdf:resource="periplus://resource:1732"/><wlr:hasDescription>(Si la fin de cette page s\'affiche mal, rafra�chissez votre �cran- touche F5) A l\'�poque, l\'Unita avait contest� par les armes le r�sultat favorable au MPLA, replongeant le pays dans la guerre. Le combat des deux ex-compagn</wlr:hasDescription><wlr:hasScore>0.944239</wlr:hasScore><wlr:hasRank>6</wlr:hasRank><dc:identifier>22545</dc:identifier><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/hit:5803"><wlr:inResultSetHit rdf:resource="periplus://simquery/result"/><wlr:isLinkedTo rdf:resource="periplus://resource:5803"/><wlr:hasDescription>Lot de consolation pour la droite : La Guyane basculerait. Selon des chiffres encore pro</wlr:hasDescription><wlr:hasScore>0.939834</wlr:hasScore><wlr:hasRank>7</wlr:hasRank><dc:identifier>78083</dc:identifier><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/hit:1744"><wlr:inResultSetHit rdf:resource="periplus://simquery/result"/><wlr:isLinkedTo rdf:resource="periplus://resource:1744"/><wlr:hasDescription>Une bombe dort au p�le financier du tribunal de grande instance de Paris. Les juges Fran�oise Desset et</wlr:hasDescription><wlr:hasScore>0.936393</wlr:hasScore><wlr:hasRank>8</wlr:hasRank><dc:identifier>22631</dc:identifier><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/hit:1745"><wlr:inResultSetHit rdf:resource="periplus://simquery/result"/><wlr:isLinkedTo rdf:resource="periplus://resource:1745"/><wlr:hasDescription>Une bombe dort au p�le financier du tribunal de Paris. Les juges Fran�oise Desset et</wlr:hasDescription><wlr:hasScore>0.935581</wlr:hasScore><wlr:hasRank>9</wlr:hasRank><dc:identifier>22632</dc:identifier><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/hit:96"><wlr:inResultSetHit rdf:resource="periplus://simquery/result"/><wlr:isLinkedTo rdf:resource="periplus://resource:96"/><wlr:hasDescription>C\'�tait le 18 mars 2001. Au soir du second tour des �l</wlr:hasDescription><wlr:hasScore>0.930653</wlr:hasScore><wlr:hasRank>10</wlr:hasRank><dc:identifier>423</dc:identifier><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/hit:4210"><wlr:inResultSetHit rdf:resource="periplus://simquery/result"/><wlr:isLinkedTo rdf:resource="periplus://resource:4210"/><wlr:hasDescription>L\'�change �pistolaire entre Martine Aubry et Manuel Valls a ouvert la comp�tition des �gos au PS. Mais la pr�sidente de la r�gi</wlr:hasDescription><wlr:hasScore>0.930653</wlr:hasScore><wlr:hasRank>11</wlr:hasRank><dc:identifier>45247</dc:identifier><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/hit:3972"><wlr:inResultSetHit rdf:resource="periplus://simquery/result"/><wlr:isLinkedTo rdf:resource="periplus://resource:3972"/><wlr:hasDescription>L\'affaire de Karachi qui pr�occupe au plus haut sommet de l\'Etat est apparue au d�tour d\'une enqu�te purement financi�re, qui rec�le potentiellement en elle-m�me d\'autres scandales d\'Etat, largement �voqu�s par Mediapart voil� d�j� neuf mois. Les juges du p�le financier p</wlr:hasDescription><wlr:hasScore>0.930406</wlr:hasScore><wlr:hasRank>12</wlr:hasRank><dc:identifier>43103</dc:identifier><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/hit:3973"><wlr:inResultSetHit rdf:resource="periplus://simquery/result"/><wlr:isLinkedTo rdf:resource="periplus://resource:3973"/><wlr:hasDescription>L\'affaire de Karachi qui pr�occupe au plus haut sommet de l\'Etat est apparue au d�tour d\'une enqu�te purement financi�re, qui rec�le potentiellement en elle-m�me d\'autres scandales d\'Etat, largement �voqu�s par Mediapart voil� d�j� neuf mois. Les juges du p�le financier p</wlr:hasDescription><wlr:hasScore>0.930406</wlr:hasScore><wlr:hasRank>13</wlr:hasRank><dc:identifier>43104</dc:identifier><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/hit:2475"><wlr:inResultSetHit rdf:resource="periplus://simquery/result"/><wlr:isLinkedTo rdf:resource="periplus://resource:2475"/><wlr:hasDescription>Mardi 2 d�cembre, dans un sous-sol de l\'Assembl�e nationale, Martine Aubry a d�livr� une feuille de route toute fra�che aux d�put�s socialistes. &quot;On red�marre, on est en marc</wlr:hasDescription><wlr:hasScore>0.928015</wlr:hasScore><wlr:hasRank>14</wlr:hasRank><dc:identifier>28930</dc:identifier><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/hit:3789"><wlr:inResultSetHit rdf:resource="periplus://simquery/result"/><wlr:isLinkedTo rdf:resource="periplus://resource:3789"/><wlr:hasDescription>&quot;Dans une telle campagne o� les petites phrases et les effets m�diatiques semblent plus compter que le fond, de belles images au 20 heures ne peuvent pas faire de mal.&quot; Ce commentaire d\'un dirigean</wlr:hasDescription><wlr:hasScore>0.928015</wlr:hasScore><wlr:hasRank>15</wlr:hasRank><dc:identifier>41525</dc:identifier><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/hit:5767"><wlr:inResultSetHit rdf:resource="periplus://simquery/result"/><wlr:isLinkedTo rdf:resource="periplus://resource:5767"/><wlr:hasDescription>Elle n\'est pas encore la plus chouette du monde, mais la gauche fran�aise a au moins �vit� d\'�tre la plus b�te, au moment de discuter unit� avant le second tour des r�gionales. Mardi � 18h, dix-huit listes </wlr:hasDescription><wlr:hasScore>0.927953</wlr:hasScore><wlr:hasRank>16</wlr:hasRank><dc:identifier>77730</dc:identifier><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/hit:1036"><wlr:inResultSetHit rdf:resource="periplus://simquery/result"/><wlr:isLinkedTo rdf:resource="periplus://resource:1036"/><wlr:hasDescription>N\'en doutons pas, la semaine sociale sera � la contestation tous azimuts et, si le sujet n\'�tait pas grave et s�rieux, un esprit malicieux pourrait voir dans ce tintamarre une nouvelle expression des contradictions fran�aises. A nouveau se pose le probl�me</wlr:hasDescription><wlr:hasScore>0.926465</wlr:hasScore><wlr:hasRank>17</wlr:hasRank><dc:identifier>16313</dc:identifier><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/hit:133"><wlr:inResultSetHit rdf:resource="periplus://simquery/result"/><wlr:isLinkedTo rdf:resource="periplus://resource:133"/><wlr:hasDescription>Face au pouvoir central incarn� par le sarkozysme et ses d�pendances, s\'installe un contre-pouvoir territorial port� par le socialisme et ses associ�s. La France est &quot; coup�e en deu</wlr:hasDescription><wlr:hasScore>0.924092</wlr:hasScore><wlr:hasRank>18</wlr:hasRank><dc:identifier>603</dc:identifier><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/hit:3675"><wlr:inResultSetHit rdf:resource="periplus://simquery/result"/><wlr:isLinkedTo rdf:resource="periplus://resource:3675"/><wlr:hasDescription>Il faudra songer � remercier Nicolas Sarkozy. Sa pratique du pouvoir, sa ge</wlr:hasDescription><wlr:hasScore>0.914044</wlr:hasScore><wlr:hasRank>19</wlr:hasRank><dc:identifier>40407</dc:identifier><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/hit:5828"><wlr:inResultSetHit rdf:resource="periplus://simquery/result"/><wlr:isLinkedTo rdf:resource="periplus://resource:5828"/><wlr:hasDescription>Jacques Julliard, 77 ans, entre en dissidence. Figure historique de la &quot;deux</wlr:hasDescription><wlr:hasScore>0.907456</wlr:hasScore><wlr:hasRank>20</wlr:hasRank><dc:identifier>78268</dc:identifier><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/hit:3993"><wlr:inResultSetHit rdf:resource="periplus://simquery/result"/><wlr:isLinkedTo rdf:resource="periplus://resource:3993"/><wlr:hasDescription>&quot;Vive la France !&quot; Apr�s quarante minutes, Nicolas Sarkozy en a termin� avec son &quot;grand&quot; discours du Congr�s. Sous les applaudissements - p</wlr:hasDescription><wlr:hasScore>0.898695</wlr:hasScore><wlr:hasRank>21</wlr:hasRank><dc:identifier>43349</dc:identifier><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/hit:4870"><wlr:inResultSetHit rdf:resource="periplus://simquery/result"/><wlr:isLinkedTo rdf:resource="periplus://resource:4870"/><wlr:hasDescription>Mais pas question pour l\'ancien pr�sident de se faire pi�ger � l\'antenne sur les affaires de la mairie de Paris, qui vont donc �tre jug�es: l\'op�ration de communication a �t� soigneusement pr�par�e, avec une promotion restreinte, en terrain connu : un hebdomadaire (Le Point sort les bonnes feuilles mercredi), un quotidien (Le Figaro aura les honneurs d\'une interview jeudi), une radio (Europe 1, au micro de Jean-Pierre Elkabbach), et une t�l�vision (il sera l\'invit� de Michel Drucker dans &quot;Vivement Dimanche&quot;, sur France 2, le 29 novembre). Le livre a �t� envoy� au com</wlr:hasDescription><wlr:hasScore>0.895167</wlr:hasScore><wlr:hasRank>22</wlr:hasRank><dc:identifier>67685</dc:identifier><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/hit:2156"><wlr:inResultSetHit rdf:resource="periplus://simquery/result"/><wlr:isLinkedTo rdf:resource="periplus://resource:2156"/><wlr:hasDescription>Les d�bats s\'encha�nent au PS, sans que les �quilibres internes ne paraissent �voluer. L\'incertitude persiste, aucun</wlr:hasDescription><wlr:hasScore>0.886579</wlr:hasScore><wlr:hasRank>23</wlr:hasRank><dc:identifier>26098</dc:identifier><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/hit:3849"><wlr:inResultSetHit rdf:resource="periplus://simquery/result"/><wlr:isLinkedTo rdf:resource="periplus://resource:3849"/><wlr:hasDescription>&quot;Celui qui gagne, c\'est celui qui arrive en t�te&quot;, a rappel� Xavier Bertrand, le secr�taire g�n�ral de l\'UMP, lors du dernier meeting europ�en de la majorit�, jeudi soir, porte de Versailles, � Paris (lire notre article). On le sait d�j�, dimanche soi</wlr:hasDescription><wlr:hasScore>0.885014</wlr:hasScore><wlr:hasRank>24</wlr:hasRank><dc:identifier>42094</dc:identifier><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/hit:3802"><wlr:inResultSetHit rdf:resource="periplus://simquery/result"/><wlr:isLinkedTo rdf:resource="periplus://resource:3802"/><wlr:hasDescription>Eparpiller les europ�ennes fa�on puzzle, pour mieux les neutraliser : gaullistes et socialistes l\'avaient r�v�, le giscardien Raffarin l\'a fait. Le proc�s �tait instruit depu</wlr:hasDescription><wlr:hasScore>0.881176</wlr:hasScore><wlr:hasRank>25</wlr:hasRank><dc:identifier>41650</dc:identifier><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/hit:1320"><wlr:inResultSetHit rdf:resource="periplus://simquery/result"/><wlr:isLinkedTo rdf:resource="periplus://resource:1320"/><wlr:hasDescription>&quot;Nous h�sitions entre le non et le non; ce sera non&quot;, a ironis� le s�nateur socialiste Bernard Frimat, mercredi 16 juillet, en r�ponse � l\'interview de Nicolas Sarkozy sur la r�forme des institutions, annon�ant in extremis dans Le Monde quelques initiatives en faveur des droits de l\'opposition. Ces d�clarations pr�sidentiel</wlr:hasDescription><wlr:hasScore>0.878407</wlr:hasScore><wlr:hasRank>26</wlr:hasRank><dc:identifier>18705</dc:identifier><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/hit:1015"><wlr:inResultSetHit rdf:resource="periplus://simquery/result"/><wlr:isLinkedTo rdf:resource="periplus://resource:1015"/><wlr:hasDescription>Jeudi soir, sur le plateau d\'&quot;A vous de juger&quot;, sur France 2, la photo de famille de l\'UMP �tait parfaite. Derri�re Fran�ois Fillon, inv</wlr:hasDescription><wlr:hasScore>0.871634</wlr:hasScore><wlr:hasRank>27</wlr:hasRank><dc:identifier>16105</dc:identifier><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/hit:4397"><wlr:inResultSetHit rdf:resource="periplus://simquery/result"/><wlr:isLinkedTo rdf:resource="periplus://resource:4397"/><wlr:hasDescription>L\'alliance est de circonstances mais elle contraint la premi�re secr�taire � r�agir. Eparpill�e depuis quelques mo</wlr:hasDescription><wlr:hasScore>0.869736</wlr:hasScore><wlr:hasRank>28</wlr:hasRank><dc:identifier>49377</dc:identifier><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/hit:4618"><wlr:inResultSetHit rdf:resource="periplus://simquery/result"/><wlr:isLinkedTo rdf:resource="periplus://resource:4618"/><wlr:hasDescription>Une fois de plus, Nicolas Sarkozy a profit� d\'une tribune internationale - en l\'occurrence l\'assembl�e g�n�rale annuelle des Nations unies � New York - pour tenir un langage extr�mement ferme � l\'attention de l\'Iran. Mais, alors que le pr�sident </wlr:hasDescription><wlr:hasScore>0.868531</wlr:hasScore><wlr:hasRank>29</wlr:hasRank><dc:identifier>59562</dc:identifier><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/hit:397"><wlr:inResultSetHit rdf:resource="periplus://simquery/result"/><wlr:isLinkedTo rdf:resource="periplus://resource:397"/><wlr:hasDescription>Les &quot; r�formistes &quot; les plus cons�quents � gauche ne sont pas toujours ceux que l\'on croit. Les premi�res r�actions autou</wlr:hasDescription><wlr:hasScore>0.867952</wlr:hasScore><wlr:hasRank>30</wlr:hasRank><dc:identifier>10623</dc:identifier><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/hit:4285"><wlr:inResultSetHit rdf:resource="periplus://simquery/result"/><wlr:isLinkedTo rdf:resource="periplus://resource:4285"/><wlr:hasDescription>Deuxi�me volet de notre enqu�te sur les raisons de la crise du parti socialiste et les relations qu\'il entretient avec les milieux de la recherche (vous pouvez lire le premier volet en cliquant ici). Mediapart a voulu interroger </wlr:hasDescription><wlr:hasScore>0.867451</wlr:hasScore><wlr:hasRank>31</wlr:hasRank><dc:identifier>45812</dc:identifier><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/hit:1668"><wlr:inResultSetHit rdf:resource="periplus://simquery/result"/><wlr:isLinkedTo rdf:resource="periplus://resource:1668"/><wlr:hasDescription>Quand personne ne croyait trop que le RSA aboutirait, il faisait l\'objet de rares d�bats. Tant qu\'il s\'exp�rimentait da</wlr:hasDescription><wlr:hasScore>0.865544</wlr:hasScore><wlr:hasRank>32</wlr:hasRank><dc:identifier>21885</dc:identifier><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/hit:2129"><wlr:inResultSetHit rdf:resource="periplus://simquery/result"/><wlr:isLinkedTo rdf:resource="periplus://resource:2129"/><wlr:hasDescription>Edouard Balladur r�pondait, mercredi 22 octobre, sur le gravier de l\'Elys�e � quelques questions sur les objectifs et le programme de la nouvelle mission que venait de lui confier Nicolas Sarkozy. Quelques minutes plus t�t, le</wlr:hasDescription><wlr:hasScore>0.865544</wlr:hasScore><wlr:hasRank>33</wlr:hasRank><dc:identifier>25866</dc:identifier><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/hit:5351"><wlr:inResultSetHit rdf:resource="periplus://simquery/result"/><wlr:isLinkedTo rdf:resource="periplus://resource:5351"/><wlr:hasDescription>&quot;Dans quelques ann�es nous dirons: il y a l\'UMP et il y a le Nouveau Centre&quot;, a assur� Herv� Morin, lors des v\339ux aux cadres de son parti, lundi 18 janvier. Chaque ann�e, le discours est</wlr:hasDescription><wlr:hasScore>0.865421</wlr:hasScore><wlr:hasRank>34</wlr:hasRank><dc:identifier>72565</dc:identifier><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/hit:4904"><wlr:inResultSetHit rdf:resource="periplus://simquery/result"/><wlr:isLinkedTo rdf:resource="periplus://resource:4904"/><wlr:hasDescription>Fran�ois Hollande fait le bilan. Dans un livre d\'entretien ave</wlr:hasDescription><wlr:hasScore>0.86539</wlr:hasScore><wlr:hasRank>35</wlr:hasRank><dc:identifier>67950</dc:identifier><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/hit:1797"><wlr:inResultSetHit rdf:resource="periplus://simquery/result"/><wlr:isLinkedTo rdf:resource="periplus://resource:1797"/><wlr:hasDescription>Le fichage politique en France, c\'est fini ! C\'est du moins la promesse lanc�e par la ministre de l\'int�rieur, devant l\'Assembl�e nationale. Au gr� d\'une r��criture compl</wlr:hasDescription><wlr:hasScore>0.865269</wlr:hasScore><wlr:hasRank>36</wlr:hasRank><dc:identifier>23106</dc:identifier><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/hit:1176"><wlr:inResultSetHit rdf:resource="periplus://simquery/result"/><wlr:isLinkedTo rdf:resource="periplus://resource:1176"/><wlr:hasDescription>Les parlementaires UMP, jusqu\'ici divis�s sur la r�forme des institutions, semblent avoir d�nich� un compromis sur le \&quot;dossier turc\&quot;, valid� mardi 1er juillet par Fran�ois Fillon. Les s�nateurs, r�vuls�s � l\'i</wlr:hasDescription><wlr:hasScore>0.865142</wlr:hasScore><wlr:hasRank>37</wlr:hasRank><dc:identifier>17508</dc:identifier><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/hit:571"><wlr:inResultSetHit rdf:resource="periplus://simquery/result"/><wlr:isLinkedTo rdf:resource="periplus://resource:571"/><wlr:hasDescription>Avocat, Jean-Pierre Mignard est pr�sident de l\'association D�sirs d\'avenir depuis novembre 2007. Vieil ami de Fran�ois Holland</wlr:hasDescription><wlr:hasScore>0.860128</wlr:hasScore><wlr:hasRank>38</wlr:hasRank><dc:identifier>12169</dc:identifier><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/hit:3676"><wlr:inResultSetHit rdf:resource="periplus://simquery/result"/><wlr:isLinkedTo rdf:resource="periplus://resource:3676"/><wlr:hasDescription>Comme un mauvais moment � passer. Depuis son entr�e en campagne</wlr:hasDescription><wlr:hasScore>0.858979</wlr:hasScore><wlr:hasRank>39</wlr:hasRank><dc:identifier>40411</dc:identifier><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/hit:3799"><wlr:inResultSetHit rdf:resource="periplus://simquery/result"/><wlr:isLinkedTo rdf:resource="periplus://resource:3799"/><wlr:hasDescription>Une porcelaine (d\'une entreprise viennoise en difficult�) contre une statue africaine (de &quot;femme debout&quot;). Par cet �change de cadeaux, M</wlr:hasDescription><wlr:hasScore>0.858373</wlr:hasScore><wlr:hasRank>40</wlr:hasRank><dc:identifier>41634</dc:identifier><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/hit:3646"><wlr:inResultSetHit rdf:resource="periplus://simquery/result"/><wlr:isLinkedTo rdf:resource="periplus://resource:3646"/><wlr:hasDescription>Il a recueilli plus de 18% des voix au premier tour de l\'�lection pr�sidentielle de 2007. Les sondages le cr�ditent de </wlr:hasDescription><wlr:hasScore>0.858245</wlr:hasScore><wlr:hasRank>41</wlr:hasRank><dc:identifier>40117</dc:identifier><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/hit:1535"><wlr:inResultSetHit rdf:resource="periplus://simquery/result"/><wlr:isLinkedTo rdf:resource="periplus://resource:1535"/><wlr:hasDescription>Nicolas Sarkozy et le gouvernement ont-t-ils bien per�u ce qui s\'est jou� dans l\'environnement international? A lire les discours, � observer les d�cisions, la question se posait depuis un an ; la publication par l\'Insee du recul de 0,3% du PIB au deuxi�me trimestre et de la destruction de 12.000 emplois, avec les r�action</wlr:hasDescription><wlr:hasScore>0.856629</wlr:hasScore><wlr:hasRank>42</wlr:hasRank><dc:identifier>20563</dc:identifier><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/hit:2361"><wlr:inResultSetHit rdf:resource="periplus://simquery/result"/><wlr:isLinkedTo rdf:resource="periplus://resource:2361"/><wlr:hasDescription>A la veille de l\'�lection du nouveau premier secr�taire socialiste, on n\'a jamais autant parl�\8230 du MoDem. Mardi, interrog�e sur France </wlr:hasDescription><wlr:hasScore>0.856416</wlr:hasScore><wlr:hasRank>43</wlr:hasRank><dc:identifier>28041</dc:identifier><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/hit:2441"><wlr:inResultSetHit rdf:resource="periplus://simquery/result"/><wlr:isLinkedTo rdf:resource="periplus://resource:2441"/><wlr:hasDescription>A Paris, l\'UMP a des airs de parti socialiste, en cette p�riode de renouvellement de la f�d�ration. La semaine pass�e, les adh�re</wlr:hasDescription><wlr:hasScore>0.854737</wlr:hasScore><wlr:hasRank>44</wlr:hasRank><dc:identifier>28692</dc:identifier><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/hit:5005"><wlr:inResultSetHit rdf:resource="periplus://simquery/result"/><wlr:isLinkedTo rdf:resource="periplus://resource:5005"/><wlr:hasDescription>La droite a longtemps d�test� les panth�onisations. En 1908, celle de Zola fit de</wlr:hasDescription><wlr:hasScore>0.854737</wlr:hasScore><wlr:hasRank>45</wlr:hasRank><dc:identifier>69111</dc:identifier><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/hit:3556"><wlr:inResultSetHit rdf:resource="periplus://simquery/result"/><wlr:isLinkedTo rdf:resource="periplus://resource:3556"/><wlr:hasDescription>Martine Aubry en avait sans doute r�v�, Poul Nyrup Rasmussen l\'a fait. Le parti socialiste a enfin r</wlr:hasDescription><wlr:hasScore>0.854005</wlr:hasScore><wlr:hasRank>46</wlr:hasRank><dc:identifier>39274</dc:identifier><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/hit:47"><wlr:inResultSetHit rdf:resource="periplus://simquery/result"/><wlr:isLinkedTo rdf:resource="periplus://resource:47"/><wlr:hasDescription>C\'est assur�ment une crise atypique que traverse, en France, la presse quotidienne. Irruption de la gratuit� et d</wlr:hasDescription><wlr:hasScore>0.853189</wlr:hasScore><wlr:hasRank>47</wlr:hasRank><dc:identifier>200</dc:identifier><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/hit:2185"><wlr:inResultSetHit rdf:resource="periplus://simquery/result"/><wlr:isLinkedTo rdf:resource="periplus://resource:2185"/><wlr:hasDescription>Il y a peu, les &quot;carnets noirs&quot; d\'Yves Bertrand et le fichier Edvige ravivaient le spectre de la police secr�te. Dans le m�me temps, un servic</wlr:hasDescription><wlr:hasScore>0.852803</wlr:hasScore><wlr:hasRank>48</wlr:hasRank><dc:identifier>26509</dc:identifier><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/hit:2278"><wlr:inResultSetHit rdf:resource="periplus://simquery/result"/><wlr:isLinkedTo rdf:resource="periplus://resource:2278"/><wlr:hasDescription>Les grands esprits socialistes se sont repos�s, au lendemain d\'une longue nuit �lectorale. Si S�gol�ne Royal arrive en t</wlr:hasDescription><wlr:hasScore>0.85201</wlr:hasScore><wlr:hasRank>49</wlr:hasRank><dc:identifier>27180</dc:identifier><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/hit:1902"><wlr:inResultSetHit rdf:resource="periplus://simquery/result"/><wlr:isLinkedTo rdf:resource="periplus://resource:1902"/><wlr:hasDescription>En pleine panique financi�re, les responsables politiques retrouvent la parole. Apr�s la r�union de crise ce </wlr:hasDescription><wlr:hasScore>0.851838</wlr:hasScore><wlr:hasRank>50</wlr:hasRank><dc:identifier>23938</dc:identifier><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/hit:288"><wlr:inResultSetHit rdf:resource="periplus://simquery/result"/><wlr:isLinkedTo rdf:resource="periplus://resource:288"/><wlr:hasDescription>L\'UMP et le PS sont des jumeaux dizygotes. Ils ne sont pas issus du m�me</wlr:hasDescription><wlr:hasScore>0.848327</wlr:hasScore><wlr:hasRank>51</wlr:hasRank><dc:identifier>9624</dc:identifier><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/hit:1093"><wlr:inResultSetHit rdf:resource="periplus://simquery/result"/><wlr:isLinkedTo rdf:resource="periplus://resource:1093"/><wlr:hasDescription>Il dit vouloir rendre des comptes, d�montrer combien les d�put�s socialistes se sont montr�s utiles depuis un an au Palais-Bourbon. Jean-Marc Ayrault organisera </wlr:hasDescription><wlr:hasScore>0.847377</wlr:hasScore><wlr:hasRank>52</wlr:hasRank><dc:identifier>16697</dc:identifier><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/hit:1462"><wlr:inResultSetHit rdf:resource="periplus://simquery/result"/><wlr:isLinkedTo rdf:resource="periplus://resource:1462"/><wlr:hasDescription>Les ministres sont partis en vacances mais il en est rest� un, le porte-parole du gouvernement, Luc Chatel, pour faire le service apr�s-vente des lois en cascade vot�es par le Parlement depuis un an. &quot;De grandes batailles id�olog</wlr:hasDescription><wlr:hasScore>0.847377</wlr:hasScore><wlr:hasRank>53</wlr:hasRank><dc:identifier>19657</dc:identifier><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/hit:2179"><wlr:inResultSetHit rdf:resource="periplus://simquery/result"/><wlr:isLinkedTo rdf:resource="periplus://resource:2179"/><wlr:hasDescription>Sit�t que l\'on a su que le taux de r�mun�ration du Livret A allait baisser le 1er f�vrier prochain, de 4% actuellement � sans doute 3,5% et peut-�tre m�me 3%, cela a �t� un v�ritable tir de barrage. Comprenant qu\'en pleine tourm</wlr:hasDescription><wlr:hasScore>0.847377</wlr:hasScore><wlr:hasRank>54</wlr:hasRank><dc:identifier>26409</dc:identifier><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/hit:1403"><wlr:inResultSetHit rdf:resource="periplus://simquery/result"/><wlr:isLinkedTo rdf:resource="periplus://resource:1403"/><wlr:hasDescription>La \&quot;nouvelle\&quot; Constitution, parue jeudi 24 juillet au Journal officiel, fait litt�ralement jubiler Jean-Fran�ois Cop�. (T�l�chargez ici le calendri</wlr:hasDescription><wlr:hasScore>0.845198</wlr:hasScore><wlr:hasRank>55</wlr:hasRank><dc:identifier>19199</dc:identifier><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/hit:2501"><wlr:inResultSetHit rdf:resource="periplus://simquery/result"/><wlr:isLinkedTo rdf:resource="periplus://resource:2501"/><wlr:hasDescription>Jeudi 4 d�cembre, l\'Assembl�e nationale est entr�e dans le vif du sujet, en adoptant deux mesures cl�s du projet de loi sur l\'audiovisuel public, qui pr�voient la d�signation et la r�vocation par le chef de l\'Etat des patrons de France T�l�visions, de Radio France et d\'AEF (la holding regroupant France 24, RFI et TV5 Monde). Sur l\'article 8 (fixant le pr</wlr:hasDescription><wlr:hasScore>0.845198</wlr:hasScore><wlr:hasRank>56</wlr:hasRank><dc:identifier>29095</dc:identifier><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/hit:4470"><wlr:inResultSetHit rdf:resource="periplus://simquery/result"/><wlr:isLinkedTo rdf:resource="periplus://resource:4470"/><wlr:hasDescription>De notre envoy�e sp�ciale � La Grande-Motte  Pour �viter qu\'�cologistes et socialistes fassent une OPA sur le Modem, sorti tr�s affaibli des �lections europ�ennes, Bayrou leur a lanc� une &quot;offre publique de dialogue&quot;, dimanche 6 septembre, en cl�ture de l\'universit� d\'�t� du mouvement, organis�e � La Grande-Motte. Par son discours, il a sign� </wlr:hasDescription><wlr:hasScore>0.844449</wlr:hasScore><wlr:hasRank>57</wlr:hasRank><dc:identifier>53657</dc:identifier><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/hit:5881"><wlr:inResultSetHit rdf:resource="periplus://simquery/result"/><wlr:isLinkedTo rdf:resource="periplus://resource:5881"/><wlr:hasDescription>&quot;Je ne rentre pas au gouvernement dans les meilleures conditions, ni de popularit�, ni de finances publiques&quot;, a reconnu le nouveau ministre du budget, sur Europe1, jeudi matin. Il aurait pu ajouter: &quot;ni de </wlr:hasDescription><wlr:hasScore>0.842533</wlr:hasScore><wlr:hasRank>58</wlr:hasRank><dc:identifier>78812</dc:identifier><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/hit:3533"><wlr:inResultSetHit rdf:resource="periplus://simquery/result"/><wlr:isLinkedTo rdf:resource="periplus://resource:3533"/><wlr:hasDescription>A l\'Elys�e, on affirme que Dominique de Villepin ne fait pas peur. On pr�tend m�me qu\'il n\'a qu\'</wlr:hasDescription><wlr:hasScore>0.84111</wlr:hasScore><wlr:hasRank>59</wlr:hasRank><dc:identifier>39104</dc:identifier><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/hit:1978"><wlr:inResultSetHit rdf:resource="periplus://simquery/result"/><wlr:isLinkedTo rdf:resource="periplus://resource:1978"/><wlr:hasDescription>Aucune faillite retentissante, pas d\'annonce de menaces suppl�mentaires sur l\'�conomie malgr� les prix de l\'immobilier qui commencent � chuter et l\'Islande qui se liqu�fie. A Paris notamment, les march�</wlr:hasDescription><wlr:hasScore>0.837822</wlr:hasScore><wlr:hasRank>60</wlr:hasRank><dc:identifier>24554</dc:identifier><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/hit:5120"><wlr:inResultSetHit rdf:resource="periplus://simquery/result"/><wlr:isLinkedTo rdf:resource="periplus://resource:5120"/><wlr:hasDescription>Des �lus qui claquent la porte de l\'UMP, des conseillers qui quittent sur la pointe des pieds l\'Elys�e... Les annonces de ce lundi 7 </wlr:hasDescription><wlr:hasScore>0.837822</wlr:hasScore><wlr:hasRank>61</wlr:hasRank><dc:identifier>70129</dc:identifier><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/hit:154"><wlr:inResultSetHit rdf:resource="periplus://simquery/result"/><wlr:isLinkedTo rdf:resource="periplus://resource:154"/><wlr:hasDescription>Face au pouvoir central incarn� par le sarkozysme et ses d�pendances, s\'installe un contre-pouvoir territorial port� par le socialisme et ses associ�s. La France est &quot; coup�e en deu</wlr:hasDescription><wlr:hasScore>0.837729</wlr:hasScore><wlr:hasRank>62</wlr:hasRank><dc:identifier>748</dc:identifier><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/hit:3862"><wlr:inResultSetHit rdf:resource="periplus://simquery/result"/><wlr:isLinkedTo rdf:resource="periplus://resource:3862"/><wlr:hasDescription>De midi � minuit, dans la journ�e du dimanche 7 juin, la r�daction de Mediapart a tenu la chronique, minute par minute, de la journ�e �lectorale. Vous pouvez lire ci-dessous, </wlr:hasDescription><wlr:hasScore>0.836646</wlr:hasScore><wlr:hasRank>63</wlr:hasRank><dc:identifier>42258</dc:identifier><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/hit:5246"><wlr:inResultSetHit rdf:resource="periplus://simquery/result"/><wlr:isLinkedTo rdf:resource="periplus://resource:5246"/><wlr:hasDescription>&quot;Les gnomes de Francfort&quot;, par exemple, qualificatif de Jean-Pierre Chev�nement � l\'encontre des dirigeants de la Banque centrale europ�enne, gardienne du fameux trait� de &quot;MasTrique&quot;. Il y a le savoureux &quot;Le parti</wlr:hasDescription><wlr:hasScore>0.829268</wlr:hasScore><wlr:hasRank>64</wlr:hasRank><dc:identifier>71364</dc:identifier><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/hit:5506"><wlr:inResultSetHit rdf:resource="periplus://simquery/result"/><wlr:isLinkedTo rdf:resource="periplus://resource:5506"/><wlr:hasDescription>Changement express de strat�gie, n�gociations interminables pour boucler des listes, choix contest�s en Ile-de-France, affaire Clearstream qui d�chire la majorit�. A moins de deux mois du scrut</wlr:hasDescription><wlr:hasScore>0.829268</wlr:hasScore><wlr:hasRank>65</wlr:hasRank><dc:identifier>74059</dc:identifier><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/hit:1524"><wlr:inResultSetHit rdf:resource="periplus://simquery/result"/><wlr:isLinkedTo rdf:resource="periplus://resource:1524"/><wlr:hasDescription>Les autruches sortent enfin la t�te de terre. Contrairement � l\'antienne op</wlr:hasDescription><wlr:hasScore>0.827191</wlr:hasScore><wlr:hasRank>66</wlr:hasRank><dc:identifier>20496</dc:identifier><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/hit:1614"><wlr:inResultSetHit rdf:resource="periplus://simquery/result"/><wlr:isLinkedTo rdf:resource="periplus://resource:1614"/><wlr:hasDescription>Elle a la voix toute chevrotante, Monique. M�gaphone en main, cette inst</wlr:hasDescription><wlr:hasScore>0.825859</wlr:hasScore><wlr:hasRank>67</wlr:hasRank><dc:identifier>21353</dc:identifier><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/hit:3576"><wlr:inResultSetHit rdf:resource="periplus://simquery/result"/><wlr:isLinkedTo rdf:resource="periplus://resource:3576"/><wlr:hasDescription>&quot;La politique est de retour ! Ces �lections seront politiques&quot;, a pr�venu Xavier Bertrand en marge du premier meeting europ�en de l\'UMP, mardi soir, � Rueil-Malmaison (Hauts-de-Seine). Le but �tait clair : ramener </wlr:hasDescription><wlr:hasScore>0.825809</wlr:hasScore><wlr:hasRank>68</wlr:hasRank><dc:identifier>39518</dc:identifier><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/hit:5922"><wlr:inResultSetHit rdf:resource="periplus://simquery/result"/><wlr:isLinkedTo rdf:resource="periplus://resource:5922"/><wlr:hasDescription>M�me s\'il est un ami de Nicolas Sarkozy et un client d\'Alain Minc, St�phane Courbit est depuis quelque temps bien malheureux en affaires. Apr�s avoir acquis une partic</wlr:hasDescription><wlr:hasScore>0.825159</wlr:hasScore><wlr:hasRank>69</wlr:hasRank><dc:identifier>79317</dc:identifier><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/hit:5786"><wlr:inResultSetHit rdf:resource="periplus://simquery/result"/><wlr:isLinkedTo rdf:resource="periplus://resource:5786"/><wlr:hasDescription>La rumeur circule depuis quelques jours - le site internet Wansquare s\'en est fait le premier l\'�cho, et apr�s lui Le Point - et nous en avons obtenu une confirmation de tr�s bonne source: Yazid Sabeg, l\'actuel commissaire � la diversit� et � l\'�galit� des chances, devrait succ�der � Anne Lauvergeon � la t�te d\'Areva, le champion du nucl�aire fran�ais. Selon nos informations, cette</wlr:hasDescription><wlr:hasScore>0.824374</wlr:hasScore><wlr:hasRank>70</wlr:hasRank><dc:identifier>77916</dc:identifier><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/hit:4453"><wlr:inResultSetHit rdf:resource="periplus://simquery/result"/><wlr:isLinkedTo rdf:resource="periplus://resource:4453"/><wlr:hasDescription>Apr�s avoir pass� son �t� � temp�ter, mena�ant de d�missionner de la direction ou d\'en appeler aux militants pour imposer les primaires ouvertes qu\'il promeut dans un livre (Comment sauver la gauche, au Seuil, avec Olivier Ferrand), Arnaud Montebourg est finalement l\'un des grands gagnants des universit�s d\'�t� de La Rochelle. M�me si son forcing a irrit� </wlr:hasDescription><wlr:hasScore>0.824323</wlr:hasScore><wlr:hasRank>71</wlr:hasRank><dc:identifier>52502</dc:identifier><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/hit:347"><wlr:inResultSetHit rdf:resource="periplus://simquery/result"/><wlr:isLinkedTo rdf:resource="periplus://resource:347"/><wlr:hasDescription>L\'accueil de gu�rilleros des Forces arm�es r�volutionnaires en Colombie (FARC) sur le territoire fran�ais : voil� la probable clef diplomatique de la tentative de lib�ration d\'Ingrid Betancourt qui est en train de se jouer en Am�rique du Sud. L\'Elys�e a annonc�, mercredi </wlr:hasDescription><wlr:hasScore>0.823627</wlr:hasScore><wlr:hasRank>72</wlr:hasRank><dc:identifier>10057</dc:identifier><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/hit:600"><wlr:inResultSetHit rdf:resource="periplus://simquery/result"/><wlr:isLinkedTo rdf:resource="periplus://resource:600"/><wlr:hasDescription>En mati�re culturelle, le candidat � l\'�lection pr�sidentielle Nicolas Sarkozy s\'�tait limit� au strict minimum. Deux promesses saillantes, en</wlr:hasDescription><wlr:hasScore>0.823627</wlr:hasScore><wlr:hasRank>73</wlr:hasRank><dc:identifier>12369</dc:identifier><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/hit:3200"><wlr:inResultSetHit rdf:resource="periplus://simquery/result"/><wlr:isLinkedTo rdf:resource="periplus://resource:3200"/><wlr:hasDescription>&quot;Je suis quelqu\'un de souple dans mes charentaises&quot;, plaisante Val�rie P�cresse sur France Culture en f�vrier 2009, en contrepoint du fameux &quot;droit dans mes bottes&quot; d\'Alain Jupp� en pleine crise de la r�forme des retraites en 1995. Cette souplesse en chaussons </wlr:hasDescription><wlr:hasScore>0.823627</wlr:hasScore><wlr:hasRank>74</wlr:hasRank><dc:identifier>35718</dc:identifier><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/hit:4458"><wlr:inResultSetHit rdf:resource="periplus://simquery/result"/><wlr:isLinkedTo rdf:resource="periplus://resource:4458"/><wlr:hasDescription>Jean-Pierre Mignard quitte la pr�sidence de D�sirs d\'avenir d�sormais assum�e par S�gol�ne Royal elle-m�me, qui entend transformer l\'association en &quot;ONG europ�enne&quot; proche d\'une fondation type think tank, comme le pr�cise un communiqu� publi� jeudi 3 septembre. Dans un entretien � Mediapart</wlr:hasDescription><wlr:hasScore>0.823627</wlr:hasScore><wlr:hasRank>75</wlr:hasRank><dc:identifier>53147</dc:identifier><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/hit:4698"><wlr:inResultSetHit rdf:resource="periplus://simquery/result"/><wlr:isLinkedTo rdf:resource="periplus://resource:4698"/><wlr:hasDescription>Alors que la session parlementaire est � peine r�unie, que les sujets foisonnent allant des suites de la crise �conomique au colossal d�ficit budg�taire en passant par la r�forme des collectivit�s locales, quel est l\'un des tout premiers sujets que le gouvernement d�cide d\'inscrire � l\'ordre du jour de l\'Assembl�e nationale? L\'ouverture du march� des jeux en ligne et la fin du monopole de l\'Etat sur ce secteur.&quot;Nous avons pour ambition que </wlr:hasDescription><wlr:hasScore>0.823627</wlr:hasScore><wlr:hasRank>76</wlr:hasRank><dc:identifier>63657</dc:identifier><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/hit:4823"><wlr:inResultSetHit rdf:resource="periplus://simquery/result"/><wlr:isLinkedTo rdf:resource="periplus://resource:4823"/><wlr:hasDescription>&quot;Je ne dirai rien sur les �lections au PS, ce serait d�sagr�able&quot;, ironisait Jean Sarkozy, vendredi, au conseil g�n�ral des Hauts-de-Seine, lors de son discours de candidat au poste d\'administrateur de l\'Epad. A l\'UMP, on se pla�t � renvoy</wlr:hasDescription><wlr:hasScore>0.823127</wlr:hasScore><wlr:hasRank>77</wlr:hasRank><dc:identifier>67076</dc:identifier><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/hit:4272"><wlr:inResultSetHit rdf:resource="periplus://simquery/result"/><wlr:isLinkedTo rdf:resource="periplus://resource:4272"/><wlr:hasDescription>Oublions Jack Lang, Bernard-Henri L�vy et leurs impr�cations sur la mort assur�e du Parti socialiste. Laissons � Max Gallo, ancien </wlr:hasDescription><wlr:hasScore>0.822925</wlr:hasScore><wlr:hasRank>78</wlr:hasRank><dc:identifier>45740</dc:identifier><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/hit:2577"><wlr:inResultSetHit rdf:resource="periplus://simquery/result"/><wlr:isLinkedTo rdf:resource="periplus://resource:2577"/><wlr:hasDescription>Attention, un train peut en cacher un autre. L\'arriv�e de Patrick Devedjia</wlr:hasDescription><wlr:hasScore>0.819154</wlr:hasScore><wlr:hasRank>79</wlr:hasRank><dc:identifier>29621</dc:identifier><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/hit:4728"><wlr:inResultSetHit rdf:resource="periplus://simquery/result"/><wlr:isLinkedTo rdf:resource="periplus://resource:4728"/><wlr:hasDescription>L\'ex-judoka David Douillet, engag� sous les couleurs du parti pr�sidentiel, a �cras� le premier tour de l\'�lection l�gislative partielle organis�e dimanche 11 octobre, dans la 12e circonscription des Yvelines, en captant 44,2% des voix, soit le double du candidat socialiste et maire de Poissy, Fr�d�rik Bernard, qui a recueilli 21,9% des bulletins. Le candidat d\'Europe-Ecologie</wlr:hasDescription><wlr:hasScore>0.818169</wlr:hasScore><wlr:hasRank>80</wlr:hasRank><dc:identifier>65097</dc:identifier><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/hit:5490"><wlr:inResultSetHit rdf:resource="periplus://simquery/result"/><wlr:isLinkedTo rdf:resource="periplus://resource:5490"/><wlr:hasDescription>Jeudi, l\'UMP �tait plus bavarde sur la derni�re sortie du socialiste Georges Fr�che que sur la relaxe de Dominique de Villepin dans le proc�s Clearstream. Connu pour d�gainer des commu</wlr:hasDescription><wlr:hasScore>0.818169</wlr:hasScore><wlr:hasRank>81</wlr:hasRank><dc:identifier>73885</dc:identifier><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/hit:4341"><wlr:inResultSetHit rdf:resource="periplus://simquery/result"/><wlr:isLinkedTo rdf:resource="periplus://resource:4341"/><wlr:hasDescription>Plus de trois mois apr�s le revers des �lections europ�ennes, o� il a recueilli � peine 16,48%, devan�ant d\'une rien les listes Europe-Ecologie, et � quelques jours de son universit� d\'�t� de La Rochelle (28-30 ao�t), il n\'est pas certain que le parti socialiste a retrouv� confiance, s�r�nit� et coh�sion. Entre les silences de S�gol�n</wlr:hasDescription><wlr:hasScore>0.817228</wlr:hasScore><wlr:hasRank>82</wlr:hasRank><dc:identifier>46602</dc:identifier><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/hit:2286"><wlr:inResultSetHit rdf:resource="periplus://simquery/result"/><wlr:isLinkedTo rdf:resource="periplus://resource:2286"/><wlr:hasDescription>Lundi 10 novembre au matin, une d�l�gation du Cran, conseil repr�sentatif des associations noires, est re�ue � l\'Elys�e. Pas par le pr�sident, ni par </wlr:hasDescription><wlr:hasScore>0.817157</wlr:hasScore><wlr:hasRank>83</wlr:hasRank><dc:identifier>27334</dc:identifier><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/hit:3510"><wlr:inResultSetHit rdf:resource="periplus://simquery/result"/><wlr:isLinkedTo rdf:resource="periplus://resource:3510"/><wlr:hasDescription>&quot;Une caravane mobile pour montrer que l\'Europe peut mobiliser.&quot; Lundi 20 avril, le secr�tair</wlr:hasDescription><wlr:hasScore>0.817157</wlr:hasScore><wlr:hasRank>84</wlr:hasRank><dc:identifier>38947</dc:identifier><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/hit:4201"><wlr:inResultSetHit rdf:resource="periplus://simquery/result"/><wlr:isLinkedTo rdf:resource="periplus://resource:4201"/><wlr:hasDescription>Martin Hirsch a pris un coup de jeune. Tel un �tudiant cherchant un </wlr:hasDescription><wlr:hasScore>0.817157</wlr:hasScore><wlr:hasRank>85</wlr:hasRank><dc:identifier>45166</dc:identifier><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/hit:4545"><wlr:inResultSetHit rdf:resource="periplus://simquery/result"/><wlr:isLinkedTo rdf:resource="periplus://resource:4545"/><wlr:hasDescription>Il aura fallu deux ans pour que Nicolas Sarkozy fasse son mea-culpa sur les empreintes g�n�tiques r�serv�es aux �trangers souhaitant rejoindre leur famille en France. Lors d\'une rencontre � l\'�lys</wlr:hasDescription><wlr:hasScore>0.815821</wlr:hasScore><wlr:hasRank>86</wlr:hasRank><dc:identifier>56762</dc:identifier><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/hit:4513"><wlr:inResultSetHit rdf:resource="periplus://simquery/result"/><wlr:isLinkedTo rdf:resource="periplus://resource:4513"/><wlr:hasDescription>Il a �t� l\'une des stars de \8220l\'ouverture socialiste\8221 durant l\'�t�, participant aux meetings de Fran�ois Hollande (� Lorient en juin) puis de Vincent Peillon (� Marseille en ao�t). D�sormais ressorti de l\'anony</wlr:hasDescription><wlr:hasScore>0.814434</wlr:hasScore><wlr:hasRank>87</wlr:hasRank><dc:identifier>55167</dc:identifier><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/hit:446"><wlr:inResultSetHit rdf:resource="periplus://simquery/result"/><wlr:isLinkedTo rdf:resource="periplus://resource:446"/><wlr:hasDescription>L\'inusable Michel Charasse exclu du PS? La f�d�ration socialiste du Puy-de-D�me en a vot� la demande jeudi soir, � une large majorit� du conseil f�d�ral (42 voix contre 14). Mais l\'ancien ministre du Bud</wlr:hasDescription><wlr:hasScore>0.814077</wlr:hasScore><wlr:hasRank>88</wlr:hasRank><dc:identifier>11001</dc:identifier><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/hit:2312"><wlr:inResultSetHit rdf:resource="periplus://simquery/result"/><wlr:isLinkedTo rdf:resource="periplus://resource:2312"/><wlr:hasDescription>Ces derniers jours, le bruit s\'est r�pandu comme une tra�n�e de poudre dans la maison socialiste: &quot;La presse people d�barque au congr�s!&quot; Les journalistes de Voici seraient d�j� en route pour Reims, bard�s de magn�tos... Interrog�, le service de pr</wlr:hasDescription><wlr:hasScore>0.814077</wlr:hasScore><wlr:hasRank>89</wlr:hasRank><dc:identifier>27639</dc:identifier><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/hit:5488"><wlr:inResultSetHit rdf:resource="periplus://simquery/result"/><wlr:isLinkedTo rdf:resource="periplus://resource:5488"/><wlr:hasDescription>Si le parti socialiste n\'est toujours pas un long fleuve tranquille, il parvient tout de m�me � ne pas se noyer dans les eaux troubles de la division. En adoptant mardi soir une po</wlr:hasDescription><wlr:hasScore>0.814077</wlr:hasScore><wlr:hasRank>90</wlr:hasRank><dc:identifier>73823</dc:identifier><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/hit:2075"><wlr:inResultSetHit rdf:resource="periplus://simquery/result"/><wlr:isLinkedTo rdf:resource="periplus://resource:2075"/><wlr:hasDescription>La Caisse d\'�pargne, qui a r�v�l� une perte de 600 millions d\'euros dans des op�rations de march�, doit r�unir son conseil de surveillance, dimanche 19 octobre, dans l\'apr�s-midi, afin de se prononcer sur le sort de la direction et notamment celui du pr�sident du directoire de la Caisse nationale des Caisses d\'�pargne (CNCE), Charles Milhaud.Dans un entretien, publi� par</wlr:hasDescription><wlr:hasScore>0.813793</wlr:hasScore><wlr:hasRank>91</wlr:hasRank><dc:identifier>25510</dc:identifier><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/hit:487"><wlr:inResultSetHit rdf:resource="periplus://simquery/result"/><wlr:isLinkedTo rdf:resource="periplus://resource:487"/><wlr:hasDescription>Du &quot;les caisses sont vides&quot; de Nicolas Sarkozy au &quot;pays en faillite&quot; de Fran�ois Fillon, le triste �tat des finances publiques fran�aises alimente la chronique par intermittence. Mais derri�re le propos polit</wlr:hasDescription><wlr:hasScore>0.811021</wlr:hasScore><wlr:hasRank>92</wlr:hasRank><dc:identifier>11333</dc:identifier><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/hit:1799"><wlr:inResultSetHit rdf:resource="periplus://simquery/result"/><wlr:isLinkedTo rdf:resource="periplus://resource:1799"/><wlr:hasDescription>Adieu lev�es de fourches, d�versements de lisier, saccages de b�timents administratifs et autres violences � agents de la force publique : la grande agriculture fran�aise semble �tre entr�e dans l\'�re du lobbying � visage humain. Et elle a choisi pour annonce</wlr:hasDescription><wlr:hasScore>0.811021</wlr:hasScore><wlr:hasRank>93</wlr:hasRank><dc:identifier>23127</dc:identifier><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/hit:1976"><wlr:inResultSetHit rdf:resource="periplus://simquery/result"/><wlr:isLinkedTo rdf:resource="periplus://resource:1976"/><wlr:hasDescription>Mais o� est donc pass�e la gauche? Cette �poque de temp�te et de crise devrait �tre faste pour elle. Alors que le capitalisme trav</wlr:hasDescription><wlr:hasScore>0.811021</wlr:hasScore><wlr:hasRank>94</wlr:hasRank><dc:identifier>24528</dc:identifier><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/hit:5753"><wlr:inResultSetHit rdf:resource="periplus://simquery/result"/><wlr:isLinkedTo rdf:resource="periplus://resource:5753"/><wlr:hasDescription>Chez Europe Ecologie, beaucoup ne le disent qu\'� demi-mot, mais ils sont d��us: tous auraient aim� d�passer les 16% des europ�ennes de 2009. Tout juste d�barqu� de son ma</wlr:hasDescription><wlr:hasScore>0.810912</wlr:hasScore><wlr:hasRank>95</wlr:hasRank><dc:identifier>77546</dc:identifier><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/hit:1592"><wlr:inResultSetHit rdf:resource="periplus://simquery/result"/><wlr:isLinkedTo rdf:resource="periplus://resource:1592"/><wlr:hasDescription>Certains auront peut-�tre du mal � le croire, mais, � quelques heures de l\'ouverture de la Convention d�mocrate de Denver, charg�e d\'investir officiellement Barack Obama, ce dernier n\'est pas encore assur� d\'acc�der � la Maison Blanche. Les 200.000 Allemands qui lui</wlr:hasDescription><wlr:hasScore>0.810167</wlr:hasScore><wlr:hasRank>96</wlr:hasRank><dc:identifier>21133</dc:identifier><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/hit:1600"><wlr:inResultSetHit rdf:resource="periplus://simquery/result"/><wlr:isLinkedTo rdf:resource="periplus://resource:1600"/><wlr:hasDescription>On pr�te � Talleyrand ce mot: \&quot;Quand je m\'examine, je m\'inqui�te. Quand je me compare, je me ra</wlr:hasDescription><wlr:hasScore>0.804479</wlr:hasScore><wlr:hasRank>97</wlr:hasRank><dc:identifier>21227</dc:identifier><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/hit:5548"><wlr:inResultSetHit rdf:resource="periplus://simquery/result"/><wlr:isLinkedTo rdf:resource="periplus://resource:5548"/><wlr:hasDescription>De notre envoy�e sp�ciale en Paca, Ce jour-l�, en campagne sur le site nucl�aire du Tricastin, Europe Ecologie vient mesurer la radioactivit� et d�poser une gerbe de fleurs: &quot;Ci-g�t la sant� publique!&quot;... Des candidats aux r�gionale</wlr:hasDescription><wlr:hasScore>0.802372</wlr:hasScore><wlr:hasRank>98</wlr:hasRank><dc:identifier>74485</dc:identifier><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/hit:2290"><wlr:inResultSetHit rdf:resource="periplus://simquery/result"/><wlr:isLinkedTo rdf:resource="periplus://resource:2290"/><wlr:hasDescription>Difficile construction d\'alliances majoritaires, au parti socialiste. Apr�s le vote des motions et </wlr:hasDescription><wlr:hasScore>0.801553</wlr:hasScore><wlr:hasRank>99</wlr:hasRank><dc:identifier>27360</dc:identifier><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/hit:2033"><wlr:inResultSetHit rdf:resource="periplus://simquery/result"/><wlr:isLinkedTo rdf:resource="periplus://resource:2033"/><wlr:hasDescription>Soudain, un week-end, le travail du dimanche est devenu priorit� nationale. Dimanche dernier, le ministre</wlr:hasDescription><wlr:hasScore>0.801468</wlr:hasScore><wlr:hasRank>100</wlr:hasRank><dc:identifier>25201</dc:identifier><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/cluster:0"><wlr:hasNumberOfResults>19</wlr:hasNumberOfResults><wlr:isLinkedTo rdf:resource="periplus://cluster:0"/><wlr:hasScore>1</wlr:hasScore><wlr:hasDescription>Proche de S�gol�ne Royal, Fran�ois Rebsamen a un temps envisag� de faire le trait-d\'union avec les amis de Fran�ois Hollande pour renverser Martine Aubry de la direction du PS. Rentr� dans le rang</wlr:hasDescription><mediaUnit xsi:type="model:Image" uri="periplus://resource:41634/image" ><annotation uri="periplus://resource:41634/image/annot:0\" ><data><rdf:RDF xmlns:wls="http://weblab.ow2.org/core/1.2/ontology/retrieval#" xmlns:dc=\"http://purl.org/dc/elements/1.1/" xmlns:rdf=\"http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#" xmlns:wlp=http://weblab.ow2.org/core/1.2/ontology/processing#" ><rdf:Description rdf:about=periplus://resource:41634/image><dc:abstract>No description available</dc:abstract><wlp:hasNativeContent>http://static.mediapart.fr/files/imagecache/300_pixels/St%C3%A9phane%20Alli%C3%A8s/ResizedImage383255-IMG0707.JPG</wlp:hasNativeContent></rdf:Description><mediaUnit xsi:type="model:Image" uri="periplus://resource:16697/image" ><annotation uri="periplus://resource:16697/image/annot:0\" ><data><rdf:RDF xmlns:wls="http://weblab.ow2.org/core/1.2/ontology/retrieval#" xmlns:dc=\"http://purl.org/dc/elements/1.1/" xmlns:rdf=\"http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#" xmlns:wlp=http://weblab.ow2.org/core/1.2/ontology/processing#" ><rdf:Description rdf:about=periplus://resource:16697/image><dc:abstract>No description available</dc:abstract><wlp:hasNativeContent>http://static.mediapart.fr/files/Mathilde Mathieu/229180457_9db20a3f47_m.jpg</wlp:hasNativeContent></rdf:Description><dc:title>PS</dc:title><rdf:type rdf:resource="DocumentCluster"/></rdf:Description><rdf:Bag rdf:about="periplus://simquery/result/cluster:0"><rdf:li rdf:resource="periplus://simquery/result/hit:42360"/><rdf:li rdf:resource="periplus://simquery/result/hit:28930"/><rdf:li rdf:resource="periplus://simquery/result/hit:45247"/><rdf:li rdf:resource="periplus://simquery/result/hit:26098"/><rdf:li rdf:resource="periplus://simquery/result/hit:40411"/><rdf:li rdf:resource="periplus://simquery/result/hit:41634"/><rdf:li rdf:resource="periplus://simquery/result/hit:27180"/><rdf:li rdf:resource="periplus://simquery/result/hit:16697"/><rdf:li rdf:resource="periplus://simquery/result/hit:21227"/><rdf:li rdf:resource="periplus://simquery/result/hit:27360"/><rdf:li rdf:resource="periplus://simquery/result/hit:45812"/><rdf:li rdf:resource="periplus://simquery/result/hit:12169"/><rdf:li rdf:resource="periplus://simquery/result/hit:53147"/><rdf:li rdf:resource="periplus://simquery/result/hit:45740"/><rdf:li rdf:resource="periplus://simquery/result/hit:11001"/><rdf:li rdf:resource="periplus://simquery/result/hit:27639"/><rdf:li rdf:resource="periplus://simquery/result/hit:73823"/><rdf:li rdf:resource="periplus://simquery/result/hit:55167"/><rdf:li rdf:resource="periplus://simquery/result/hit:65097"/></rdf:Bag><rdf:Description rdf:about="periplus://simquery/result/cluster:1"><wlr:hasNumberOfResults>9</wlr:hasNumberOfResults><wlr:isLinkedTo rdf:resource="periplus://cluster:1"/><wlr:hasScore>0.970595</wlr:hasScore><wlr:hasDescription>Lot de consolation pour la droite : La Guyane basculerait. Selon des chiffres encore</wlr:hasDescription><mediaUnit xsi:type="model:Image" uri="periplus://resource:78083/image" ><annotation uri="periplus://resource:78083/image/annot:0\" ><data><rdf:RDF xmlns:wls="http://weblab.ow2.org/core/1.2/ontology/retrieval#" xmlns:dc=\"http://purl.org/dc/elements/1.1/" xmlns:rdf=\"http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#" xmlns:wlp=http://weblab.ow2.org/core/1.2/ontology/processing#" ><rdf:Description rdf:about=periplus://resource:78083/image><dc:abstract>No description available</dc:abstract><wlp:hasNativeContent>http://static.mediapart.fr/files/imagecache/300_pixels/La%20r%C3%A9daction%20Mediapart/rejet.png</wlp:hasNativeContent></rdf:Description><mediaUnit xsi:type="model:Image" uri="periplus://resource:78083/image" ><annotation uri="periplus://resource:78083/image/annot:0\" ><data><rdf:RDF xmlns:wls="http://weblab.ow2.org/core/1.2/ontology/retrieval#" xmlns:dc=\"http://purl.org/dc/elements/1.1/" xmlns:rdf=\"http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#" xmlns:wlp=http://weblab.ow2.org/core/1.2/ontology/processing#" ><rdf:Description rdf:about=periplus://resource:78083/image><dc:abstract>No description available</dc:abstract><wlp:hasNativeContent>http://static.mediapart.fr/files/imagecache/475_pixels/La%20r%C3%A9daction%20Mediapart/paille.png</wlp:hasNativeContent></rdf:Description><dc:title>�lections r�gionales</dc:title><rdf:type rdf:resource="DocumentCluster"/></rdf:Description><rdf:Bag rdf:about="periplus://simquery/result/cluster:1"><rdf:li rdf:resource="periplus://simquery/result/hit:78083"/><rdf:li rdf:resource="periplus://simquery/result/hit:77730"/><rdf:li rdf:resource="periplus://simquery/result/hit:74485"/><rdf:li rdf:resource="periplus://simquery/result/hit:603"/><rdf:li rdf:resource="periplus://simquery/result/hit:36313"/><rdf:li rdf:resource="periplus://simquery/result/hit:37060"/><rdf:li rdf:resource="periplus://simquery/result/hit:49377"/><rdf:li rdf:resource="periplus://simquery/result/hit:423"/><rdf:li rdf:resource="periplus://simquery/result/hit:74059"/></rdf:Bag><rdf:Description rdf:about="periplus://simquery/result/cluster:2"><wlr:hasNumberOfResults>25</wlr:hasNumberOfResults><wlr:isLinkedTo rdf:resource="periplus://cluster:2"/><wlr:hasScore>0.961693</wlr:hasScore><wlr:hasDescription>Du changement de statut de La Poste, il n\'a �t� que peu question durant la campagne des �lections europ�ennes, comme si la r�forme avait pris du retard ou n\'�tait plus d\'actualit�. Et pourtant, il n\'en est rien</wlr:hasDescription><mediaUnit xsi:type="model:Image" uri="periplus://resource:42059/image" ><annotation uri="periplus://resource:42059/image/annot:0\" ><data><rdf:RDF xmlns:wls="http://weblab.ow2.org/core/1.2/ontology/retrieval#" xmlns:dc=\"http://purl.org/dc/elements/1.1/" xmlns:rdf=\"http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#" xmlns:wlp=http://weblab.ow2.org/core/1.2/ontology/processing#" ><rdf:Description rdf:about=periplus://resource:42059/image><dc:abstract>No description available</dc:abstract><wlp:hasNativeContent>http://static.mediapart.fr/files/Laurent Mauduit/Image 8_13.png</wlp:hasNativeContent></rdf:Description><dc:title>gouvernement UMP</dc:title><rdf:type rdf:resource="DocumentCluster"/></rdf:Description><rdf:Bag rdf:about="periplus://simquery/result/cluster:2"><rdf:li rdf:resource="periplus://simquery/result/hit:42059"/><rdf:li rdf:resource="periplus://simquery/result/hit:25866"/><rdf:li rdf:resource="periplus://simquery/result/hit:28692"/><rdf:li rdf:resource="periplus://simquery/result/hit:70129"/><rdf:li rdf:resource="periplus://simquery/result/hit:29095"/><rdf:li rdf:resource="periplus://simquery/result/hit:19657"/><rdf:li rdf:resource="periplus://simquery/result/hit:23106"/><rdf:li rdf:resource="periplus://simquery/result/hit:26509"/><rdf:li rdf:resource="periplus://simquery/result/hit:10623"/><rdf:li rdf:resource="periplus://simquery/result/hit:21885"/><rdf:li rdf:resource="periplus://simquery/result/hit:16313"/><rdf:li rdf:resource="periplus://simquery/result/hit:21353"/><rdf:li rdf:resource="periplus://simquery/result/hit:20563"/><rdf:li rdf:resource="periplus://simquery/result/hit:18705"/><rdf:li rdf:resource="periplus://simquery/result/hit:17508"/><rdf:li rdf:resource="periplus://simquery/result/hit:19199"/><rdf:li rdf:resource="periplus://simquery/result/hit:26409"/><rdf:li rdf:resource="periplus://simquery/result/hit:24528"/><rdf:li rdf:resource="periplus://simquery/result/hit:748"/><rdf:li rdf:resource="periplus://simquery/result/hit:200"/><rdf:li rdf:resource="periplus://simquery/result/hit:10057"/><rdf:li rdf:resource="periplus://simquery/result/hit:25201"/><rdf:li rdf:resource="periplus://simquery/result/hit:63657"/><rdf:li rdf:resource="periplus://simquery/result/hit:45166"/><rdf:li rdf:resource="periplus://simquery/result/hit:56762"/></rdf:Bag><rdf:Description rdf:about="periplus://simquery/result/cluster:3"><wlr:hasNumberOfResults>4</wlr:hasNumberOfResults><wlr:isLinkedTo rdf:resource="periplus://cluster:3"/><wlr:hasScore>0.936393</wlr:hasScore><wlr:hasDescription>Une bombe dort au p�le financier du tribunal de grande instance de Paris. Les juges Fran�oise Desset et</wlr:hasDescription><mediaUnit xsi:type="model:Image" uri="periplus://resource:22632/image" ><annotation uri="periplus://resource:22632/image/annot:0\" ><data><rdf:RDF xmlns:wls="http://weblab.ow2.org/core/1.2/ontology/retrieval#" xmlns:dc=\"http://purl.org/dc/elements/1.1/" xmlns:rdf=\"http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#" xmlns:wlp=http://weblab.ow2.org/core/1.2/ontology/processing#" ><rdf:Description rdf:about=periplus://resource:22632/image><dc:abstract>No description available</dc:abstract><wlp:hasNativeContent>http://static.mediapart.fr/files/imagecache/475_pixels/Fabrice%20Arfi/article_photo_1218010950574-1-0.jpg</wlp:hasNativeContent></rdf:Description><dc:title>affaire de Karachi</dc:title><rdf:type rdf:resource="DocumentCluster"/></rdf:Description><rdf:Bag rdf:about="periplus://simquery/result/cluster:3"><rdf:li rdf:resource="periplus://simquery/result/hit:22631"/><rdf:li rdf:resource="periplus://simquery/result/hit:22632"/><rdf:li rdf:resource="periplus://simquery/result/hit:43103"/><rdf:li rdf:resource="periplus://simquery/result/hit:43104"/></rdf:Bag><rdf:Description rdf:about="periplus://simquery/result/cluster:4"><wlr:hasNumberOfResults>9</wlr:hasNumberOfResults><wlr:isLinkedTo rdf:resource="periplus://cluster:4"/><wlr:hasScore>0.928015</wlr:hasScore><wlr:hasDescription>&quot;Dans une telle campagne o� les petites phrases et les effets m�diatiques semblent plus compter que le fond, de belles images au 20 heures ne peuvent pas faire de mal.&quot; Ce commentaire d\'un dirigean</wlr:hasDescription><mediaUnit xsi:type="model:Image" uri="periplus://resource:41525/image" ><annotation uri="periplus://resource:41525/image/annot:0\" ><data><rdf:RDF xmlns:wls="http://weblab.ow2.org/core/1.2/ontology/retrieval#" xmlns:dc=\"http://purl.org/dc/elements/1.1/" xmlns:rdf=\"http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#" xmlns:wlp=http://weblab.ow2.org/core/1.2/ontology/processing#" ><rdf:Description rdf:about=periplus://resource:41525/image><dc:abstract>No description available</dc:abstract><wlp:hasNativeContent>http://static.mediapart.fr/files/imagecache/300_pixels/St%C3%A9phane%20Alli%C3%A8s/Image%205_5.png</wlp:hasNativeContent></rdf:Description><dc:title>campagne des europ�ennes</dc:title><rdf:type rdf:resource="DocumentCluster"/></rdf:Description><rdf:Bag rdf:about="periplus://simquery/result/cluster:4"><rdf:li rdf:resource="periplus://simquery/result/hit:41525"/><rdf:li rdf:resource="periplus://simquery/result/hit:39274"/><rdf:li rdf:resource="periplus://simquery/result/hit:42094"/><rdf:li rdf:resource="periplus://simquery/result/hit:41650"/><rdf:li rdf:resource="periplus://simquery/result/hit:39518"/><rdf:li rdf:resource="periplus://simquery/result/hit:77546"/><rdf:li rdf:resource="periplus://simquery/result/hit:42258"/><rdf:li rdf:resource="periplus://simquery/result/hit:46602"/><rdf:li rdf:resource="periplus://simquery/result/hit:38947"/></rdf:Bag><rdf:Description rdf:about="periplus://simquery/result/cluster:5"><wlr:hasNumberOfResults>10</wlr:hasNumberOfResults><wlr:isLinkedTo rdf:resource="periplus://cluster:5"/><wlr:hasScore>0.914044</wlr:hasScore><wlr:hasDescription>L\'UMP et le PS sont des jumeaux dizygotes. Ils ne sont pas issus du m�me</wlr:hasDescription><mediaUnit xsi:type="model:Image" uri="periplus://resource:39104/image" ><annotation uri="periplus://resource:39104/image/annot:0\" ><data><rdf:RDF xmlns:wls="http://weblab.ow2.org/core/1.2/ontology/retrieval#" xmlns:dc=\"http://purl.org/dc/elements/1.1/" xmlns:rdf=\"http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#" xmlns:wlp=http://weblab.ow2.org/core/1.2/ontology/processing#" ><rdf:Description rdf:about=periplus://resource:39104/image><dc:abstract>No description available</dc:abstract><wlp:hasNativeContent>http://static.mediapart.fr/files/imagecache/475_pixels/Marine%20Turchi/2083.jpg</wlp:hasNativeContent></rdf:Description><dc:title>UMP</dc:title><rdf:type rdf:resource="DocumentCluster"/></rdf:Description><rdf:Bag rdf:about="periplus://simquery/result/cluster:5"><rdf:li rdf:resource="periplus://simquery/result/hit:9624"/><rdf:li rdf:resource="periplus://simquery/result/hit:40407"/><rdf:li rdf:resource="periplus://simquery/result/hit:43349"/><rdf:li rdf:resource="periplus://simquery/result/hit:16105"/><rdf:li rdf:resource="periplus://simquery/result/hit:39104"/><rdf:li rdf:resource="periplus://simquery/result/hit:12369"/><rdf:li rdf:resource="periplus://simquery/result/hit:35718"/><rdf:li rdf:resource="periplus://simquery/result/hit:29621"/><rdf:li rdf:resource="periplus://simquery/result/hit:67076"/><rdf:li rdf:resource="periplus://simquery/result/hit:73885"/></rdf:Bag><rdf:Description rdf:about="periplus://simquery/result/cluster:6"><wlr:hasNumberOfResults>6</wlr:hasNumberOfResults><wlr:isLinkedTo rdf:resource="periplus://cluster:6"/><wlr:hasScore>0.907456</wlr:hasScore><wlr:hasDescription>Jacques Julliard, 77 ans, entre en dissidence. Figure historique de la &quot;deux</wlr:hasDescription><mediaUnit xsi:type="model:Image" uri="periplus://resource:78268/image" ><annotation uri="periplus://resource:78268/image/annot:0\" ><data><rdf:RDF xmlns:wls="http://weblab.ow2.org/core/1.2/ontology/retrieval#" xmlns:dc=\"http://purl.org/dc/elements/1.1/" xmlns:rdf=\"http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#" xmlns:wlp=http://weblab.ow2.org/core/1.2/ontology/processing#" ><rdf:Description rdf:about=periplus://resource:78268/image><dc:abstract>No description available</dc:abstract><wlp:hasNativeContent>http://static.mediapart.fr/files/imagecache/250_pixels/St%C3%A9phane%20Alli%C3%A8s/julliard.png</wlp:hasNativeContent></rdf:Description><mediaUnit xsi:type="model:Image" uri="periplus://resource:67685/image" ><annotation uri="periplus://resource:67685/image/annot:0\" ><data><rdf:RDF xmlns:wls="http://weblab.ow2.org/core/1.2/ontology/retrieval#" xmlns:dc=\"http://purl.org/dc/elements/1.1/" xmlns:rdf=\"http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#" xmlns:wlp=http://weblab.ow2.org/core/1.2/ontology/processing#" ><rdf:Description rdf:about=periplus://resource:67685/image><dc:abstract>No description available</dc:abstract><wlp:hasNativeContent>http://static.mediapart.fr/files/imagecache/300_pixels/Marine%20Turchi/chirac_balladur.png</wlp:hasNativeContent></rdf:Description><dc:title>livre</dc:title><rdf:type rdf:resource="DocumentCluster"/></rdf:Description><rdf:Bag rdf:about="periplus://simquery/result/cluster:6"><rdf:li rdf:resource="periplus://simquery/result/hit:78268"/><rdf:li rdf:resource="periplus://simquery/result/hit:67685"/><rdf:li rdf:resource="periplus://simquery/result/hit:71364"/><rdf:li rdf:resource="periplus://simquery/result/hit:52502"/><rdf:li rdf:resource="periplus://simquery/result/hit:67950"/><rdf:li rdf:resource="periplus://simquery/result/hit:69111"/></rdf:Bag><rdf:Description rdf:about="periplus://simquery/result/cluster:7"><wlr:hasNumberOfResults>4</wlr:hasNumberOfResults><wlr:isLinkedTo rdf:resource="periplus://cluster:7"/><wlr:hasScore>0.865421</wlr:hasScore><wlr:hasDescription>&quot;Dans quelques ann�es nous dirons: il y a l\'UMP et il y a le Nouveau Centre&quot;, a assur� Herv� Morin, lors des v\339ux aux cadres de son parti, lundi 18 janvier. Chaque ann�e, le discours est</wlr:hasDescription><mediaUnit xsi:type="model:Image" uri="periplus://resource:72565/image" ><annotation uri="periplus://resource:72565/image/annot:0\" ><data><rdf:RDF xmlns:wls="http://weblab.ow2.org/core/1.2/ontology/retrieval#" xmlns:dc=\"http://purl.org/dc/elements/1.1/" xmlns:rdf=\"http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#" xmlns:wlp=http://weblab.ow2.org/core/1.2/ontology/processing#" ><rdf:Description rdf:about=periplus://resource:72565/image><dc:abstract>No description available</dc:abstract><wlp:hasNativeContent>http://static.mediapart.fr/files/Marine Turchi/udf.png</wlp:hasNativeContent></rdf:Description><mediaUnit xsi:type="model:Image" uri="periplus://resource:40117/image" ><annotation uri="periplus://resource:40117/image/annot:0\" ><data><rdf:RDF xmlns:wls="http://weblab.ow2.org/core/1.2/ontology/retrieval#" xmlns:dc=\"http://purl.org/dc/elements/1.1/" xmlns:rdf=\"http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#" xmlns:wlp=http://weblab.ow2.org/core/1.2/ontology/processing#" ><rdf:Description rdf:about=periplus://resource:40117/image><dc:abstract>No description available</dc:abstract><wlp:hasNativeContent>http://static.mediapart.fr/files/imagecache/150_pixels/Marine%20Turchi/Dominique_villepin_1.jpg</wlp:hasNativeContent></rdf:Description><dc:title>Nouveau Centre Modem</dc:title><rdf:type rdf:resource="DocumentCluster"/></rdf:Description><rdf:Bag rdf:about="periplus://simquery/result/cluster:7"><rdf:li rdf:resource="periplus://simquery/result/hit:72565"/><rdf:li rdf:resource="periplus://simquery/result/hit:40117"/><rdf:li rdf:resource="periplus://simquery/result/hit:28041"/><rdf:li rdf:resource="periplus://simquery/result/hit:53657"/></rdf:Bag><rdf:Description rdf:about="periplus://simquery/result/cluster:8"><wlr:hasNumberOfResults>6</wlr:hasNumberOfResults><wlr:isLinkedTo rdf:resource="periplus://cluster:8"/><wlr:hasScore>0.851838</wlr:hasScore><wlr:hasDescription>En pleine panique financi�re, les responsables politiques retrouvent la parole. Apr�s la r�union de crise ce </wlr:hasDescription><mediaUnit xsi:type="model:Image" uri="periplus://resource:78812/image" ><annotation uri="periplus://resource:78812/image/annot:0\" ><data><rdf:RDF xmlns:wls="http://weblab.ow2.org/core/1.2/ontology/retrieval#" xmlns:dc=\"http://purl.org/dc/elements/1.1/" xmlns:rdf=\"http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#" xmlns:wlp=http://weblab.ow2.org/core/1.2/ontology/processing#" ><rdf:Description rdf:about=periplus://resource:78812/image><dc:abstract>No description available</dc:abstract><wlp:hasNativeContent>http://static.mediapart.fr/files/imagecache/300_pixels/Marine%20Turchi/baroin_sarkozy.jpg</wlp:hasNativeContent></rdf:Description><dc:title>panique financi�re</dc:title><rdf:type rdf:resource="DocumentCluster"/></rdf:Description><rdf:Bag rdf:about="periplus://simquery/result/cluster:8"><rdf:li rdf:resource="periplus://simquery/result/hit:23938"/><rdf:li rdf:resource="periplus://simquery/result/hit:78812"/><rdf:li rdf:resource="periplus://simquery/result/hit:24554"/><rdf:li rdf:resource="periplus://simquery/result/hit:20496"/><rdf:li rdf:resource="periplus://simquery/result/hit:25510"/><rdf:li rdf:resource="periplus://simquery/result/hit:11333"/></rdf:Bag><rdf:Description rdf:about="periplus://simquery/result/cluster:9"><wlr:hasNumberOfResults>8</wlr:hasNumberOfResults><wlr:isLinkedTo rdf:resource="periplus://cluster:9"/><wlr:hasScore>0.95304</wlr:hasScore><wlr:hasDescription>No summary available</wlr:hasDescription><dc:title>etc.</dc:title><rdf:type rdf:resource="DocumentCluster"/></rdf:Description><rdf:Bag rdf:about="periplus://simquery/result/cluster:9"><rdf:li rdf:resource="periplus://simquery/result/hit:5581"/><rdf:li rdf:resource="periplus://simquery/result/hit:23127"/><rdf:li rdf:resource="periplus://simquery/result/hit:22545"/><rdf:li rdf:resource="periplus://simquery/result/hit:59562"/><rdf:li rdf:resource="periplus://simquery/result/hit:79317"/><rdf:li rdf:resource="periplus://simquery/result/hit:77916"/><rdf:li rdf:resource="periplus://simquery/result/hit:21133"/><rdf:li rdf:resource="periplus://simquery/result/hit:27334"/></rdf:Bag><rdf:Description rdf:about="periplus://simquery/result"><wlr:hasQueryOffset>0</wlr:hasQueryOffset><wlr:hasNumberOfResults>100</wlr:hasNumberOfResults><wlr:isResultOf rdf:resource="periplus://simquery"/><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/model#ResultSet"/><wlr:hasHit rdf:resource="periplus://simquery/result/hit:3883"/><wlr:hasHit rdf:resource="periplus://simquery/result/hit:3256"/><wlr:hasHit rdf:resource="periplus://simquery/result/hit:3328"/><wlr:hasHit rdf:resource="periplus://simquery/result/hit:3844"/><wlr:hasHit rdf:resource="periplus://simquery/result/hit:271"/><wlr:hasHit rdf:resource="periplus://simquery/result/hit:1732"/><wlr:hasHit rdf:resource="periplus://simquery/result/hit:5803"/><wlr:hasHit rdf:resource="periplus://simquery/result/hit:1744"/><wlr:hasHit rdf:resource="periplus://simquery/result/hit:1745"/><wlr:hasHit rdf:resource="periplus://simquery/result/hit:96"/><wlr:hasHit rdf:resource="periplus://simquery/result/hit:4210"/><wlr:hasHit rdf:resource="periplus://simquery/result/hit:3972"/><wlr:hasHit rdf:resource="periplus://simquery/result/hit:3973"/><wlr:hasHit rdf:resource="periplus://simquery/result/hit:2475"/><wlr:hasHit rdf:resource="periplus://simquery/result/hit:3789"/><wlr:hasHit rdf:resource="periplus://simquery/result/hit:5767"/><wlr:hasHit rdf:resource="periplus://simquery/result/hit:1036"/><wlr:hasHit rdf:resource="periplus://simquery/result/hit:133"/><wlr:hasHit rdf:resource="periplus://simquery/result/hit:3675"/><wlr:hasHit rdf:resource="periplus://simquery/result/hit:5828"/><wlr:hasHit rdf:resource="periplus://simquery/result/hit:3993"/><wlr:hasHit rdf:resource="periplus://simquery/result/hit:4870"/><wlr:hasHit rdf:resource="periplus://simquery/result/hit:2156"/><wlr:hasHit rdf:resource="periplus://simquery/result/hit:3849"/><wlr:hasHit rdf:resource="periplus://simquery/result/hit:3802"/><wlr:hasHit rdf:resource="periplus://simquery/result/hit:1320"/><wlr:hasHit rdf:resource="periplus://simquery/result/hit:1015"/><wlr:hasHit rdf:resource="periplus://simquery/result/hit:4397"/><wlr:hasHit rdf:resource="periplus://simquery/result/hit:4618"/><wlr:hasHit rdf:resource="periplus://simquery/result/hit:397"/><wlr:hasHit rdf:resource="periplus://simquery/result/hit:4285"/><wlr:hasHit rdf:resource="periplus://simquery/result/hit:1668"/><wlr:hasHit rdf:resource="periplus://simquery/result/hit:2129"/><wlr:hasHit rdf:resource="periplus://simquery/result/hit:5351"/><wlr:hasHit rdf:resource="periplus://simquery/result/hit:4904"/><wlr:hasHit rdf:resource="periplus://simquery/result/hit:1797"/><wlr:hasHit rdf:resource="periplus://simquery/result/hit:1176"/><wlr:hasHit rdf:resource="periplus://simquery/result/hit:571"/><wlr:hasHit rdf:resource="periplus://simquery/result/hit:3676"/><wlr:hasHit rdf:resource="periplus://simquery/result/hit:3799"/><wlr:hasHit rdf:resource="periplus://simquery/result/hit:3646"/><wlr:hasHit rdf:resource="periplus://simquery/result/hit:1535"/><wlr:hasHit rdf:resource="periplus://simquery/result/hit:2361"/><wlr:hasHit rdf:resource="periplus://simquery/result/hit:2441"/><wlr:hasHit rdf:resource="periplus://simquery/result/hit:5005"/><wlr:hasHit rdf:resource="periplus://simquery/result/hit:3556"/><wlr:hasHit rdf:resource="periplus://simquery/result/hit:47"/><wlr:hasHit rdf:resource="periplus://simquery/result/hit:2185"/><wlr:hasHit rdf:resource="periplus://simquery/result/hit:2278"/><wlr:hasHit rdf:resource="periplus://simquery/result/hit:1902"/><wlr:hasHit rdf:resource="periplus://simquery/result/hit:288"/><wlr:hasHit rdf:resource="periplus://simquery/result/hit:1093"/><wlr:hasHit rdf:resource="periplus://simquery/result/hit:1462"/><wlr:hasHit rdf:resource="periplus://simquery/result/hit:2179"/><wlr:hasHit rdf:resource="periplus://simquery/result/hit:1403"/><wlr:hasHit rdf:resource="periplus://simquery/result/hit:2501"/><wlr:hasHit rdf:resource="periplus://simquery/result/hit:4470"/><wlr:hasHit rdf:resource="periplus://simquery/result/hit:5881"/><wlr:hasHit rdf:resource="periplus://simquery/result/hit:3533"/><wlr:hasHit rdf:resource="periplus://simquery/result/hit:1978"/><wlr:hasHit rdf:resource="periplus://simquery/result/hit:5120"/><wlr:hasHit rdf:resource="periplus://simquery/result/hit:154"/><wlr:hasHit rdf:resource="periplus://simquery/result/hit:3862"/><wlr:hasHit rdf:resource="periplus://simquery/result/hit:5246"/><wlr:hasHit rdf:resource="periplus://simquery/result/hit:5506"/><wlr:hasHit rdf:resource="periplus://simquery/result/hit:1524"/><wlr:hasHit rdf:resource="periplus://simquery/result/hit:1614"/><wlr:hasHit rdf:resource="periplus://simquery/result/hit:3576"/><wlr:hasHit rdf:resource="periplus://simquery/result/hit:5922"/><wlr:hasHit rdf:resource="periplus://simquery/result/hit:5786"/><wlr:hasHit rdf:resource="periplus://simquery/result/hit:4453"/><wlr:hasHit rdf:resource="periplus://simquery/result/hit:347"/><wlr:hasHit rdf:resource="periplus://simquery/result/hit:600"/><wlr:hasHit rdf:resource="periplus://simquery/result/hit:3200"/><wlr:hasHit rdf:resource="periplus://simquery/result/hit:4458"/><wlr:hasHit rdf:resource="periplus://simquery/result/hit:4698"/><wlr:hasHit rdf:resource="periplus://simquery/result/hit:4823"/><wlr:hasHit rdf:resource="periplus://simquery/result/hit:4272"/><wlr:hasHit rdf:resource="periplus://simquery/result/hit:2577"/><wlr:hasHit rdf:resource="periplus://simquery/result/hit:4728"/><wlr:hasHit rdf:resource="periplus://simquery/result/hit:5490"/><wlr:hasHit rdf:resource="periplus://simquery/result/hit:4341"/><wlr:hasHit rdf:resource="periplus://simquery/result/hit:2286"/><wlr:hasHit rdf:resource="periplus://simquery/result/hit:3510"/><wlr:hasHit rdf:resource="periplus://simquery/result/hit:4201"/><wlr:hasHit rdf:resource="periplus://simquery/result/hit:4545"/><wlr:hasHit rdf:resource="periplus://simquery/result/hit:4513"/><wlr:hasHit rdf:resource="periplus://simquery/result/hit:446"/><wlr:hasHit rdf:resource="periplus://simquery/result/hit:2312"/><wlr:hasHit rdf:resource="periplus://simquery/result/hit:5488"/><wlr:hasHit rdf:resource="periplus://simquery/result/hit:2075"/><wlr:hasHit rdf:resource="periplus://simquery/result/hit:487"/><wlr:hasHit rdf:resource="periplus://simquery/result/hit:1799"/><wlr:hasHit rdf:resource="periplus://simquery/result/hit:1976"/><wlr:hasHit rdf:resource="periplus://simquery/result/hit:5753"/><wlr:hasHit rdf:resource="periplus://simquery/result/hit:1592"/><wlr:hasHit rdf:resource="periplus://simquery/result/hit:1600"/><wlr:hasHit rdf:resource="periplus://simquery/result/hit:5548"/><wlr:hasHit rdf:resource="periplus://simquery/result/hit:2290"/><wlr:hasHit rdf:resource="periplus://simquery/result/hit:2033"/></rdf:Description></rdf:RDF></data></annotation><resource uri="periplus://resource:3883" xsi:type="model:Document"><annotation uri="periplus://resource:3883/annot:0"><data><rdf:RDF xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://resource:3883"><wlp:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/3883</wlp:hasNativeContent></rdf:Description></rdf:RDF></data></annotation></resource><resource uri="periplus://resource:3256" xsi:type="model:Document"><annotation uri="periplus://resource:3256/annot:0"><data><rdf:RDF xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://resource:3256"><wlp:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/3256</wlp:hasNativeContent></rdf:Description></rdf:RDF></data></annotation></resource><resource uri="periplus://resource:3328" xsi:type="model:Document"><annotation uri="periplus://resource:3328/annot:0"><data><rdf:RDF xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://resource:3328"><wlp:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/3328</wlp:hasNativeContent></rdf:Description></rdf:RDF></data></annotation></resource><resource uri="periplus://resource:3844" xsi:type="model:Document"><annotation uri="periplus://resource:3844/annot:0"><data><rdf:RDF xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://resource:3844"><wlp:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/3844</wlp:hasNativeContent></rdf:Description></rdf:RDF></data></annotation></resource><resource uri="periplus://resource:271" xsi:type="model:Document"><annotation uri="periplus://resource:271/annot:0"><data><rdf:RDF xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://resource:271"><wlp:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/271</wlp:hasNativeContent></rdf:Description></rdf:RDF></data></annotation></resource><resource uri="periplus://resource:1732" xsi:type="model:Document"><annotation uri="periplus://resource:1732/annot:0"><data><rdf:RDF xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://resource:1732"><wlp:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/1732</wlp:hasNativeContent></rdf:Description></rdf:RDF></data></annotation></resource><resource uri="periplus://resource:5803" xsi:type="model:Document"><annotation uri="periplus://resource:5803/annot:0"><data><rdf:RDF xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://resource:5803"><wlp:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/5803</wlp:hasNativeContent></rdf:Description></rdf:RDF></data></annotation></resource><resource uri="periplus://resource:1744" xsi:type="model:Document"><annotation uri="periplus://resource:1744/annot:0"><data><rdf:RDF xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://resource:1744"><wlp:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/1744</wlp:hasNativeContent></rdf:Description></rdf:RDF></data></annotation></resource><resource uri="periplus://resource:1745" xsi:type="model:Document"><annotation uri="periplus://resource:1745/annot:0"><data><rdf:RDF xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://resource:1745"><wlp:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/1745</wlp:hasNativeContent></rdf:Description></rdf:RDF></data></annotation></resource><resource uri="periplus://resource:96" xsi:type="model:Document"><annotation uri="periplus://resource:96/annot:0"><data><rdf:RDF xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://resource:96"><wlp:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/96</wlp:hasNativeContent></rdf:Description></rdf:RDF></data></annotation></resource><resource uri="periplus://resource:4210" xsi:type="model:Document"><annotation uri="periplus://resource:4210/annot:0"><data><rdf:RDF xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://resource:4210"><wlp:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/4210</wlp:hasNativeContent></rdf:Description></rdf:RDF></data></annotation></resource><resource uri="periplus://resource:3972" xsi:type="model:Document"><annotation uri="periplus://resource:3972/annot:0"><data><rdf:RDF xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://resource:3972"><wlp:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/3972</wlp:hasNativeContent></rdf:Description></rdf:RDF></data></annotation></resource><resource uri="periplus://resource:3973" xsi:type="model:Document"><annotation uri="periplus://resource:3973/annot:0"><data><rdf:RDF xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://resource:3973"><wlp:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/3973</wlp:hasNativeContent></rdf:Description></rdf:RDF></data></annotation></resource><resource uri="periplus://resource:2475" xsi:type="model:Document"><annotation uri="periplus://resource:2475/annot:0"><data><rdf:RDF xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://resource:2475"><wlp:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/2475</wlp:hasNativeContent></rdf:Description></rdf:RDF></data></annotation></resource><resource uri="periplus://resource:3789" xsi:type="model:Document"><annotation uri="periplus://resource:3789/annot:0"><data><rdf:RDF xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://resource:3789"><wlp:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/3789</wlp:hasNativeContent></rdf:Description></rdf:RDF></data></annotation></resource><resource uri="periplus://resource:5767" xsi:type="model:Document"><annotation uri="periplus://resource:5767/annot:0"><data><rdf:RDF xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://resource:5767"><wlp:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/5767</wlp:hasNativeContent></rdf:Description></rdf:RDF></data></annotation></resource><resource uri="periplus://resource:1036" xsi:type="model:Document"><annotation uri="periplus://resource:1036/annot:0"><data><rdf:RDF xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://resource:1036"><wlp:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/1036</wlp:hasNativeContent></rdf:Description></rdf:RDF></data></annotation></resource><resource uri="periplus://resource:133" xsi:type="model:Document"><annotation uri="periplus://resource:133/annot:0"><data><rdf:RDF xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://resource:133"><wlp:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/133</wlp:hasNativeContent></rdf:Description></rdf:RDF></data></annotation></resource><resource uri="periplus://resource:3675" xsi:type="model:Document"><annotation uri="periplus://resource:3675/annot:0"><data><rdf:RDF xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://resource:3675"><wlp:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/3675</wlp:hasNativeContent></rdf:Description></rdf:RDF></data></annotation></resource><resource uri="periplus://resource:5828" xsi:type="model:Document"><annotation uri="periplus://resource:5828/annot:0"><data><rdf:RDF xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://resource:5828"><wlp:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/5828</wlp:hasNativeContent></rdf:Description></rdf:RDF></data></annotation></resource><resource uri="periplus://resource:3993" xsi:type="model:Document"><annotation uri="periplus://resource:3993/annot:0"><data><rdf:RDF xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://resource:3993"><wlp:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/3993</wlp:hasNativeContent></rdf:Description></rdf:RDF></data></annotation></resource><resource uri="periplus://resource:4870" xsi:type="model:Document"><annotation uri="periplus://resource:4870/annot:0"><data><rdf:RDF xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://resource:4870"><wlp:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/4870</wlp:hasNativeContent></rdf:Description></rdf:RDF></data></annotation></resource><resource uri="periplus://resource:2156" xsi:type="model:Document"><annotation uri="periplus://resource:2156/annot:0"><data><rdf:RDF xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://resource:2156"><wlp:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/2156</wlp:hasNativeContent></rdf:Description></rdf:RDF></data></annotation></resource><resource uri="periplus://resource:3849" xsi:type="model:Document"><annotation uri="periplus://resource:3849/annot:0"><data><rdf:RDF xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://resource:3849"><wlp:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/3849</wlp:hasNativeContent></rdf:Description></rdf:RDF></data></annotation></resource><resource uri="periplus://resource:3802" xsi:type="model:Document"><annotation uri="periplus://resource:3802/annot:0"><data><rdf:RDF xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://resource:3802"><wlp:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/3802</wlp:hasNativeContent></rdf:Description></rdf:RDF></data></annotation></resource><resource uri="periplus://resource:1320" xsi:type="model:Document"><annotation uri="periplus://resource:1320/annot:0"><data><rdf:RDF xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://resource:1320"><wlp:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/1320</wlp:hasNativeContent></rdf:Description></rdf:RDF></data></annotation></resource><resource uri="periplus://resource:1015" xsi:type="model:Document"><annotation uri="periplus://resource:1015/annot:0"><data><rdf:RDF xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://resource:1015"><wlp:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/1015</wlp:hasNativeContent></rdf:Description></rdf:RDF></data></annotation></resource><resource uri="periplus://resource:4397" xsi:type="model:Document"><annotation uri="periplus://resource:4397/annot:0"><data><rdf:RDF xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://resource:4397"><wlp:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/4397</wlp:hasNativeContent></rdf:Description></rdf:RDF></data></annotation></resource><resource uri="periplus://resource:4618" xsi:type="model:Document"><annotation uri="periplus://resource:4618/annot:0"><data><rdf:RDF xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://resource:4618"><wlp:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/4618</wlp:hasNativeContent></rdf:Description></rdf:RDF></data></annotation></resource><resource uri="periplus://resource:397" xsi:type="model:Document"><annotation uri="periplus://resource:397/annot:0"><data><rdf:RDF xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://resource:397"><wlp:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/397</wlp:hasNativeContent></rdf:Description></rdf:RDF></data></annotation></resource><resource uri="periplus://resource:4285" xsi:type="model:Document"><annotation uri="periplus://resource:4285/annot:0"><data><rdf:RDF xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://resource:4285"><wlp:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/4285</wlp:hasNativeContent></rdf:Description></rdf:RDF></data></annotation></resource><resource uri="periplus://resource:1668" xsi:type="model:Document"><annotation uri="periplus://resource:1668/annot:0"><data><rdf:RDF xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://resource:1668"><wlp:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/1668</wlp:hasNativeContent></rdf:Description></rdf:RDF></data></annotation></resource><resource uri="periplus://resource:2129" xsi:type="model:Document"><annotation uri="periplus://resource:2129/annot:0"><data><rdf:RDF xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://resource:2129"><wlp:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/2129</wlp:hasNativeContent></rdf:Description></rdf:RDF></data></annotation></resource><resource uri="periplus://resource:5351" xsi:type="model:Document"><annotation uri="periplus://resource:5351/annot:0"><data><rdf:RDF xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://resource:5351"><wlp:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/5351</wlp:hasNativeContent></rdf:Description></rdf:RDF></data></annotation></resource><resource uri="periplus://resource:4904" xsi:type="model:Document"><annotation uri="periplus://resource:4904/annot:0"><data><rdf:RDF xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://resource:4904"><wlp:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/4904</wlp:hasNativeContent></rdf:Description></rdf:RDF></data></annotation></resource><resource uri="periplus://resource:1797" xsi:type="model:Document"><annotation uri="periplus://resource:1797/annot:0"><data><rdf:RDF xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://resource:1797"><wlp:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/1797</wlp:hasNativeContent></rdf:Description></rdf:RDF></data></annotation></resource><resource uri="periplus://resource:1176" xsi:type="model:Document"><annotation uri="periplus://resource:1176/annot:0"><data><rdf:RDF xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://resource:1176"><wlp:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/1176</wlp:hasNativeContent></rdf:Description></rdf:RDF></data></annotation></resource><resource uri="periplus://resource:571" xsi:type="model:Document"><annotation uri="periplus://resource:571/annot:0"><data><rdf:RDF xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://resource:571"><wlp:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/571</wlp:hasNativeContent></rdf:Description></rdf:RDF></data></annotation></resource><resource uri="periplus://resource:3676" xsi:type="model:Document"><annotation uri="periplus://resource:3676/annot:0"><data><rdf:RDF xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://resource:3676"><wlp:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/3676</wlp:hasNativeContent></rdf:Description></rdf:RDF></data></annotation></resource><resource uri="periplus://resource:3799" xsi:type="model:Document"><annotation uri="periplus://resource:3799/annot:0"><data><rdf:RDF xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://resource:3799"><wlp:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/3799</wlp:hasNativeContent></rdf:Description></rdf:RDF></data></annotation></resource><resource uri="periplus://resource:3646" xsi:type="model:Document"><annotation uri="periplus://resource:3646/annot:0"><data><rdf:RDF xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://resource:3646"><wlp:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/3646</wlp:hasNativeContent></rdf:Description></rdf:RDF></data></annotation></resource><resource uri="periplus://resource:1535" xsi:type="model:Document"><annotation uri="periplus://resource:1535/annot:0"><data><rdf:RDF xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://resource:1535"><wlp:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/1535</wlp:hasNativeContent></rdf:Description></rdf:RDF></data></annotation></resource><resource uri="periplus://resource:2361" xsi:type="model:Document"><annotation uri="periplus://resource:2361/annot:0"><data><rdf:RDF xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://resource:2361"><wlp:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/2361</wlp:hasNativeContent></rdf:Description></rdf:RDF></data></annotation></resource><resource uri="periplus://resource:2441" xsi:type="model:Document"><annotation uri="periplus://resource:2441/annot:0"><data><rdf:RDF xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://resource:2441"><wlp:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/2441</wlp:hasNativeContent></rdf:Description></rdf:RDF></data></annotation></resource><resource uri="periplus://resource:5005" xsi:type="model:Document"><annotation uri="periplus://resource:5005/annot:0"><data><rdf:RDF xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://resource:5005"><wlp:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/5005</wlp:hasNativeContent></rdf:Description></rdf:RDF></data></annotation></resource><resource uri="periplus://resource:3556" xsi:type="model:Document"><annotation uri="periplus://resource:3556/annot:0"><data><rdf:RDF xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://resource:3556"><wlp:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/3556</wlp:hasNativeContent></rdf:Description></rdf:RDF></data></annotation></resource><resource uri="periplus://resource:47" xsi:type="model:Document"><annotation uri="periplus://resource:47/annot:0"><data><rdf:RDF xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://resource:47"><wlp:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/47</wlp:hasNativeContent></rdf:Description></rdf:RDF></data></annotation></resource><resource uri="periplus://resource:2185" xsi:type="model:Document"><annotation uri="periplus://resource:2185/annot:0"><data><rdf:RDF xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://resource:2185"><wlp:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/2185</wlp:hasNativeContent></rdf:Description></rdf:RDF></data></annotation></resource><resource uri="periplus://resource:2278" xsi:type="model:Document"><annotation uri="periplus://resource:2278/annot:0"><data><rdf:RDF xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://resource:2278"><wlp:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/2278</wlp:hasNativeContent></rdf:Description></rdf:RDF></data></annotation></resource><resource uri="periplus://resource:1902" xsi:type="model:Document"><annotation uri="periplus://resource:1902/annot:0"><data><rdf:RDF xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://resource:1902"><wlp:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/1902</wlp:hasNativeContent></rdf:Description></rdf:RDF></data></annotation></resource><resource uri="periplus://resource:288" xsi:type="model:Document"><annotation uri="periplus://resource:288/annot:0"><data><rdf:RDF xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://resource:288"><wlp:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/288</wlp:hasNativeContent></rdf:Description></rdf:RDF></data></annotation></resource><resource uri="periplus://resource:1093" xsi:type="model:Document"><annotation uri="periplus://resource:1093/annot:0"><data><rdf:RDF xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://resource:1093"><wlp:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/1093</wlp:hasNativeContent></rdf:Description></rdf:RDF></data></annotation></resource><resource uri="periplus://resource:1462" xsi:type="model:Document"><annotation uri="periplus://resource:1462/annot:0"><data><rdf:RDF xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://resource:1462"><wlp:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/1462</wlp:hasNativeContent></rdf:Description></rdf:RDF></data></annotation></resource><resource uri="periplus://resource:2179" xsi:type="model:Document"><annotation uri="periplus://resource:2179/annot:0"><data><rdf:RDF xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://resource:2179"><wlp:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/2179</wlp:hasNativeContent></rdf:Description></rdf:RDF></data></annotation></resource><resource uri="periplus://resource:1403" xsi:type="model:Document"><annotation uri="periplus://resource:1403/annot:0"><data><rdf:RDF xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://resource:1403"><wlp:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/1403</wlp:hasNativeContent></rdf:Description></rdf:RDF></data></annotation></resource><resource uri="periplus://resource:2501" xsi:type="model:Document"><annotation uri="periplus://resource:2501/annot:0"><data><rdf:RDF xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://resource:2501"><wlp:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/2501</wlp:hasNativeContent></rdf:Description></rdf:RDF></data></annotation></resource><resource uri="periplus://resource:4470" xsi:type="model:Document"><annotation uri="periplus://resource:4470/annot:0"><data><rdf:RDF xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://resource:4470"><wlp:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/4470</wlp:hasNativeContent></rdf:Description></rdf:RDF></data></annotation></resource><resource uri="periplus://resource:5881" xsi:type="model:Document"><annotation uri="periplus://resource:5881/annot:0"><data><rdf:RDF xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://resource:5881"><wlp:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/5881</wlp:hasNativeContent></rdf:Description></rdf:RDF></data></annotation></resource><resource uri="periplus://resource:3533" xsi:type="model:Document"><annotation uri="periplus://resource:3533/annot:0"><data><rdf:RDF xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://resource:3533"><wlp:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/3533</wlp:hasNativeContent></rdf:Description></rdf:RDF></data></annotation></resource><resource uri="periplus://resource:1978" xsi:type="model:Document"><annotation uri="periplus://resource:1978/annot:0"><data><rdf:RDF xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://resource:1978"><wlp:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/1978</wlp:hasNativeContent></rdf:Description></rdf:RDF></data></annotation></resource><resource uri="periplus://resource:5120" xsi:type="model:Document"><annotation uri="periplus://resource:5120/annot:0"><data><rdf:RDF xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://resource:5120"><wlp:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/5120</wlp:hasNativeContent></rdf:Description></rdf:RDF></data></annotation></resource><resource uri="periplus://resource:154" xsi:type="model:Document"><annotation uri="periplus://resource:154/annot:0"><data><rdf:RDF xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://resource:154"><wlp:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/154</wlp:hasNativeContent></rdf:Description></rdf:RDF></data></annotation></resource><resource uri="periplus://resource:3862" xsi:type="model:Document"><annotation uri="periplus://resource:3862/annot:0"><data><rdf:RDF xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://resource:3862"><wlp:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/3862</wlp:hasNativeContent></rdf:Description></rdf:RDF></data></annotation></resource><resource uri="periplus://resource:5246" xsi:type="model:Document"><annotation uri="periplus://resource:5246/annot:0"><data><rdf:RDF xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://resource:5246"><wlp:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/5246</wlp:hasNativeContent></rdf:Description></rdf:RDF></data></annotation></resource><resource uri="periplus://resource:5506" xsi:type="model:Document"><annotation uri="periplus://resource:5506/annot:0"><data><rdf:RDF xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://resource:5506"><wlp:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/5506</wlp:hasNativeContent></rdf:Description></rdf:RDF></data></annotation></resource><resource uri="periplus://resource:1524" xsi:type="model:Document"><annotation uri="periplus://resource:1524/annot:0"><data><rdf:RDF xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://resource:1524"><wlp:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/1524</wlp:hasNativeContent></rdf:Description></rdf:RDF></data></annotation></resource><resource uri="periplus://resource:1614" xsi:type="model:Document"><annotation uri="periplus://resource:1614/annot:0"><data><rdf:RDF xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://resource:1614"><wlp:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/1614</wlp:hasNativeContent></rdf:Description></rdf:RDF></data></annotation></resource><resource uri="periplus://resource:3576" xsi:type="model:Document"><annotation uri="periplus://resource:3576/annot:0"><data><rdf:RDF xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://resource:3576"><wlp:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/3576</wlp:hasNativeContent></rdf:Description></rdf:RDF></data></annotation></resource><resource uri="periplus://resource:5922" xsi:type="model:Document"><annotation uri="periplus://resource:5922/annot:0"><data><rdf:RDF xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://resource:5922"><wlp:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/5922</wlp:hasNativeContent></rdf:Description></rdf:RDF></data></annotation></resource><resource uri="periplus://resource:5786" xsi:type="model:Document"><annotation uri="periplus://resource:5786/annot:0"><data><rdf:RDF xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://resource:5786"><wlp:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/5786</wlp:hasNativeContent></rdf:Description></rdf:RDF></data></annotation></resource><resource uri="periplus://resource:4453" xsi:type="model:Document"><annotation uri="periplus://resource:4453/annot:0"><data><rdf:RDF xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://resource:4453"><wlp:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/4453</wlp:hasNativeContent></rdf:Description></rdf:RDF></data></annotation></resource><resource uri="periplus://resource:347" xsi:type="model:Document"><annotation uri="periplus://resource:347/annot:0"><data><rdf:RDF xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://resource:347"><wlp:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/347</wlp:hasNativeContent></rdf:Description></rdf:RDF></data></annotation></resource><resource uri="periplus://resource:600" xsi:type="model:Document"><annotation uri="periplus://resource:600/annot:0"><data><rdf:RDF xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://resource:600"><wlp:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/600</wlp:hasNativeContent></rdf:Description></rdf:RDF></data></annotation></resource><resource uri="periplus://resource:3200" xsi:type="model:Document"><annotation uri="periplus://resource:3200/annot:0"><data><rdf:RDF xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://resource:3200"><wlp:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/3200</wlp:hasNativeContent></rdf:Description></rdf:RDF></data></annotation></resource><resource uri="periplus://resource:4458" xsi:type="model:Document"><annotation uri="periplus://resource:4458/annot:0"><data><rdf:RDF xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://resource:4458"><wlp:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/4458</wlp:hasNativeContent></rdf:Description></rdf:RDF></data></annotation></resource><resource uri="periplus://resource:4698" xsi:type="model:Document"><annotation uri="periplus://resource:4698/annot:0"><data><rdf:RDF xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://resource:4698"><wlp:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/4698</wlp:hasNativeContent></rdf:Description></rdf:RDF></data></annotation></resource><resource uri="periplus://resource:4823" xsi:type="model:Document"><annotation uri="periplus://resource:4823/annot:0"><data><rdf:RDF xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://resource:4823"><wlp:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/4823</wlp:hasNativeContent></rdf:Description></rdf:RDF></data></annotation></resource><resource uri="periplus://resource:4272" xsi:type="model:Document"><annotation uri="periplus://resource:4272/annot:0"><data><rdf:RDF xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://resource:4272"><wlp:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/4272</wlp:hasNativeContent></rdf:Description></rdf:RDF></data></annotation></resource><resource uri="periplus://resource:2577" xsi:type="model:Document"><annotation uri="periplus://resource:2577/annot:0"><data><rdf:RDF xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://resource:2577"><wlp:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/2577</wlp:hasNativeContent></rdf:Description></rdf:RDF></data></annotation></resource><resource uri="periplus://resource:4728" xsi:type="model:Document"><annotation uri="periplus://resource:4728/annot:0"><data><rdf:RDF xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://resource:4728"><wlp:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/4728</wlp:hasNativeContent></rdf:Description></rdf:RDF></data></annotation></resource><resource uri="periplus://resource:5490" xsi:type="model:Document"><annotation uri="periplus://resource:5490/annot:0"><data><rdf:RDF xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://resource:5490"><wlp:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/5490</wlp:hasNativeContent></rdf:Description></rdf:RDF></data></annotation></resource><resource uri="periplus://resource:4341" xsi:type="model:Document"><annotation uri="periplus://resource:4341/annot:0"><data><rdf:RDF xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://resource:4341"><wlp:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/4341</wlp:hasNativeContent></rdf:Description></rdf:RDF></data></annotation></resource><resource uri="periplus://resource:2286" xsi:type="model:Document"><annotation uri="periplus://resource:2286/annot:0"><data><rdf:RDF xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://resource:2286"><wlp:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/2286</wlp:hasNativeContent></rdf:Description></rdf:RDF></data></annotation></resource><resource uri="periplus://resource:3510" xsi:type="model:Document"><annotation uri="periplus://resource:3510/annot:0"><data><rdf:RDF xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://resource:3510"><wlp:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/3510</wlp:hasNativeContent></rdf:Description></rdf:RDF></data></annotation></resource><resource uri="periplus://resource:4201" xsi:type="model:Document"><annotation uri="periplus://resource:4201/annot:0"><data><rdf:RDF xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://resource:4201"><wlp:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/4201</wlp:hasNativeContent></rdf:Description></rdf:RDF></data></annotation></resource><resource uri="periplus://resource:4545" xsi:type="model:Document"><annotation uri="periplus://resource:4545/annot:0"><data><rdf:RDF xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://resource:4545"><wlp:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/4545</wlp:hasNativeContent></rdf:Description></rdf:RDF></data></annotation></resource><resource uri="periplus://resource:4513" xsi:type="model:Document"><annotation uri="periplus://resource:4513/annot:0"><data><rdf:RDF xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://resource:4513"><wlp:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/4513</wlp:hasNativeContent></rdf:Description></rdf:RDF></data></annotation></resource><resource uri="periplus://resource:446" xsi:type="model:Document"><annotation uri="periplus://resource:446/annot:0"><data><rdf:RDF xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://resource:446"><wlp:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/446</wlp:hasNativeContent></rdf:Description></rdf:RDF></data></annotation></resource><resource uri="periplus://resource:2312" xsi:type="model:Document"><annotation uri="periplus://resource:2312/annot:0"><data><rdf:RDF xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://resource:2312"><wlp:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/2312</wlp:hasNativeContent></rdf:Description></rdf:RDF></data></annotation></resource><resource uri="periplus://resource:5488" xsi:type="model:Document"><annotation uri="periplus://resource:5488/annot:0"><data><rdf:RDF xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://resource:5488"><wlp:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/5488</wlp:hasNativeContent></rdf:Description></rdf:RDF></data></annotation></resource><resource uri="periplus://resource:2075" xsi:type="model:Document"><annotation uri="periplus://resource:2075/annot:0"><data><rdf:RDF xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://resource:2075"><wlp:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/2075</wlp:hasNativeContent></rdf:Description></rdf:RDF></data></annotation></resource><resource uri="periplus://resource:487" xsi:type="model:Document"><annotation uri="periplus://resource:487/annot:0"><data><rdf:RDF xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://resource:487"><wlp:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/487</wlp:hasNativeContent></rdf:Description></rdf:RDF></data></annotation></resource><resource uri="periplus://resource:1799" xsi:type="model:Document"><annotation uri="periplus://resource:1799/annot:0"><data><rdf:RDF xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://resource:1799"><wlp:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/1799</wlp:hasNativeContent></rdf:Description></rdf:RDF></data></annotation></resource><resource uri="periplus://resource:1976" xsi:type="model:Document"><annotation uri="periplus://resource:1976/annot:0"><data><rdf:RDF xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://resource:1976"><wlp:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/1976</wlp:hasNativeContent></rdf:Description></rdf:RDF></data></annotation></resource><resource uri="periplus://resource:5753" xsi:type="model:Document"><annotation uri="periplus://resource:5753/annot:0"><data><rdf:RDF xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://resource:5753"><wlp:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/5753</wlp:hasNativeContent></rdf:Description></rdf:RDF></data></annotation></resource><resource uri="periplus://resource:1592" xsi:type="model:Document"><annotation uri="periplus://resource:1592/annot:0"><data><rdf:RDF xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://resource:1592"><wlp:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/1592</wlp:hasNativeContent></rdf:Description></rdf:RDF></data></annotation></resource><resource uri="periplus://resource:1600" xsi:type="model:Document"><annotation uri="periplus://resource:1600/annot:0"><data><rdf:RDF xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://resource:1600"><wlp:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/1600</wlp:hasNativeContent></rdf:Description></rdf:RDF></data></annotation></resource><resource uri="periplus://resource:5548" xsi:type="model:Document"><annotation uri="periplus://resource:5548/annot:0"><data><rdf:RDF xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://resource:5548"><wlp:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/5548</wlp:hasNativeContent></rdf:Description></rdf:RDF></data></annotation></resource><resource uri="periplus://resource:2290" xsi:type="model:Document"><annotation uri="periplus://resource:2290/annot:0"><data><rdf:RDF xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://resource:2290"><wlp:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/2290</wlp:hasNativeContent></rdf:Description></rdf:RDF></data></annotation></resource><resource uri="periplus://resource:2033" xsi:type="model:Document"><annotation uri="periplus://resource:2033/annot:0"><data><rdf:RDF xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://resource:2033"><wlp:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/2033</wlp:hasNativeContent></rdf:Description></rdf:RDF></data></annotation></resource></resultSet></sear:searchReturn></soapenv:Body></soapenv:Envelope>'''
        '''res = '<soapenv:Envelope xmlns:soapenv="http://schemas.xmlsoap.org/soap/envelope/"><soapenv:Body><sear:searchReturn xmlns:model="http://weblab.ow2.org/core/1.2/model#" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns:sear="http://weblab.ow2.org/core/1.2/services/searcher" xmlns:soapenv="http://schemas.xmlsoap.org/soap/envelope/"><resultSet uri="periplus://simquery/result" xmlns:model="http://weblab.ow2.org/core/1.2/model#" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"><annotation uri="periplus://simquery/result/annotation"><data><rdf:RDF xmlns:wlr="http://weblab.ow2.org/core/1.2/ontology/retrieval#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://simquery/result/hit:3883"><wlr:inResultSetHit rdf:resource="periplus://simquery/result"/><wlr:isLinkedTo rdf:resource="periplus://resource:3883"/><wlr:hasDescription>Proche de Ségolène Royal, François Rebsamen a un temps envisagé de faire le trait-d\'union avec les amis de François Hollande pour renverser Martine Aubry de la direction du PS. Rentré dans le rang, il n\'en </wlr:hasDescription><wlr:hasScore>1</wlr:hasScore><wlr:hasRank>1</wlr:hasRank><dc:identifier>42360</dc:identifier><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/hit:3256"><wlr:inResultSetHit rdf:resource="periplus://simquery/result"/><wlr:isLinkedTo rdf:resource="periplus://resource:3256"/><wlr:hasDescription>Du 16 au 22 mars, les quelque 70.000 adhérents franciliens (rev</wlr:hasDescription><wlr:hasScore>0.970595</wlr:hasScore><wlr:hasRank>2</wlr:hasRank><dc:identifier>36313</dc:identifier><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/hit:3328"><wlr:inResultSetHit rdf:resource="periplus://simquery/result"/><wlr:isLinkedTo rdf:resource="periplus://resource:3328"/><wlr:hasDescription>Sans surprise, Valérie Pécresse l\'a largement emporté, dimanche 22 mars, sur son collègue Roger Karoutchi lors de la primaire organisée chez les militants UMP de l\'Ile-de-France. Entre le 16 et le 22 mars, 48</wlr:hasDescription><wlr:hasScore>0.970595</wlr:hasScore><wlr:hasRank>3</wlr:hasRank><dc:identifier>37060</dc:identifier><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/hit:3844"><wlr:inResultSetHit rdf:resource="periplus://simquery/result"/><wlr:isLinkedTo rdf:resource="periplus://resource:3844"/><wlr:hasDescription>Du changement de statut de La Poste, il n\'a été que peu question durant la campagne des élections européennes, comme si la réforme avait pris du retard ou n\'était plus d\'actualité. Et pourtant, il n\'en est rien</wlr:hasDescription><wlr:hasScore>0.961693</wlr:hasScore><wlr:hasRank>4</wlr:hasRank><dc:identifier>42059</dc:identifier><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/hit:271"><wlr:inResultSetHit rdf:resource="periplus://simquery/result"/><wlr:isLinkedTo rdf:resource="periplus://resource:271"/><wlr:hasDescription>Jeudi 27 mars, dans la soirée, Nicolas Sarkozy a finalement promis que l\'Assemblée nationale pourrait débattre de sa décision toute fraîche d\'envoyer des soldats supplémentaires en Afghanistan (probablement un millier). Notifiée la veille outre-manc</wlr:hasDescription><wlr:hasScore>0.95304</wlr:hasScore><wlr:hasRank>5</wlr:hasRank><dc:identifier>5581</dc:identifier><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/hit:1732"><wlr:inResultSetHit rdf:resource="periplus://simquery/result"/><wlr:isLinkedTo rdf:resource="periplus://resource:1732"/><wlr:hasDescription>(Si la fin de cette page s\'affiche mal, rafraîchissez votre écran- touche F5) A l\'époque, l\'Unita avait contesté par les armes le résultat favorable au MPLA, replongeant le pays dans la guerre. Le combat des deux ex-compagn</wlr:hasDescription><wlr:hasScore>0.944239</wlr:hasScore><wlr:hasRank>6</wlr:hasRank><dc:identifier>22545</dc:identifier><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/hit:5803"><wlr:inResultSetHit rdf:resource="periplus://simquery/result"/><wlr:isLinkedTo rdf:resource="periplus://resource:5803"/><wlr:hasDescription>Lot de consolation pour la droite : La Guyane basculerait. Selon des chiffres encore pro</wlr:hasDescription><wlr:hasScore>0.939834</wlr:hasScore><wlr:hasRank>7</wlr:hasRank><dc:identifier>78083</dc:identifier><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/hit:1744"><wlr:inResultSetHit rdf:resource="periplus://simquery/result"/><wlr:isLinkedTo rdf:resource="periplus://resource:1744"/><wlr:hasDescription>Une bombe dort au pôle financier du tribunal de grande instance de Paris. Les juges Françoise Desset et</wlr:hasDescription><wlr:hasScore>0.936393</wlr:hasScore><wlr:hasRank>8</wlr:hasRank><dc:identifier>22631</dc:identifier><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/hit:1745"><wlr:inResultSetHit rdf:resource="periplus://simquery/result"/><wlr:isLinkedTo rdf:resource="periplus://resource:1745"/><wlr:hasDescription>Une bombe dort au pôle financier du tribunal de Paris. Les juges Françoise Desset et</wlr:hasDescription><wlr:hasScore>0.935581</wlr:hasScore><wlr:hasRank>9</wlr:hasRank><dc:identifier>22632</dc:identifier><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/hit:96"><wlr:inResultSetHit rdf:resource="periplus://simquery/result"/><wlr:isLinkedTo rdf:resource="periplus://resource:96"/><wlr:hasDescription>C\'était le 18 mars 2001. Au soir du second tour des él</wlr:hasDescription><wlr:hasScore>0.930653</wlr:hasScore><wlr:hasRank>10</wlr:hasRank><dc:identifier>423</dc:identifier><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/hit:4210"><wlr:inResultSetHit rdf:resource="periplus://simquery/result"/><wlr:isLinkedTo rdf:resource="periplus://resource:4210"/><wlr:hasDescription>L\'échange épistolaire entre Martine Aubry et Manuel Valls a ouvert la compétition des égos au PS. Mais la présidente de la régi</wlr:hasDescription><wlr:hasScore>0.930653</wlr:hasScore><wlr:hasRank>11</wlr:hasRank><dc:identifier>45247</dc:identifier><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/hit:3972"><wlr:inResultSetHit rdf:resource="periplus://simquery/result"/><wlr:isLinkedTo rdf:resource="periplus://resource:3972"/><wlr:hasDescription>L\'affaire de Karachi qui préoccupe au plus haut sommet de l\'Etat est apparue au détour d\'une enquête purement financière, qui recèle potentiellement en elle-même d\'autres scandales d\'Etat, largement évoqués par Mediapart voilà déjà neuf mois. Les juges du pôle financier p</wlr:hasDescription><wlr:hasScore>0.930406</wlr:hasScore><wlr:hasRank>12</wlr:hasRank><dc:identifier>43103</dc:identifier><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/hit:3973"><wlr:inResultSetHit rdf:resource="periplus://simquery/result"/><wlr:isLinkedTo rdf:resource="periplus://resource:3973"/><wlr:hasDescription>L\'affaire de Karachi qui préoccupe au plus haut sommet de l\'Etat est apparue au détour d\'une enquête purement financière, qui recèle potentiellement en elle-même d\'autres scandales d\'Etat, largement évoqués par Mediapart voilà déjà neuf mois. Les juges du pôle financier p</wlr:hasDescription><wlr:hasScore>0.930406</wlr:hasScore><wlr:hasRank>13</wlr:hasRank><dc:identifier>43104</dc:identifier><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/hit:2475"><wlr:inResultSetHit rdf:resource="periplus://simquery/result"/><wlr:isLinkedTo rdf:resource="periplus://resource:2475"/><wlr:hasDescription>Mardi 2 décembre, dans un sous-sol de l\'Assemblée nationale, Martine Aubry a délivré une feuille de route toute fraîche aux députés socialistes. &quot;On redémarre, on est en marc</wlr:hasDescription><wlr:hasScore>0.928015</wlr:hasScore><wlr:hasRank>14</wlr:hasRank><dc:identifier>28930</dc:identifier><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/hit:3789"><wlr:inResultSetHit rdf:resource="periplus://simquery/result"/><wlr:isLinkedTo rdf:resource="periplus://resource:3789"/><wlr:hasDescription>&quot;Dans une telle campagne où les petites phrases et les effets médiatiques semblent plus compter que le fond, de belles images au 20 heures ne peuvent pas faire de mal.&quot; Ce commentaire d\'un dirigean</wlr:hasDescription><wlr:hasScore>0.928015</wlr:hasScore><wlr:hasRank>15</wlr:hasRank><dc:identifier>41525</dc:identifier><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/hit:5767"><wlr:inResultSetHit rdf:resource="periplus://simquery/result"/>  <wlr:isLinkedTo rdf:resource="periplus://resource:5767"/><wlr:hasDescription>Elle n\'est pas encore la plus chouette du monde, mais la gauche française a au moins évité d\'être la plus bête, au moment de discuter unité avant le second tour des régionales. Mardi à 18h, dix-huit listes </wlr:hasDescription><wlr:hasScore>0.927953</wlr:hasScore><wlr:hasRank>16</wlr:hasRank><dc:identifier>77730</dc:identifier><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/hit:1036"><wlr:inResultSetHit rdf:resource="periplus://simquery/result"/><wlr:isLinkedTo rdf:resource="periplus://resource:1036"/><wlr:hasDescription>N\'en doutons pas, la semaine sociale sera à la contestation tous azimuts et, si le sujet n\'était pas grave et sérieux, un esprit malicieux pourrait voir dans ce tintamarre une nouvelle expression des contradictions françaises. A nouveau se pose le problème</wlr:hasDescription><wlr:hasScore>0.926465</wlr:hasScore><wlr:hasRank>17</wlr:hasRank><dc:identifier>16313</dc:identifier><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/hit:133"><wlr:inResultSetHit rdf:resource="periplus://simquery/result"/><wlr:isLinkedTo rdf:resource="periplus://resource:133"/><wlr:hasDescription>Face au pouvoir central incarné par le sarkozysme et ses dépendances, s\'installe un contre-pouvoir territorial porté par le socialisme et ses associés. La France est &quot; coupée en deu</wlr:hasDescription><wlr:hasScore>0.924092</wlr:hasScore><wlr:hasRank>18</wlr:hasRank><dc:identifier>603</dc:identifier><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/hit:3675"><wlr:inResultSetHit rdf:resource="periplus://simquery/result"/><wlr:isLinkedTo rdf:resource="periplus://resource:3675"/><wlr:hasDescription>Il faudra songer à remercier Nicolas Sarkozy. Sa pratique du pouvoir, sa ge</wlr:hasDescription><wlr:hasScore>0.914044</wlr:hasScore><wlr:hasRank>19</wlr:hasRank><dc:identifier>40407</dc:identifier><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/hit:5828"><wlr:inResultSetHit rdf:resource="periplus://simquery/result"/><wlr:isLinkedTo rdf:resource="periplus://resource:5828"/><wlr:hasDescription>Jacques Julliard, 77 ans, entre en dissidence. Figure historique de la &quot;deux</wlr:hasDescription><wlr:hasScore>0.907456</wlr:hasScore><wlr:hasRank>20</wlr:hasRank><dc:identifier>78268</dc:identifier><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/hit:3993"><wlr:inResultSetHit rdf:resource="periplus://simquery/result"/><wlr:isLinkedTo rdf:resource="periplus://resource:3993"/><wlr:hasDescription>&quot;Vive la France !&quot; Après quarante minutes, Nicolas Sarkozy en a terminé avec son &quot;grand&quot; discours du Congrès. Sous les applaudissements - p</wlr:hasDescription><wlr:hasScore>0.898695</wlr:hasScore><wlr:hasRank>21</wlr:hasRank><dc:identifier>43349</dc:identifier><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/hit:4870"><wlr:inResultSetHit rdf:resource="periplus://simquery/result"/><wlr:isLinkedTo rdf:resource="periplus://resource:4870"/><wlr:hasDescription>Mais pas question pour l\'ancien président de se faire piéger à l\'antenne sur les affaires de la mairie de Paris, qui vont donc être jugées: l\'opération de communication a été soigneusement préparée, avec une promotion restreinte, en terrain connu : un hebdomadaire (Le Point sort les bonnes feuilles mercredi), un quotidien (Le Figaro aura les honneurs d\'une interview jeudi), une radio (Europe 1, au micro de Jean-Pierre Elkabbach), et une télévision (il sera l\'invité de Michel Drucker dans &quot;Vivement Dimanche&quot;, sur France 2, le 29 novembre). Le livre a été envoyé au com</wlr:hasDescription><wlr:hasScore>0.895167</wlr:hasScore><wlr:hasRank>22</wlr:hasRank><dc:identifier>67685</dc:identifier><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/hit:2156"><wlr:inResultSetHit rdf:resource="periplus://simquery/result"/><wlr:isLinkedTo rdf:resource="periplus://resource:2156"/><wlr:hasDescription>Les débats s\'enchaînent au PS, sans que les équilibres internes ne paraissent évoluer. L\'incertitude persiste, aucun</wlr:hasDescription><wlr:hasScore>0.886579</wlr:hasScore><wlr:hasRank>23</wlr:hasRank><dc:identifier>26098</dc:identifier><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/hit:3849"><wlr:inResultSetHit rdf:resource="periplus://simquery/result"/><wlr:isLinkedTo rdf:resource="periplus://resource:3849"/><wlr:hasDescription>&quot;Celui qui gagne, c\'est celui qui arrive en tête&quot;, a rappelé Xavier Bertrand, le secrétaire général de l\'UMP, lors du dernier meeting européen de la majorité, jeudi soir, porte de Versailles, à Paris (lire notre article). On le sait déjà, dimanche soi</wlr:hasDescription><wlr:hasScore>0.885014</wlr:hasScore><wlr:hasRank>24</wlr:hasRank><dc:identifier>42094</dc:identifier><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/hit:3802"><wlr:inResultSetHit rdf:resource="periplus://simquery/result"/><wlr:isLinkedTo rdf:resource="periplus://resource:3802"/><wlr:hasDescription>Eparpiller les européennes façon puzzle, pour mieux les neutraliser : gaullistes et socialistes l\'avaient rêvé, le giscardien Raffarin l\'a fait. Le procès était instruit depu</wlr:hasDescription><wlr:hasScore>0.881176</wlr:hasScore><wlr:hasRank>25</wlr:hasRank><dc:identifier>41650</dc:identifier><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/hit:1320"><wlr:inResultSetHit rdf:resource="periplus://simquery/result"/><wlr:isLinkedTo rdf:resource="periplus://resource:1320"/><wlr:hasDescription>&quot;Nous hésitions entre le non et le non; ce sera non&quot;, a ironisé le sénateur socialiste Bernard Frimat, mercredi 16 juillet, en réponse à l\'interview de Nicolas Sarkozy sur la réforme des institutions, annonçant in extremis dans Le Monde quelques initiatives en faveur des droits de l\'opposition. Ces déclarations présidentiel</wlr:hasDescription><wlr:hasScore>0.878407</wlr:hasScore><wlr:hasRank>26</wlr:hasRank><dc:identifier>18705</dc:identifier><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/hit:1015"><wlr:inResultSetHit rdf:resource="periplus://simquery/result"/><wlr:isLinkedTo rdf:resource="periplus://resource:1015"/><wlr:hasDescription>Jeudi soir, sur le plateau d\'&quot;A vous de juger&quot;, sur France 2, la photo de famille de l\'UMP était parfaite. Derrière François Fillon, inv</wlr:hasDescription><wlr:hasScore>0.871634</wlr:hasScore><wlr:hasRank>27</wlr:hasRank><dc:identifier>16105</dc:identifier><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/hit:4397"><wlr:inResultSetHit rdf:resource="periplus://simquery/result"/><wlr:isLinkedTo rdf:resource="periplus://resource:4397"/><wlr:hasDescription>L\'alliance est de circonstances mais elle contraint la première secrétaire à réagir. Eparpillée depuis quelques mo</wlr:hasDescription><wlr:hasScore>0.869736</wlr:hasScore><wlr:hasRank>28</wlr:hasRank><dc:identifier>49377</dc:identifier><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/hit:4618"><wlr:inResultSetHit rdf:resource="periplus://simquery/result"/><wlr:isLinkedTo rdf:resource="periplus://resource:4618"/><wlr:hasDescription>Une fois de plus, Nicolas Sarkozy a profité d\'une tribune internationale - en l\'occurrence l\'assemblée générale annuelle des Nations unies à New York - pour tenir un langage extrêmement ferme à l\'attention de l\'Iran. Mais, alors que le président </wlr:hasDescription><wlr:hasScore>0.868531</wlr:hasScore><wlr:hasRank>29</wlr:hasRank><dc:identifier>59562</dc:identifier><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/hit:397"><wlr:inResultSetHit rdf:resource="periplus://simquery/result"/><wlr:isLinkedTo rdf:resource="periplus://resource:397"/><wlr:hasDescription>Les &quot; réformistes &quot; les plus conséquents à gauche ne sont pas toujours ceux que l\'on croit. Les premières réactions autou</wlr:hasDescription><wlr:hasScore>0.867952</wlr:hasScore><wlr:hasRank>30</wlr:hasRank><dc:identifier>10623</dc:identifier><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/hit:4285"><wlr:inResultSetHit rdf:resource="periplus://simquery/result"/><wlr:isLinkedTo rdf:resource="periplus://resource:4285"/><wlr:hasDescription>Deuxième volet de notre enquête sur les raisons de la crise du parti socialiste et les relations qu\'il entretient avec les milieux de la recherche (vous pouvez lire le premier volet en cliquant ici). Mediapart a voulu interroger </wlr:hasDescription><wlr:hasScore>0.867451</wlr:hasScore><wlr:hasRank>31</wlr:hasRank><dc:identifier>45812</dc:identifier><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/hit:1668"><wlr:inResultSetHit rdf:resource="periplus://simquery/result"/><wlr:isLinkedTo rdf:resource="periplus://resource:1668"/><wlr:hasDescription>Quand personne ne croyait trop que le RSA aboutirait, il faisait l\'objet de rares débats. Tant qu\'il s\'expérimentait da</wlr:hasDescription><wlr:hasScore>0.865544</wlr:hasScore><wlr:hasRank>32</wlr:hasRank><dc:identifier>21885</dc:identifier><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/hit:2129"><wlr:inResultSetHit rdf:resource="periplus://simquery/result"/><wlr:isLinkedTo rdf:resource="periplus://resource:2129"/><wlr:hasDescription>Edouard Balladur répondait, mercredi 22 octobre, sur le gravier de l\'Elysée à quelques questions sur les objectifs et le programme de la nouvelle mission que venait de lui confier Nicolas Sarkozy. Quelques minutes plus tôt, le</wlr:hasDescription><wlr:hasScore>0.865544</wlr:hasScore><wlr:hasRank>33</wlr:hasRank><dc:identifier>25866</dc:identifier><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/hit:5351"><wlr:inResultSetHit rdf:resource="periplus://simquery/result"/><wlr:isLinkedTo rdf:resource="periplus://resource:5351"/><wlr:hasDescription>&quot;Dans quelques années nous dirons: il y a l\'UMP et il y a le Nouveau Centre&quot;, a assuré Hervé Morin, lors des voeux aux cadres de son parti, lundi 18 janvier. Chaque année, le discours est</wlr:hasDescription><wlr:hasScore>0.865421</wlr:hasScore><wlr:hasRank>34</wlr:hasRank><dc:identifier>72565</dc:identifier><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/hit:4904"><wlr:inResultSetHit rdf:resource="periplus://simquery/result"/><wlr:isLinkedTo rdf:resource="periplus://resource:4904"/><wlr:hasDescription>François Hollande fait le bilan. Dans un livre d\'entretien ave</wlr:hasDescription><wlr:hasScore>0.86539</wlr:hasScore><wlr:hasRank>35</wlr:hasRank><dc:identifier>67950</dc:identifier><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/hit:1797"><wlr:inResultSetHit rdf:resource="periplus://simquery/result"/><wlr:isLinkedTo rdf:resource="periplus://resource:1797"/><wlr:hasDescription>Le fichage politique en France, c\'est fini ! C\'est du moins la promesse lancée par la ministre de l\'intérieur, devant l\'Assemblée nationale. Au gré d\'une réécriture compl</wlr:hasDescription><wlr:hasScore>0.865269</wlr:hasScore><wlr:hasRank>36</wlr:hasRank><dc:identifier>23106</dc:identifier><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/hit:1176"><wlr:inResultSetHit rdf:resource="periplus://simquery/result"/><wlr:isLinkedTo rdf:resource="periplus://resource:1176"/><wlr:hasDescription>Les parlementaires UMP, jusqu\'ici divisés sur la réforme des institutions, semblent avoir déniché un compromis sur le \&quot;dossier turc\&quot;, validé mardi 1er juillet par François Fillon. Les sénateurs, révulsés à l\'i</wlr:hasDescription><wlr:hasScore>0.865142</wlr:hasScore><wlr:hasRank>37</wlr:hasRank><dc:identifier>17508</dc:identifier><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/hit:571"><wlr:inResultSetHit rdf:resource="periplus://simquery/result"/><wlr:isLinkedTo rdf:resource="periplus://resource:571"/><wlr:hasDescription>Avocat, Jean-Pierre Mignard est président de l\'association Désirs d\'avenir depuis novembre 2007. Vieil ami de François Holland</wlr:hasDescription><wlr:hasScore>0.860128</wlr:hasScore><wlr:hasRank>38</wlr:hasRank><dc:identifier>12169</dc:identifier><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/hit:3676"><wlr:inResultSetHit rdf:resource="periplus://simquery/result"/><wlr:isLinkedTo rdf:resource="periplus://resource:3676"/><wlr:hasDescription>Comme un mauvais moment à passer. Depuis son entrée en campagne</wlr:hasDescription><wlr:hasScore>0.858979</wlr:hasScore><wlr:hasRank>39</wlr:hasRank><dc:identifier>40411</dc:identifier><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/hit:3799"><wlr:inResultSetHit rdf:resource="periplus://simquery/result"/><wlr:isLinkedTo rdf:resource="periplus://resource:3799"/><wlr:hasDescription>Une porcelaine (d\'une entreprise viennoise en difficulté) contre une statue africaine (de &quot;femme debout&quot;). Par cet échange de cadeaux, M</wlr:hasDescription><wlr:hasScore>0.858373</wlr:hasScore><wlr:hasRank>40</wlr:hasRank><dc:identifier>41634</dc:identifier><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/hit:3646"><wlr:inResultSetHit rdf:resource="periplus://simquery/result"/><wlr:isLinkedTo rdf:resource="periplus://resource:3646"/><wlr:hasDescription>Il a recueilli plus de 18% des voix au premier tour de l\'élection présidentielle de 2007. Les sondages le créditent de </wlr:hasDescription><wlr:hasScore>0.858245</wlr:hasScore><wlr:hasRank>41</wlr:hasRank><dc:identifier>40117</dc:identifier><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/hit:1535"><wlr:inResultSetHit rdf:resource="periplus://simquery/result"/><wlr:isLinkedTo rdf:resource="periplus://resource:1535"/><wlr:hasDescription>Nicolas Sarkozy et le gouvernement ont-t-ils bien perçu ce qui s\'est joué dans l\'environnement international? A lire les discours, à observer les décisions, la question se posait depuis un an ; la publication par l\'Insee du recul de 0,3% du PIB au deuxième trimestre et de la destruction de 12.000 emplois, avec les réaction</wlr:hasDescription><wlr:hasScore>0.856629</wlr:hasScore><wlr:hasRank>42</wlr:hasRank><dc:identifier>20563</dc:identifier><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/hit:2361"><wlr:inResultSetHit rdf:resource="periplus://simquery/result"/><wlr:isLinkedTo rdf:resource="periplus://resource:2361"/><wlr:hasDescription>A la veille de l\'élection du nouveau premier secrétaire socialiste, on n\'a jamais autant parlé\8230 du MoDem. Mardi, interrogée sur France </wlr:hasDescription><wlr:hasScore>0.856416</wlr:hasScore><wlr:hasRank>43</wlr:hasRank><dc:identifier>28041</dc:identifier><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/hit:2441"><wlr:inResultSetHit rdf:resource="periplus://simquery/result"/><wlr:isLinkedTo rdf:resource="periplus://resource:2441"/><wlr:hasDescription>A Paris, l\'UMP a des airs de parti socialiste, en cette période de renouvellement de la fédération. La semaine passée, les adhére</wlr:hasDescription><wlr:hasScore>0.854737</wlr:hasScore><wlr:hasRank>44</wlr:hasRank><dc:identifier>28692</dc:identifier><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/hit:5005"><wlr:inResultSetHit rdf:resource="periplus://simquery/result"/><wlr:isLinkedTo rdf:resource="periplus://resource:5005"/><wlr:hasDescription>La droite a longtemps détesté les panthéonisations. En 1908, celle de Zola fit de</wlr:hasDescription><wlr:hasScore>0.854737</wlr:hasScore><wlr:hasRank>45</wlr:hasRank><dc:identifier>69111</dc:identifier><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/hit:3556"><wlr:inResultSetHit rdf:resource="periplus://simquery/result"/><wlr:isLinkedTo rdf:resource="periplus://resource:3556"/><wlr:hasDescription>Martine Aubry en avait sans doute rêvé, Poul Nyrup Rasmussen l\'a fait. Le parti socialiste a enfin r</wlr:hasDescription><wlr:hasScore>0.854005</wlr:hasScore><wlr:hasRank>46</wlr:hasRank><dc:identifier>39274</dc:identifier><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/hit:47"><wlr:inResultSetHit rdf:resource="periplus://simquery/result"/><wlr:isLinkedTo rdf:resource="periplus://resource:47"/><wlr:hasDescription>C\'est assurément une crise atypique que traverse, en France, la presse quotidienne. Irruption de la gratuité et d</wlr:hasDescription><wlr:hasScore>0.853189</wlr:hasScore><wlr:hasRank>47</wlr:hasRank><dc:identifier>200</dc:identifier><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/hit:2185"><wlr:inResultSetHit rdf:resource="periplus://simquery/result"/><wlr:isLinkedTo rdf:resource="periplus://resource:2185"/><wlr:hasDescription>Il y a peu, les &quot;carnets noirs&quot; d\'Yves Bertrand et le fichier Edvige ravivaient le spectre de la police secrète. Dans le même temps, un servic</wlr:hasDescription><wlr:hasScore>0.852803</wlr:hasScore><wlr:hasRank>48</wlr:hasRank><dc:identifier>26509</dc:identifier><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/hit:2278"><wlr:inResultSetHit rdf:resource="periplus://simquery/result"/><wlr:isLinkedTo rdf:resource="periplus://resource:2278"/><wlr:hasDescription>Les grands esprits socialistes se sont reposés, au lendemain d\'une longue nuit électorale. Si Ségolène Royal arrive en t</wlr:hasDescription><wlr:hasScore>0.85201</wlr:hasScore><wlr:hasRank>49</wlr:hasRank><dc:identifier>27180</dc:identifier><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/hit:1902"><wlr:inResultSetHit rdf:resource="periplus://simquery/result"/><wlr:isLinkedTo rdf:resource="periplus://resource:1902"/><wlr:hasDescription>En pleine panique financière, les responsables politiques retrouvent la parole. Après la réunion de crise ce </wlr:hasDescription><wlr:hasScore>0.851838</wlr:hasScore><wlr:hasRank>50</wlr:hasRank><dc:identifier>23938</dc:identifier><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/hit:288"><wlr:inResultSetHit rdf:resource="periplus://simquery/result"/><wlr:isLinkedTo rdf:resource="periplus://resource:288"/><wlr:hasDescription>L\'UMP et le PS sont des jumeaux dizygotes. Ils ne sont pas issus du même</wlr:hasDescription><wlr:hasScore>0.848327</wlr:hasScore><wlr:hasRank>51</wlr:hasRank><dc:identifier>9624</dc:identifier><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/hit:1093"><wlr:inResultSetHit rdf:resource="periplus://simquery/result"/><wlr:isLinkedTo rdf:resource="periplus://resource:1093"/><wlr:hasDescription>Il dit vouloir rendre des comptes, démontrer combien les députés socialistes se sont montrés utiles depuis un an au Palais-Bourbon. Jean-Marc Ayrault organisera </wlr:hasDescription><wlr:hasScore>0.847377</wlr:hasScore><wlr:hasRank>52</wlr:hasRank><dc:identifier>16697</dc:identifier><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/hit:1462"><wlr:inResultSetHit rdf:resource="periplus://simquery/result"/><wlr:isLinkedTo rdf:resource="periplus://resource:1462"/><wlr:hasDescription>Les ministres sont partis en vacances mais il en est resté un, le porte-parole du gouvernement, Luc Chatel, pour faire le service après-vente des lois en cascade votées par le Parlement depuis un an. &quot;De grandes batailles idéolog</wlr:hasDescription><wlr:hasScore>0.847377</wlr:hasScore><wlr:hasRank>53</wlr:hasRank><dc:identifier>19657</dc:identifier><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/hit:2179"><wlr:inResultSetHit rdf:resource="periplus://simquery/result"/><wlr:isLinkedTo rdf:resource="periplus://resource:2179"/><wlr:hasDescription>Sitôt que l\'on a su que le taux de rémunération du Livret A allait baisser le 1er février prochain, de 4% actuellement à sans doute 3,5% et peut-être même 3%, cela a été un véritable tir de barrage. Comprenant qu\'en pleine tourm</wlr:hasDescription><wlr:hasScore>0.847377</wlr:hasScore><wlr:hasRank>54</wlr:hasRank><dc:identifier>26409</dc:identifier><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/hit:1403"><wlr:inResultSetHit rdf:resource="periplus://simquery/result"/><wlr:isLinkedTo rdf:resource="periplus://resource:1403"/><wlr:hasDescription>La \&quot;nouvelle\&quot; Constitution, parue jeudi 24 juillet au Journal officiel, fait littéralement jubiler Jean-François Copé. (Téléchargez ici le calendri</wlr:hasDescription><wlr:hasScore>0.845198</wlr:hasScore><wlr:hasRank>55</wlr:hasRank><dc:identifier>19199</dc:identifier><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/hit:2501"><wlr:inResultSetHit rdf:resource="periplus://simquery/result"/><wlr:isLinkedTo rdf:resource="periplus://resource:2501"/><wlr:hasDescription>Jeudi 4 décembre, l\'Assemblée nationale est entrée dans le vif du sujet, en adoptant deux mesures clés du projet de loi sur l\'audiovisuel public, qui prévoient la désignation et la révocation par le chef de l\'Etat des patrons de France Télévisions, de Radio France et d\'AEF (la holding regroupant France 24, RFI et TV5 Monde). Sur l\'article 8 (fixant le pr</wlr:hasDescription><wlr:hasScore>0.845198</wlr:hasScore><wlr:hasRank>56</wlr:hasRank><dc:identifier>29095</dc:identifier><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/hit:4470"><wlr:inResultSetHit rdf:resource="periplus://simquery/result"/><wlr:isLinkedTo rdf:resource="periplus://resource:4470"/><wlr:hasDescription>De notre envoyée spéciale à La Grande-Motte  Pour éviter qu\'écologistes et socialistes fassent une OPA sur le Modem, sorti très affaibli des élections européennes, Bayrou leur a lancé une &quot;offre publique de dialogue&quot;, dimanche 6 septembre, en clôture de l\'université d\'été du mouvement, organisée à La Grande-Motte. Par son discours, il a signé </wlr:hasDescription><wlr:hasScore>0.844449</wlr:hasScore><wlr:hasRank>57</wlr:hasRank><dc:identifier>53657</dc:identifier><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/hit:5881"><wlr:inResultSetHit rdf:resource="periplus://simquery/result"/><wlr:isLinkedTo rdf:resource="periplus://resource:5881"/><wlr:hasDescription>&quot;Je ne rentre pas au gouvernement dans les meilleures conditions, ni de popularité, ni de finances publiques&quot;, a reconnu le nouveau ministre du budget, sur Europe1, jeudi matin. Il aurait pu ajouter: &quot;ni de </wlr:hasDescription><wlr:hasScore>0.842533</wlr:hasScore><wlr:hasRank>58</wlr:hasRank><dc:identifier>78812</dc:identifier><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/hit:3533"><wlr:inResultSetHit rdf:resource="periplus://simquery/result"/><wlr:isLinkedTo rdf:resource="periplus://resource:3533"/><wlr:hasDescription>A l\'Elysée, on affirme que Dominique de Villepin ne fait pas peur. On prétend même qu\'il n\'a qu\'</wlr:hasDescription><wlr:hasScore>0.84111</wlr:hasScore><wlr:hasRank>59</wlr:hasRank><dc:identifier>39104</dc:identifier><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/hit:1978"><wlr:inResultSetHit rdf:resource="periplus://simquery/result"/><wlr:isLinkedTo rdf:resource="periplus://resource:1978"/><wlr:hasDescription>Aucune faillite retentissante, pas d\'annonce de menaces supplémentaires sur l\'économie malgré les prix de l\'immobilier qui commencent à chuter et l\'Islande qui se liquéfie. A Paris notamment, les marché</wlr:hasDescription><wlr:hasScore>0.837822</wlr:hasScore><wlr:hasRank>60</wlr:hasRank><dc:identifier>24554</dc:identifier><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/hit:5120"><wlr:inResultSetHit rdf:resource="periplus://simquery/result"/><wlr:isLinkedTo rdf:resource="periplus://resource:5120"/><wlr:hasDescription>Des élus qui claquent la porte de l\'UMP, des conseillers qui quittent sur la pointe des pieds l\'Elysée... Les annonces de ce lundi 7 </wlr:hasDescription><wlr:hasScore>0.837822</wlr:hasScore><wlr:hasRank>61</wlr:hasRank><dc:identifier>70129</dc:identifier><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/hit:154"><wlr:inResultSetHit rdf:resource="periplus://simquery/result"/><wlr:isLinkedTo rdf:resource="periplus://resource:154"/><wlr:hasDescription>Face au pouvoir central incarné par le sarkozysme et ses dépendances, s\'installe un contre-pouvoir territorial porté par le socialisme et ses associés. La France est &quot; coupée en deu</wlr:hasDescription><wlr:hasScore>0.837729</wlr:hasScore><wlr:hasRank>62</wlr:hasRank><dc:identifier>748</dc:identifier><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/hit:3862"><wlr:inResultSetHit rdf:resource="periplus://simquery/result"/><wlr:isLinkedTo rdf:resource="periplus://resource:3862"/><wlr:hasDescription>De midi à minuit, dans la journée du dimanche 7 juin, la rédaction de Mediapart a tenu la chronique, minute par minute, de la journée électorale. Vous pouvez lire ci-dessous, </wlr:hasDescription><wlr:hasScore>0.836646</wlr:hasScore><wlr:hasRank>63</wlr:hasRank><dc:identifier>42258</dc:identifier><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/hit:5246"><wlr:inResultSetHit rdf:resource="periplus://simquery/result"/><wlr:isLinkedTo rdf:resource="periplus://resource:5246"/><wlr:hasDescription>&quot;Les gnomes de Francfort&quot;, par exemple, qualificatif de Jean-Pierre Chevènement à l\'encontre des dirigeants de la Banque centrale européenne, gardienne du fameux traité de &quot;MasTrique&quot;. Il y a le savoureux &quot;Le parti</wlr:hasDescription><wlr:hasScore>0.829268</wlr:hasScore><wlr:hasRank>64</wlr:hasRank><dc:identifier>71364</dc:identifier><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/hit:5506"><wlr:inResultSetHit rdf:resource="periplus://simquery/result"/><wlr:isLinkedTo rdf:resource="periplus://resource:5506"/><wlr:hasDescription>Changement express de stratégie, négociations interminables pour boucler des listes, choix contestés en Ile-de-France, affaire Clearstream qui déchire la majorité. A moins de deux mois du scrut</wlr:hasDescription><wlr:hasScore>0.829268</wlr:hasScore><wlr:hasRank>65</wlr:hasRank><dc:identifier>74059</dc:identifier><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/hit:1524"><wlr:inResultSetHit rdf:resource="periplus://simquery/result"/><wlr:isLinkedTo rdf:resource="periplus://resource:1524"/><wlr:hasDescription>Les autruches sortent enfin la tête de terre. Contrairement à l\'antienne op</wlr:hasDescription><wlr:hasScore>0.827191</wlr:hasScore><wlr:hasRank>66</wlr:hasRank><dc:identifier>20496</dc:identifier><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/hit:1614"><wlr:inResultSetHit rdf:resource="periplus://simquery/result"/><wlr:isLinkedTo rdf:resource="periplus://resource:1614"/><wlr:hasDescription>Elle a la voix toute chevrotante, Monique. Mégaphone en main, cette inst</wlr:hasDescription><wlr:hasScore>0.825859</wlr:hasScore><wlr:hasRank>67</wlr:hasRank><dc:identifier>21353</dc:identifier><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/hit:3576"><wlr:inResultSetHit rdf:resource="periplus://simquery/result"/><wlr:isLinkedTo rdf:resource="periplus://resource:3576"/><wlr:hasDescription>&quot;La politique est de retour ! Ces élections seront politiques&quot;, a prévenu Xavier Bertrand en marge du premier meeting européen de l\'UMP, mardi soir, à Rueil-Malmaison (Hauts-de-Seine). Le but était clair : ramener </wlr:hasDescription><wlr:hasScore>0.825809</wlr:hasScore><wlr:hasRank>68</wlr:hasRank><dc:identifier>39518</dc:identifier><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/hit:5922"><wlr:inResultSetHit rdf:resource="periplus://simquery/result"/><wlr:isLinkedTo rdf:resource="periplus://resource:5922"/><wlr:hasDescription>Même s\'il est un ami de Nicolas Sarkozy et un client d\'Alain Minc, Stéphane Courbit est depuis quelque temps bien malheureux en affaires. Après avoir acquis une partic</wlr:hasDescription><wlr:hasScore>0.825159</wlr:hasScore><wlr:hasRank>69</wlr:hasRank><dc:identifier>79317</dc:identifier><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/hit:5786"><wlr:inResultSetHit rdf:resource="periplus://simquery/result"/><wlr:isLinkedTo rdf:resource="periplus://resource:5786"/><wlr:hasDescription>La rumeur circule depuis quelques jours - le site internet Wansquare s\'en est fait le premier l\'écho, et après lui Le Point - et nous en avons obtenu une confirmation de très bonne source: Yazid Sabeg, l\'actuel commissaire à la diversité et à l\'égalité des chances, devrait succéder à Anne Lauvergeon à la tête d\'Areva, le champion du nucléaire français. Selon nos informations, cette</wlr:hasDescription><wlr:hasScore>0.824374</wlr:hasScore><wlr:hasRank>70</wlr:hasRank><dc:identifier>77916</dc:identifier><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/hit:4453"><wlr:inResultSetHit rdf:resource="periplus://simquery/result"/><wlr:isLinkedTo rdf:resource="periplus://resource:4453"/><wlr:hasDescription>Après avoir passé son été à tempêter, menaçant de démissionner de la direction ou d\'en appeler aux militants pour imposer les primaires ouvertes qu\'il promeut dans un livre (Comment sauver la gauche, au Seuil, avec Olivier Ferrand), Arnaud Montebourg est finalement l\'un des grands gagnants des universités d\'été de La Rochelle. Même si son forcing a irrité </wlr:hasDescription><wlr:hasScore>0.824323</wlr:hasScore><wlr:hasRank>71</wlr:hasRank><dc:identifier>52502</dc:identifier><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/hit:347"><wlr:inResultSetHit rdf:resource="periplus://simquery/result"/><wlr:isLinkedTo rdf:resource="periplus://resource:347"/><wlr:hasDescription>L\'accueil de guérilleros des Forces armées révolutionnaires en Colombie (FARC) sur le territoire français : voilà la probable clef diplomatique de la tentative de libération d\'Ingrid Betancourt qui est en train de se jouer en Amérique du Sud. L\'Elysée a annoncé, mercredi </wlr:hasDescription><wlr:hasScore>0.823627</wlr:hasScore><wlr:hasRank>72</wlr:hasRank><dc:identifier>10057</dc:identifier><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/hit:600"><wlr:inResultSetHit rdf:resource="periplus://simquery/result"/><wlr:isLinkedTo rdf:resource="periplus://resource:600"/><wlr:hasDescription>En matière culturelle, le candidat à l\'élection présidentielle Nicolas Sarkozy s\'était limité au strict minimum. Deux promesses saillantes, en</wlr:hasDescription><wlr:hasScore>0.823627</wlr:hasScore><wlr:hasRank>73</wlr:hasRank><dc:identifier>12369</dc:identifier><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/hit:3200"><wlr:inResultSetHit rdf:resource="periplus://simquery/result"/><wlr:isLinkedTo rdf:resource="periplus://resource:3200"/><wlr:hasDescription>&quot;Je suis quelqu\'un de souple dans mes charentaises&quot;, plaisante Valérie Pécresse sur France Culture en février 2009, en contrepoint du fameux &quot;droit dans mes bottes&quot; d\'Alain Juppé en pleine crise de la réforme des retraites en 1995. Cette souplesse en chaussons </wlr:hasDescription><wlr:hasScore>0.823627</wlr:hasScore><wlr:hasRank>74</wlr:hasRank><dc:identifier>35718</dc:identifier><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/hit:4458"><wlr:inResultSetHit rdf:resource="periplus://simquery/result"/><wlr:isLinkedTo rdf:resource="periplus://resource:4458"/><wlr:hasDescription>Jean-Pierre Mignard quitte la présidence de Désirs d\'avenir désormais assumée par Ségolène Royal elle-même, qui entend transformer l\'association en &quot;ONG européenne&quot; proche d\'une fondation type think tank, comme le précise un communiqué publié jeudi 3 septembre. Dans un entretien à Mediapart</wlr:hasDescription><wlr:hasScore>0.823627</wlr:hasScore><wlr:hasRank>75</wlr:hasRank><dc:identifier>53147</dc:identifier><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/hit:4698"><wlr:inResultSetHit rdf:resource="periplus://simquery/result"/><wlr:isLinkedTo rdf:resource="periplus://resource:4698"/><wlr:hasDescription>Alors que la session parlementaire est à peine réunie, que les sujets foisonnent allant des suites de la crise économique au colossal déficit budgétaire en passant par la réforme des collectivités locales, quel est l\'un des tout premiers sujets que le gouvernement décide d\'inscrire à l\'ordre du jour de l\'Assemblée nationale? L\'ouverture du marché des jeux en ligne et la fin du monopole de l\'Etat sur ce secteur.&quot;Nous avons pour ambition que </wlr:hasDescription><wlr:hasScore>0.823627</wlr:hasScore><wlr:hasRank>76</wlr:hasRank><dc:identifier>63657</dc:identifier><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/hit:4823"><wlr:inResultSetHit rdf:resource="periplus://simquery/result"/><wlr:isLinkedTo rdf:resource="periplus://resource:4823"/><wlr:hasDescription>&quot;Je ne dirai rien sur les élections au PS, ce serait désagréable&quot;, ironisait Jean Sarkozy, vendredi, au conseil général des Hauts-de-Seine, lors de son discours de candidat au poste d\'administrateur de l\'Epad. A l\'UMP, on se plaît à renvoy</wlr:hasDescription><wlr:hasScore>0.823127</wlr:hasScore><wlr:hasRank>77</wlr:hasRank><dc:identifier>67076</dc:identifier><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/hit:4272"><wlr:inResultSetHit rdf:resource="periplus://simquery/result"/><wlr:isLinkedTo rdf:resource="periplus://resource:4272"/><wlr:hasDescription>Oublions Jack Lang, Bernard-Henri Lévy et leurs imprécations sur la mort assurée du Parti socialiste. Laissons à Max Gallo, ancien </wlr:hasDescription><wlr:hasScore>0.822925</wlr:hasScore><wlr:hasRank>78</wlr:hasRank><dc:identifier>45740</dc:identifier><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/hit:2577"><wlr:inResultSetHit rdf:resource="periplus://simquery/result"/><wlr:isLinkedTo rdf:resource="periplus://resource:2577"/><wlr:hasDescription>Attention, un train peut en cacher un autre. L\'arrivée de Patrick Devedjia</wlr:hasDescription><wlr:hasScore>0.819154</wlr:hasScore><wlr:hasRank>79</wlr:hasRank><dc:identifier>29621</dc:identifier><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/hit:4728"><wlr:inResultSetHit rdf:resource="periplus://simquery/result"/><wlr:isLinkedTo rdf:resource="periplus://resource:4728"/><wlr:hasDescription>L\'ex-judoka David Douillet, engagé sous les couleurs du parti présidentiel, a écrasé le premier tour de l\'élection législative partielle organisée dimanche 11 octobre, dans la 12e circonscription des Yvelines, en captant 44,2% des voix, soit le double du candidat socialiste et maire de Poissy, Frédérik Bernard, qui a recueilli 21,9% des bulletins. Le candidat d\'Europe-Ecologie</wlr:hasDescription><wlr:hasScore>0.818169</wlr:hasScore><wlr:hasRank>80</wlr:hasRank><dc:identifier>65097</dc:identifier><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/hit:5490"><wlr:inResultSetHit rdf:resource="periplus://simquery/result"/><wlr:isLinkedTo rdf:resource="periplus://resource:5490"/><wlr:hasDescription>Jeudi, l\'UMP était plus bavarde sur la dernière sortie du socialiste Georges Frêche que sur la relaxe de Dominique de Villepin dans le procès Clearstream. Connu pour dégainer des commu</wlr:hasDescription><wlr:hasScore>0.818169</wlr:hasScore><wlr:hasRank>81</wlr:hasRank><dc:identifier>73885</dc:identifier><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/hit:4341"><wlr:inResultSetHit rdf:resource="periplus://simquery/result"/><wlr:isLinkedTo rdf:resource="periplus://resource:4341"/><wlr:hasDescription>Plus de trois mois après le revers des élections européennes, où il a recueilli à peine 16,48%, devançant d\'une rien les listes Europe-Ecologie, et à quelques jours de son université d\'été de La Rochelle (28-30 août), il n\'est pas certain que le parti socialiste a retrouvé confiance, sérénité et cohésion. Entre les silences de Ségolèn</wlr:hasDescription><wlr:hasScore>0.817228</wlr:hasScore><wlr:hasRank>82</wlr:hasRank><dc:identifier>46602</dc:identifier><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/hit:2286"><wlr:inResultSetHit rdf:resource="periplus://simquery/result"/><wlr:isLinkedTo rdf:resource="periplus://resource:2286"/><wlr:hasDescription>Lundi 10 novembre au matin, une délégation du Cran, conseil représentatif des associations noires, est reçue à l\'Elysée. Pas par le président, ni par </wlr:hasDescription><wlr:hasScore>0.817157</wlr:hasScore><wlr:hasRank>83</wlr:hasRank><dc:identifier>27334</dc:identifier><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/hit:3510"><wlr:inResultSetHit rdf:resource="periplus://simquery/result"/><wlr:isLinkedTo rdf:resource="periplus://resource:3510"/><wlr:hasDescription>&quot;Une caravane mobile pour montrer que l\'Europe peut mobiliser.&quot; Lundi 20 avril, le secrétair</wlr:hasDescription><wlr:hasScore>0.817157</wlr:hasScore><wlr:hasRank>84</wlr:hasRank><dc:identifier>38947</dc:identifier><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/hit:4201"><wlr:inResultSetHit rdf:resource="periplus://simquery/result"/><wlr:isLinkedTo rdf:resource="periplus://resource:4201"/><wlr:hasDescription>Martin Hirsch a pris un coup de jeune. Tel un étudiant cherchant un </wlr:hasDescription><wlr:hasScore>0.817157</wlr:hasScore><wlr:hasRank>85</wlr:hasRank><dc:identifier>45166</dc:identifier><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/hit:4545"><wlr:inResultSetHit rdf:resource="periplus://simquery/result"/><wlr:isLinkedTo rdf:resource="periplus://resource:4545"/><wlr:hasDescription>Il aura fallu deux ans pour que Nicolas Sarkozy fasse son mea-culpa sur les empreintes génétiques réservées aux étrangers souhaitant rejoindre leur famille en France. Lors d\'une rencontre à l\'Élys</wlr:hasDescription><wlr:hasScore>0.815821</wlr:hasScore><wlr:hasRank>86</wlr:hasRank><dc:identifier>56762</dc:identifier><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/hit:4513"><wlr:inResultSetHit rdf:resource="periplus://simquery/result"/><wlr:isLinkedTo rdf:resource="periplus://resource:4513"/><wlr:hasDescription>Il a été l\'une des stars de \8220l\'ouverture socialiste\8221 durant l\'été, participant aux meetings de François Hollande (à Lorient en juin) puis de Vincent Peillon (à Marseille en août). Désormais ressorti de l\'anony</wlr:hasDescription><wlr:hasScore>0.814434</wlr:hasScore><wlr:hasRank>87</wlr:hasRank><dc:identifier>55167</dc:identifier><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/hit:446"><wlr:inResultSetHit rdf:resource="periplus://simquery/result"/><wlr:isLinkedTo rdf:resource="periplus://resource:446"/><wlr:hasDescription>L\'inusable Michel Charasse exclu du PS? La fédération socialiste du Puy-de-Dôme en a voté la demande jeudi soir, à une large majorité du conseil fédéral (42 voix contre 14). Mais l\'ancien ministre du Bud</wlr:hasDescription><wlr:hasScore>0.814077</wlr:hasScore><wlr:hasRank>88</wlr:hasRank><dc:identifier>11001</dc:identifier><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/hit:2312"><wlr:inResultSetHit rdf:resource="periplus://simquery/result"/><wlr:isLinkedTo rdf:resource="periplus://resource:2312"/><wlr:hasDescription>Ces derniers jours, le bruit s\'est répandu comme une traînée de poudre dans la maison socialiste: &quot;La presse people débarque au congrès!&quot; Les journalistes de Voici seraient déjà en route pour Reims, bardés de magnétos... Interrogé, le service de pr</wlr:hasDescription><wlr:hasScore>0.814077</wlr:hasScore><wlr:hasRank>89</wlr:hasRank><dc:identifier>27639</dc:identifier><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/hit:5488"><wlr:inResultSetHit rdf:resource="periplus://simquery/result"/><wlr:isLinkedTo rdf:resource="periplus://resource:5488"/><wlr:hasDescription>Si le parti socialiste n\'est toujours pas un long fleuve tranquille, il parvient tout de même à ne pas se noyer dans les eaux troubles de la division. En adoptant mardi soir une po</wlr:hasDescription><wlr:hasScore>0.814077</wlr:hasScore><wlr:hasRank>90</wlr:hasRank><dc:identifier>73823</dc:identifier><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/hit:2075"><wlr:inResultSetHit rdf:resource="periplus://simquery/result"/><wlr:isLinkedTo rdf:resource="periplus://resource:2075"/><wlr:hasDescription>La Caisse d\'épargne, qui a révélé une perte de 600 millions d\'euros dans des opérations de marché, doit réunir son conseil de surveillance, dimanche 19 octobre, dans l\'après-midi, afin de se prononcer sur le sort de la direction et notamment celui du président du directoire de la Caisse nationale des Caisses d\'épargne (CNCE), Charles Milhaud.Dans un entretien, publié par</wlr:hasDescription><wlr:hasScore>0.813793</wlr:hasScore><wlr:hasRank>91</wlr:hasRank><dc:identifier>25510</dc:identifier><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/hit:487"><wlr:inResultSetHit rdf:resource="periplus://simquery/result"/><wlr:isLinkedTo rdf:resource="periplus://resource:487"/><wlr:hasDescription>Du &quot;les caisses sont vides&quot; de Nicolas Sarkozy au &quot;pays en faillite&quot; de François Fillon, le triste état des finances publiques françaises alimente la chronique par intermittence. Mais derrière le propos polit</wlr:hasDescription><wlr:hasScore>0.811021</wlr:hasScore><wlr:hasRank>92</wlr:hasRank><dc:identifier>11333</dc:identifier><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/hit:1799"><wlr:inResultSetHit rdf:resource="periplus://simquery/result"/><wlr:isLinkedTo rdf:resource="periplus://resource:1799"/><wlr:hasDescription>Adieu levées de fourches, déversements de lisier, saccages de bâtiments administratifs et autres violences à agents de la force publique : la grande agriculture française semble être entrée dans l\'ère du lobbying à visage humain. Et elle a choisi pour annonce</wlr:hasDescription><wlr:hasScore>0.811021</wlr:hasScore><wlr:hasRank>93</wlr:hasRank><dc:identifier>23127</dc:identifier><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/hit:1976"><wlr:inResultSetHit rdf:resource="periplus://simquery/result"/><wlr:isLinkedTo rdf:resource="periplus://resource:1976"/><wlr:hasDescription>Mais où est donc passée la gauche? Cette époque de tempête et de crise devrait être faste pour elle. Alors que le capitalisme trav</wlr:hasDescription><wlr:hasScore>0.811021</wlr:hasScore><wlr:hasRank>94</wlr:hasRank><dc:identifier>24528</dc:identifier><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/hit:5753"><wlr:inResultSetHit rdf:resource="periplus://simquery/result"/><wlr:isLinkedTo rdf:resource="periplus://resource:5753"/><wlr:hasDescription>Chez Europe Ecologie, beaucoup ne le disent qu\'à demi-mot, mais ils sont déçus: tous auraient aimé dépasser les 16% des européennes de 2009. Tout juste débarqué de son ma</wlr:hasDescription><wlr:hasScore>0.810912</wlr:hasScore><wlr:hasRank>95</wlr:hasRank><dc:identifier>77546</dc:identifier><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/hit:1592"><wlr:inResultSetHit rdf:resource="periplus://simquery/result"/><wlr:isLinkedTo rdf:resource="periplus://resource:1592"/><wlr:hasDescription>Certains auront peut-être du mal à le croire, mais, à quelques heures de l\'ouverture de la Convention démocrate de Denver, chargée d\'investir officiellement Barack Obama, ce dernier n\'est pas encore assuré d\'accéder à la Maison Blanche. Les 200.000 Allemands qui lui</wlr:hasDescription><wlr:hasScore>0.810167</wlr:hasScore><wlr:hasRank>96</wlr:hasRank><dc:identifier>21133</dc:identifier><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/hit:1600"><wlr:inResultSetHit rdf:resource="periplus://simquery/result"/><wlr:isLinkedTo rdf:resource="periplus://resource:1600"/><wlr:hasDescription>On prête à Talleyrand ce mot: \&quot;Quand je m\'examine, je m\'inquiète. Quand je me compare, je me ra</wlr:hasDescription><wlr:hasScore>0.804479</wlr:hasScore><wlr:hasRank>97</wlr:hasRank><dc:identifier>21227</dc:identifier><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/hit:5548"><wlr:inResultSetHit rdf:resource="periplus://simquery/result"/><wlr:isLinkedTo rdf:resource="periplus://resource:5548"/><wlr:hasDescription>De notre envoyée spéciale en Paca, Ce jour-là, en campagne sur le site nucléaire du Tricastin, Europe Ecologie vient mesurer la radioactivité et déposer une gerbe de fleurs: &quot;Ci-gît la santé publique!&quot;... Des candidats aux régionale</wlr:hasDescription><wlr:hasScore>0.802372</wlr:hasScore><wlr:hasRank>98</wlr:hasRank><dc:identifier>74485</dc:identifier><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/hit:2290"><wlr:inResultSetHit rdf:resource="periplus://simquery/result"/><wlr:isLinkedTo rdf:resource="periplus://resource:2290"/><wlr:hasDescription>Difficile construction d\'alliances majoritaires, au parti socialiste. Après le vote des motions et </wlr:hasDescription><wlr:hasScore>0.801553</wlr:hasScore><wlr:hasRank>99</wlr:hasRank><dc:identifier>27360</dc:identifier><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/hit:2033"><wlr:inResultSetHit rdf:resource="periplus://simquery/result"/><wlr:isLinkedTo rdf:resource="periplus://resource:2033"/><wlr:hasDescription>Soudain, un week-end, le travail du dimanche est devenu priorité nationale. Dimanche dernier, le ministre</wlr:hasDescription><wlr:hasScore>0.801468</wlr:hasScore><wlr:hasRank>100</wlr:hasRank><dc:identifier>25201</dc:identifier><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/cluster:0"><wlr:hasNumberOfResults>19</wlr:hasNumberOfResults><wlr:isLinkedTo rdf:resource="periplus://cluster:0"/><wlr:hasScore>1</wlr:hasScore><wlr:hasDescription>Proche de Ségolène Royal, François Rebsamen a un temps envisagé de faire le trait-d\'union avec les amis de François Hollande pour renverser Martine Aubry de la direction du PS. Rentré dans le rang</wlr:hasDescription><mediaUnit xsi:type="model:Image"><wlr:hasNativeContent>http://static.mediapart.fr/files/imagecache/300_pixels/St%C3%A9phane%20Alli%C3%A8s/ResizedImage383255-IMG0707.JPG</wlr:hasNativeContent></mediaUnit><mediaUnit xsi:type="model:Image"><wlr:hasNativeContent>http://static.mediapart.fr/files/Mathilde Mathieu/229180457_9db20a3f47_m.jpg</wlr:hasNativeContent></mediaUnit><dc:title>PS</dc:title><rdf:type rdf:resource="DocumentCluster"/></rdf:Description><rdf:Bag rdf:about="periplus://simquery/result/cluster:0"><rdf:li rdf:resource="periplus://simquery/result/hit:3883"/><rdf:li rdf:resource="periplus://simquery/result/hit:2475"/><rdf:li rdf:resource="periplus://simquery/result/hit:4210"/><rdf:li rdf:resource="periplus://simquery/result/hit:2156"/><rdf:li rdf:resource="periplus://simquery/result/hit:3676"/><rdf:li rdf:resource="periplus://simquery/result/hit:3799"/><rdf:li rdf:resource="periplus://simquery/result/hit:2278"/><rdf:li rdf:resource="periplus://simquery/result/hit:1093"/><rdf:li rdf:resource="periplus://simquery/result/hit:1600"/><rdf:li rdf:resource="periplus://simquery/result/hit:2290"/><rdf:li rdf:resource="periplus://simquery/result/hit:4285"/><rdf:li rdf:resource="periplus://simquery/result/hit:571"/><rdf:li rdf:resource="periplus://simquery/result/hit:4458"/><rdf:li rdf:resource="periplus://simquery/result/hit:4272"/><rdf:li rdf:resource="periplus://simquery/result/hit:446"/><rdf:li rdf:resource="periplus://simquery/result/hit:2312"/><rdf:li rdf:resource="periplus://simquery/result/hit:5488"/><rdf:li rdf:resource="periplus://simquery/result/hit:4513"/><rdf:li rdf:resource="periplus://simquery/result/hit:4728"/></rdf:Bag><rdf:Description rdf:about="periplus://simquery/result/cluster:1"><wlr:hasNumberOfResults>9</wlr:hasNumberOfResults><wlr:isLinkedTo rdf:resource="periplus://cluster:1"/><wlr:hasScore>0.970595</wlr:hasScore><wlr:hasDescription>Lot de consolation pour la droite : La Guyane basculerait. Selon des chiffres encore</wlr:hasDescription><mediaUnit xsi:type="model:Image"><wlr:hasNativeContent>http://static.mediapart.fr/files/imagecache/300_pixels/La%20r%C3%A9daction%20Mediapart/rejet.png</wlr:hasNativeContent></mediaUnit><mediaUnit xsi:type="model:Image"><wlr:hasNativeContent>http://static.mediapart.fr/files/imagecache/475_pixels/La%20r%C3%A9daction%20Mediapart/paille.png</wlr:hasNativeContent></mediaUnit><dc:title>élections régionales</dc:title><rdf:type rdf:resource="DocumentCluster"/></rdf:Description><rdf:Bag rdf:about="periplus://simquery/result/cluster:1"><rdf:li rdf:resource="periplus://simquery/result/hit:5803"/><rdf:li rdf:resource="periplus://simquery/result/hit:5767"/><rdf:li rdf:resource="periplus://simquery/result/hit:5548"/><rdf:li rdf:resource="periplus://simquery/result/hit:133"/><rdf:li rdf:resource="periplus://simquery/result/hit:3256"/><rdf:li rdf:resource="periplus://simquery/result/hit:3328"/><rdf:li rdf:resource="periplus://simquery/result/hit:4397"/><rdf:li rdf:resource="periplus://simquery/result/hit:96"/><rdf:li rdf:resource="periplus://simquery/result/hit:5506"/></rdf:Bag><rdf:Description rdf:about="periplus://simquery/result/cluster:2"><wlr:hasNumberOfResults>25</wlr:hasNumberOfResults><wlr:isLinkedTo rdf:resource="periplus://cluster:2"/><wlr:hasScore>0.961693</wlr:hasScore><wlr:hasDescription>Du changement de statut de La Poste, il n\'a été que peu question durant la campagne des élections européennes, comme si la réforme avait pris du retard ou n\'était plus d\'actualité. Et pourtant, il n\'en est rien</wlr:hasDescription><mediaUnit xsi:type="model:Image"><wlr:hasNativeContent>http://static.mediapart.fr/files/Laurent Mauduit/Image 8_13.png</wlr:hasNativeContent></mediaUnit><dc:title>gouvernement UMP</dc:title><rdf:type rdf:resource="DocumentCluster"/></rdf:Description><rdf:Bag rdf:about="periplus://simquery/result/cluster:2"><rdf:li rdf:resource="periplus://simquery/result/hit:3844"/><rdf:li rdf:resource="periplus://simquery/result/hit:2129"/><rdf:li rdf:resource="periplus://simquery/result/hit:2441"/><rdf:li rdf:resource="periplus://simquery/result/hit:5120"/><rdf:li rdf:resource="periplus://simquery/result/hit:2501"/><rdf:li rdf:resource="periplus://simquery/result/hit:1462"/><rdf:li rdf:resource="periplus://simquery/result/hit:1797"/><rdf:li rdf:resource="periplus://simquery/result/hit:2185"/><rdf:li rdf:resource="periplus://simquery/result/hit:397"/><rdf:li rdf:resource="periplus://simquery/result/hit:1668"/><rdf:li rdf:resource="periplus://simquery/result/hit:1036"/><rdf:li rdf:resource="periplus://simquery/result/hit:1614"/><rdf:li rdf:resource="periplus://simquery/result/hit:1535"/><rdf:li rdf:resource="periplus://simquery/result/hit:1320"/><rdf:li rdf:resource="periplus://simquery/result/hit:1176"/><rdf:li rdf:resource="periplus://simquery/result/hit:1403"/><rdf:li rdf:resource="periplus://simquery/result/hit:2179"/><rdf:li rdf:resource="periplus://simquery/result/hit:1976"/><rdf:li rdf:resource="periplus://simquery/result/hit:154"/><rdf:li rdf:resource="periplus://simquery/result/hit:47"/><rdf:li rdf:resource="periplus://simquery/result/hit:347"/><rdf:li rdf:resource="periplus://simquery/result/hit:2033"/><rdf:li rdf:resource="periplus://simquery/result/hit:4698"/><rdf:li rdf:resource="periplus://simquery/result/hit:4201"/><rdf:li rdf:resource="periplus://simquery/result/hit:4545"/></rdf:Bag><rdf:Description rdf:about="periplus://simquery/result/cluster:3"><wlr:hasNumberOfResults>4</wlr:hasNumberOfResults><wlr:isLinkedTo rdf:resource="periplus://cluster:3"/><wlr:hasScore>0.936393</wlr:hasScore><wlr:hasDescription>Une bombe dort au pôle financier du tribunal de grande instance de Paris. Les juges Françoise Desset et</wlr:hasDescription><mediaUnit xsi:type="model:Image"><wlr:hasNativeContent>http://static.mediapart.fr/files/imagecache/475_pixels/Fabrice%20Arfi/article_photo_1218010950574-1-0.jpg</wlr:hasNativeContent></mediaUnit><dc:title>affaire de Karachi</dc:title><rdf:type rdf:resource="DocumentCluster"/></rdf:Description><rdf:Bag rdf:about="periplus://simquery/result/cluster:3"><rdf:li rdf:resource="periplus://simquery/result/hit:1744"/><rdf:li rdf:resource="periplus://simquery/result/hit:1745"/><rdf:li rdf:resource="periplus://simquery/result/hit:3972"/><rdf:li rdf:resource="periplus://simquery/result/hit:3973"/></rdf:Bag><rdf:Description rdf:about="periplus://simquery/result/cluster:4"><wlr:hasNumberOfResults>9</wlr:hasNumberOfResults><wlr:isLinkedTo rdf:resource="periplus://cluster:4"/><wlr:hasScore>0.928015</wlr:hasScore><wlr:hasDescription>&quot;Dans une telle campagne où les petites phrases et les effets médiatiques semblent plus compter que le fond, de belles images au 20 heures ne peuvent pas faire de mal.&quot; Ce commentaire d\'un dirigean</wlr:hasDescription><mediaUnit xsi:type="model:Image"><wlr:hasNativeContent>http://static.mediapart.fr/files/imagecache/300_pixels/St%C3%A9phane%20Alli%C3%A8s/Image%205_5.png</wlr:hasNativeContent></mediaUnit><dc:title>campagne des européennes</dc:title><rdf:type rdf:resource="DocumentCluster"/></rdf:Description><rdf:Bag rdf:about="periplus://simquery/result/cluster:4"><rdf:li rdf:resource="periplus://simquery/result/hit:3789"/><rdf:li rdf:resource="periplus://simquery/result/hit:3556"/><rdf:li rdf:resource="periplus://simquery/result/hit:3849"/><rdf:li rdf:resource="periplus://simquery/result/hit:3802"/><rdf:li rdf:resource="periplus://simquery/result/hit:3576"/><rdf:li rdf:resource="periplus://simquery/result/hit:5753"/><rdf:li rdf:resource="periplus://simquery/result/hit:3862"/><rdf:li rdf:resource="periplus://simquery/result/hit:4341"/><rdf:li rdf:resource="periplus://simquery/result/hit:3510"/></rdf:Bag><rdf:Description rdf:about="periplus://simquery/result/cluster:5"><wlr:hasNumberOfResults>10</wlr:hasNumberOfResults><wlr:isLinkedTo rdf:resource="periplus://cluster:5"/><wlr:hasScore>0.914044</wlr:hasScore><wlr:hasDescription>L\'UMP et le PS sont des jumeaux dizygotes. Ils ne sont pas issus du même</wlr:hasDescription><mediaUnit xsi:type="model:Image"><wlr:hasNativeContent>http://static.mediapart.fr/files/imagecache/475_pixels/Marine%20Turchi/2083.jpg</wlr:hasNativeContent></mediaUnit><dc:title>UMP</dc:title><rdf:type rdf:resource="DocumentCluster"/></rdf:Description><rdf:Bag rdf:about="periplus://simquery/result/cluster:5"><rdf:li rdf:resource="periplus://simquery/result/hit:288"/><rdf:li rdf:resource="periplus://simquery/result/hit:3675"/><rdf:li rdf:resource="periplus://simquery/result/hit:3993"/><rdf:li rdf:resource="periplus://simquery/result/hit:1015"/><rdf:li rdf:resource="periplus://simquery/result/hit:3533"/><rdf:li rdf:resource="periplus://simquery/result/hit:600"/><rdf:li rdf:resource="periplus://simquery/result/hit:3200"/><rdf:li rdf:resource="periplus://simquery/result/hit:2577"/><rdf:li rdf:resource="periplus://simquery/result/hit:4823"/><rdf:li rdf:resource="periplus://simquery/result/hit:5490"/></rdf:Bag><rdf:Description rdf:about="periplus://simquery/result/cluster:6"><wlr:hasNumberOfResults>6</wlr:hasNumberOfResults><wlr:isLinkedTo rdf:resource="periplus://cluster:6"/><wlr:hasScore>0.907456</wlr:hasScore><wlr:hasDescription>Jacques Julliard, 77 ans, entre en dissidence. Figure historique de la &quot;deux</wlr:hasDescription><mediaUnit xsi:type="model:Image"><wlr:hasNativeContent>http://static.mediapart.fr/files/imagecache/250_pixels/St%C3%A9phane%20Alli%C3%A8s/julliard.png</wlr:hasNativeContent></mediaUnit><mediaUnit xsi:type="model:Image"><wlr:hasNativeContent>http://static.mediapart.fr/files/imagecache/300_pixels/Marine%20Turchi/chirac_balladur.png</wlr:hasNativeContent></mediaUnit><dc:title>livre</dc:title><rdf:type rdf:resource="DocumentCluster"/></rdf:Description><rdf:Bag rdf:about="periplus://simquery/result/cluster:6"><rdf:li rdf:resource="periplus://simquery/result/hit:5828"/><rdf:li rdf:resource="periplus://simquery/result/hit:4870"/><rdf:li rdf:resource="periplus://simquery/result/hit:5246"/><rdf:li rdf:resource="periplus://simquery/result/hit:4453"/><rdf:li rdf:resource="periplus://simquery/result/hit:4904"/><rdf:li rdf:resource="periplus://simquery/result/hit:5005"/></rdf:Bag><rdf:Description rdf:about="periplus://simquery/result/cluster:7"><wlr:hasNumberOfResults>4</wlr:hasNumberOfResults><wlr:isLinkedTo rdf:resource="periplus://cluster:7"/><wlr:hasScore>0.865421</wlr:hasScore><wlr:hasDescription>&quot;Dans quelques années nous dirons: il y a l\'UMP et il y a le Nouveau Centre&quot;, a assuré Hervé Morin, lors des voeux aux cadres de son parti, lundi 18 janvier. Chaque année, le discours est</wlr:hasDescription><mediaUnit xsi:type="model:Image"><wlr:hasNativeContent>http://static.mediapart.fr/files/Marine%20Turchi/udf.png</wlr:hasNativeContent></mediaUnit><mediaUnit xsi:type="model:Image"><wlr:hasNativeContent>http://static.mediapart.fr/files/imagecache/150_pixels/Marine%20Turchi/Dominique_villepin_1.jpg</wlr:hasNativeContent></mediaUnit><dc:title>Nouveau Centre Modem</dc:title><rdf:type rdf:resource="DocumentCluster"/></rdf:Description><rdf:Bag rdf:about="periplus://simquery/result/cluster:7"><rdf:li rdf:resource="periplus://simquery/result/hit:5351"/><rdf:li rdf:resource="periplus://simquery/result/hit:3646"/><rdf:li rdf:resource="periplus://simquery/result/hit:2361"/><rdf:li rdf:resource="periplus://simquery/result/hit:4470"/></rdf:Bag><rdf:Description rdf:about="periplus://simquery/result/cluster:8"><wlr:hasNumberOfResults>6</wlr:hasNumberOfResults><wlr:isLinkedTo rdf:resource="periplus://cluster:8"/><wlr:hasScore>0.851838</wlr:hasScore><wlr:hasDescription>En pleine panique financière, les responsables politiques retrouvent la parole. Après la réunion de crise ce </wlr:hasDescription><mediaUnit xsi:type="model:Image"><wlr:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/3883</wlr:hasNativeContent></mediaUnit><mediaUnit xsi:type="model:Image"><wlr:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/3256</wlr:hasNativeContent></mediaUnit><dc:title>panique financière</dc:title><rdf:type rdf:resource="DocumentCluster"/></rdf:Description><rdf:Bag rdf:about="periplus://simquery/result/cluster:8"><rdf:li rdf:resource="periplus://simquery/result/hit:1902"/><rdf:li rdf:resource="periplus://simquery/result/hit:5881"/><rdf:li rdf:resource="periplus://simquery/result/hit:1978"/><rdf:li rdf:resource="periplus://simquery/result/hit:1524"/><rdf:li rdf:resource="periplus://simquery/result/hit:2075"/><rdf:li rdf:resource="periplus://simquery/result/hit:487"/></rdf:Bag><rdf:Description rdf:about="periplus://simquery/result/cluster:9"><wlr:hasNumberOfResults>8</wlr:hasNumberOfResults><wlr:isLinkedTo rdf:resource="periplus://cluster:9"/><wlr:hasScore>0.95304</wlr:hasScore><wlr:hasDescription>No summary available</wlr:hasDescription><dc:title>etc.</dc:title><rdf:type rdf:resource="DocumentCluster"/></rdf:Description><rdf:Bag rdf:about="periplus://simquery/result/cluster:9"><rdf:li rdf:resource="periplus://simquery/result/hit:271"/><rdf:li rdf:resource="periplus://simquery/result/hit:1799"/><rdf:li rdf:resource="periplus://simquery/result/hit:1732"/><rdf:li rdf:resource="periplus://simquery/result/hit:4618"/><rdf:li rdf:resource="periplus://simquery/result/hit:5922"/><rdf:li rdf:resource="periplus://simquery/result/hit:5786"/><rdf:li rdf:resource="periplus://simquery/result/hit:1592"/><rdf:li rdf:resource="periplus://simquery/result/hit:2286"/></rdf:Bag><rdf:Description rdf:about="periplus://simquery/result"><wlr:hasQueryOffset>0</wlr:hasQueryOffset><wlr:hasNumberOfResults>100</wlr:hasNumberOfResults><wlr:isResultOf rdf:resource="periplus://simquery"/><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/model#ResultSet"/><wlr:hasHit rdf:resource="periplus://simquery/result/hit:3883"/><wlr:hasHit rdf:resource="periplus://simquery/result/hit:3256"/><wlr:hasHit rdf:resource="periplus://simquery/result/hit:3328"/><wlr:hasHit rdf:resource="periplus://simquery/result/hit:3844"/><wlr:hasHit rdf:resource="periplus://simquery/result/hit:271"/><wlr:hasHit rdf:resource="periplus://simquery/result/hit:1732"/><wlr:hasHit rdf:resource="periplus://simquery/result/hit:5803"/><wlr:hasHit rdf:resource="periplus://simquery/result/hit:1744"/><wlr:hasHit rdf:resource="periplus://simquery/result/hit:1745"/><wlr:hasHit rdf:resource="periplus://simquery/result/hit:96"/><wlr:hasHit rdf:resource="periplus://simquery/result/hit:4210"/><wlr:hasHit rdf:resource="periplus://simquery/result/hit:3972"/><wlr:hasHit rdf:resource="periplus://simquery/result/hit:3973"/><wlr:hasHit rdf:resource="periplus://simquery/result/hit:2475"/><wlr:hasHit rdf:resource="periplus://simquery/result/hit:3789"/><wlr:hasHit rdf:resource="periplus://simquery/result/hit:5767"/><wlr:hasHit rdf:resource="periplus://simquery/result/hit:1036"/><wlr:hasHit rdf:resource="periplus://simquery/result/hit:133"/><wlr:hasHit rdf:resource="periplus://simquery/result/hit:3675"/><wlr:hasHit rdf:resource="periplus://simquery/result/hit:5828"/><wlr:hasHit rdf:resource="periplus://simquery/result/hit:3993"/><wlr:hasHit rdf:resource="periplus://simquery/result/hit:4870"/><wlr:hasHit rdf:resource="periplus://simquery/result/hit:2156"/><wlr:hasHit rdf:resource="periplus://simquery/result/hit:3849"/><wlr:hasHit rdf:resource="periplus://simquery/result/hit:3802"/><wlr:hasHit rdf:resource="periplus://simquery/result/hit:1320"/><wlr:hasHit rdf:resource="periplus://simquery/result/hit:1015"/><wlr:hasHit rdf:resource="periplus://simquery/result/hit:4397"/><wlr:hasHit rdf:resource="periplus://simquery/result/hit:4618"/><wlr:hasHit rdf:resource="periplus://simquery/result/hit:397"/><wlr:hasHit rdf:resource="periplus://simquery/result/hit:4285"/><wlr:hasHit rdf:resource="periplus://simquery/result/hit:1668"/><wlr:hasHit rdf:resource="periplus://simquery/result/hit:2129"/><wlr:hasHit rdf:resource="periplus://simquery/result/hit:5351"/><wlr:hasHit rdf:resource="periplus://simquery/result/hit:4904"/><wlr:hasHit rdf:resource="periplus://simquery/result/hit:1797"/><wlr:hasHit rdf:resource="periplus://simquery/result/hit:1176"/><wlr:hasHit rdf:resource="periplus://simquery/result/hit:571"/><wlr:hasHit rdf:resource="periplus://simquery/result/hit:3676"/><wlr:hasHit rdf:resource="periplus://simquery/result/hit:3799"/><wlr:hasHit rdf:resource="periplus://simquery/result/hit:3646"/><wlr:hasHit rdf:resource="periplus://simquery/result/hit:1535"/><wlr:hasHit rdf:resource="periplus://simquery/result/hit:2361"/><wlr:hasHit rdf:resource="periplus://simquery/result/hit:2441"/><wlr:hasHit rdf:resource="periplus://simquery/result/hit:5005"/><wlr:hasHit rdf:resource="periplus://simquery/result/hit:3556"/><wlr:hasHit rdf:resource="periplus://simquery/result/hit:47"/><wlr:hasHit rdf:resource="periplus://simquery/result/hit:2185"/><wlr:hasHit rdf:resource="periplus://simquery/result/hit:2278"/><wlr:hasHit rdf:resource="periplus://simquery/result/hit:1902"/><wlr:hasHit rdf:resource="periplus://simquery/result/hit:288"/><wlr:hasHit rdf:resource="periplus://simquery/result/hit:1093"/><wlr:hasHit rdf:resource="periplus://simquery/result/hit:1462"/><wlr:hasHit rdf:resource="periplus://simquery/result/hit:2179"/><wlr:hasHit rdf:resource="periplus://simquery/result/hit:1403"/><wlr:hasHit rdf:resource="periplus://simquery/result/hit:2501"/><wlr:hasHit rdf:resource="periplus://simquery/result/hit:4470"/><wlr:hasHit rdf:resource="periplus://simquery/result/hit:5881"/><wlr:hasHit rdf:resource="periplus://simquery/result/hit:3533"/><wlr:hasHit rdf:resource="periplus://simquery/result/hit:1978"/><wlr:hasHit rdf:resource="periplus://simquery/result/hit:5120"/><wlr:hasHit rdf:resource="periplus://simquery/result/hit:154"/><wlr:hasHit rdf:resource="periplus://simquery/result/hit:3862"/><wlr:hasHit rdf:resource="periplus://simquery/result/hit:5246"/><wlr:hasHit rdf:resource="periplus://simquery/result/hit:5506"/><wlr:hasHit rdf:resource="periplus://simquery/result/hit:1524"/><wlr:hasHit rdf:resource="periplus://simquery/result/hit:1614"/><wlr:hasHit rdf:resource="periplus://simquery/result/hit:3576"/><wlr:hasHit rdf:resource="periplus://simquery/result/hit:5922"/><wlr:hasHit rdf:resource="periplus://simquery/result/hit:5786"/><wlr:hasHit rdf:resource="periplus://simquery/result/hit:4453"/><wlr:hasHit rdf:resource="periplus://simquery/result/hit:347"/><wlr:hasHit rdf:resource="periplus://simquery/result/hit:600"/><wlr:hasHit rdf:resource="periplus://simquery/result/hit:3200"/><wlr:hasHit rdf:resource="periplus://simquery/result/hit:4458"/><wlr:hasHit rdf:resource="periplus://simquery/result/hit:4698"/><wlr:hasHit rdf:resource="periplus://simquery/result/hit:4823"/><wlr:hasHit rdf:resource="periplus://simquery/result/hit:4272"/><wlr:hasHit rdf:resource="periplus://simquery/result/hit:2577"/><wlr:hasHit rdf:resource="periplus://simquery/result/hit:4728"/><wlr:hasHit rdf:resource="periplus://simquery/result/hit:5490"/><wlr:hasHit rdf:resource="periplus://simquery/result/hit:4341"/><wlr:hasHit rdf:resource="periplus://simquery/result/hit:2286"/><wlr:hasHit rdf:resource="periplus://simquery/result/hit:3510"/><wlr:hasHit rdf:resource="periplus://simquery/result/hit:4201"/><wlr:hasHit rdf:resource="periplus://simquery/result/hit:4545"/><wlr:hasHit rdf:resource="periplus://simquery/result/hit:4513"/><wlr:hasHit rdf:resource="periplus://simquery/result/hit:446"/><wlr:hasHit rdf:resource="periplus://simquery/result/hit:2312"/><wlr:hasHit rdf:resource="periplus://simquery/result/hit:5488"/><wlr:hasHit rdf:resource="periplus://simquery/result/hit:2075"/><wlr:hasHit rdf:resource="periplus://simquery/result/hit:487"/><wlr:hasHit rdf:resource="periplus://simquery/result/hit:1799"/><wlr:hasHit rdf:resource="periplus://simquery/result/hit:1976"/><wlr:hasHit rdf:resource="periplus://simquery/result/hit:5753"/><wlr:hasHit rdf:resource="periplus://simquery/result/hit:1592"/><wlr:hasHit rdf:resource="periplus://simquery/result/hit:1600"/><wlr:hasHit rdf:resource="periplus://simquery/result/hit:5548"/><wlr:hasHit rdf:resource="periplus://simquery/result/hit:2290"/><wlr:hasHit rdf:resource="periplus://simquery/result/hit:2033"/></rdf:Description></rdf:RDF></data></annotation><resource uri="periplus://resource:3883" xsi:type="model:Document"><annotation uri="periplus://resource:3883/annot:0"><data><rdf:RDF xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://resource:3883"><wlp:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/3883</wlp:hasNativeContent></rdf:Description></rdf:RDF></data></annotation></resource><resource uri="periplus://resource:3256" xsi:type="model:Document"><annotation uri="periplus://resource:3256/annot:0"><data><rdf:RDF xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://resource:3256"><wlp:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/3256</wlp:hasNativeContent></rdf:Description></rdf:RDF></data></annotation></resource><resource uri="periplus://resource:3328" xsi:type="model:Document"><annotation uri="periplus://resource:3328/annot:0"><data><rdf:RDF xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://resource:3328"><wlp:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/3328</wlp:hasNativeContent></rdf:Description></rdf:RDF></data></annotation></resource><resource uri="periplus://resource:3844" xsi:type="model:Document"><annotation uri="periplus://resource:3844/annot:0"><data><rdf:RDF xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://resource:3844"><wlp:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/3844</wlp:hasNativeContent></rdf:Description></rdf:RDF></data></annotation></resource><resource uri="periplus://resource:271" xsi:type="model:Document"><annotation uri="periplus://resource:271/annot:0"><data><rdf:RDF xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://resource:271"><wlp:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/271</wlp:hasNativeContent></rdf:Description></rdf:RDF></data></annotation></resource><resource uri="periplus://resource:1732" xsi:type="model:Document"><annotation uri="periplus://resource:1732/annot:0"><data><rdf:RDF xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://resource:1732"><wlp:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/1732</wlp:hasNativeContent></rdf:Description></rdf:RDF></data></annotation></resource><resource uri="periplus://resource:5803" xsi:type="model:Document"><annotation uri="periplus://resource:5803/annot:0"><data><rdf:RDF xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://resource:5803"><wlp:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/5803</wlp:hasNativeContent></rdf:Description></rdf:RDF></data></annotation></resource><resource uri="periplus://resource:1744" xsi:type="model:Document"><annotation uri="periplus://resource:1744/annot:0"><data><rdf:RDF xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://resource:1744"><wlp:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/1744</wlp:hasNativeContent></rdf:Description></rdf:RDF></data></annotation></resource><resource uri="periplus://resource:1745" xsi:type="model:Document"><annotation uri="periplus://resource:1745/annot:0"><data><rdf:RDF xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://resource:1745"><wlp:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/1745</wlp:hasNativeContent></rdf:Description></rdf:RDF></data></annotation></resource><resource uri="periplus://resource:96" xsi:type="model:Document"><annotation uri="periplus://resource:96/annot:0"><data><rdf:RDF xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://resource:96"><wlp:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/96</wlp:hasNativeContent></rdf:Description></rdf:RDF></data></annotation></resource><resource uri="periplus://resource:4210" xsi:type="model:Document"><annotation uri="periplus://resource:4210/annot:0"><data><rdf:RDF xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://resource:4210"><wlp:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/4210</wlp:hasNativeContent></rdf:Description></rdf:RDF></data></annotation></resource><resource uri="periplus://resource:3972" xsi:type="model:Document"><annotation uri="periplus://resource:3972/annot:0"><data><rdf:RDF xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://resource:3972"><wlp:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/3972</wlp:hasNativeContent></rdf:Description></rdf:RDF></data></annotation></resource><resource uri="periplus://resource:3973" xsi:type="model:Document"><annotation uri="periplus://resource:3973/annot:0"><data><rdf:RDF xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://resource:3973"><wlp:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/3973</wlp:hasNativeContent></rdf:Description></rdf:RDF></data></annotation></resource><resource uri="periplus://resource:2475" xsi:type="model:Document"><annotation uri="periplus://resource:2475/annot:0"><data><rdf:RDF xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://resource:2475"><wlp:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/2475</wlp:hasNativeContent></rdf:Description></rdf:RDF></data></annotation></resource><resource uri="periplus://resource:3789" xsi:type="model:Document"><annotation uri="periplus://resource:3789/annot:0"><data><rdf:RDF xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://resource:3789"><wlp:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/3789</wlp:hasNativeContent></rdf:Description></rdf:RDF></data></annotation></resource><resource uri="periplus://resource:5767" xsi:type="model:Document"><annotation uri="periplus://resource:5767/annot:0"><data><rdf:RDF xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://resource:5767"><wlp:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/5767</wlp:hasNativeContent></rdf:Description></rdf:RDF></data></annotation></resource><resource uri="periplus://resource:1036" xsi:type="model:Document"><annotation uri="periplus://resource:1036/annot:0"><data><rdf:RDF xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://resource:1036"><wlp:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/1036</wlp:hasNativeContent></rdf:Description></rdf:RDF></data></annotation></resource><resource uri="periplus://resource:133" xsi:type="model:Document"><annotation uri="periplus://resource:133/annot:0"><data><rdf:RDF xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://resource:133"><wlp:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/133</wlp:hasNativeContent></rdf:Description></rdf:RDF></data></annotation></resource><resource uri="periplus://resource:3675" xsi:type="model:Document"><annotation uri="periplus://resource:3675/annot:0"><data><rdf:RDF xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://resource:3675"><wlp:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/3675</wlp:hasNativeContent></rdf:Description></rdf:RDF></data></annotation></resource><resource uri="periplus://resource:5828" xsi:type="model:Document"><annotation uri="periplus://resource:5828/annot:0"><data><rdf:RDF xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://resource:5828"><wlp:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/5828</wlp:hasNativeContent></rdf:Description></rdf:RDF></data></annotation></resource><resource uri="periplus://resource:3993" xsi:type="model:Document"><annotation uri="periplus://resource:3993/annot:0"><data><rdf:RDF xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://resource:3993"><wlp:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/3993</wlp:hasNativeContent></rdf:Description></rdf:RDF></data></annotation></resource><resource uri="periplus://resource:4870" xsi:type="model:Document"><annotation uri="periplus://resource:4870/annot:0"><data><rdf:RDF xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://resource:4870"><wlp:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/4870</wlp:hasNativeContent></rdf:Description></rdf:RDF></data></annotation></resource><resource uri="periplus://resource:2156" xsi:type="model:Document"><annotation uri="periplus://resource:2156/annot:0"><data><rdf:RDF xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://resource:2156"><wlp:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/2156</wlp:hasNativeContent></rdf:Description></rdf:RDF></data></annotation></resource><resource uri="periplus://resource:3849" xsi:type="model:Document"><annotation uri="periplus://resource:3849/annot:0"><data><rdf:RDF xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://resource:3849"><wlp:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/3849</wlp:hasNativeContent></rdf:Description></rdf:RDF></data></annotation></resource><resource uri="periplus://resource:3802" xsi:type="model:Document"><annotation uri="periplus://resource:3802/annot:0"><data><rdf:RDF xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://resource:3802"><wlp:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/3802</wlp:hasNativeContent></rdf:Description></rdf:RDF></data></annotation></resource><resource uri="periplus://resource:1320" xsi:type="model:Document"><annotation uri="periplus://resource:1320/annot:0"><data><rdf:RDF xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://resource:1320"><wlp:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/1320</wlp:hasNativeContent></rdf:Description></rdf:RDF></data></annotation></resource><resource uri="periplus://resource:1015" xsi:type="model:Document"><annotation uri="periplus://resource:1015/annot:0"><data><rdf:RDF xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://resource:1015"><wlp:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/1015</wlp:hasNativeContent></rdf:Description></rdf:RDF></data></annotation></resource><resource uri="periplus://resource:4397" xsi:type="model:Document"><annotation uri="periplus://resource:4397/annot:0"><data><rdf:RDF xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://resource:4397"><wlp:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/4397</wlp:hasNativeContent></rdf:Description></rdf:RDF></data></annotation></resource><resource uri="periplus://resource:4618" xsi:type="model:Document"><annotation uri="periplus://resource:4618/annot:0"><data><rdf:RDF xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://resource:4618"><wlp:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/4618</wlp:hasNativeContent></rdf:Description></rdf:RDF></data></annotation></resource><resource uri="periplus://resource:397" xsi:type="model:Document"><annotation uri="periplus://resource:397/annot:0"><data><rdf:RDF xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://resource:397"><wlp:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/397</wlp:hasNativeContent></rdf:Description></rdf:RDF></data></annotation></resource><resource uri="periplus://resource:4285" xsi:type="model:Document"><annotation uri="periplus://resource:4285/annot:0"><data><rdf:RDF xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://resource:4285"><wlp:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/4285</wlp:hasNativeContent></rdf:Description></rdf:RDF></data></annotation></resource><resource uri="periplus://resource:1668" xsi:type="model:Document"><annotation uri="periplus://resource:1668/annot:0"><data><rdf:RDF xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://resource:1668"><wlp:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/1668</wlp:hasNativeContent></rdf:Description></rdf:RDF></data></annotation></resource><resource uri="periplus://resource:2129" xsi:type="model:Document"><annotation uri="periplus://resource:2129/annot:0"><data><rdf:RDF xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://resource:2129"><wlp:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/2129</wlp:hasNativeContent></rdf:Description></rdf:RDF></data></annotation></resource><resource uri="periplus://resource:5351" xsi:type="model:Document"><annotation uri="periplus://resource:5351/annot:0"><data><rdf:RDF xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://resource:5351"><wlp:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/5351</wlp:hasNativeContent></rdf:Description></rdf:RDF></data></annotation></resource><resource uri="periplus://resource:4904" xsi:type="model:Document"><annotation uri="periplus://resource:4904/annot:0"><data><rdf:RDF xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://resource:4904"><wlp:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/4904</wlp:hasNativeContent></rdf:Description></rdf:RDF></data></annotation></resource><resource uri="periplus://resource:1797" xsi:type="model:Document"><annotation uri="periplus://resource:1797/annot:0"><data><rdf:RDF xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://resource:1797"><wlp:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/1797</wlp:hasNativeContent></rdf:Description></rdf:RDF></data></annotation></resource><resource uri="periplus://resource:1176" xsi:type="model:Document"><annotation uri="periplus://resource:1176/annot:0"><data><rdf:RDF xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://resource:1176"><wlp:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/1176</wlp:hasNativeContent></rdf:Description></rdf:RDF></data></annotation></resource><resource uri="periplus://resource:571" xsi:type="model:Document"><annotation uri="periplus://resource:571/annot:0"><data><rdf:RDF xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://resource:571"><wlp:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/571</wlp:hasNativeContent></rdf:Description></rdf:RDF></data></annotation></resource><resource uri="periplus://resource:3676" xsi:type="model:Document"><annotation uri="periplus://resource:3676/annot:0"><data><rdf:RDF xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://resource:3676"><wlp:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/3676</wlp:hasNativeContent></rdf:Description></rdf:RDF></data></annotation></resource><resource uri="periplus://resource:3799" xsi:type="model:Document"><annotation uri="periplus://resource:3799/annot:0"><data><rdf:RDF xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://resource:3799"><wlp:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/3799</wlp:hasNativeContent></rdf:Description></rdf:RDF></data></annotation></resource><resource uri="periplus://resource:3646" xsi:type="model:Document"><annotation uri="periplus://resource:3646/annot:0"><data><rdf:RDF xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://resource:3646"><wlp:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/3646</wlp:hasNativeContent></rdf:Description></rdf:RDF></data></annotation></resource><resource uri="periplus://resource:1535" xsi:type="model:Document"><annotation uri="periplus://resource:1535/annot:0"><data><rdf:RDF xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://resource:1535"><wlp:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/1535</wlp:hasNativeContent></rdf:Description></rdf:RDF></data></annotation></resource><resource uri="periplus://resource:2361" xsi:type="model:Document"><annotation uri="periplus://resource:2361/annot:0"><data><rdf:RDF xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://resource:2361"><wlp:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/2361</wlp:hasNativeContent></rdf:Description></rdf:RDF></data></annotation></resource><resource uri="periplus://resource:2441" xsi:type="model:Document"><annotation uri="periplus://resource:2441/annot:0"><data><rdf:RDF xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://resource:2441"><wlp:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/2441</wlp:hasNativeContent></rdf:Description></rdf:RDF></data></annotation></resource><resource uri="periplus://resource:5005" xsi:type="model:Document"><annotation uri="periplus://resource:5005/annot:0"><data><rdf:RDF xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://resource:5005"><wlp:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/5005</wlp:hasNativeContent></rdf:Description></rdf:RDF></data></annotation></resource><resource uri="periplus://resource:3556" xsi:type="model:Document"><annotation uri="periplus://resource:3556/annot:0"><data><rdf:RDF xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://resource:3556"><wlp:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/3556</wlp:hasNativeContent></rdf:Description></rdf:RDF></data></annotation></resource><resource uri="periplus://resource:47" xsi:type="model:Document"><annotation uri="periplus://resource:47/annot:0"><data><rdf:RDF xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://resource:47"><wlp:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/47</wlp:hasNativeContent></rdf:Description></rdf:RDF></data></annotation></resource><resource uri="periplus://resource:2185" xsi:type="model:Document"><annotation uri="periplus://resource:2185/annot:0"><data><rdf:RDF xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://resource:2185"><wlp:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/2185</wlp:hasNativeContent></rdf:Description></rdf:RDF></data></annotation></resource><resource uri="periplus://resource:2278" xsi:type="model:Document"><annotation uri="periplus://resource:2278/annot:0"><data><rdf:RDF xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://resource:2278"><wlp:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/2278</wlp:hasNativeContent></rdf:Description></rdf:RDF></data></annotation></resource><resource uri="periplus://resource:1902" xsi:type="model:Document"><annotation uri="periplus://resource:1902/annot:0"><data><rdf:RDF xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://resource:1902"><wlp:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/1902</wlp:hasNativeContent></rdf:Description></rdf:RDF></data></annotation></resource><resource uri="periplus://resource:288" xsi:type="model:Document"><annotation uri="periplus://resource:288/annot:0"><data><rdf:RDF xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://resource:288"><wlp:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/288</wlp:hasNativeContent></rdf:Description></rdf:RDF></data></annotation></resource><resource uri="periplus://resource:1093" xsi:type="model:Document"><annotation uri="periplus://resource:1093/annot:0"><data><rdf:RDF xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://resource:1093"><wlp:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/1093</wlp:hasNativeContent></rdf:Description></rdf:RDF></data></annotation></resource><resource uri="periplus://resource:1462" xsi:type="model:Document"><annotation uri="periplus://resource:1462/annot:0"><data><rdf:RDF xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://resource:1462"><wlp:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/1462</wlp:hasNativeContent></rdf:Description></rdf:RDF></data></annotation></resource><resource uri="periplus://resource:2179" xsi:type="model:Document"><annotation uri="periplus://resource:2179/annot:0"><data><rdf:RDF xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://resource:2179"><wlp:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/2179</wlp:hasNativeContent></rdf:Description></rdf:RDF></data></annotation></resource><resource uri="periplus://resource:1403" xsi:type="model:Document"><annotation uri="periplus://resource:1403/annot:0"><data><rdf:RDF xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://resource:1403"><wlp:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/1403</wlp:hasNativeContent></rdf:Description></rdf:RDF></data></annotation></resource><resource uri="periplus://resource:2501" xsi:type="model:Document"><annotation uri="periplus://resource:2501/annot:0"><data><rdf:RDF xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://resource:2501"><wlp:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/2501</wlp:hasNativeContent></rdf:Description></rdf:RDF></data></annotation></resource><resource uri="periplus://resource:4470" xsi:type="model:Document"><annotation uri="periplus://resource:4470/annot:0"><data><rdf:RDF xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://resource:4470"><wlp:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/4470</wlp:hasNativeContent></rdf:Description></rdf:RDF></data></annotation></resource><resource uri="periplus://resource:5881" xsi:type="model:Document"><annotation uri="periplus://resource:5881/annot:0"><data><rdf:RDF xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://resource:5881"><wlp:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/5881</wlp:hasNativeContent></rdf:Description></rdf:RDF></data></annotation></resource><resource uri="periplus://resource:3533" xsi:type="model:Document"><annotation uri="periplus://resource:3533/annot:0"><data><rdf:RDF xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://resource:3533"><wlp:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/3533</wlp:hasNativeContent></rdf:Description></rdf:RDF></data></annotation></resource><resource uri="periplus://resource:1978" xsi:type="model:Document"><annotation uri="periplus://resource:1978/annot:0"><data><rdf:RDF xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://resource:1978"><wlp:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/1978</wlp:hasNativeContent></rdf:Description></rdf:RDF></data></annotation></resource><resource uri="periplus://resource:5120" xsi:type="model:Document"><annotation uri="periplus://resource:5120/annot:0"><data><rdf:RDF xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://resource:5120"><wlp:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/5120</wlp:hasNativeContent></rdf:Description></rdf:RDF></data></annotation></resource><resource uri="periplus://resource:154" xsi:type="model:Document"><annotation uri="periplus://resource:154/annot:0"><data><rdf:RDF xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://resource:154"><wlp:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/154</wlp:hasNativeContent></rdf:Description></rdf:RDF></data></annotation></resource><resource uri="periplus://resource:3862" xsi:type="model:Document"><annotation uri="periplus://resource:3862/annot:0"><data><rdf:RDF xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://resource:3862"><wlp:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/3862</wlp:hasNativeContent></rdf:Description></rdf:RDF></data></annotation></resource><resource uri="periplus://resource:5246" xsi:type="model:Document"><annotation uri="periplus://resource:5246/annot:0"><data><rdf:RDF xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://resource:5246"><wlp:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/5246</wlp:hasNativeContent></rdf:Description></rdf:RDF></data></annotation></resource><resource uri="periplus://resource:5506" xsi:type="model:Document"><annotation uri="periplus://resource:5506/annot:0"><data><rdf:RDF xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://resource:5506"><wlp:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/5506</wlp:hasNativeContent></rdf:Description></rdf:RDF></data></annotation></resource><resource uri="periplus://resource:1524" xsi:type="model:Document"><annotation uri="periplus://resource:1524/annot:0"><data><rdf:RDF xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://resource:1524"><wlp:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/1524</wlp:hasNativeContent></rdf:Description></rdf:RDF></data></annotation></resource><resource uri="periplus://resource:1614" xsi:type="model:Document"><annotation uri="periplus://resource:1614/annot:0"><data><rdf:RDF xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://resource:1614"><wlp:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/1614</wlp:hasNativeContent></rdf:Description></rdf:RDF></data></annotation></resource><resource uri="periplus://resource:3576" xsi:type="model:Document"><annotation uri="periplus://resource:3576/annot:0"><data><rdf:RDF xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://resource:3576"><wlp:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/3576</wlp:hasNativeContent></rdf:Description></rdf:RDF></data></annotation></resource><resource uri="periplus://resource:5922" xsi:type="model:Document"><annotation uri="periplus://resource:5922/annot:0"><data><rdf:RDF xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://resource:5922"><wlp:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/5922</wlp:hasNativeContent></rdf:Description></rdf:RDF></data></annotation></resource><resource uri="periplus://resource:5786" xsi:type="model:Document"><annotation uri="periplus://resource:5786/annot:0"><data><rdf:RDF xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://resource:5786"><wlp:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/5786</wlp:hasNativeContent></rdf:Description></rdf:RDF></data></annotation></resource><resource uri="periplus://resource:4453" xsi:type="model:Document"><annotation uri="periplus://resource:4453/annot:0"><data><rdf:RDF xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://resource:4453"><wlp:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/4453</wlp:hasNativeContent></rdf:Description></rdf:RDF></data></annotation></resource><resource uri="periplus://resource:347" xsi:type="model:Document"><annotation uri="periplus://resource:347/annot:0"><data><rdf:RDF xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://resource:347"><wlp:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/347</wlp:hasNativeContent></rdf:Description></rdf:RDF></data></annotation></resource><resource uri="periplus://resource:600" xsi:type="model:Document"><annotation uri="periplus://resource:600/annot:0"><data><rdf:RDF xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://resource:600"><wlp:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/600</wlp:hasNativeContent></rdf:Description></rdf:RDF></data></annotation></resource><resource uri="periplus://resource:3200" xsi:type="model:Document"><annotation uri="periplus://resource:3200/annot:0"><data><rdf:RDF xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://resource:3200"><wlp:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/3200</wlp:hasNativeContent></rdf:Description></rdf:RDF></data></annotation></resource><resource uri="periplus://resource:4458" xsi:type="model:Document"><annotation uri="periplus://resource:4458/annot:0"><data><rdf:RDF xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://resource:4458"><wlp:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/4458</wlp:hasNativeContent></rdf:Description></rdf:RDF></data></annotation></resource><resource uri="periplus://resource:4698" xsi:type="model:Document"><annotation uri="periplus://resource:4698/annot:0"><data><rdf:RDF xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://resource:4698"><wlp:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/4698</wlp:hasNativeContent></rdf:Description></rdf:RDF></data></annotation></resource><resource uri="periplus://resource:4823" xsi:type="model:Document"><annotation uri="periplus://resource:4823/annot:0"><data><rdf:RDF xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://resource:4823"><wlp:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/4823</wlp:hasNativeContent></rdf:Description></rdf:RDF></data></annotation></resource><resource uri="periplus://resource:4272" xsi:type="model:Document"><annotation uri="periplus://resource:4272/annot:0"><data><rdf:RDF xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://resource:4272"><wlp:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/4272</wlp:hasNativeContent></rdf:Description></rdf:RDF></data></annotation></resource><resource uri="periplus://resource:2577" xsi:type="model:Document"><annotation uri="periplus://resource:2577/annot:0"><data><rdf:RDF xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://resource:2577"><wlp:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/2577</wlp:hasNativeContent></rdf:Description></rdf:RDF></data></annotation></resource><resource uri="periplus://resource:4728" xsi:type="model:Document"><annotation uri="periplus://resource:4728/annot:0"><data><rdf:RDF xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://resource:4728"><wlp:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/4728</wlp:hasNativeContent></rdf:Description></rdf:RDF></data></annotation></resource><resource uri="periplus://resource:5490" xsi:type="model:Document"><annotation uri="periplus://resource:5490/annot:0"><data><rdf:RDF xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://resource:5490"><wlp:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/5490</wlp:hasNativeContent></rdf:Description></rdf:RDF></data></annotation></resource><resource uri="periplus://resource:4341" xsi:type="model:Document"><annotation uri="periplus://resource:4341/annot:0"><data><rdf:RDF xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://resource:4341"><wlp:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/4341</wlp:hasNativeContent></rdf:Description></rdf:RDF></data></annotation></resource><resource uri="periplus://resource:2286" xsi:type="model:Document"><annotation uri="periplus://resource:2286/annot:0"><data><rdf:RDF xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://resource:2286"><wlp:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/2286</wlp:hasNativeContent></rdf:Description></rdf:RDF></data></annotation></resource><resource uri="periplus://resource:3510" xsi:type="model:Document"><annotation uri="periplus://resource:3510/annot:0"><data><rdf:RDF xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://resource:3510"><wlp:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/3510</wlp:hasNativeContent></rdf:Description></rdf:RDF></data></annotation></resource><resource uri="periplus://resource:4201" xsi:type="model:Document"><annotation uri="periplus://resource:4201/annot:0"><data><rdf:RDF xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://resource:4201"><wlp:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/4201</wlp:hasNativeContent></rdf:Description></rdf:RDF></data></annotation></resource><resource uri="periplus://resource:4545" xsi:type="model:Document"><annotation uri="periplus://resource:4545/annot:0"><data><rdf:RDF xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://resource:4545"><wlp:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/4545</wlp:hasNativeContent></rdf:Description></rdf:RDF></data></annotation></resource><resource uri="periplus://resource:4513" xsi:type="model:Document"><annotation uri="periplus://resource:4513/annot:0"><data><rdf:RDF xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://resource:4513"><wlp:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/4513</wlp:hasNativeContent></rdf:Description></rdf:RDF></data></annotation></resource><resource uri="periplus://resource:446" xsi:type="model:Document"><annotation uri="periplus://resource:446/annot:0"><data><rdf:RDF xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://resource:446"><wlp:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/446</wlp:hasNativeContent></rdf:Description></rdf:RDF></data></annotation></resource><resource uri="periplus://resource:2312" xsi:type="model:Document"><annotation uri="periplus://resource:2312/annot:0"><data><rdf:RDF xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://resource:2312"><wlp:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/2312</wlp:hasNativeContent></rdf:Description></rdf:RDF></data></annotation></resource><resource uri="periplus://resource:5488" xsi:type="model:Document"><annotation uri="periplus://resource:5488/annot:0"><data><rdf:RDF xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://resource:5488"><wlp:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/5488</wlp:hasNativeContent></rdf:Description></rdf:RDF></data></annotation></resource><resource uri="periplus://resource:2075" xsi:type="model:Document"><annotation uri="periplus://resource:2075/annot:0"><data><rdf:RDF xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://resource:2075"><wlp:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/2075</wlp:hasNativeContent></rdf:Description></rdf:RDF></data></annotation></resource><resource uri="periplus://resource:487" xsi:type="model:Document"><annotation uri="periplus://resource:487/annot:0"><data><rdf:RDF xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://resource:487"><wlp:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/487</wlp:hasNativeContent></rdf:Description></rdf:RDF></data></annotation></resource><resource uri="periplus://resource:1799" xsi:type="model:Document"><annotation uri="periplus://resource:1799/annot:0"><data><rdf:RDF xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://resource:1799"><wlp:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/1799</wlp:hasNativeContent></rdf:Description></rdf:RDF></data></annotation></resource><resource uri="periplus://resource:1976" xsi:type="model:Document"><annotation uri="periplus://resource:1976/annot:0"><data><rdf:RDF xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://resource:1976"><wlp:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/1976</wlp:hasNativeContent></rdf:Description></rdf:RDF></data></annotation></resource><resource uri="periplus://resource:5753" xsi:type="model:Document"><annotation uri="periplus://resource:5753/annot:0"><data><rdf:RDF xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://resource:5753"><wlp:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/5753</wlp:hasNativeContent></rdf:Description></rdf:RDF></data></annotation></resource><resource uri="periplus://resource:1592" xsi:type="model:Document"><annotation uri="periplus://resource:1592/annot:0"><data><rdf:RDF xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://resource:1592"><wlp:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/1592</wlp:hasNativeContent></rdf:Description></rdf:RDF></data></annotation></resource><resource uri="periplus://resource:1600" xsi:type="model:Document"><annotation uri="periplus://resource:1600/annot:0"><data><rdf:RDF xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://resource:1600"><wlp:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/1600</wlp:hasNativeContent></rdf:Description></rdf:RDF></data></annotation></resource><resource uri="periplus://resource:5548" xsi:type="model:Document"><annotation uri="periplus://resource:5548/annot:0"><data><rdf:RDF xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://resource:5548"><wlp:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/5548</wlp:hasNativeContent></rdf:Description></rdf:RDF></data></annotation></resource><resource uri="periplus://resource:2290" xsi:type="model:Document"><annotation uri="periplus://resource:2290/annot:0"><data><rdf:RDF xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://resource:2290"><wlp:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/2290</wlp:hasNativeContent></rdf:Description></rdf:RDF></data></annotation></resource><resource uri="periplus://resource:2033" xsi:type="model:Document"><annotation uri="periplus://resource:2033/annot:0"><data><rdf:RDF xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://resource:2033"><wlp:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/2033</wlp:hasNativeContent></rdf:Description></rdf:RDF></data></annotation></resource></resultSet></sear:searchReturn></soapenv:Body></soapenv:Envelope>'''
        res = '<soapenv:Envelope xmlns:soapenv="http://schemas.xmlsoap.org/soap/envelope/"><soapenv:Body><sear:searchReturn xmlns:model="http://weblab.ow2.org/core/1.2/model#" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns:sear="http://weblab.ow2.org/core/1.2/services/searcher" xmlns:soapenv="http://schemas.xmlsoap.org/soap/envelope/"><resultSet uri="periplus://simquery/result" xmlns:model="http://weblab.ow2.org/core/1.2/model#" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"><annotation uri="periplus://simquery/result/annotation"><data><rdf:RDF xmlns:wlr="http://weblab.ow2.org/core/1.2/ontology/retrieval#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://simquery/result/hit:3883"><wlr:inResultSetHit rdf:resource="periplus://simquery/result"/><wlr:isLinkedTo rdf:resource="periplus://resource:3883"/><wlr:hasDescription>Proche de Ségolène Royal, François Rebsamen a un temps envisagé de faire le trait-d\'union avec les amis de François Hollande pour renverser Martine Aubry de la direction du PS. Rentré dans le rang, il n\'en </wlr:hasDescription><wlr:hasScore>1</wlr:hasScore><wlr:hasRank>1</wlr:hasRank><dc:identifier>42360</dc:identifier><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/hit:3256"><wlr:inResultSetHit rdf:resource="periplus://simquery/result"/><wlr:isLinkedTo rdf:resource="periplus://resource:3256"/><wlr:hasDescription>Du 16 au 22 mars, les quelque 70.000 adhérents franciliens (rev</wlr:hasDescription><mediaUnit xsi:type="model:Image"><wlr:hasNativeContent>http://static.mediapart.fr/files/imagecache/300_pixels/Marine%20Turchi/3253562677_526473474b_m.jpg</wlr:hasNativeContent></mediaUnit><mediaUnit xsi:type="model:Image"><wlr:hasNativeContent>http://static.mediapart.fr/files/imagecache/475_pixels/La%20r%C3%A9daction%20Mediapart/paille.png</wlr:hasNativeContent></mediaUnit><wlr:hasScore>0.970595</wlr:hasScore><wlr:hasRank>2</wlr:hasRank><dc:identifier>36313</dc:identifier><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/hit:3328"><wlr:inResultSetHit rdf:resource="periplus://simquery/result"/><wlr:isLinkedTo rdf:resource="periplus://resource:3328"/><wlr:hasDescription>Sans surprise, Valérie Pécresse l\'a largement emporté, dimanche 22 mars, sur son collègue Roger Karoutchi lors de la primaire organisée chez les militants UMP de l\'Ile-de-France. Entre le 16 et le 22 mars, 48</wlr:hasDescription><mediaUnit xsi:type="model:Image"><wlr:hasNativeContent>http://static.mediapart.fr/files/imagecache/300_pixels/Marine%20Turchi/3253562677_526473474b_m.jpg</wlr:hasNativeContent></mediaUnit><mediaUnit xsi:type="model:Image"><wlr:hasNativeContent>http://static.mediapart.fr/files/imagecache/475_pixels/La%20r%C3%A9daction%20Mediapart/paille.png</wlr:hasNativeContent></mediaUnit><wlr:hasScore>0.970595</wlr:hasScore><wlr:hasRank>3</wlr:hasRank><dc:identifier>37060</dc:identifier><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/hit:3844"><wlr:inResultSetHit rdf:resource="periplus://simquery/result"/><wlr:isLinkedTo rdf:resource="periplus://resource:3844"/><wlr:hasDescription>Du changement de statut de La Poste, il n\'a été que peu question durant la campagne des élections européennes, comme si la réforme avait pris du retard ou n\'était plus d\'actualité. Et pourtant, il n\'en est rien</wlr:hasDescription><mediaUnit xsi:type="model:Image"><wlr:hasNativeContent>http://static.mediapart.fr/files/Laurent Mauduit/Image 8_13.png</wlr:hasNativeContent></mediaUnit><mediaUnit xsi:type="model:Image"><wlr:hasNativeContent>http://static.mediapart.fr/files/imagecache/475_pixels/La%20r%C3%A9daction%20Mediapart/paille.png</wlr:hasNativeContent></mediaUnit><wlr:hasScore>0.961693</wlr:hasScore><wlr:hasRank>4</wlr:hasRank><dc:identifier>42059</dc:identifier><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/hit:271"><wlr:inResultSetHit rdf:resource="periplus://simquery/result"/><wlr:isLinkedTo rdf:resource="periplus://resource:271"/><wlr:hasDescription>Jeudi 27 mars, dans la soirée, Nicolas Sarkozy a finalement promis que l\'Assemblée nationale pourrait débattre de sa décision toute fraîche d\'envoyer des soldats supplémentaires en Afghanistan (probablement un millier). Notifiée la veille outre-manc</wlr:hasDescription><wlr:hasScore>0.95304</wlr:hasScore><wlr:hasRank>5</wlr:hasRank><dc:identifier>5581</dc:identifier><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/hit:1732"><wlr:inResultSetHit rdf:resource="periplus://simquery/result"/><wlr:isLinkedTo rdf:resource="periplus://resource:1732"/><wlr:hasDescription>(Si la fin de cette page s\'affiche mal, rafraîchissez votre écran- touche F5) A l\'époque, l\'Unita avait contesté par les armes le résultat favorable au MPLA, replongeant le pays dans la guerre. Le combat des deux ex-compagn</wlr:hasDescription><mediaUnit xsi:type="model:Image"><wlr:hasNativeContent>http://static.mediapart.fr/files/imagecache/475_pixels/Fran%C3%A7ois%20Bonnet/ango.jpg</wlr:hasNativeContent></mediaUnit><mediaUnit xsi:type="model:Image"><wlr:hasNativeContent>http://static.mediapart.fr/files/imagecache/475_pixels/La%20r%C3%A9daction%20Mediapart/paille.png</wlr:hasNativeContent></mediaUnit><wlr:hasScore>0.944239</wlr:hasScore><wlr:hasRank>6</wlr:hasRank><dc:identifier>22545</dc:identifier><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/hit:5803"><wlr:inResultSetHit rdf:resource="periplus://simquery/result"/><wlr:isLinkedTo rdf:resource="periplus://resource:5803"/><wlr:hasDescription>Lot de consolation pour la droite : La Guyane basculerait. Selon des chiffres encore pro</wlr:hasDescription><mediaUnit xsi:type="model:Image"><wlr:hasNativeContent>http://static.mediapart.fr/files/imagecache/300_pixels/La%20r%C3%A9daction%20Mediapart/rejet.png</wlr:hasNativeContent></mediaUnit><mediaUnit xsi:type="model:Image"><wlr:hasNativeContent>http://static.mediapart.fr/files/imagecache/475_pixels/La%20r%C3%A9daction%20Mediapart/paille.png</wlr:hasNativeContent></mediaUnit><wlr:hasScore>0.939834</wlr:hasScore><wlr:hasRank>7</wlr:hasRank><dc:identifier>78083</dc:identifier><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/hit:1744"><wlr:inResultSetHit rdf:resource="periplus://simquery/result"/><wlr:isLinkedTo rdf:resource="periplus://resource:1744"/><wlr:hasDescription>Une bombe dort au pôle financier du tribunal de grande instance de Paris. Les juges Françoise Desset et</wlr:hasDescription><mediaUnit xsi:type="model:Image"><wlr:hasNativeContent>http://static.mediapart.fr/files/imagecache/475_pixels/Fabrice%20Arfi/bpc140dcn.jpg</wlr:hasNativeContent></mediaUnit><mediaUnit xsi:type="model:Image"><wlr:hasNativeContent>http://static.mediapart.fr/files/imagecache/475_pixels/La%20r%C3%A9daction%20Mediapart/paille.png</wlr:hasNativeContent></mediaUnit><wlr:hasScore>0.936393</wlr:hasScore><wlr:hasRank>8</wlr:hasRank><dc:identifier>22631</dc:identifier><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/hit:1745"><wlr:inResultSetHit rdf:resource="periplus://simquery/result"/><wlr:isLinkedTo rdf:resource="periplus://resource:1745"/><wlr:hasDescription>Une bombe dort au pôle financier du tribunal de Paris. Les juges Françoise Desset et</wlr:hasDescription><mediaUnit xsi:type="model:Image"><wlr:hasNativeContent>http://static.mediapart.fr/files/imagecache/225_pixels/Fabrice%20Arfi/sarko_0.png</wlr:hasNativeContent></mediaUnit><mediaUnit xsi:type="model:Image"><wlr:hasNativeContent>http://static.mediapart.fr/files/imagecache/475_pixels/La%20r%C3%A9daction%20Mediapart/paille.png</wlr:hasNativeContent></mediaUnit><wlr:hasScore>0.935581</wlr:hasScore><wlr:hasRank>9</wlr:hasRank><dc:identifier>22632</dc:identifier><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/hit:96"><wlr:inResultSetHit rdf:resource="periplus://simquery/result"/><wlr:isLinkedTo rdf:resource="periplus://resource:96"/><wlr:hasDescription>C\'était le 18 mars 2001. Au soir du second tour des él</wlr:hasDescription><wlr:hasScore>0.930653</wlr:hasScore><wlr:hasRank>10</wlr:hasRank><dc:identifier>423</dc:identifier><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/hit:4210"><wlr:inResultSetHit rdf:resource="periplus://simquery/result"/><wlr:isLinkedTo rdf:resource="periplus://resource:4210"/><wlr:hasDescription>L\'échange épistolaire entre Martine Aubry et Manuel Valls a ouvert la compétition des égos au PS. Mais la présidente de la régi</wlr:hasDescription><wlr:hasScore>0.930653</wlr:hasScore><wlr:hasRank>11</wlr:hasRank><dc:identifier>45247</dc:identifier><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/hit:3972"><wlr:inResultSetHit rdf:resource="periplus://simquery/result"/><wlr:isLinkedTo rdf:resource="periplus://resource:3972"/><wlr:hasDescription>L\'affaire de Karachi qui préoccupe au plus haut sommet de l\'Etat est apparue au détour d\'une enquête purement financière, qui recèle potentiellement en elle-même d\'autres scandales d\'Etat, largement évoqués par Mediapart voilà déjà neuf mois. Les juges du pôle financier p</wlr:hasDescription><wlr:hasScore>0.930406</wlr:hasScore><wlr:hasRank>12</wlr:hasRank><dc:identifier>43103</dc:identifier><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/hit:3973"><wlr:inResultSetHit rdf:resource="periplus://simquery/result"/><wlr:isLinkedTo rdf:resource="periplus://resource:3973"/><wlr:hasDescription>L\'affaire de Karachi qui préoccupe au plus haut sommet de l\'Etat est apparue au détour d\'une enquête purement financière, qui recèle potentiellement en elle-même d\'autres scandales d\'Etat, largement évoqués par Mediapart voilà déjà neuf mois. Les juges du pôle financier p</wlr:hasDescription><wlr:hasScore>0.930406</wlr:hasScore><wlr:hasRank>13</wlr:hasRank><dc:identifier>43104</dc:identifier><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/hit:2475"><wlr:inResultSetHit rdf:resource="periplus://simquery/result"/><wlr:isLinkedTo rdf:resource="periplus://resource:2475"/><wlr:hasDescription>Mardi 2 décembre, dans un sous-sol de l\'Assemblée nationale, Martine Aubry a délivré une feuille de route toute fraîche aux députés socialistes. &quot;On redémarre, on est en marc</wlr:hasDescription><wlr:hasScore>0.928015</wlr:hasScore><wlr:hasRank>14</wlr:hasRank><dc:identifier>28930</dc:identifier><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/hit:3789"><wlr:inResultSetHit rdf:resource="periplus://simquery/result"/><wlr:isLinkedTo rdf:resource="periplus://resource:3789"/><wlr:hasDescription>&quot;Dans une telle campagne où les petites phrases et les effets médiatiques semblent plus compter que le fond, de belles images au 20 heures ne peuvent pas faire de mal.&quot; Ce commentaire d\'un dirigean</wlr:hasDescription><mediaUnit xsi:type="model:Image"><wlr:hasNativeContent>http://static.mediapart.fr/files/imagecache/300_pixels/St%C3%A9phane%20Alli%C3%A8s/Image%205_5.png</wlr:hasNativeContent></mediaUnit><mediaUnit xsi:type="model:Image"><wlr:hasNativeContent>http://static.mediapart.fr/files/imagecache/475_pixels/La%20r%C3%A9daction%20Mediapart/paille.png</wlr:hasNativeContent></mediaUnit><wlr:hasScore>0.928015</wlr:hasScore><wlr:hasRank>15</wlr:hasRank><dc:identifier>41525</dc:identifier><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/hit:5767"><wlr:inResultSetHit rdf:resource="periplus://simquery/result"/>  <wlr:isLinkedTo rdf:resource="periplus://resource:5767"/><wlr:hasDescription>Elle n\'est pas encore la plus chouette du monde, mais la gauche française a au moins évité d\'être la plus bête, au moment de discuter unité avant le second tour des régionales. Mardi à 18h, dix-huit listes </wlr:hasDescription><wlr:hasScore>0.927953</wlr:hasScore><wlr:hasRank>16</wlr:hasRank><dc:identifier>77730</dc:identifier><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/hit:1036"><wlr:inResultSetHit rdf:resource="periplus://simquery/result"/><wlr:isLinkedTo rdf:resource="periplus://resource:1036"/><wlr:hasDescription>N\'en doutons pas, la semaine sociale sera à la contestation tous azimuts et, si le sujet n\'était pas grave et sérieux, un esprit malicieux pourrait voir dans ce tintamarre une nouvelle expression des contradictions françaises. A nouveau se pose le problème</wlr:hasDescription><wlr:hasScore>0.926465</wlr:hasScore><wlr:hasRank>17</wlr:hasRank><dc:identifier>16313</dc:identifier><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/hit:133"><wlr:inResultSetHit rdf:resource="periplus://simquery/result"/><wlr:isLinkedTo rdf:resource="periplus://resource:133"/><wlr:hasDescription>Face au pouvoir central incarné par le sarkozysme et ses dépendances, s\'installe un contre-pouvoir territorial porté par le socialisme et ses associés. La France est &quot; coupée en deu</wlr:hasDescription><wlr:hasScore>0.924092</wlr:hasScore><wlr:hasRank>18</wlr:hasRank><dc:identifier>603</dc:identifier><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/hit:3675"><wlr:inResultSetHit rdf:resource="periplus://simquery/result"/><wlr:isLinkedTo rdf:resource="periplus://resource:3675"/><wlr:hasDescription>Il faudra songer à remercier Nicolas Sarkozy. Sa pratique du pouvoir, sa ge</wlr:hasDescription><wlr:hasScore>0.914044</wlr:hasScore><wlr:hasRank>19</wlr:hasRank><dc:identifier>40407</dc:identifier><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/hit:5828"><wlr:inResultSetHit rdf:resource="periplus://simquery/result"/><wlr:isLinkedTo rdf:resource="periplus://resource:5828"/><wlr:hasDescription>Jacques Julliard, 77 ans, entre en dissidence. Figure historique de la &quot;deux</wlr:hasDescription><mediaUnit xsi:type="model:Image"><wlr:hasNativeContent>http://static.mediapart.fr/files/imagecache/250_pixels/St%C3%A9phane%20Alli%C3%A8s/julliard.png</wlr:hasNativeContent></mediaUnit><mediaUnit xsi:type="model:Image"><wlr:hasNativeContent>http://static.mediapart.fr/files/imagecache/475_pixels/La%20r%C3%A9daction%20Mediapart/paille.png</wlr:hasNativeContent></mediaUnit><wlr:hasScore>0.907456</wlr:hasScore><wlr:hasRank>20</wlr:hasRank><dc:identifier>78268</dc:identifier><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/hit:3993"><wlr:inResultSetHit rdf:resource="periplus://simquery/result"/><wlr:isLinkedTo rdf:resource="periplus://resource:3993"/><wlr:hasDescription>&quot;Vive la France !&quot; Après quarante minutes, Nicolas Sarkozy en a terminé avec son &quot;grand&quot; discours du Congrès. Sous les applaudissements - p</wlr:hasDescription><wlr:hasScore>0.898695</wlr:hasScore><wlr:hasRank>21</wlr:hasRank><dc:identifier>43349</dc:identifier><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/hit:4870"><wlr:inResultSetHit rdf:resource="periplus://simquery/result"/><wlr:isLinkedTo rdf:resource="periplus://resource:4870"/><wlr:hasDescription>Mais pas question pour l\'ancien président de se faire piéger à l\'antenne sur les affaires de la mairie de Paris, qui vont donc être jugées: l\'opération de communication a été soigneusement préparée, avec une promotion restreinte, en terrain connu : un hebdomadaire (Le Point sort les bonnes feuilles mercredi), un quotidien (Le Figaro aura les honneurs d\'une interview jeudi), une radio (Europe 1, au micro de Jean-Pierre Elkabbach), et une télévision (il sera l\'invité de Michel Drucker dans &quot;Vivement Dimanche&quot;, sur France 2, le 29 novembre). Le livre a été envoyé au com</wlr:hasDescription><mediaUnit xsi:type="model:Image"><wlr:hasNativeContent>http://static.mediapart.fr/files/imagecache/225_pixels/Marine%20Turchi/9782841113934.jpg</wlr:hasNativeContent></mediaUnit><mediaUnit xsi:type="model:Image"><wlr:hasNativeContent>http://static.mediapart.fr/files/imagecache/475_pixels/La%20r%C3%A9daction%20Mediapart/paille.png</wlr:hasNativeContent></mediaUnit><wlr:hasScore>0.895167</wlr:hasScore><wlr:hasRank>22</wlr:hasRank><dc:identifier>67685</dc:identifier><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/hit:2156"><wlr:inResultSetHit rdf:resource="periplus://simquery/result"/><wlr:isLinkedTo rdf:resource="periplus://resource:2156"/><wlr:hasDescription>Les débats s\'enchaînent au PS, sans que les équilibres internes ne paraissent évoluer. L\'incertitude persiste, aucun</wlr:hasDescription><wlr:hasScore>0.886579</wlr:hasScore><wlr:hasRank>23</wlr:hasRank><dc:identifier>26098</dc:identifier><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/hit:3849"><wlr:inResultSetHit rdf:resource="periplus://simquery/result"/><wlr:isLinkedTo rdf:resource="periplus://resource:3849"/><wlr:hasDescription>&quot;Celui qui gagne, c\'est celui qui arrive en tête&quot;, a rappelé Xavier Bertrand, le secrétaire général de l\'UMP, lors du dernier meeting européen de la majorité, jeudi soir, porte de Versailles, à Paris (lire notre article). On le sait déjà, dimanche soi</wlr:hasDescription><wlr:hasScore>0.885014</wlr:hasScore><wlr:hasRank>24</wlr:hasRank><dc:identifier>42094</dc:identifier><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/hit:3802"><wlr:inResultSetHit rdf:resource="periplus://simquery/result"/><wlr:isLinkedTo rdf:resource="periplus://resource:3802"/><wlr:hasDescription>Eparpiller les européennes façon puzzle, pour mieux les neutraliser : gaullistes et socialistes l\'avaient rêvé, le giscardien Raffarin l\'a fait. Le procès était instruit depu</wlr:hasDescription><wlr:hasScore>0.881176</wlr:hasScore><wlr:hasRank>25</wlr:hasRank><dc:identifier>41650</dc:identifier><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/hit:1320"><wlr:inResultSetHit rdf:resource="periplus://simquery/result"/><wlr:isLinkedTo rdf:resource="periplus://resource:1320"/><wlr:hasDescription>&quot;Nous hésitions entre le non et le non; ce sera non&quot;, a ironisé le sénateur socialiste Bernard Frimat, mercredi 16 juillet, en réponse à l\'interview de Nicolas Sarkozy sur la réforme des institutions, annonçant in extremis dans Le Monde quelques initiatives en faveur des droits de l\'opposition. Ces déclarations présidentiel</wlr:hasDescription><mediaUnit xsi:type="model:Image"><wlr:hasNativeContent>http://static.mediapart.fr/files/Mathilde Mathieu/Image 2_2.png</wlr:hasNativeContent></mediaUnit><mediaUnit xsi:type="model:Image"><wlr:hasNativeContent>http://static.mediapart.fr/files/imagecache/475_pixels/La%20r%C3%A9daction%20Mediapart/paille.png</wlr:hasNativeContent></mediaUnit><wlr:hasScore>0.878407</wlr:hasScore><wlr:hasRank>26</wlr:hasRank><dc:identifier>18705</dc:identifier><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/hit:1015"><wlr:inResultSetHit rdf:resource="periplus://simquery/result"/><wlr:isLinkedTo rdf:resource="periplus://resource:1015"/><wlr:hasDescription>Jeudi soir, sur le plateau d\'&quot;A vous de juger&quot;, sur France 2, la photo de famille de l\'UMP était parfaite. Derrière François Fillon, inv</wlr:hasDescription><wlr:hasScore>0.871634</wlr:hasScore><wlr:hasRank>27</wlr:hasRank><dc:identifier>16105</dc:identifier><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/hit:4397"><wlr:inResultSetHit rdf:resource="periplus://simquery/result"/><wlr:isLinkedTo rdf:resource="periplus://resource:4397"/><wlr:hasDescription>L\'alliance est de circonstances mais elle contraint la première secrétaire à réagir. Eparpillée depuis quelques mo</wlr:hasDescription><wlr:hasScore>0.869736</wlr:hasScore><wlr:hasRank>28</wlr:hasRank><dc:identifier>49377</dc:identifier><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/hit:4618"><wlr:inResultSetHit rdf:resource="periplus://simquery/result"/><wlr:isLinkedTo rdf:resource="periplus://resource:4618"/><wlr:hasDescription>Une fois de plus, Nicolas Sarkozy a profité d\'une tribune internationale - en l\'occurrence l\'assemblée générale annuelle des Nations unies à New York - pour tenir un langage extrêmement ferme à l\'attention de l\'Iran. Mais, alors que le président </wlr:hasDescription><wlr:hasScore>0.868531</wlr:hasScore><wlr:hasRank>29</wlr:hasRank><dc:identifier>59562</dc:identifier><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/hit:397"><wlr:inResultSetHit rdf:resource="periplus://simquery/result"/><wlr:isLinkedTo rdf:resource="periplus://resource:397"/><wlr:hasDescription>Les &quot; réformistes &quot; les plus conséquents à gauche ne sont pas toujours ceux que l\'on croit. Les premières réactions autou</wlr:hasDescription><wlr:hasScore>0.867952</wlr:hasScore><wlr:hasRank>30</wlr:hasRank><dc:identifier>10623</dc:identifier><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/hit:4285"><wlr:inResultSetHit rdf:resource="periplus://simquery/result"/><wlr:isLinkedTo rdf:resource="periplus://resource:4285"/><wlr:hasDescription>Deuxième volet de notre enquête sur les raisons de la crise du parti socialiste et les relations qu\'il entretient avec les milieux de la recherche (vous pouvez lire le premier volet en cliquant ici). Mediapart a voulu interroger </wlr:hasDescription><mediaUnit xsi:type="model:Image"><wlr:hasNativeContent>http://static.mediapart.fr/files/imagecache/150_pixels/Sylvain%20Bourmeau/Matonti%20F.jpg</wlr:hasNativeContent></mediaUnit><mediaUnit xsi:type="model:Image"><wlr:hasNativeContent>http://static.mediapart.fr/files/imagecache/475_pixels/La%20r%C3%A9daction%20Mediapart/paille.png</wlr:hasNativeContent></mediaUnit><wlr:hasScore>0.867451</wlr:hasScore><wlr:hasRank>31</wlr:hasRank><dc:identifier>45812</dc:identifier><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/hit:1668"><wlr:inResultSetHit rdf:resource="periplus://simquery/result"/><wlr:isLinkedTo rdf:resource="periplus://resource:1668"/><wlr:hasDescription>Quand personne ne croyait trop que le RSA aboutirait, il faisait l\'objet de rares débats. Tant qu\'il s\'expérimentait da</wlr:hasDescription><wlr:hasScore>0.865544</wlr:hasScore><wlr:hasRank>32</wlr:hasRank><dc:identifier>21885</dc:identifier><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/hit:2129"><wlr:inResultSetHit rdf:resource="periplus://simquery/result"/><wlr:isLinkedTo rdf:resource="periplus://resource:2129"/><wlr:hasDescription>Edouard Balladur répondait, mercredi 22 octobre, sur le gravier de l\'Elysée à quelques questions sur les objectifs et le programme de la nouvelle mission que venait de lui confier Nicolas Sarkozy. Quelques minutes plus tôt, le</wlr:hasDescription><wlr:hasScore>0.865544</wlr:hasScore><wlr:hasRank>33</wlr:hasRank><dc:identifier>25866</dc:identifier><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/hit:5351"><wlr:inResultSetHit rdf:resource="periplus://simquery/result"/><wlr:isLinkedTo rdf:resource="periplus://resource:5351"/><wlr:hasDescription>&quot;Dans quelques années nous dirons: il y a l\'UMP et il y a le Nouveau Centre&quot;, a assuré Hervé Morin, lors des voeux aux cadres de son parti, lundi 18 janvier. Chaque année, le discours est</wlr:hasDescription><mediaUnit xsi:type="model:Image"><wlr:hasNativeContent>http://static.mediapart.fr/files/Marine Turchi/udf.png</wlr:hasNativeContent></mediaUnit><mediaUnit xsi:type="model:Image"><wlr:hasNativeContent>http://static.mediapart.fr/files/imagecache/475_pixels/La%20r%C3%A9daction%20Mediapart/paille.png</wlr:hasNativeContent></mediaUnit><wlr:hasScore>0.865421</wlr:hasScore><wlr:hasRank>34</wlr:hasRank><dc:identifier>72565</dc:identifier><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/hit:4904"><wlr:inResultSetHit rdf:resource="periplus://simquery/result"/><wlr:isLinkedTo rdf:resource="periplus://resource:4904"/><wlr:hasDescription>François Hollande fait le bilan. Dans un livre d\'entretien ave</wlr:hasDescription><wlr:hasScore>0.86539</wlr:hasScore><wlr:hasRank>35</wlr:hasRank><dc:identifier>67950</dc:identifier><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/hit:1797"><wlr:inResultSetHit rdf:resource="periplus://simquery/result"/><wlr:isLinkedTo rdf:resource="periplus://resource:1797"/><wlr:hasDescription>Le fichage politique en France, c\'est fini ! C\'est du moins la promesse lancée par la ministre de l\'intérieur, devant l\'Assemblée nationale. Au gré d\'une réécriture compl</wlr:hasDescription><wlr:hasScore>0.865269</wlr:hasScore><wlr:hasRank>36</wlr:hasRank><dc:identifier>23106</dc:identifier><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/hit:1176"><wlr:inResultSetHit rdf:resource="periplus://simquery/result"/><wlr:isLinkedTo rdf:resource="periplus://resource:1176"/><wlr:hasDescription>Les parlementaires UMP, jusqu\'ici divisés sur la réforme des institutions, semblent avoir déniché un compromis sur le \&quot;dossier turc\&quot;, validé mardi 1er juillet par François Fillon. Les sénateurs, révulsés à l\'i</wlr:hasDescription><mediaUnit xsi:type="model:Image"><wlr:hasNativeContent>http://static.mediapart.fr/files/Mathilde Mathieu/Image 6_3.png</wlr:hasNativeContent></mediaUnit><mediaUnit xsi:type="model:Image"><wlr:hasNativeContent>http://static.mediapart.fr/files/imagecache/475_pixels/La%20r%C3%A9daction%20Mediapart/paille.png</wlr:hasNativeContent></mediaUnit><wlr:hasScore>0.865142</wlr:hasScore><wlr:hasRank>37</wlr:hasRank><dc:identifier>17508</dc:identifier><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/hit:571"><wlr:inResultSetHit rdf:resource="periplus://simquery/result"/><wlr:isLinkedTo rdf:resource="periplus://resource:571"/><wlr:hasDescription>Avocat, Jean-Pierre Mignard est président de l\'association Désirs d\'avenir depuis novembre 2007. Vieil ami de François Holland</wlr:hasDescription><wlr:hasScore>0.860128</wlr:hasScore><wlr:hasRank>38</wlr:hasRank><dc:identifier>12169</dc:identifier><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/hit:3676"><wlr:inResultSetHit rdf:resource="periplus://simquery/result"/><wlr:isLinkedTo rdf:resource="periplus://resource:3676"/><wlr:hasDescription>Comme un mauvais moment à passer. Depuis son entrée en campagne</wlr:hasDescription><wlr:hasScore>0.858979</wlr:hasScore><wlr:hasRank>39</wlr:hasRank><dc:identifier>40411</dc:identifier><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/hit:3799"><wlr:inResultSetHit rdf:resource="periplus://simquery/result"/><wlr:isLinkedTo rdf:resource="periplus://resource:3799"/><wlr:hasDescription>Une porcelaine (d\'une entreprise viennoise en difficulté) contre une statue africaine (de &quot;femme debout&quot;). Par cet échange de cadeaux, M</wlr:hasDescription><mediaUnit xsi:type="model:Image"><wlr:hasNativeContent>http://static.mediapart.fr/files/imagecache/300_pixels/St%C3%A9phane%20Alli%C3%A8s/ResizedImage383255-IMG0707.JPG</wlr:hasNativeContent></mediaUnit><mediaUnit xsi:type="model:Image"><wlr:hasNativeContent>http://static.mediapart.fr/files/imagecache/475_pixels/La%20r%C3%A9daction%20Mediapart/paille.png</wlr:hasNativeContent></mediaUnit><wlr:hasScore>0.858373</wlr:hasScore><wlr:hasRank>40</wlr:hasRank><dc:identifier>41634</dc:identifier><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/hit:3646"><wlr:inResultSetHit rdf:resource="periplus://simquery/result"/><wlr:isLinkedTo rdf:resource="periplus://resource:3646"/><wlr:hasDescription>Il a recueilli plus de 18% des voix au premier tour de l\'élection présidentielle de 2007. Les sondages le créditent de </wlr:hasDescription><mediaUnit xsi:type="model:Image"><wlr:hasNativeContent>http://static.mediapart.fr/files/imagecache/300_pixels/Marine%20Turchi/800px-Francois_bayrou_forum_democrate_seignosse_20070916_f_1.jpg</wlr:hasNativeContent></mediaUnit><mediaUnit xsi:type="model:Image"><wlr:hasNativeContent>http://static.mediapart.fr/files/imagecache/475_pixels/La%20r%C3%A9daction%20Mediapart/paille.png</wlr:hasNativeContent></mediaUnit><wlr:hasScore>0.858245</wlr:hasScore><wlr:hasRank>41</wlr:hasRank><dc:identifier>40117</dc:identifier><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/hit:1535"><wlr:inResultSetHit rdf:resource="periplus://simquery/result"/><wlr:isLinkedTo rdf:resource="periplus://resource:1535"/><wlr:hasDescription>Nicolas Sarkozy et le gouvernement ont-t-ils bien perçu ce qui s\'est joué dans l\'environnement international? A lire les discours, à observer les décisions, la question se posait depuis un an ; la publication par l\'Insee du recul de 0,3% du PIB au deuxième trimestre et de la destruction de 12.000 emplois, avec les réaction</wlr:hasDescription><wlr:hasScore>0.856629</wlr:hasScore><wlr:hasRank>42</wlr:hasRank><dc:identifier>20563</dc:identifier><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/hit:2361"><wlr:inResultSetHit rdf:resource="periplus://simquery/result"/><wlr:isLinkedTo rdf:resource="periplus://resource:2361"/><wlr:hasDescription>A la veille de l\'élection du nouveau premier secrétaire socialiste, on n\'a jamais autant parlé\8230 du MoDem. Mardi, interrogée sur France </wlr:hasDescription><wlr:hasScore>0.856416</wlr:hasScore><wlr:hasRank>43</wlr:hasRank><dc:identifier>28041</dc:identifier><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/hit:2441"><wlr:inResultSetHit rdf:resource="periplus://simquery/result"/><wlr:isLinkedTo rdf:resource="periplus://resource:2441"/><wlr:hasDescription>A Paris, l\'UMP a des airs de parti socialiste, en cette période de renouvellement de la fédération. La semaine passée, les adhére</wlr:hasDescription><wlr:hasScore>0.854737</wlr:hasScore><wlr:hasRank>44</wlr:hasRank><dc:identifier>28692</dc:identifier><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/hit:5005"><wlr:inResultSetHit rdf:resource="periplus://simquery/result"/><wlr:isLinkedTo rdf:resource="periplus://resource:5005"/><wlr:hasDescription>La droite a longtemps détesté les panthéonisations. En 1908, celle de Zola fit de</wlr:hasDescription><mediaUnit xsi:type="model:Image"><wlr:hasNativeContent>http://static.mediapart.fr/files/imagecache/300_pixels/Sophie%20Dufau/pantheon-de-paris.jpg</wlr:hasNativeContent></mediaUnit><mediaUnit xsi:type="model:Image"><wlr:hasNativeContent>http://static.mediapart.fr/files/imagecache/475_pixels/La%20r%C3%A9daction%20Mediapart/paille.png</wlr:hasNativeContent></mediaUnit><wlr:hasScore>0.854737</wlr:hasScore><wlr:hasRank>45</wlr:hasRank><dc:identifier>69111</dc:identifier><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/hit:3556"><wlr:inResultSetHit rdf:resource="periplus://simquery/result"/><wlr:isLinkedTo rdf:resource="periplus://resource:3556"/><wlr:hasDescription>Martine Aubry en avait sans doute rêvé, Poul Nyrup Rasmussen l\'a fait. Le parti socialiste a enfin r</wlr:hasDescription><wlr:hasScore>0.854005</wlr:hasScore><wlr:hasRank>46</wlr:hasRank><dc:identifier>39274</dc:identifier><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/hit:47"><wlr:inResultSetHit rdf:resource="periplus://simquery/result"/><wlr:isLinkedTo rdf:resource="periplus://resource:47"/><wlr:hasDescription>C\'est assurément une crise atypique que traverse, en France, la presse quotidienne. Irruption de la gratuité et d</wlr:hasDescription><wlr:hasScore>0.853189</wlr:hasScore><wlr:hasRank>47</wlr:hasRank><dc:identifier>200</dc:identifier><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/hit:2185"><wlr:inResultSetHit rdf:resource="periplus://simquery/result"/><wlr:isLinkedTo rdf:resource="periplus://resource:2185"/><wlr:hasDescription>Il y a peu, les &quot;carnets noirs&quot; d\'Yves Bertrand et le fichier Edvige ravivaient le spectre de la police secrète. Dans le même temps, un servic</wlr:hasDescription><wlr:hasScore>0.852803</wlr:hasScore><wlr:hasRank>48</wlr:hasRank><dc:identifier>26509</dc:identifier><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/hit:2278"><wlr:inResultSetHit rdf:resource="periplus://simquery/result"/><wlr:isLinkedTo rdf:resource="periplus://resource:2278"/><wlr:hasDescription>Les grands esprits socialistes se sont reposés, au lendemain d\'une longue nuit électorale. Si Ségolène Royal arrive en t</wlr:hasDescription><wlr:hasScore>0.85201</wlr:hasScore><wlr:hasRank>49</wlr:hasRank><dc:identifier>27180</dc:identifier><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/hit:1902"><wlr:inResultSetHit rdf:resource="periplus://simquery/result"/><wlr:isLinkedTo rdf:resource="periplus://resource:1902"/><wlr:hasDescription>En pleine panique financière, les responsables politiques retrouvent la parole. Après la réunion de crise ce </wlr:hasDescription><wlr:hasScore>0.851838</wlr:hasScore><wlr:hasRank>50</wlr:hasRank><dc:identifier>23938</dc:identifier><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/hit:288"><wlr:inResultSetHit rdf:resource="periplus://simquery/result"/><wlr:isLinkedTo rdf:resource="periplus://resource:288"/><wlr:hasDescription>L\'UMP et le PS sont des jumeaux dizygotes. Ils ne sont pas issus du même</wlr:hasDescription><wlr:hasScore>0.848327</wlr:hasScore><wlr:hasRank>51</wlr:hasRank><dc:identifier>9624</dc:identifier><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/hit:1093"><wlr:inResultSetHit rdf:resource="periplus://simquery/result"/><wlr:isLinkedTo rdf:resource="periplus://resource:1093"/><wlr:hasDescription>Il dit vouloir rendre des comptes, démontrer combien les députés socialistes se sont montrés utiles depuis un an au Palais-Bourbon. Jean-Marc Ayrault organisera </wlr:hasDescription><mediaUnit xsi:type="model:Image"><wlr:hasNativeContent>http://static.mediapart.fr/files/Mathilde Mathieu/229180457_9db20a3f47_m.jpg</wlr:hasNativeContent></mediaUnit><mediaUnit xsi:type="model:Image"><wlr:hasNativeContent>http://static.mediapart.fr/files/imagecache/475_pixels/La%20r%C3%A9daction%20Mediapart/paille.png</wlr:hasNativeContent></mediaUnit><wlr:hasScore>0.847377</wlr:hasScore><wlr:hasRank>52</wlr:hasRank><dc:identifier>16697</dc:identifier><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/hit:1462"><wlr:inResultSetHit rdf:resource="periplus://simquery/result"/><wlr:isLinkedTo rdf:resource="periplus://resource:1462"/><wlr:hasDescription>Les ministres sont partis en vacances mais il en est resté un, le porte-parole du gouvernement, Luc Chatel, pour faire le service après-vente des lois en cascade votées par le Parlement depuis un an. &quot;De grandes batailles idéolog</wlr:hasDescription><mediaUnit xsi:type="model:Image"><wlr:hasNativeContent>http://static.mediapart.fr/files/imagecache/475_pixels/Mathieu%20Magnaudeix/Image%203_7.png</wlr:hasNativeContent></mediaUnit><mediaUnit xsi:type="model:Image"><wlr:hasNativeContent>http://static.mediapart.fr/files/imagecache/475_pixels/La%20r%C3%A9daction%20Mediapart/paille.png</wlr:hasNativeContent></mediaUnit><wlr:hasScore>0.847377</wlr:hasScore><wlr:hasRank>53</wlr:hasRank><dc:identifier>19657</dc:identifier><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/hit:2179"><wlr:inResultSetHit rdf:resource="periplus://simquery/result"/><wlr:isLinkedTo rdf:resource="periplus://resource:2179"/><wlr:hasDescription>Sitôt que l\'on a su que le taux de rémunération du Livret A allait baisser le 1er février prochain, de 4% actuellement à sans doute 3,5% et peut-être même 3%, cela a été un véritable tir de barrage. Comprenant qu\'en pleine tourm</wlr:hasDescription><wlr:hasScore>0.847377</wlr:hasScore><wlr:hasRank>54</wlr:hasRank><dc:identifier>26409</dc:identifier><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/hit:1403"><wlr:inResultSetHit rdf:resource="periplus://simquery/result"/><wlr:isLinkedTo rdf:resource="periplus://resource:1403"/><wlr:hasDescription>La \&quot;nouvelle\&quot; Constitution, parue jeudi 24 juillet au Journal officiel, fait littéralement jubiler Jean-François Copé. (Téléchargez ici le calendri</wlr:hasDescription><wlr:hasScore>0.845198</wlr:hasScore><wlr:hasRank>55</wlr:hasRank><dc:identifier>19199</dc:identifier><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/hit:2501"><wlr:inResultSetHit rdf:resource="periplus://simquery/result"/><wlr:isLinkedTo rdf:resource="periplus://resource:2501"/><wlr:hasDescription>Jeudi 4 décembre, l\'Assemblée nationale est entrée dans le vif du sujet, en adoptant deux mesures clés du projet de loi sur l\'audiovisuel public, qui prévoient la désignation et la révocation par le chef de l\'Etat des patrons de France Télévisions, de Radio France et d\'AEF (la holding regroupant France 24, RFI et TV5 Monde). Sur l\'article 8 (fixant le pr</wlr:hasDescription><wlr:hasScore>0.845198</wlr:hasScore><wlr:hasRank>56</wlr:hasRank><dc:identifier>29095</dc:identifier><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/hit:4470"><wlr:inResultSetHit rdf:resource="periplus://simquery/result"/><wlr:isLinkedTo rdf:resource="periplus://resource:4470"/><wlr:hasDescription>De notre envoyée spéciale à La Grande-Motte  Pour éviter qu\'écologistes et socialistes fassent une OPA sur le Modem, sorti très affaibli des élections européennes, Bayrou leur a lancé une &quot;offre publique de dialogue&quot;, dimanche 6 septembre, en clôture de l\'université d\'été du mouvement, organisée à La Grande-Motte. Par son discours, il a signé </wlr:hasDescription><wlr:hasScore>0.844449</wlr:hasScore><wlr:hasRank>57</wlr:hasRank><dc:identifier>53657</dc:identifier><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/hit:5881"><wlr:inResultSetHit rdf:resource="periplus://simquery/result"/><wlr:isLinkedTo rdf:resource="periplus://resource:5881"/><wlr:hasDescription>&quot;Je ne rentre pas au gouvernement dans les meilleures conditions, ni de popularité, ni de finances publiques&quot;, a reconnu le nouveau ministre du budget, sur Europe1, jeudi matin. Il aurait pu ajouter: &quot;ni de </wlr:hasDescription><mediaUnit xsi:type="model:Image"><wlr:hasNativeContent>http://static.mediapart.fr/files/imagecache/300_pixels/Marine%20Turchi/baroin_sarkozy.jpg</wlr:hasNativeContent></mediaUnit><mediaUnit xsi:type="model:Image"><wlr:hasNativeContent>http://static.mediapart.fr/files/imagecache/475_pixels/La%20r%C3%A9daction%20Mediapart/paille.png</wlr:hasNativeContent></mediaUnit><wlr:hasScore>0.842533</wlr:hasScore><wlr:hasRank>58</wlr:hasRank><dc:identifier>78812</dc:identifier><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/hit:3533"><wlr:inResultSetHit rdf:resource="periplus://simquery/result"/><wlr:isLinkedTo rdf:resource="periplus://resource:3533"/><wlr:hasDescription>A l\'Elysée, on affirme que Dominique de Villepin ne fait pas peur. On prétend même qu\'il n\'a qu\'</wlr:hasDescription><mediaUnit xsi:type="model:Image"><wlr:hasNativeContent>http://static.mediapart.fr/files/imagecache/475_pixels/Marine%20Turchi/2083.jpg</wlr:hasNativeContent></mediaUnit><mediaUnit xsi:type="model:Image"><wlr:hasNativeContent>http://static.mediapart.fr/files/imagecache/475_pixels/La%20r%C3%A9daction%20Mediapart/paille.png</wlr:hasNativeContent></mediaUnit><wlr:hasScore>0.84111</wlr:hasScore><wlr:hasRank>59</wlr:hasRank><dc:identifier>39104</dc:identifier><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/hit:1978"><wlr:inResultSetHit rdf:resource="periplus://simquery/result"/><wlr:isLinkedTo rdf:resource="periplus://resource:1978"/><wlr:hasDescription>Aucune faillite retentissante, pas d\'annonce de menaces supplémentaires sur l\'économie malgré les prix de l\'immobilier qui commencent à chuter et l\'Islande qui se liquéfie. A Paris notamment, les marché</wlr:hasDescription><wlr:hasScore>0.837822</wlr:hasScore><wlr:hasRank>60</wlr:hasRank><dc:identifier>24554</dc:identifier><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/hit:5120"><wlr:inResultSetHit rdf:resource="periplus://simquery/result"/><wlr:isLinkedTo rdf:resource="periplus://resource:5120"/><wlr:hasDescription>Des élus qui claquent la porte de l\'UMP, des conseillers qui quittent sur la pointe des pieds l\'Elysée... Les annonces de ce lundi 7 </wlr:hasDescription><wlr:hasScore>0.837822</wlr:hasScore><wlr:hasRank>61</wlr:hasRank><dc:identifier>70129</dc:identifier><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/hit:154"><wlr:inResultSetHit rdf:resource="periplus://simquery/result"/><wlr:isLinkedTo rdf:resource="periplus://resource:154"/><wlr:hasDescription>Face au pouvoir central incarné par le sarkozysme et ses dépendances, s\'installe un contre-pouvoir territorial porté par le socialisme et ses associés. La France est &quot; coupée en deu</wlr:hasDescription><wlr:hasScore>0.837729</wlr:hasScore><wlr:hasRank>62</wlr:hasRank><dc:identifier>748</dc:identifier><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/hit:3862"><wlr:inResultSetHit rdf:resource="periplus://simquery/result"/><wlr:isLinkedTo rdf:resource="periplus://resource:3862"/><wlr:hasDescription>De midi à minuit, dans la journée du dimanche 7 juin, la rédaction de Mediapart a tenu la chronique, minute par minute, de la journée électorale. Vous pouvez lire ci-dessous, </wlr:hasDescription><mediaUnit xsi:type="model:Image"><wlr:hasNativeContent>http://static.mediapart.fr/files/imagecache/475_pixels/La%20r%C3%A9daction%20Mediapart/Image%206_2.png</wlr:hasNativeContent></mediaUnit><mediaUnit xsi:type="model:Image"><wlr:hasNativeContent>http://static.mediapart.fr/files/imagecache/475_pixels/La%20r%C3%A9daction%20Mediapart/paille.png</wlr:hasNativeContent></mediaUnit><wlr:hasScore>0.836646</wlr:hasScore><wlr:hasRank>63</wlr:hasRank><dc:identifier>42258</dc:identifier><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/hit:5246"><wlr:inResultSetHit rdf:resource="periplus://simquery/result"/><wlr:isLinkedTo rdf:resource="periplus://resource:5246"/><wlr:hasDescription>&quot;Les gnomes de Francfort&quot;, par exemple, qualificatif de Jean-Pierre Chevènement à l\'encontre des dirigeants de la Banque centrale européenne, gardienne du fameux traité de &quot;MasTrique&quot;. Il y a le savoureux &quot;Le parti</wlr:hasDescription><mediaUnit xsi:type="model:Image"><wlr:hasNativeContent>http://static.mediapart.fr/files/imagecache/225_pixels/Fran%C3%A7ois%20Bonnet/couv.png</wlr:hasNativeContent></mediaUnit><mediaUnit xsi:type="model:Image"><wlr:hasNativeContent>http://static.mediapart.fr/files/imagecache/475_pixels/La%20r%C3%A9daction%20Mediapart/paille.png</wlr:hasNativeContent></mediaUnit><wlr:hasScore>0.829268</wlr:hasScore><wlr:hasRank>64</wlr:hasRank><dc:identifier>71364</dc:identifier><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/hit:5506"><wlr:inResultSetHit rdf:resource="periplus://simquery/result"/><wlr:isLinkedTo rdf:resource="periplus://resource:5506"/><wlr:hasDescription>Changement express de stratégie, négociations interminables pour boucler des listes, choix contestés en Ile-de-France, affaire Clearstream qui déchire la majorité. A moins de deux mois du scrut</wlr:hasDescription><mediaUnit xsi:type="model:Image"><wlr:hasNativeContent>http://static.mediapart.fr/files/imagecache/475_pixels/Marine%20Turchi/conseil_national_UMP.jpg</wlr:hasNativeContent></mediaUnit><mediaUnit xsi:type="model:Image"><wlr:hasNativeContent>http://static.mediapart.fr/files/imagecache/475_pixels/La%20r%C3%A9daction%20Mediapart/paille.png</wlr:hasNativeContent></mediaUnit><wlr:hasScore>0.829268</wlr:hasScore><wlr:hasRank>65</wlr:hasRank><dc:identifier>74059</dc:identifier><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/hit:1524"><wlr:inResultSetHit rdf:resource="periplus://simquery/result"/><wlr:isLinkedTo rdf:resource="periplus://resource:1524"/><wlr:hasDescription>Les autruches sortent enfin la tête de terre. Contrairement à l\'antienne op</wlr:hasDescription><wlr:hasScore>0.827191</wlr:hasScore><wlr:hasRank>66</wlr:hasRank><dc:identifier>20496</dc:identifier><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/hit:1614"><wlr:inResultSetHit rdf:resource="periplus://simquery/result"/><wlr:isLinkedTo rdf:resource="periplus://resource:1614"/><wlr:hasDescription>Elle a la voix toute chevrotante, Monique. Mégaphone en main, cette inst</wlr:hasDescription><wlr:hasScore>0.825859</wlr:hasScore><wlr:hasRank>67</wlr:hasRank><dc:identifier>21353</dc:identifier><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/hit:3576"><wlr:inResultSetHit rdf:resource="periplus://simquery/result"/><wlr:isLinkedTo rdf:resource="periplus://resource:3576"/><wlr:hasDescription>&quot;La politique est de retour ! Ces élections seront politiques&quot;, a prévenu Xavier Bertrand en marge du premier meeting européen de l\'UMP, mardi soir, à Rueil-Malmaison (Hauts-de-Seine). Le but était clair : ramener </wlr:hasDescription><wlr:hasScore>0.825809</wlr:hasScore><wlr:hasRank>68</wlr:hasRank><dc:identifier>39518</dc:identifier><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/hit:5922"><wlr:inResultSetHit rdf:resource="periplus://simquery/result"/><wlr:isLinkedTo rdf:resource="periplus://resource:5922"/><wlr:hasDescription>Même s\'il est un ami de Nicolas Sarkozy et un client d\'Alain Minc, Stéphane Courbit est depuis quelque temps bien malheureux en affaires. Après avoir acquis une partic</wlr:hasDescription><wlr:hasScore>0.825159</wlr:hasScore><wlr:hasRank>69</wlr:hasRank><dc:identifier>79317</dc:identifier><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/hit:5786"><wlr:inResultSetHit rdf:resource="periplus://simquery/result"/><wlr:isLinkedTo rdf:resource="periplus://resource:5786"/><wlr:hasDescription>La rumeur circule depuis quelques jours - le site internet Wansquare s\'en est fait le premier l\'écho, et après lui Le Point - et nous en avons obtenu une confirmation de très bonne source: Yazid Sabeg, l\'actuel commissaire à la diversité et à l\'égalité des chances, devrait succéder à Anne Lauvergeon à la tête d\'Areva, le champion du nucléaire français. Selon nos informations, cette</wlr:hasDescription><wlr:hasScore>0.824374</wlr:hasScore><wlr:hasRank>70</wlr:hasRank><dc:identifier>77916</dc:identifier><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/hit:4453"><wlr:inResultSetHit rdf:resource="periplus://simquery/result"/><wlr:isLinkedTo rdf:resource="periplus://resource:4453"/><wlr:hasDescription>Après avoir passé son été à tempêter, menaçant de démissionner de la direction ou d\'en appeler aux militants pour imposer les primaires ouvertes qu\'il promeut dans un livre (Comment sauver la gauche, au Seuil, avec Olivier Ferrand), Arnaud Montebourg est finalement l\'un des grands gagnants des universités d\'été de La Rochelle. Même si son forcing a irrité </wlr:hasDescription><wlr:hasScore>0.824323</wlr:hasScore><wlr:hasRank>71</wlr:hasRank><dc:identifier>52502</dc:identifier><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/hit:347"><wlr:inResultSetHit rdf:resource="periplus://simquery/result"/><wlr:isLinkedTo rdf:resource="periplus://resource:347"/><wlr:hasDescription>L\'accueil de guérilleros des Forces armées révolutionnaires en Colombie (FARC) sur le territoire français : voilà la probable clef diplomatique de la tentative de libération d\'Ingrid Betancourt qui est en train de se jouer en Amérique du Sud. L\'Elysée a annoncé, mercredi </wlr:hasDescription><wlr:hasScore>0.823627</wlr:hasScore><wlr:hasRank>72</wlr:hasRank><dc:identifier>10057</dc:identifier><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/hit:600"><wlr:inResultSetHit rdf:resource="periplus://simquery/result"/><wlr:isLinkedTo rdf:resource="periplus://resource:600"/><wlr:hasDescription>En matière culturelle, le candidat à l\'élection présidentielle Nicolas Sarkozy s\'était limité au strict minimum. Deux promesses saillantes, en</wlr:hasDescription><wlr:hasScore>0.823627</wlr:hasScore><wlr:hasRank>73</wlr:hasRank><dc:identifier>12369</dc:identifier><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/hit:3200"><wlr:inResultSetHit rdf:resource="periplus://simquery/result"/><wlr:isLinkedTo rdf:resource="periplus://resource:3200"/><wlr:hasDescription>&quot;Je suis quelqu\'un de souple dans mes charentaises&quot;, plaisante Valérie Pécresse sur France Culture en février 2009, en contrepoint du fameux &quot;droit dans mes bottes&quot; d\'Alain Juppé en pleine crise de la réforme des retraites en 1995. Cette souplesse en chaussons </wlr:hasDescription><mediaUnit xsi:type="model:Image"><wlr:hasNativeContent>http://static.mediapart.fr/files/imagecache/475_pixels/Jade%20Lindgaard/lussault.jpg</wlr:hasNativeContent></mediaUnit><mediaUnit xsi:type="model:Image"><wlr:hasNativeContent>http://static.mediapart.fr/files/imagecache/475_pixels/La%20r%C3%A9daction%20Mediapart/paille.png</wlr:hasNativeContent></mediaUnit><wlr:hasScore>0.823627</wlr:hasScore><wlr:hasRank>74</wlr:hasRank><dc:identifier>35718</dc:identifier><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/hit:4458"><wlr:inResultSetHit rdf:resource="periplus://simquery/result"/><wlr:isLinkedTo rdf:resource="periplus://resource:4458"/><wlr:hasDescription>Jean-Pierre Mignard quitte la présidence de Désirs d\'avenir désormais assumée par Ségolène Royal elle-même, qui entend transformer l\'association en &quot;ONG européenne&quot; proche d\'une fondation type think tank, comme le précise un communiqué publié jeudi 3 septembre. Dans un entretien à Mediapart</wlr:hasDescription><wlr:hasScore>0.823627</wlr:hasScore><wlr:hasRank>75</wlr:hasRank><dc:identifier>53147</dc:identifier><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/hit:4698"><wlr:inResultSetHit rdf:resource="periplus://simquery/result"/><wlr:isLinkedTo rdf:resource="periplus://resource:4698"/><wlr:hasDescription>Alors que la session parlementaire est à peine réunie, que les sujets foisonnent allant des suites de la crise économique au colossal déficit budgétaire en passant par la réforme des collectivités locales, quel est l\'un des tout premiers sujets que le gouvernement décide d\'inscrire à l\'ordre du jour de l\'Assemblée nationale? L\'ouverture du marché des jeux en ligne et la fin du monopole de l\'Etat sur ce secteur.&quot;Nous avons pour ambition que </wlr:hasDescription><wlr:hasScore>0.823627</wlr:hasScore><wlr:hasRank>76</wlr:hasRank><dc:identifier>63657</dc:identifier><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/hit:4823"><wlr:inResultSetHit rdf:resource="periplus://simquery/result"/><wlr:isLinkedTo rdf:resource="periplus://resource:4823"/><wlr:hasDescription>&quot;Je ne dirai rien sur les élections au PS, ce serait désagréable&quot;, ironisait Jean Sarkozy, vendredi, au conseil général des Hauts-de-Seine, lors de son discours de candidat au poste d\'administrateur de l\'Epad. A l\'UMP, on se plaît à renvoy</wlr:hasDescription><mediaUnit xsi:type="model:Image"><wlr:hasNativeContent>http://static.mediapart.fr/files/Michel Dalloni/tableau_primaires_ump.png</wlr:hasNativeContent></mediaUnit><mediaUnit xsi:type="model:Image"><wlr:hasNativeContent>http://static.mediapart.fr/files/imagecache/475_pixels/La%20r%C3%A9daction%20Mediapart/paille.png</wlr:hasNativeContent></mediaUnit><wlr:hasScore>0.823127</wlr:hasScore><wlr:hasRank>77</wlr:hasRank><dc:identifier>67076</dc:identifier><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/hit:4272"><wlr:inResultSetHit rdf:resource="periplus://simquery/result"/><wlr:isLinkedTo rdf:resource="periplus://resource:4272"/><wlr:hasDescription>Oublions Jack Lang, Bernard-Henri Lévy et leurs imprécations sur la mort assurée du Parti socialiste. Laissons à Max Gallo, ancien </wlr:hasDescription><mediaUnit xsi:type="model:Image"><wlr:hasNativeContent>http://static.mediapart.fr/files/imagecache/150_pixels/Sylvain%20Bourmeau/Assayag%20J.jpg</wlr:hasNativeContent></mediaUnit><mediaUnit xsi:type="model:Image"><wlr:hasNativeContent>http://static.mediapart.fr/files/imagecache/475_pixels/La%20r%C3%A9daction%20Mediapart/paille.png</wlr:hasNativeContent></mediaUnit><wlr:hasScore>0.822925</wlr:hasScore><wlr:hasRank>78</wlr:hasRank><dc:identifier>45740</dc:identifier><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/hit:2577"><wlr:inResultSetHit rdf:resource="periplus://simquery/result"/><wlr:isLinkedTo rdf:resource="periplus://resource:2577"/><wlr:hasDescription>Attention, un train peut en cacher un autre. L\'arrivée de Patrick Devedjia</wlr:hasDescription><wlr:hasScore>0.819154</wlr:hasScore><wlr:hasRank>79</wlr:hasRank><dc:identifier>29621</dc:identifier><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/hit:4728"><wlr:inResultSetHit rdf:resource="periplus://simquery/result"/><wlr:isLinkedTo rdf:resource="periplus://resource:4728"/><wlr:hasDescription>L\'ex-judoka David Douillet, engagé sous les couleurs du parti présidentiel, a écrasé le premier tour de l\'élection législative partielle organisée dimanche 11 octobre, dans la 12e circonscription des Yvelines, en captant 44,2% des voix, soit le double du candidat socialiste et maire de Poissy, Frédérik Bernard, qui a recueilli 21,9% des bulletins. Le candidat d\'Europe-Ecologie</wlr:hasDescription><wlr:hasScore>0.818169</wlr:hasScore><wlr:hasRank>80</wlr:hasRank><dc:identifier>65097</dc:identifier><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/hit:5490"><wlr:inResultSetHit rdf:resource="periplus://simquery/result"/><wlr:isLinkedTo rdf:resource="periplus://resource:5490"/><wlr:hasDescription>Jeudi, l\'UMP était plus bavarde sur la dernière sortie du socialiste Georges Frêche que sur la relaxe de Dominique de Villepin dans le procès Clearstream. Connu pour dégainer des commu</wlr:hasDescription><wlr:hasScore>0.818169</wlr:hasScore><wlr:hasRank>81</wlr:hasRank><dc:identifier>73885</dc:identifier><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/hit:4341"><wlr:inResultSetHit rdf:resource="periplus://simquery/result"/><wlr:isLinkedTo rdf:resource="periplus://resource:4341"/><wlr:hasDescription>Plus de trois mois après le revers des élections européennes, où il a recueilli à peine 16,48%, devançant d\'une rien les listes Europe-Ecologie, et à quelques jours de son université d\'été de La Rochelle (28-30 août), il n\'est pas certain que le parti socialiste a retrouvé confiance, sérénité et cohésion. Entre les silences de Ségolèn</wlr:hasDescription><wlr:hasScore>0.817228</wlr:hasScore><wlr:hasRank>82</wlr:hasRank><dc:identifier>46602</dc:identifier><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/hit:2286"><wlr:inResultSetHit rdf:resource="periplus://simquery/result"/><wlr:isLinkedTo rdf:resource="periplus://resource:2286"/><wlr:hasDescription>Lundi 10 novembre au matin, une délégation du Cran, conseil représentatif des associations noires, est reçue à l\'Elysée. Pas par le président, ni par </wlr:hasDescription><wlr:hasScore>0.817157</wlr:hasScore><wlr:hasRank>83</wlr:hasRank><dc:identifier>27334</dc:identifier><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/hit:3510"><wlr:inResultSetHit rdf:resource="periplus://simquery/result"/><wlr:isLinkedTo rdf:resource="periplus://resource:3510"/><wlr:hasDescription>&quot;Une caravane mobile pour montrer que l\'Europe peut mobiliser.&quot; Lundi 20 avril, le secrétair</wlr:hasDescription><mediaUnit xsi:type="model:Image"><wlr:hasNativeContent>http://static.mediapart.fr/files/imagecache/225_pixels/Marine%20Turchi/Image%202_6.png</wlr:hasNativeContent></mediaUnit><mediaUnit xsi:type="model:Image"><wlr:hasNativeContent>http://static.mediapart.fr/files/imagecache/475_pixels/La%20r%C3%A9daction%20Mediapart/paille.png</wlr:hasNativeContent></mediaUnit><wlr:hasScore>0.817157</wlr:hasScore><wlr:hasRank>84</wlr:hasRank><dc:identifier>38947</dc:identifier><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/hit:4201"><wlr:inResultSetHit rdf:resource="periplus://simquery/result"/><wlr:isLinkedTo rdf:resource="periplus://resource:4201"/><wlr:hasDescription>Martin Hirsch a pris un coup de jeune. Tel un étudiant cherchant un </wlr:hasDescription><mediaUnit xsi:type="model:Image"><wlr:hasNativeContent>http://static.mediapart.fr/files/imagecache/225_pixels/Micha%C3%ABl%20Hajdenberg/Image%2031.png</wlr:hasNativeContent></mediaUnit><mediaUnit xsi:type="model:Image"><wlr:hasNativeContent>http://static.mediapart.fr/files/imagecache/475_pixels/La%20r%C3%A9daction%20Mediapart/paille.png</wlr:hasNativeContent></mediaUnit><wlr:hasScore>0.817157</wlr:hasScore><wlr:hasRank>85</wlr:hasRank><dc:identifier>45166</dc:identifier><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/hit:4545"><wlr:inResultSetHit rdf:resource="periplus://simquery/result"/><wlr:isLinkedTo rdf:resource="periplus://resource:4545"/><wlr:hasDescription>Il aura fallu deux ans pour que Nicolas Sarkozy fasse son mea-culpa sur les empreintes génétiques réservées aux étrangers souhaitant rejoindre leur famille en France. Lors d\'une rencontre à l\'Élys</wlr:hasDescription><wlr:hasScore>0.815821</wlr:hasScore><wlr:hasRank>86</wlr:hasRank><dc:identifier>56762</dc:identifier><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/hit:4513"><wlr:inResultSetHit rdf:resource="periplus://simquery/result"/><wlr:isLinkedTo rdf:resource="periplus://resource:4513"/><wlr:hasDescription>Il a été l\'une des stars de \8220l\'ouverture socialiste\8221 durant l\'été, participant aux meetings de François Hollande (à Lorient en juin) puis de Vincent Peillon (à Marseille en août). Désormais ressorti de l\'anony</wlr:hasDescription><wlr:hasScore>0.814434</wlr:hasScore><wlr:hasRank>87</wlr:hasRank><dc:identifier>55167</dc:identifier><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/hit:446"><wlr:inResultSetHit rdf:resource="periplus://simquery/result"/><wlr:isLinkedTo rdf:resource="periplus://resource:446"/><wlr:hasDescription>L\'inusable Michel Charasse exclu du PS? La fédération socialiste du Puy-de-Dôme en a voté la demande jeudi soir, à une large majorité du conseil fédéral (42 voix contre 14). Mais l\'ancien ministre du Bud</wlr:hasDescription><wlr:hasScore>0.814077</wlr:hasScore><wlr:hasRank>88</wlr:hasRank><dc:identifier>11001</dc:identifier><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/hit:2312"><wlr:inResultSetHit rdf:resource="periplus://simquery/result"/><wlr:isLinkedTo rdf:resource="periplus://resource:2312"/><wlr:hasDescription>Ces derniers jours, le bruit s\'est répandu comme une traînée de poudre dans la maison socialiste: &quot;La presse people débarque au congrès!&quot; Les journalistes de Voici seraient déjà en route pour Reims, bardés de magnétos... Interrogé, le service de pr</wlr:hasDescription><mediaUnit xsi:type="model:Image"><wlr:hasNativeContent>http://static.mediapart.fr/files/Mathilde Mathieu/tiny_3119_couv.jpg</wlr:hasNativeContent></mediaUnit><mediaUnit xsi:type="model:Image"><wlr:hasNativeContent>http://static.mediapart.fr/files/imagecache/475_pixels/La%20r%C3%A9daction%20Mediapart/paille.png</wlr:hasNativeContent></mediaUnit><wlr:hasScore>0.814077</wlr:hasScore><wlr:hasRank>89</wlr:hasRank><dc:identifier>27639</dc:identifier><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/hit:5488"><wlr:inResultSetHit rdf:resource="periplus://simquery/result"/><wlr:isLinkedTo rdf:resource="periplus://resource:5488"/><wlr:hasDescription>Si le parti socialiste n\'est toujours pas un long fleuve tranquille, il parvient tout de même à ne pas se noyer dans les eaux troubles de la division. En adoptant mardi soir une po</wlr:hasDescription><wlr:hasScore>0.814077</wlr:hasScore><wlr:hasRank>90</wlr:hasRank><dc:identifier>73823</dc:identifier><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/hit:2075"><wlr:inResultSetHit rdf:resource="periplus://simquery/result"/><wlr:isLinkedTo rdf:resource="periplus://resource:2075"/><wlr:hasDescription>La Caisse d\'épargne, qui a révélé une perte de 600 millions d\'euros dans des opérations de marché, doit réunir son conseil de surveillance, dimanche 19 octobre, dans l\'après-midi, afin de se prononcer sur le sort de la direction et notamment celui du président du directoire de la Caisse nationale des Caisses d\'épargne (CNCE), Charles Milhaud.Dans un entretien, publié par</wlr:hasDescription><wlr:hasScore>0.813793</wlr:hasScore><wlr:hasRank>91</wlr:hasRank><dc:identifier>25510</dc:identifier><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/hit:487"><wlr:inResultSetHit rdf:resource="periplus://simquery/result"/><wlr:isLinkedTo rdf:resource="periplus://resource:487"/><wlr:hasDescription>Du &quot;les caisses sont vides&quot; de Nicolas Sarkozy au &quot;pays en faillite&quot; de François Fillon, le triste état des finances publiques françaises alimente la chronique par intermittence. Mais derrière le propos polit</wlr:hasDescription><wlr:hasScore>0.811021</wlr:hasScore><wlr:hasRank>92</wlr:hasRank><dc:identifier>11333</dc:identifier><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/hit:1799"><wlr:inResultSetHit rdf:resource="periplus://simquery/result"/><wlr:isLinkedTo rdf:resource="periplus://resource:1799"/><wlr:hasDescription>Adieu levées de fourches, déversements de lisier, saccages de bâtiments administratifs et autres violences à agents de la force publique : la grande agriculture française semble être entrée dans l\'ère du lobbying à visage humain. Et elle a choisi pour annonce</wlr:hasDescription><wlr:hasScore>0.811021</wlr:hasScore><wlr:hasRank>93</wlr:hasRank><dc:identifier>23127</dc:identifier><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/hit:1976"><wlr:inResultSetHit rdf:resource="periplus://simquery/result"/><wlr:isLinkedTo rdf:resource="periplus://resource:1976"/><wlr:hasDescription>Mais où est donc passée la gauche? Cette époque de tempête et de crise devrait être faste pour elle. Alors que le capitalisme trav</wlr:hasDescription><wlr:hasScore>0.811021</wlr:hasScore><wlr:hasRank>94</wlr:hasRank><dc:identifier>24528</dc:identifier><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/hit:5753"><wlr:inResultSetHit rdf:resource="periplus://simquery/result"/><wlr:isLinkedTo rdf:resource="periplus://resource:5753"/><wlr:hasDescription>Chez Europe Ecologie, beaucoup ne le disent qu\'à demi-mot, mais ils sont déçus: tous auraient aimé dépasser les 16% des européennes de 2009. Tout juste débarqué de son ma</wlr:hasDescription><mediaUnit xsi:type="model:Image"><wlr:hasNativeContent>http://static.mediapart.fr/files/imagecache/300_pixels/La%20r%C3%A9daction%20Mediapart/besson-photo.jpg</wlr:hasNativeContent></mediaUnit><mediaUnit xsi:type="model:Image"><wlr:hasNativeContent>http://static.mediapart.fr/files/imagecache/475_pixels/La%20r%C3%A9daction%20Mediapart/paille.png</wlr:hasNativeContent></mediaUnit><wlr:hasScore>0.810912</wlr:hasScore><wlr:hasRank>95</wlr:hasRank><dc:identifier>77546</dc:identifier><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/hit:1592"><wlr:inResultSetHit rdf:resource="periplus://simquery/result"/><wlr:isLinkedTo rdf:resource="periplus://resource:1592"/><wlr:hasDescription>Certains auront peut-être du mal à le croire, mais, à quelques heures de l\'ouverture de la Convention démocrate de Denver, chargée d\'investir officiellement Barack Obama, ce dernier n\'est pas encore assuré d\'accéder à la Maison Blanche. Les 200.000 Allemands qui lui</wlr:hasDescription><mediaUnit xsi:type="model:Image"><wlr:hasNativeContent>http://static.mediapart.fr/files/imagecache/475_pixels/Thomas%20Cantaloube/photos/Image%203_4.png</wlr:hasNativeContent></mediaUnit><mediaUnit xsi:type="model:Image"><wlr:hasNativeContent>http://static.mediapart.fr/files/imagecache/475_pixels/La%20r%C3%A9daction%20Mediapart/paille.png</wlr:hasNativeContent></mediaUnit><wlr:hasScore>0.810167</wlr:hasScore><wlr:hasRank>96</wlr:hasRank><dc:identifier>21133</dc:identifier><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/hit:1600"><wlr:inResultSetHit rdf:resource="periplus://simquery/result"/><wlr:isLinkedTo rdf:resource="periplus://resource:1600"/><wlr:hasDescription>On prête à Talleyrand ce mot: \&quot;Quand je m\'examine, je m\'inquiète. Quand je me compare, je me ra</wlr:hasDescription><wlr:hasScore>0.804479</wlr:hasScore><wlr:hasRank>97</wlr:hasRank><dc:identifier>21227</dc:identifier><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/hit:5548"><wlr:inResultSetHit rdf:resource="periplus://simquery/result"/><wlr:isLinkedTo rdf:resource="periplus://resource:5548"/><wlr:hasDescription>De notre envoyée spéciale en Paca, Ce jour-là, en campagne sur le site nucléaire du Tricastin, Europe Ecologie vient mesurer la radioactivité et déposer une gerbe de fleurs: &quot;Ci-gît la santé publique!&quot;... Des candidats aux régionale</wlr:hasDescription><mediaUnit xsi:type="model:Image"><wlr:hasNativeContent>http://static.mediapart.fr/files/imagecache/475_pixels/Mathilde%20Mathieu/vichnievsky5.jpg</wlr:hasNativeContent></mediaUnit><mediaUnit xsi:type="model:Image"><wlr:hasNativeContent>http://static.mediapart.fr/files/imagecache/475_pixels/La%20r%C3%A9daction%20Mediapart/paille.png</wlr:hasNativeContent></mediaUnit><wlr:hasScore>0.802372</wlr:hasScore><wlr:hasRank>98</wlr:hasRank><dc:identifier>74485</dc:identifier><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/hit:2290"><wlr:inResultSetHit rdf:resource="periplus://simquery/result"/><wlr:isLinkedTo rdf:resource="periplus://resource:2290"/><wlr:hasDescription>Difficile construction d\'alliances majoritaires, au parti socialiste. Après le vote des motions et </wlr:hasDescription><wlr:hasScore>0.801553</wlr:hasScore><wlr:hasRank>99</wlr:hasRank><dc:identifier>27360</dc:identifier><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/hit:2033"><wlr:inResultSetHit rdf:resource="periplus://simquery/result"/><wlr:isLinkedTo rdf:resource="periplus://resource:2033"/><wlr:hasDescription>Soudain, un week-end, le travail du dimanche est devenu priorité nationale. Dimanche dernier, le ministre</wlr:hasDescription><mediaUnit xsi:type="model:Image"><wlr:hasNativeContent>http://static.mediapart.fr/files/imagecache/475_pixels/Mathieu%20Magnaudeix/Image%208_2.png</wlr:hasNativeContent></mediaUnit><mediaUnit xsi:type="model:Image"><wlr:hasNativeContent>http://static.mediapart.fr/files/imagecache/475_pixels/La%20r%C3%A9daction%20Mediapart/paille.png</wlr:hasNativeContent></mediaUnit><wlr:hasScore>0.801468</wlr:hasScore><wlr:hasRank>100</wlr:hasRank><dc:identifier>25201</dc:identifier><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"/></rdf:Description><rdf:Description rdf:about="periplus://simquery/result/cluster:0"><wlr:hasNumberOfResults>19</wlr:hasNumberOfResults><wlr:isLinkedTo rdf:resource="periplus://cluster:0"/><wlr:hasScore>1</wlr:hasScore><wlr:hasDescription>Proche de Ségolène Royal, François Rebsamen a un temps envisagé de faire le trait-d\'union avec les amis de François Hollande pour renverser Martine Aubry de la direction du PS. Rentré dans le rang</wlr:hasDescription><mediaUnit xsi:type="model:Image"><wlr:hasNativeContent>http://static.mediapart.fr/files/imagecache/300_pixels/St%C3%A9phane%20Alli%C3%A8s/ResizedImage383255-IMG0707.JPG</wlr:hasNativeContent></mediaUnit><mediaUnit xsi:type="model:Image"><wlr:hasNativeContent>http://static.mediapart.fr/files/Mathilde Mathieu/229180457_9db20a3f47_m.jpg</wlr:hasNativeContent></mediaUnit><dc:title>PS</dc:title><rdf:type rdf:resource="DocumentCluster"/></rdf:Description><rdf:Bag rdf:about="periplus://simquery/result/cluster:0"><rdf:li rdf:resource="periplus://simquery/result/hit:3883"/><rdf:li rdf:resource="periplus://simquery/result/hit:2475"/><rdf:li rdf:resource="periplus://simquery/result/hit:4210"/><rdf:li rdf:resource="periplus://simquery/result/hit:2156"/><rdf:li rdf:resource="periplus://simquery/result/hit:3676"/><rdf:li rdf:resource="periplus://simquery/result/hit:3799"/><rdf:li rdf:resource="periplus://simquery/result/hit:2278"/><rdf:li rdf:resource="periplus://simquery/result/hit:1093"/><rdf:li rdf:resource="periplus://simquery/result/hit:1600"/><rdf:li rdf:resource="periplus://simquery/result/hit:2290"/><rdf:li rdf:resource="periplus://simquery/result/hit:4285"/><rdf:li rdf:resource="periplus://simquery/result/hit:571"/><rdf:li rdf:resource="periplus://simquery/result/hit:4458"/><rdf:li rdf:resource="periplus://simquery/result/hit:4272"/><rdf:li rdf:resource="periplus://simquery/result/hit:446"/><rdf:li rdf:resource="periplus://simquery/result/hit:2312"/><rdf:li rdf:resource="periplus://simquery/result/hit:5488"/><rdf:li rdf:resource="periplus://simquery/result/hit:4513"/><rdf:li rdf:resource="periplus://simquery/result/hit:4728"/></rdf:Bag><rdf:Description rdf:about="periplus://simquery/result/cluster:1"><wlr:hasNumberOfResults>9</wlr:hasNumberOfResults><wlr:isLinkedTo rdf:resource="periplus://cluster:1"/><wlr:hasScore>0.970595</wlr:hasScore><wlr:hasDescription>Lot de consolation pour la droite : La Guyane basculerait. Selon des chiffres encore</wlr:hasDescription><mediaUnit xsi:type="model:Image"><wlr:hasNativeContent>http://static.mediapart.fr/files/imagecache/300_pixels/La%20r%C3%A9daction%20Mediapart/rejet.png</wlr:hasNativeContent></mediaUnit><mediaUnit xsi:type="model:Image"><wlr:hasNativeContent>http://static.mediapart.fr/files/imagecache/475_pixels/La%20r%C3%A9daction%20Mediapart/paille.png</wlr:hasNativeContent></mediaUnit><dc:title>élections régionales</dc:title><rdf:type rdf:resource="DocumentCluster"/></rdf:Description><rdf:Bag rdf:about="periplus://simquery/result/cluster:1"><rdf:li rdf:resource="periplus://simquery/result/hit:5803"/><rdf:li rdf:resource="periplus://simquery/result/hit:5767"/><rdf:li rdf:resource="periplus://simquery/result/hit:5548"/><rdf:li rdf:resource="periplus://simquery/result/hit:133"/><rdf:li rdf:resource="periplus://simquery/result/hit:3256"/><rdf:li rdf:resource="periplus://simquery/result/hit:3328"/><rdf:li rdf:resource="periplus://simquery/result/hit:4397"/><rdf:li rdf:resource="periplus://simquery/result/hit:96"/><rdf:li rdf:resource="periplus://simquery/result/hit:5506"/></rdf:Bag><rdf:Description rdf:about="periplus://simquery/result/cluster:2"><wlr:hasNumberOfResults>25</wlr:hasNumberOfResults><wlr:isLinkedTo rdf:resource="periplus://cluster:2"/><wlr:hasScore>0.961693</wlr:hasScore><wlr:hasDescription>Du changement de statut de La Poste, il n\'a été que peu question durant la campagne des élections européennes, comme si la réforme avait pris du retard ou n\'était plus d\'actualité. Et pourtant, il n\'en est rien</wlr:hasDescription><mediaUnit xsi:type="model:Image"><wlr:hasNativeContent>http://static.mediapart.fr/files/Laurent Mauduit/Image 8_13.png</wlr:hasNativeContent></mediaUnit><dc:title>gouvernement UMP</dc:title><rdf:type rdf:resource="DocumentCluster"/></rdf:Description><rdf:Bag rdf:about="periplus://simquery/result/cluster:2"><rdf:li rdf:resource="periplus://simquery/result/hit:3844"/><rdf:li rdf:resource="periplus://simquery/result/hit:2129"/><rdf:li rdf:resource="periplus://simquery/result/hit:2441"/><rdf:li rdf:resource="periplus://simquery/result/hit:5120"/><rdf:li rdf:resource="periplus://simquery/result/hit:2501"/><rdf:li rdf:resource="periplus://simquery/result/hit:1462"/><rdf:li rdf:resource="periplus://simquery/result/hit:1797"/><rdf:li rdf:resource="periplus://simquery/result/hit:2185"/><rdf:li rdf:resource="periplus://simquery/result/hit:397"/><rdf:li rdf:resource="periplus://simquery/result/hit:1668"/><rdf:li rdf:resource="periplus://simquery/result/hit:1036"/><rdf:li rdf:resource="periplus://simquery/result/hit:1614"/><rdf:li rdf:resource="periplus://simquery/result/hit:1535"/><rdf:li rdf:resource="periplus://simquery/result/hit:1320"/><rdf:li rdf:resource="periplus://simquery/result/hit:1176"/><rdf:li rdf:resource="periplus://simquery/result/hit:1403"/><rdf:li rdf:resource="periplus://simquery/result/hit:2179"/><rdf:li rdf:resource="periplus://simquery/result/hit:1976"/><rdf:li rdf:resource="periplus://simquery/result/hit:154"/><rdf:li rdf:resource="periplus://simquery/result/hit:47"/><rdf:li rdf:resource="periplus://simquery/result/hit:347"/><rdf:li rdf:resource="periplus://simquery/result/hit:2033"/><rdf:li rdf:resource="periplus://simquery/result/hit:4698"/><rdf:li rdf:resource="periplus://simquery/result/hit:4201"/><rdf:li rdf:resource="periplus://simquery/result/hit:4545"/></rdf:Bag><rdf:Description rdf:about="periplus://simquery/result/cluster:3"><wlr:hasNumberOfResults>4</wlr:hasNumberOfResults><wlr:isLinkedTo rdf:resource="periplus://cluster:3"/><wlr:hasScore>0.936393</wlr:hasScore><wlr:hasDescription>Une bombe dort au pôle financier du tribunal de grande instance de Paris. Les juges Françoise Desset et</wlr:hasDescription><mediaUnit xsi:type="model:Image"><wlr:hasNativeContent>http://static.mediapart.fr/files/imagecache/475_pixels/Fabrice%20Arfi/article_photo_1218010950574-1-0.jpg</wlr:hasNativeContent></mediaUnit><dc:title>affaire de Karachi</dc:title><rdf:type rdf:resource="DocumentCluster"/></rdf:Description><rdf:Bag rdf:about="periplus://simquery/result/cluster:3"><rdf:li rdf:resource="periplus://simquery/result/hit:1744"/><rdf:li rdf:resource="periplus://simquery/result/hit:1745"/><rdf:li rdf:resource="periplus://simquery/result/hit:3972"/><rdf:li rdf:resource="periplus://simquery/result/hit:3973"/></rdf:Bag><rdf:Description rdf:about="periplus://simquery/result/cluster:4"><wlr:hasNumberOfResults>9</wlr:hasNumberOfResults><wlr:isLinkedTo rdf:resource="periplus://cluster:4"/><wlr:hasScore>0.928015</wlr:hasScore><wlr:hasDescription>&quot;Dans une telle campagne où les petites phrases et les effets médiatiques semblent plus compter que le fond, de belles images au 20 heures ne peuvent pas faire de mal.&quot; Ce commentaire d\'un dirigean</wlr:hasDescription><mediaUnit xsi:type="model:Image"><wlr:hasNativeContent>http://static.mediapart.fr/files/imagecache/300_pixels/St%C3%A9phane%20Alli%C3%A8s/Image%205_5.png</wlr:hasNativeContent></mediaUnit><dc:title>campagne des européennes</dc:title><rdf:type rdf:resource="DocumentCluster"/></rdf:Description><rdf:Bag rdf:about="periplus://simquery/result/cluster:4"><rdf:li rdf:resource="periplus://simquery/result/hit:3789"/><rdf:li rdf:resource="periplus://simquery/result/hit:3556"/><rdf:li rdf:resource="periplus://simquery/result/hit:3849"/><rdf:li rdf:resource="periplus://simquery/result/hit:3802"/><rdf:li rdf:resource="periplus://simquery/result/hit:3576"/><rdf:li rdf:resource="periplus://simquery/result/hit:5753"/><rdf:li rdf:resource="periplus://simquery/result/hit:3862"/><rdf:li rdf:resource="periplus://simquery/result/hit:4341"/><rdf:li rdf:resource="periplus://simquery/result/hit:3510"/></rdf:Bag><rdf:Description rdf:about="periplus://simquery/result/cluster:5"><wlr:hasNumberOfResults>10</wlr:hasNumberOfResults><wlr:isLinkedTo rdf:resource="periplus://cluster:5"/><wlr:hasScore>0.914044</wlr:hasScore><wlr:hasDescription>L\'UMP et le PS sont des jumeaux dizygotes. Ils ne sont pas issus du même</wlr:hasDescription><mediaUnit xsi:type="model:Image"><wlr:hasNativeContent>http://static.mediapart.fr/files/imagecache/475_pixels/Marine%20Turchi/2083.jpg</wlr:hasNativeContent></mediaUnit><dc:title>UMP</dc:title><rdf:type rdf:resource="DocumentCluster"/></rdf:Description><rdf:Bag rdf:about="periplus://simquery/result/cluster:5"><rdf:li rdf:resource="periplus://simquery/result/hit:288"/><rdf:li rdf:resource="periplus://simquery/result/hit:3675"/><rdf:li rdf:resource="periplus://simquery/result/hit:3993"/><rdf:li rdf:resource="periplus://simquery/result/hit:1015"/><rdf:li rdf:resource="periplus://simquery/result/hit:3533"/><rdf:li rdf:resource="periplus://simquery/result/hit:600"/><rdf:li rdf:resource="periplus://simquery/result/hit:3200"/><rdf:li rdf:resource="periplus://simquery/result/hit:2577"/><rdf:li rdf:resource="periplus://simquery/result/hit:4823"/><rdf:li rdf:resource="periplus://simquery/result/hit:5490"/></rdf:Bag><rdf:Description rdf:about="periplus://simquery/result/cluster:6"><wlr:hasNumberOfResults>6</wlr:hasNumberOfResults><wlr:isLinkedTo rdf:resource="periplus://cluster:6"/><wlr:hasScore>0.907456</wlr:hasScore><wlr:hasDescription>Jacques Julliard, 77 ans, entre en dissidence. Figure historique de la &quot;deux</wlr:hasDescription><mediaUnit xsi:type="model:Image"><wlr:hasNativeContent>http://static.mediapart.fr/files/imagecache/250_pixels/St%C3%A9phane%20Alli%C3%A8s/julliard.png</wlr:hasNativeContent></mediaUnit><mediaUnit xsi:type="model:Image"><wlr:hasNativeContent>http://static.mediapart.fr/files/imagecache/300_pixels/Marine%20Turchi/chirac_balladur.png</wlr:hasNativeContent></mediaUnit><dc:title>livre</dc:title><rdf:type rdf:resource="DocumentCluster"/></rdf:Description><rdf:Bag rdf:about="periplus://simquery/result/cluster:6"><rdf:li rdf:resource="periplus://simquery/result/hit:5828"/><rdf:li rdf:resource="periplus://simquery/result/hit:4870"/><rdf:li rdf:resource="periplus://simquery/result/hit:5246"/><rdf:li rdf:resource="periplus://simquery/result/hit:4453"/><rdf:li rdf:resource="periplus://simquery/result/hit:4904"/><rdf:li rdf:resource="periplus://simquery/result/hit:5005"/></rdf:Bag><rdf:Description rdf:about="periplus://simquery/result/cluster:7"><wlr:hasNumberOfResults>4</wlr:hasNumberOfResults><wlr:isLinkedTo rdf:resource="periplus://cluster:7"/><wlr:hasScore>0.865421</wlr:hasScore><wlr:hasDescription>&quot;Dans quelques années nous dirons: il y a l\'UMP et il y a le Nouveau Centre&quot;, a assuré Hervé Morin, lors des voeux aux cadres de son parti, lundi 18 janvier. Chaque année, le discours est</wlr:hasDescription><mediaUnit xsi:type="model:Image"><wlr:hasNativeContent>http://static.mediapart.fr/files/Marine%20Turchi/udf.png</wlr:hasNativeContent></mediaUnit><mediaUnit xsi:type="model:Image"><wlr:hasNativeContent>http://static.mediapart.fr/files/imagecache/150_pixels/Marine%20Turchi/Dominique_villepin_1.jpg</wlr:hasNativeContent></mediaUnit><dc:title>Nouveau Centre Modem</dc:title><rdf:type rdf:resource="DocumentCluster"/></rdf:Description><rdf:Bag rdf:about="periplus://simquery/result/cluster:7"><rdf:li rdf:resource="periplus://simquery/result/hit:5351"/><rdf:li rdf:resource="periplus://simquery/result/hit:3646"/><rdf:li rdf:resource="periplus://simquery/result/hit:2361"/><rdf:li rdf:resource="periplus://simquery/result/hit:4470"/></rdf:Bag><rdf:Description rdf:about="periplus://simquery/result/cluster:8"><wlr:hasNumberOfResults>6</wlr:hasNumberOfResults><wlr:isLinkedTo rdf:resource="periplus://cluster:8"/><wlr:hasScore>0.851838</wlr:hasScore><wlr:hasDescription>En pleine panique financière, les responsables politiques retrouvent la parole. Après la réunion de crise ce </wlr:hasDescription><mediaUnit xsi:type="model:Image"><wlr:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/3883</wlr:hasNativeContent></mediaUnit><mediaUnit xsi:type="model:Image"><wlr:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/3256</wlr:hasNativeContent></mediaUnit><dc:title>panique financière</dc:title><rdf:type rdf:resource="DocumentCluster"/></rdf:Description><rdf:Bag rdf:about="periplus://simquery/result/cluster:8"><rdf:li rdf:resource="periplus://simquery/result/hit:1902"/><rdf:li rdf:resource="periplus://simquery/result/hit:5881"/><rdf:li rdf:resource="periplus://simquery/result/hit:1978"/><rdf:li rdf:resource="periplus://simquery/result/hit:1524"/><rdf:li rdf:resource="periplus://simquery/result/hit:2075"/><rdf:li rdf:resource="periplus://simquery/result/hit:487"/></rdf:Bag><rdf:Description rdf:about="periplus://simquery/result/cluster:9"><wlr:hasNumberOfResults>8</wlr:hasNumberOfResults><wlr:isLinkedTo rdf:resource="periplus://cluster:9"/><wlr:hasScore>0.95304</wlr:hasScore><wlr:hasDescription>No summary available</wlr:hasDescription><dc:title>etc.</dc:title><rdf:type rdf:resource="DocumentCluster"/></rdf:Description><rdf:Bag rdf:about="periplus://simquery/result/cluster:9"><rdf:li rdf:resource="periplus://simquery/result/hit:271"/><rdf:li rdf:resource="periplus://simquery/result/hit:1799"/><rdf:li rdf:resource="periplus://simquery/result/hit:1732"/><rdf:li rdf:resource="periplus://simquery/result/hit:4618"/><rdf:li rdf:resource="periplus://simquery/result/hit:5922"/><rdf:li rdf:resource="periplus://simquery/result/hit:5786"/><rdf:li rdf:resource="periplus://simquery/result/hit:1592"/><rdf:li rdf:resource="periplus://simquery/result/hit:2286"/></rdf:Bag><rdf:Description rdf:about="periplus://simquery/result"><wlr:hasQueryOffset>0</wlr:hasQueryOffset><wlr:hasNumberOfResults>100</wlr:hasNumberOfResults><wlr:isResultOf rdf:resource="periplus://simquery"/><rdf:type rdf:resource="http://weblab.ow2.org/core/1.2/model#ResultSet"/><wlr:hasHit rdf:resource="periplus://simquery/result/hit:3883"/><wlr:hasHit rdf:resource="periplus://simquery/result/hit:3256"/><wlr:hasHit rdf:resource="periplus://simquery/result/hit:3328"/><wlr:hasHit rdf:resource="periplus://simquery/result/hit:3844"/><wlr:hasHit rdf:resource="periplus://simquery/result/hit:271"/><wlr:hasHit rdf:resource="periplus://simquery/result/hit:1732"/><wlr:hasHit rdf:resource="periplus://simquery/result/hit:5803"/><wlr:hasHit rdf:resource="periplus://simquery/result/hit:1744"/><wlr:hasHit rdf:resource="periplus://simquery/result/hit:1745"/><wlr:hasHit rdf:resource="periplus://simquery/result/hit:96"/><wlr:hasHit rdf:resource="periplus://simquery/result/hit:4210"/><wlr:hasHit rdf:resource="periplus://simquery/result/hit:3972"/><wlr:hasHit rdf:resource="periplus://simquery/result/hit:3973"/><wlr:hasHit rdf:resource="periplus://simquery/result/hit:2475"/><wlr:hasHit rdf:resource="periplus://simquery/result/hit:3789"/><wlr:hasHit rdf:resource="periplus://simquery/result/hit:5767"/><wlr:hasHit rdf:resource="periplus://simquery/result/hit:1036"/><wlr:hasHit rdf:resource="periplus://simquery/result/hit:133"/><wlr:hasHit rdf:resource="periplus://simquery/result/hit:3675"/><wlr:hasHit rdf:resource="periplus://simquery/result/hit:5828"/><wlr:hasHit rdf:resource="periplus://simquery/result/hit:3993"/><wlr:hasHit rdf:resource="periplus://simquery/result/hit:4870"/><wlr:hasHit rdf:resource="periplus://simquery/result/hit:2156"/><wlr:hasHit rdf:resource="periplus://simquery/result/hit:3849"/><wlr:hasHit rdf:resource="periplus://simquery/result/hit:3802"/><wlr:hasHit rdf:resource="periplus://simquery/result/hit:1320"/><wlr:hasHit rdf:resource="periplus://simquery/result/hit:1015"/><wlr:hasHit rdf:resource="periplus://simquery/result/hit:4397"/><wlr:hasHit rdf:resource="periplus://simquery/result/hit:4618"/><wlr:hasHit rdf:resource="periplus://simquery/result/hit:397"/><wlr:hasHit rdf:resource="periplus://simquery/result/hit:4285"/><wlr:hasHit rdf:resource="periplus://simquery/result/hit:1668"/><wlr:hasHit rdf:resource="periplus://simquery/result/hit:2129"/><wlr:hasHit rdf:resource="periplus://simquery/result/hit:5351"/><wlr:hasHit rdf:resource="periplus://simquery/result/hit:4904"/><wlr:hasHit rdf:resource="periplus://simquery/result/hit:1797"/><wlr:hasHit rdf:resource="periplus://simquery/result/hit:1176"/><wlr:hasHit rdf:resource="periplus://simquery/result/hit:571"/><wlr:hasHit rdf:resource="periplus://simquery/result/hit:3676"/><wlr:hasHit rdf:resource="periplus://simquery/result/hit:3799"/><wlr:hasHit rdf:resource="periplus://simquery/result/hit:3646"/><wlr:hasHit rdf:resource="periplus://simquery/result/hit:1535"/><wlr:hasHit rdf:resource="periplus://simquery/result/hit:2361"/><wlr:hasHit rdf:resource="periplus://simquery/result/hit:2441"/><wlr:hasHit rdf:resource="periplus://simquery/result/hit:5005"/><wlr:hasHit rdf:resource="periplus://simquery/result/hit:3556"/><wlr:hasHit rdf:resource="periplus://simquery/result/hit:47"/><wlr:hasHit rdf:resource="periplus://simquery/result/hit:2185"/><wlr:hasHit rdf:resource="periplus://simquery/result/hit:2278"/><wlr:hasHit rdf:resource="periplus://simquery/result/hit:1902"/><wlr:hasHit rdf:resource="periplus://simquery/result/hit:288"/><wlr:hasHit rdf:resource="periplus://simquery/result/hit:1093"/><wlr:hasHit rdf:resource="periplus://simquery/result/hit:1462"/><wlr:hasHit rdf:resource="periplus://simquery/result/hit:2179"/><wlr:hasHit rdf:resource="periplus://simquery/result/hit:1403"/><wlr:hasHit rdf:resource="periplus://simquery/result/hit:2501"/><wlr:hasHit rdf:resource="periplus://simquery/result/hit:4470"/><wlr:hasHit rdf:resource="periplus://simquery/result/hit:5881"/><wlr:hasHit rdf:resource="periplus://simquery/result/hit:3533"/><wlr:hasHit rdf:resource="periplus://simquery/result/hit:1978"/><wlr:hasHit rdf:resource="periplus://simquery/result/hit:5120"/><wlr:hasHit rdf:resource="periplus://simquery/result/hit:154"/><wlr:hasHit rdf:resource="periplus://simquery/result/hit:3862"/><wlr:hasHit rdf:resource="periplus://simquery/result/hit:5246"/><wlr:hasHit rdf:resource="periplus://simquery/result/hit:5506"/><wlr:hasHit rdf:resource="periplus://simquery/result/hit:1524"/><wlr:hasHit rdf:resource="periplus://simquery/result/hit:1614"/><wlr:hasHit rdf:resource="periplus://simquery/result/hit:3576"/><wlr:hasHit rdf:resource="periplus://simquery/result/hit:5922"/><wlr:hasHit rdf:resource="periplus://simquery/result/hit:5786"/><wlr:hasHit rdf:resource="periplus://simquery/result/hit:4453"/><wlr:hasHit rdf:resource="periplus://simquery/result/hit:347"/><wlr:hasHit rdf:resource="periplus://simquery/result/hit:600"/><wlr:hasHit rdf:resource="periplus://simquery/result/hit:3200"/><wlr:hasHit rdf:resource="periplus://simquery/result/hit:4458"/><wlr:hasHit rdf:resource="periplus://simquery/result/hit:4698"/><wlr:hasHit rdf:resource="periplus://simquery/result/hit:4823"/><wlr:hasHit rdf:resource="periplus://simquery/result/hit:4272"/><wlr:hasHit rdf:resource="periplus://simquery/result/hit:2577"/><wlr:hasHit rdf:resource="periplus://simquery/result/hit:4728"/><wlr:hasHit rdf:resource="periplus://simquery/result/hit:5490"/><wlr:hasHit rdf:resource="periplus://simquery/result/hit:4341"/><wlr:hasHit rdf:resource="periplus://simquery/result/hit:2286"/><wlr:hasHit rdf:resource="periplus://simquery/result/hit:3510"/><wlr:hasHit rdf:resource="periplus://simquery/result/hit:4201"/><wlr:hasHit rdf:resource="periplus://simquery/result/hit:4545"/><wlr:hasHit rdf:resource="periplus://simquery/result/hit:4513"/><wlr:hasHit rdf:resource="periplus://simquery/result/hit:446"/><wlr:hasHit rdf:resource="periplus://simquery/result/hit:2312"/><wlr:hasHit rdf:resource="periplus://simquery/result/hit:5488"/><wlr:hasHit rdf:resource="periplus://simquery/result/hit:2075"/><wlr:hasHit rdf:resource="periplus://simquery/result/hit:487"/><wlr:hasHit rdf:resource="periplus://simquery/result/hit:1799"/><wlr:hasHit rdf:resource="periplus://simquery/result/hit:1976"/><wlr:hasHit rdf:resource="periplus://simquery/result/hit:5753"/><wlr:hasHit rdf:resource="periplus://simquery/result/hit:1592"/><wlr:hasHit rdf:resource="periplus://simquery/result/hit:1600"/><wlr:hasHit rdf:resource="periplus://simquery/result/hit:5548"/><wlr:hasHit rdf:resource="periplus://simquery/result/hit:2290"/><wlr:hasHit rdf:resource="periplus://simquery/result/hit:2033"/></rdf:Description></rdf:RDF></data></annotation><resource uri="periplus://resource:3883" xsi:type="model:Document"><annotation uri="periplus://resource:3883/annot:0"><data><rdf:RDF xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://resource:3883"><wlp:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/3883</wlp:hasNativeContent></rdf:Description></rdf:RDF></data></annotation></resource><resource uri="periplus://resource:3256" xsi:type="model:Document"><annotation uri="periplus://resource:3256/annot:0"><data><rdf:RDF xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://resource:3256"><wlp:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/3256</wlp:hasNativeContent></rdf:Description></rdf:RDF></data></annotation></resource><resource uri="periplus://resource:3328" xsi:type="model:Document"><annotation uri="periplus://resource:3328/annot:0"><data><rdf:RDF xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://resource:3328"><wlp:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/3328</wlp:hasNativeContent></rdf:Description></rdf:RDF></data></annotation></resource><resource uri="periplus://resource:3844" xsi:type="model:Document"><annotation uri="periplus://resource:3844/annot:0"><data><rdf:RDF xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://resource:3844"><wlp:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/3844</wlp:hasNativeContent></rdf:Description></rdf:RDF></data></annotation></resource><resource uri="periplus://resource:271" xsi:type="model:Document"><annotation uri="periplus://resource:271/annot:0"><data><rdf:RDF xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://resource:271"><wlp:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/271</wlp:hasNativeContent></rdf:Description></rdf:RDF></data></annotation></resource><resource uri="periplus://resource:1732" xsi:type="model:Document"><annotation uri="periplus://resource:1732/annot:0"><data><rdf:RDF xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://resource:1732"><wlp:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/1732</wlp:hasNativeContent></rdf:Description></rdf:RDF></data></annotation></resource><resource uri="periplus://resource:5803" xsi:type="model:Document"><annotation uri="periplus://resource:5803/annot:0"><data><rdf:RDF xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://resource:5803"><wlp:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/5803</wlp:hasNativeContent></rdf:Description></rdf:RDF></data></annotation></resource><resource uri="periplus://resource:1744" xsi:type="model:Document"><annotation uri="periplus://resource:1744/annot:0"><data><rdf:RDF xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://resource:1744"><wlp:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/1744</wlp:hasNativeContent></rdf:Description></rdf:RDF></data></annotation></resource><resource uri="periplus://resource:1745" xsi:type="model:Document"><annotation uri="periplus://resource:1745/annot:0"><data><rdf:RDF xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://resource:1745"><wlp:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/1745</wlp:hasNativeContent></rdf:Description></rdf:RDF></data></annotation></resource><resource uri="periplus://resource:96" xsi:type="model:Document"><annotation uri="periplus://resource:96/annot:0"><data><rdf:RDF xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://resource:96"><wlp:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/96</wlp:hasNativeContent></rdf:Description></rdf:RDF></data></annotation></resource><resource uri="periplus://resource:4210" xsi:type="model:Document"><annotation uri="periplus://resource:4210/annot:0"><data><rdf:RDF xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://resource:4210"><wlp:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/4210</wlp:hasNativeContent></rdf:Description></rdf:RDF></data></annotation></resource><resource uri="periplus://resource:3972" xsi:type="model:Document"><annotation uri="periplus://resource:3972/annot:0"><data><rdf:RDF xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://resource:3972"><wlp:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/3972</wlp:hasNativeContent></rdf:Description></rdf:RDF></data></annotation></resource><resource uri="periplus://resource:3973" xsi:type="model:Document"><annotation uri="periplus://resource:3973/annot:0"><data><rdf:RDF xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://resource:3973"><wlp:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/3973</wlp:hasNativeContent></rdf:Description></rdf:RDF></data></annotation></resource><resource uri="periplus://resource:2475" xsi:type="model:Document"><annotation uri="periplus://resource:2475/annot:0"><data><rdf:RDF xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://resource:2475"><wlp:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/2475</wlp:hasNativeContent></rdf:Description></rdf:RDF></data></annotation></resource><resource uri="periplus://resource:3789" xsi:type="model:Document"><annotation uri="periplus://resource:3789/annot:0"><data><rdf:RDF xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://resource:3789"><wlp:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/3789</wlp:hasNativeContent></rdf:Description></rdf:RDF></data></annotation></resource><resource uri="periplus://resource:5767" xsi:type="model:Document"><annotation uri="periplus://resource:5767/annot:0"><data><rdf:RDF xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://resource:5767"><wlp:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/5767</wlp:hasNativeContent></rdf:Description></rdf:RDF></data></annotation></resource><resource uri="periplus://resource:1036" xsi:type="model:Document"><annotation uri="periplus://resource:1036/annot:0"><data><rdf:RDF xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://resource:1036"><wlp:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/1036</wlp:hasNativeContent></rdf:Description></rdf:RDF></data></annotation></resource><resource uri="periplus://resource:133" xsi:type="model:Document"><annotation uri="periplus://resource:133/annot:0"><data><rdf:RDF xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://resource:133"><wlp:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/133</wlp:hasNativeContent></rdf:Description></rdf:RDF></data></annotation></resource><resource uri="periplus://resource:3675" xsi:type="model:Document"><annotation uri="periplus://resource:3675/annot:0"><data><rdf:RDF xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://resource:3675"><wlp:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/3675</wlp:hasNativeContent></rdf:Description></rdf:RDF></data></annotation></resource><resource uri="periplus://resource:5828" xsi:type="model:Document"><annotation uri="periplus://resource:5828/annot:0"><data><rdf:RDF xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://resource:5828"><wlp:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/5828</wlp:hasNativeContent></rdf:Description></rdf:RDF></data></annotation></resource><resource uri="periplus://resource:3993" xsi:type="model:Document"><annotation uri="periplus://resource:3993/annot:0"><data><rdf:RDF xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://resource:3993"><wlp:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/3993</wlp:hasNativeContent></rdf:Description></rdf:RDF></data></annotation></resource><resource uri="periplus://resource:4870" xsi:type="model:Document"><annotation uri="periplus://resource:4870/annot:0"><data><rdf:RDF xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://resource:4870"><wlp:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/4870</wlp:hasNativeContent></rdf:Description></rdf:RDF></data></annotation></resource><resource uri="periplus://resource:2156" xsi:type="model:Document"><annotation uri="periplus://resource:2156/annot:0"><data><rdf:RDF xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://resource:2156"><wlp:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/2156</wlp:hasNativeContent></rdf:Description></rdf:RDF></data></annotation></resource><resource uri="periplus://resource:3849" xsi:type="model:Document"><annotation uri="periplus://resource:3849/annot:0"><data><rdf:RDF xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://resource:3849"><wlp:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/3849</wlp:hasNativeContent></rdf:Description></rdf:RDF></data></annotation></resource><resource uri="periplus://resource:3802" xsi:type="model:Document"><annotation uri="periplus://resource:3802/annot:0"><data><rdf:RDF xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://resource:3802"><wlp:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/3802</wlp:hasNativeContent></rdf:Description></rdf:RDF></data></annotation></resource><resource uri="periplus://resource:1320" xsi:type="model:Document"><annotation uri="periplus://resource:1320/annot:0"><data><rdf:RDF xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://resource:1320"><wlp:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/1320</wlp:hasNativeContent></rdf:Description></rdf:RDF></data></annotation></resource><resource uri="periplus://resource:1015" xsi:type="model:Document"><annotation uri="periplus://resource:1015/annot:0"><data><rdf:RDF xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://resource:1015"><wlp:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/1015</wlp:hasNativeContent></rdf:Description></rdf:RDF></data></annotation></resource><resource uri="periplus://resource:4397" xsi:type="model:Document"><annotation uri="periplus://resource:4397/annot:0"><data><rdf:RDF xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://resource:4397"><wlp:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/4397</wlp:hasNativeContent></rdf:Description></rdf:RDF></data></annotation></resource><resource uri="periplus://resource:4618" xsi:type="model:Document"><annotation uri="periplus://resource:4618/annot:0"><data><rdf:RDF xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://resource:4618"><wlp:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/4618</wlp:hasNativeContent></rdf:Description></rdf:RDF></data></annotation></resource><resource uri="periplus://resource:397" xsi:type="model:Document"><annotation uri="periplus://resource:397/annot:0"><data><rdf:RDF xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://resource:397"><wlp:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/397</wlp:hasNativeContent></rdf:Description></rdf:RDF></data></annotation></resource><resource uri="periplus://resource:4285" xsi:type="model:Document"><annotation uri="periplus://resource:4285/annot:0"><data><rdf:RDF xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://resource:4285"><wlp:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/4285</wlp:hasNativeContent></rdf:Description></rdf:RDF></data></annotation></resource><resource uri="periplus://resource:1668" xsi:type="model:Document"><annotation uri="periplus://resource:1668/annot:0"><data><rdf:RDF xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://resource:1668"><wlp:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/1668</wlp:hasNativeContent></rdf:Description></rdf:RDF></data></annotation></resource><resource uri="periplus://resource:2129" xsi:type="model:Document"><annotation uri="periplus://resource:2129/annot:0"><data><rdf:RDF xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://resource:2129"><wlp:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/2129</wlp:hasNativeContent></rdf:Description></rdf:RDF></data></annotation></resource><resource uri="periplus://resource:5351" xsi:type="model:Document"><annotation uri="periplus://resource:5351/annot:0"><data><rdf:RDF xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://resource:5351"><wlp:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/5351</wlp:hasNativeContent></rdf:Description></rdf:RDF></data></annotation></resource><resource uri="periplus://resource:4904" xsi:type="model:Document"><annotation uri="periplus://resource:4904/annot:0"><data><rdf:RDF xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://resource:4904"><wlp:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/4904</wlp:hasNativeContent></rdf:Description></rdf:RDF></data></annotation></resource><resource uri="periplus://resource:1797" xsi:type="model:Document"><annotation uri="periplus://resource:1797/annot:0"><data><rdf:RDF xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://resource:1797"><wlp:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/1797</wlp:hasNativeContent></rdf:Description></rdf:RDF></data></annotation></resource><resource uri="periplus://resource:1176" xsi:type="model:Document"><annotation uri="periplus://resource:1176/annot:0"><data><rdf:RDF xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://resource:1176"><wlp:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/1176</wlp:hasNativeContent></rdf:Description></rdf:RDF></data></annotation></resource><resource uri="periplus://resource:571" xsi:type="model:Document"><annotation uri="periplus://resource:571/annot:0"><data><rdf:RDF xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://resource:571"><wlp:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/571</wlp:hasNativeContent></rdf:Description></rdf:RDF></data></annotation></resource><resource uri="periplus://resource:3676" xsi:type="model:Document"><annotation uri="periplus://resource:3676/annot:0"><data><rdf:RDF xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://resource:3676"><wlp:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/3676</wlp:hasNativeContent></rdf:Description></rdf:RDF></data></annotation></resource><resource uri="periplus://resource:3799" xsi:type="model:Document"><annotation uri="periplus://resource:3799/annot:0"><data><rdf:RDF xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://resource:3799"><wlp:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/3799</wlp:hasNativeContent></rdf:Description></rdf:RDF></data></annotation></resource><resource uri="periplus://resource:3646" xsi:type="model:Document"><annotation uri="periplus://resource:3646/annot:0"><data><rdf:RDF xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://resource:3646"><wlp:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/3646</wlp:hasNativeContent></rdf:Description></rdf:RDF></data></annotation></resource><resource uri="periplus://resource:1535" xsi:type="model:Document"><annotation uri="periplus://resource:1535/annot:0"><data><rdf:RDF xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://resource:1535"><wlp:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/1535</wlp:hasNativeContent></rdf:Description></rdf:RDF></data></annotation></resource><resource uri="periplus://resource:2361" xsi:type="model:Document"><annotation uri="periplus://resource:2361/annot:0"><data><rdf:RDF xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://resource:2361"><wlp:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/2361</wlp:hasNativeContent></rdf:Description></rdf:RDF></data></annotation></resource><resource uri="periplus://resource:2441" xsi:type="model:Document"><annotation uri="periplus://resource:2441/annot:0"><data><rdf:RDF xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://resource:2441"><wlp:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/2441</wlp:hasNativeContent></rdf:Description></rdf:RDF></data></annotation></resource><resource uri="periplus://resource:5005" xsi:type="model:Document"><annotation uri="periplus://resource:5005/annot:0"><data><rdf:RDF xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://resource:5005"><wlp:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/5005</wlp:hasNativeContent></rdf:Description></rdf:RDF></data></annotation></resource><resource uri="periplus://resource:3556" xsi:type="model:Document"><annotation uri="periplus://resource:3556/annot:0"><data><rdf:RDF xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://resource:3556"><wlp:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/3556</wlp:hasNativeContent></rdf:Description></rdf:RDF></data></annotation></resource><resource uri="periplus://resource:47" xsi:type="model:Document"><annotation uri="periplus://resource:47/annot:0"><data><rdf:RDF xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://resource:47"><wlp:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/47</wlp:hasNativeContent></rdf:Description></rdf:RDF></data></annotation></resource><resource uri="periplus://resource:2185" xsi:type="model:Document"><annotation uri="periplus://resource:2185/annot:0"><data><rdf:RDF xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://resource:2185"><wlp:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/2185</wlp:hasNativeContent></rdf:Description></rdf:RDF></data></annotation></resource><resource uri="periplus://resource:2278" xsi:type="model:Document"><annotation uri="periplus://resource:2278/annot:0"><data><rdf:RDF xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://resource:2278"><wlp:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/2278</wlp:hasNativeContent></rdf:Description></rdf:RDF></data></annotation></resource><resource uri="periplus://resource:1902" xsi:type="model:Document"><annotation uri="periplus://resource:1902/annot:0"><data><rdf:RDF xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://resource:1902"><wlp:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/1902</wlp:hasNativeContent></rdf:Description></rdf:RDF></data></annotation></resource><resource uri="periplus://resource:288" xsi:type="model:Document"><annotation uri="periplus://resource:288/annot:0"><data><rdf:RDF xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://resource:288"><wlp:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/288</wlp:hasNativeContent></rdf:Description></rdf:RDF></data></annotation></resource><resource uri="periplus://resource:1093" xsi:type="model:Document"><annotation uri="periplus://resource:1093/annot:0"><data><rdf:RDF xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://resource:1093"><wlp:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/1093</wlp:hasNativeContent></rdf:Description></rdf:RDF></data></annotation></resource><resource uri="periplus://resource:1462" xsi:type="model:Document"><annotation uri="periplus://resource:1462/annot:0"><data><rdf:RDF xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://resource:1462"><wlp:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/1462</wlp:hasNativeContent></rdf:Description></rdf:RDF></data></annotation></resource><resource uri="periplus://resource:2179" xsi:type="model:Document"><annotation uri="periplus://resource:2179/annot:0"><data><rdf:RDF xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://resource:2179"><wlp:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/2179</wlp:hasNativeContent></rdf:Description></rdf:RDF></data></annotation></resource><resource uri="periplus://resource:1403" xsi:type="model:Document"><annotation uri="periplus://resource:1403/annot:0"><data><rdf:RDF xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://resource:1403"><wlp:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/1403</wlp:hasNativeContent></rdf:Description></rdf:RDF></data></annotation></resource><resource uri="periplus://resource:2501" xsi:type="model:Document"><annotation uri="periplus://resource:2501/annot:0"><data><rdf:RDF xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://resource:2501"><wlp:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/2501</wlp:hasNativeContent></rdf:Description></rdf:RDF></data></annotation></resource><resource uri="periplus://resource:4470" xsi:type="model:Document"><annotation uri="periplus://resource:4470/annot:0"><data><rdf:RDF xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://resource:4470"><wlp:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/4470</wlp:hasNativeContent></rdf:Description></rdf:RDF></data></annotation></resource><resource uri="periplus://resource:5881" xsi:type="model:Document"><annotation uri="periplus://resource:5881/annot:0"><data><rdf:RDF xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://resource:5881"><wlp:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/5881</wlp:hasNativeContent></rdf:Description></rdf:RDF></data></annotation></resource><resource uri="periplus://resource:3533" xsi:type="model:Document"><annotation uri="periplus://resource:3533/annot:0"><data><rdf:RDF xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://resource:3533"><wlp:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/3533</wlp:hasNativeContent></rdf:Description></rdf:RDF></data></annotation></resource><resource uri="periplus://resource:1978" xsi:type="model:Document"><annotation uri="periplus://resource:1978/annot:0"><data><rdf:RDF xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://resource:1978"><wlp:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/1978</wlp:hasNativeContent></rdf:Description></rdf:RDF></data></annotation></resource><resource uri="periplus://resource:5120" xsi:type="model:Document"><annotation uri="periplus://resource:5120/annot:0"><data><rdf:RDF xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://resource:5120"><wlp:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/5120</wlp:hasNativeContent></rdf:Description></rdf:RDF></data></annotation></resource><resource uri="periplus://resource:154" xsi:type="model:Document"><annotation uri="periplus://resource:154/annot:0"><data><rdf:RDF xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://resource:154"><wlp:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/154</wlp:hasNativeContent></rdf:Description></rdf:RDF></data></annotation></resource><resource uri="periplus://resource:3862" xsi:type="model:Document"><annotation uri="periplus://resource:3862/annot:0"><data><rdf:RDF xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://resource:3862"><wlp:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/3862</wlp:hasNativeContent></rdf:Description></rdf:RDF></data></annotation></resource><resource uri="periplus://resource:5246" xsi:type="model:Document"><annotation uri="periplus://resource:5246/annot:0"><data><rdf:RDF xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://resource:5246"><wlp:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/5246</wlp:hasNativeContent></rdf:Description></rdf:RDF></data></annotation></resource><resource uri="periplus://resource:5506" xsi:type="model:Document"><annotation uri="periplus://resource:5506/annot:0"><data><rdf:RDF xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://resource:5506"><wlp:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/5506</wlp:hasNativeContent></rdf:Description></rdf:RDF></data></annotation></resource><resource uri="periplus://resource:1524" xsi:type="model:Document"><annotation uri="periplus://resource:1524/annot:0"><data><rdf:RDF xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://resource:1524"><wlp:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/1524</wlp:hasNativeContent></rdf:Description></rdf:RDF></data></annotation></resource><resource uri="periplus://resource:1614" xsi:type="model:Document"><annotation uri="periplus://resource:1614/annot:0"><data><rdf:RDF xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://resource:1614"><wlp:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/1614</wlp:hasNativeContent></rdf:Description></rdf:RDF></data></annotation></resource><resource uri="periplus://resource:3576" xsi:type="model:Document"><annotation uri="periplus://resource:3576/annot:0"><data><rdf:RDF xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://resource:3576"><wlp:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/3576</wlp:hasNativeContent></rdf:Description></rdf:RDF></data></annotation></resource><resource uri="periplus://resource:5922" xsi:type="model:Document"><annotation uri="periplus://resource:5922/annot:0"><data><rdf:RDF xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://resource:5922"><wlp:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/5922</wlp:hasNativeContent></rdf:Description></rdf:RDF></data></annotation></resource><resource uri="periplus://resource:5786" xsi:type="model:Document"><annotation uri="periplus://resource:5786/annot:0"><data><rdf:RDF xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://resource:5786"><wlp:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/5786</wlp:hasNativeContent></rdf:Description></rdf:RDF></data></annotation></resource><resource uri="periplus://resource:4453" xsi:type="model:Document"><annotation uri="periplus://resource:4453/annot:0"><data><rdf:RDF xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://resource:4453"><wlp:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/4453</wlp:hasNativeContent></rdf:Description></rdf:RDF></data></annotation></resource><resource uri="periplus://resource:347" xsi:type="model:Document"><annotation uri="periplus://resource:347/annot:0"><data><rdf:RDF xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://resource:347"><wlp:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/347</wlp:hasNativeContent></rdf:Description></rdf:RDF></data></annotation></resource><resource uri="periplus://resource:600" xsi:type="model:Document"><annotation uri="periplus://resource:600/annot:0"><data><rdf:RDF xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://resource:600"><wlp:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/600</wlp:hasNativeContent></rdf:Description></rdf:RDF></data></annotation></resource><resource uri="periplus://resource:3200" xsi:type="model:Document"><annotation uri="periplus://resource:3200/annot:0"><data><rdf:RDF xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://resource:3200"><wlp:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/3200</wlp:hasNativeContent></rdf:Description></rdf:RDF></data></annotation></resource><resource uri="periplus://resource:4458" xsi:type="model:Document"><annotation uri="periplus://resource:4458/annot:0"><data><rdf:RDF xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://resource:4458"><wlp:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/4458</wlp:hasNativeContent></rdf:Description></rdf:RDF></data></annotation></resource><resource uri="periplus://resource:4698" xsi:type="model:Document"><annotation uri="periplus://resource:4698/annot:0"><data><rdf:RDF xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://resource:4698"><wlp:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/4698</wlp:hasNativeContent></rdf:Description></rdf:RDF></data></annotation></resource><resource uri="periplus://resource:4823" xsi:type="model:Document"><annotation uri="periplus://resource:4823/annot:0"><data><rdf:RDF xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://resource:4823"><wlp:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/4823</wlp:hasNativeContent></rdf:Description></rdf:RDF></data></annotation></resource><resource uri="periplus://resource:4272" xsi:type="model:Document"><annotation uri="periplus://resource:4272/annot:0"><data><rdf:RDF xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://resource:4272"><wlp:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/4272</wlp:hasNativeContent></rdf:Description></rdf:RDF></data></annotation></resource><resource uri="periplus://resource:2577" xsi:type="model:Document"><annotation uri="periplus://resource:2577/annot:0"><data><rdf:RDF xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://resource:2577"><wlp:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/2577</wlp:hasNativeContent></rdf:Description></rdf:RDF></data></annotation></resource><resource uri="periplus://resource:4728" xsi:type="model:Document"><annotation uri="periplus://resource:4728/annot:0"><data><rdf:RDF xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://resource:4728"><wlp:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/4728</wlp:hasNativeContent></rdf:Description></rdf:RDF></data></annotation></resource><resource uri="periplus://resource:5490" xsi:type="model:Document"><annotation uri="periplus://resource:5490/annot:0"><data><rdf:RDF xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://resource:5490"><wlp:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/5490</wlp:hasNativeContent></rdf:Description></rdf:RDF></data></annotation></resource><resource uri="periplus://resource:4341" xsi:type="model:Document"><annotation uri="periplus://resource:4341/annot:0"><data><rdf:RDF xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://resource:4341"><wlp:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/4341</wlp:hasNativeContent></rdf:Description></rdf:RDF></data></annotation></resource><resource uri="periplus://resource:2286" xsi:type="model:Document"><annotation uri="periplus://resource:2286/annot:0"><data><rdf:RDF xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://resource:2286"><wlp:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/2286</wlp:hasNativeContent></rdf:Description></rdf:RDF></data></annotation></resource><resource uri="periplus://resource:3510" xsi:type="model:Document"><annotation uri="periplus://resource:3510/annot:0"><data><rdf:RDF xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://resource:3510"><wlp:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/3510</wlp:hasNativeContent></rdf:Description></rdf:RDF></data></annotation></resource><resource uri="periplus://resource:4201" xsi:type="model:Document"><annotation uri="periplus://resource:4201/annot:0"><data><rdf:RDF xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://resource:4201"><wlp:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/4201</wlp:hasNativeContent></rdf:Description></rdf:RDF></data></annotation></resource><resource uri="periplus://resource:4545" xsi:type="model:Document"><annotation uri="periplus://resource:4545/annot:0"><data><rdf:RDF xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://resource:4545"><wlp:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/4545</wlp:hasNativeContent></rdf:Description></rdf:RDF></data></annotation></resource><resource uri="periplus://resource:4513" xsi:type="model:Document"><annotation uri="periplus://resource:4513/annot:0"><data><rdf:RDF xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://resource:4513"><wlp:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/4513</wlp:hasNativeContent></rdf:Description></rdf:RDF></data></annotation></resource><resource uri="periplus://resource:446" xsi:type="model:Document"><annotation uri="periplus://resource:446/annot:0"><data><rdf:RDF xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://resource:446"><wlp:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/446</wlp:hasNativeContent></rdf:Description></rdf:RDF></data></annotation></resource><resource uri="periplus://resource:2312" xsi:type="model:Document"><annotation uri="periplus://resource:2312/annot:0"><data><rdf:RDF xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://resource:2312"><wlp:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/2312</wlp:hasNativeContent></rdf:Description></rdf:RDF></data></annotation></resource><resource uri="periplus://resource:5488" xsi:type="model:Document"><annotation uri="periplus://resource:5488/annot:0"><data><rdf:RDF xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://resource:5488"><wlp:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/5488</wlp:hasNativeContent></rdf:Description></rdf:RDF></data></annotation></resource><resource uri="periplus://resource:2075" xsi:type="model:Document"><annotation uri="periplus://resource:2075/annot:0"><data><rdf:RDF xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://resource:2075"><wlp:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/2075</wlp:hasNativeContent></rdf:Description></rdf:RDF></data></annotation></resource><resource uri="periplus://resource:487" xsi:type="model:Document"><annotation uri="periplus://resource:487/annot:0"><data><rdf:RDF xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://resource:487"><wlp:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/487</wlp:hasNativeContent></rdf:Description></rdf:RDF></data></annotation></resource><resource uri="periplus://resource:1799" xsi:type="model:Document"><annotation uri="periplus://resource:1799/annot:0"><data><rdf:RDF xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://resource:1799"><wlp:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/1799</wlp:hasNativeContent></rdf:Description></rdf:RDF></data></annotation></resource><resource uri="periplus://resource:1976" xsi:type="model:Document"><annotation uri="periplus://resource:1976/annot:0"><data><rdf:RDF xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://resource:1976"><wlp:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/1976</wlp:hasNativeContent></rdf:Description></rdf:RDF></data></annotation></resource><resource uri="periplus://resource:5753" xsi:type="model:Document"><annotation uri="periplus://resource:5753/annot:0"><data><rdf:RDF xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://resource:5753"><wlp:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/5753</wlp:hasNativeContent></rdf:Description></rdf:RDF></data></annotation></resource><resource uri="periplus://resource:1592" xsi:type="model:Document"><annotation uri="periplus://resource:1592/annot:0"><data><rdf:RDF xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://resource:1592"><wlp:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/1592</wlp:hasNativeContent></rdf:Description></rdf:RDF></data></annotation></resource><resource uri="periplus://resource:1600" xsi:type="model:Document"><annotation uri="periplus://resource:1600/annot:0"><data><rdf:RDF xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://resource:1600"><wlp:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/1600</wlp:hasNativeContent></rdf:Description></rdf:RDF></data></annotation></resource><resource uri="periplus://resource:5548" xsi:type="model:Document"><annotation uri="periplus://resource:5548/annot:0"><data><rdf:RDF xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://resource:5548"><wlp:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/5548</wlp:hasNativeContent></rdf:Description></rdf:RDF></data></annotation></resource><resource uri="periplus://resource:2290" xsi:type="model:Document"><annotation uri="periplus://resource:2290/annot:0"><data><rdf:RDF xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://resource:2290"><wlp:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/2290</wlp:hasNativeContent></rdf:Description></rdf:RDF></data></annotation></resource><resource uri="periplus://resource:2033" xsi:type="model:Document"><annotation uri="periplus://resource:2033/annot:0"><data><rdf:RDF xmlns:wlp="http://weblab.ow2.org/core/1.2/ontology/processing#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"><rdf:Description rdf:about="periplus://resource:2033"><wlp:hasNativeContent>/home/cea/WebLab/dist/run/mss/images/2033</wlp:hasNativeContent></rdf:Description></rdf:RDF></data></annotation></resource></resultSet></sear:searchReturn></soapenv:Body></soapenv:Envelope>'        
        return res
    
    def build_filtered_streamgraph_(self, list_concepts, concepts_with_detailed_documents_list, attr):
        '''my_start_date = attr.get_from_date()
        my_end_date = attr.get_to_date()'''
        logger.info('build_filtered_streamgraph_')   
        my_from_date = ''
        my_to_date = ''
        if  self.request.session['refreshOnly'] == True:
            my_from_date = self.request.session['from_date']
            my_to_date = self.request.session['to_date']
        else:
            my_from_date = attr.get_from_date()
            my_to_date = attr.get_to_date()
        
        logger.info('my_from_date = '+str(my_from_date))
        logger.info('my_to_date = '+str(my_to_date))
        time_object1 = time.strptime(str(my_from_date), '%m/%d/%Y')
        start_date = str(int(time.mktime(time_object1)))
       
        time_object2 = time.strptime(str(my_to_date), '%m/%d/%Y')
        end_date = str(int(time.mktime(time_object2)))        
        logger.info('start_date = '+str(start_date))
        logger.info('end_date = '+str(end_date))     
        
        categories = attr.get_categories()
        logger.info('streamgraph categories========'+str(categories))
        # If the dates are not defined in the http request, we specify these dates from the document dates
        start_date, end_date = self.get_start_and_end_(concepts_with_detailed_documents_list, start_date, end_date)
        
        dt_start_date = datetime.fromtimestamp(int(start_date)).isoformat()+'.0Z' 
        dt_end_date = datetime.fromtimestamp(int(end_date)).isoformat()+'.0Z'
        nb_stream_graph_unit = 50    
        time_unit = (int(end_date) - int(start_date)) / float(nb_stream_graph_unit)

        json = {'from_date':my_from_date}
        json['to_date'] = my_to_date
        json['slice_count'] = nb_stream_graph_unit
        json['query_id'] = int(attr.get_hash_value())
        json['clusters'] = []
        
        if attr.get_filtre() == 'dossierDocOk':
            my_concepts_list = eval(list_concepts)
            my_concepts_with_detailed_documents_list = eval(concepts_with_detailed_documents_list)
        else:
            my_concepts_list = list_concepts
            my_concepts_with_detailed_documents_list = concepts_with_detailed_documents_list
        
        
        for concept_index, concept_with_detailed_documents_list in enumerate(my_concepts_with_detailed_documents_list) :
            title = my_concepts_list[concept_index]['title']
            jsonconcept = {'id':concept_index}
            jsonconcept['title'] = title
            
            time_interval_begin = int(start_date)
            time_interval_end = time_interval_begin + time_unit
            jsonvolume=[]
            for i in range(nb_stream_graph_unit):
                nbvolume = 0
                for detailed_document in concept_with_detailed_documents_list:
                    #Filtering by category
                    if (categories != [] and detailed_document['category'] in categories) or (categories == []):
                        doc_date = detailed_document['date']
                        #Filtering by date
                        if int(doc_date) >= time_interval_begin and int(doc_date) < time_interval_end:
                            nbvolume += 1
                jsonvolume.append(nbvolume)       
                time_interval_begin = time_interval_end
                time_interval_end += time_unit
            logger.info('NBVOLUME ******'+str(self.verifyNbVolume_(jsonvolume)))
            if(self.verifyNbVolume_(jsonvolume) == 1):
                logger.info('ADDED VOLUME')
                jsonconcept['volumes'] = jsonvolume
                json['clusters'].append(jsonconcept)
                logger.info('jsonconcept ='+str(jsonconcept))
        result = simplejson.dumps(json)
        logger.debug('jsonstreamgraph ===================='+result)
        return result
    
    def build_filtered_treemap_(self, concepts_list, concepts_with_detailed_documents_list, attr):
        picture = attr.get_picture_url()
        categories = attr.get_categories()
        my_from_date = ''
        my_to_date = ''
        if  self.request.session['refreshOnly'] == True:
            my_from_date = self.request.session['from_date']
            my_to_date = self.request.session['to_date']
        else:
            my_from_date = attr.get_from_date()
            my_to_date = attr.get_to_date()
        
        logger.info('my_from_date = '+str(my_from_date))
        logger.info('my_to_date = '+str(my_to_date))
        time_object1 = time.strptime(str(my_from_date), '%m/%d/%Y')
        from_date = str(int(time.mktime(time_object1)))
        logger.info('from_date = '+str(from_date))
       
        time_object2 = time.strptime(str(my_to_date), '%m/%d/%Y')
        logger.info('from_date2')       
        to_date = str(int(time.mktime(time_object2))) 
      
        logger.info('from_date = '+str(from_date))
        logger.info('to_date = '+str(to_date))
            
        if attr.has_image_file():
            picture = 'http-post'
        json = {}
        jsonquery = {'text': attr.get_text()}
        jsonquery['picture'] = picture
        jsonquery['typeTri'] = self.request.session['typeTri']
        jsonquery['categories'] = categories
        jsonquery['from_date'] =  my_from_date
        jsonquery['to_date'] = my_to_date
        '''if attr.get_from_date() != '':
            jsonquery['from_date'] = datetime.fromtimestamp(int(attr.get_from_date())).isoformat() + '.0Z'
        if attr.get_to_date() != '':
            jsonquery['to_date'] = datetime.fromtimestamp(int(attr.get_to_date())).isoformat() + '.0Z'''
        
        if  self.request.session['refreshOnly'] == True or attr.get_filtre() == 'ok':
            jsonquery['query_id'] = self.request.session['query_id']
            '''self.request.session['refreshOnly'] = False'''
        else:
            jsonquery['query_id'] = int(attr.get_hash_value())
            
        json['query'] = jsonquery
        json['clusters'] = []
        logger.info(concepts_list)
        logger.info(concepts_with_detailed_documents_list)
        
        if attr.get_filtre() == 'dossierDocOk':
            my_concepts_list = eval(concepts_list)
            my_concepts_with_detailed_documents_list = eval(concepts_with_detailed_documents_list)
        else:
            my_concepts_list = concepts_list
            my_concepts_with_detailed_documents_list = concepts_with_detailed_documents_list
        
    
        for concept_index, concept in enumerate(my_concepts_list):
            concept_with_sorted_detailed_documents = sorted(my_concepts_with_detailed_documents_list[concept_index], key=lambda rank: rank['rank'])
            nb_doc = 0
            for index, document in enumerate(concept_with_sorted_detailed_documents):
                logger.info('DOC_ID = '+document['id'])
                logger.info('int(document[date]) !!!!!!!!!!!!!!!!!!!!!!!!')
                logger.info('document[category]) !!!!!!!!!!!!!!!!!!!!!!!!')
                logger.info(document['category'])
                if (categories != [] and document['category'] in categories) or (categories == []):
                    logger.info('categories) !!!!!!!!!!!!!!!!!!!!!!!!')
                    logger.info(categories)
                    logger.info('attr.get_from_date() !!!!!!!!!!!!!!!!!!!!!!!!')
                    logger.info(from_date)
                    logger.info('attr.get_to_date() !!!!!!!!!!!!!!!!!!!!!!!!')
                    logger.info(to_date)
                    
                    

                    if (from_date != '' and int(document['date']) >= int(from_date)) or from_date == '':
                        if (to_date != '' and int(document['date']) <int(to_date)) or to_date == '':
                            nb_doc+= 1
            logger.info("nb_doc = "+str(nb_doc))
            
            '''logger.info('nb_doc !!!!!!!!!!!!!!!!!!!!!!!!')
            logger.info(nb_doc)
            logger.info('concept_index !!!!!!!!!!!!!!!!!!!!!!!!')
            logger.info(concept_index)'''
            if nb_doc > 0:
                jsonconcept = {'id':concept_index}
                jsonconcept['query_id'] = jsonquery['query_id']
                jsonconcept['doc_id'] = 0
                jsonconcept['title'] = concept['title']
                jsonconcept['abstract'] = concept['abstract']
                jsonconcept['weight'] = concept['score']
                jsonconcept['url_image'] = concept['url_image']
                '''jsonconcept['documents_number'] = len(concepts_with_detailed_documents_list[concept_index])'''
                jsonconcept['documents_number'] = nb_doc
                
                if attr.get_documentary_file() != '':
                    clusters = Cluster.objects.filter(documentaryfile=attr.get_documentary_file())
                else:
                    clusters = []
                
                jsonconcept['annotations'] = []
                for cluster in clusters:
                    ''''if cluster.id == concept_index:'''
                    annotations = Annotationcluster.objects.filter(cluster=str(cluster.id))
                    jsonannotation = {}
                    for annotation in annotations:
                        jsonannotation['id'] = annotation.id
                        jsonannotation['user'] = annotation.user.username
                        jsonannotation['text'] = annotation.description
                        jsonconcept['annotations'].append(jsonannotation)
                jsonconcept['documents'] = []
                
                for doc_index, document in enumerate(concept_with_sorted_detailed_documents):
                    if (categories != [] and document['category'] in categories) or (categories == []):
                        #Filtering by date
                        if (from_date != '' and int(document['date']) >= int(from_date)) or from_date == '':
                            if (to_date != '' and int(document['date']) <int(to_date)) or to_date == '':
                                logger.info('FILTERING ADDED DOCUMENT !!!!!!')
                                jsonarticle = {'id':self.num_(document['id'])}
                                jsonarticle['title'] = document['title']
                                jsonarticle['url_document'] = document['url']
                                jsonarticle['date'] = datetime.fromtimestamp(self.num_(document['date'])).isoformat() + '.0Z' 
                                jsonarticle['category'] = document['category']
                                jsonarticle['url_image'] = document['image_path']
                                jsonarticle['weight'] = float(document['weight'])
                                jsonconcept['documents'].append(jsonarticle)
                                # Maximum: 3 articles per cluster
                                if doc_index > 2:
                                    break
                json['clusters'].append(jsonconcept)
        result = simplejson.dumps(json)
        logger.debug('jsontreemap ===================='+result)
        return result
    
        '''json = ({'query':{'text':attr.get_text(), 'picture':picture, 'categories':categories,'from_date':'tutu','to_date':'toto','query_id':int(attr.get_hash_value())}})'''
    
    def add_doc_information_(self, concepts_with_documents_list):
        reader = MediapartReader()
        concepts_with_detailed_documents = []
        for concept_with_documents in concepts_with_documents_list:
            detailed_documents_list = []
            for document in concept_with_documents:
                document_id = document['id']
                detailed_doc = {}
                detailed_doc['id'] = document_id
                detailed_doc['title'] = reader.get_title(document_id)
                detailed_doc['date'] = reader.get_date(document_id)
                detailed_doc['weight'] = document['score']
                detailed_doc['rank'] = document['rank']
                detailed_doc['isLinkedTo'] = document['isLinkedTo']
                detailed_doc['category'] = reader.get_category(document_id)
                #detailed_doc['tags'] = reader.get_tags(document_id)
                detailed_doc['url'] = reader.get_url(document_id)
                detailed_doc['image_path'] = document['image_path']
                detailed_doc['abstract'] = document['abstract']
                detailed_documents_list.append(detailed_doc)
            concepts_with_detailed_documents.append(detailed_documents_list)
        return concepts_with_detailed_documents
        
    def get_start_and_end_(self, documents_dates_concepts_list, start_date, end_date):
        if start_date == '' or end_date == '':
            int_start_date = 9999999999
            int_end_date=0
            
            for documents_dates_concepts in documents_dates_concepts_list:
                for documents_dates in documents_dates_concepts:
                    doc_date = documents_dates['date']
                    if int(doc_date) < int_start_date:
                        int_start_date = int(doc_date)
                    if int(doc_date) > int_end_date:
                        int_end_date = int(doc_date)
            if start_date == '':
                start_date = str(int_start_date)
            if end_date == '':
                end_date = str(int_end_date)
        return (start_date, end_date) 
    
    def num_(self, s):
        try:
            return int(s)
        except Exception, err:
            logger.error('Can\'t convert the value into int.')
            logger.error(err)
            return 0
    
    def verifyNbVolume_(self,nbvolumes):
        if any(nbvolume > 0 for nbvolume in nbvolumes):
            logger.info('nbvolume >0')
            return 1
        else:
            logger.info('nbvolume ==0')
            return 0

